/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.io;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.ExecutorService;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.FileUtil;
import org.jetbrains.kotlin.com.intellij.util.CompressionUtil;
import org.jetbrains.kotlin.com.intellij.util.io.AppendablePersistentMap;
import org.jetbrains.kotlin.com.intellij.util.io.DataExternalizer;
import org.jetbrains.kotlin.com.intellij.util.io.DataInputOutputUtil;
import org.jetbrains.kotlin.com.intellij.util.io.DataOutputStream;
import org.jetbrains.kotlin.com.intellij.util.io.KeyDescriptor;
import org.jetbrains.kotlin.com.intellij.util.io.UnsyncByteArrayOutputStream;
import org.jetbrains.kotlin.com.intellij.util.io.VersionUpdatedException;
import org.jetbrains.kotlin.com.intellij.util.io.WalOpCode;
import org.jetbrains.kotlin.com.intellij.util.io.WalRecord;
import org.jetbrains.kotlin.com.intellij.util.io.WriteAheadLogKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u0012\n\u0002\b\u0003\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u00020\u0003BE\b\u0007\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\b\b\u0002\u0010\u000e\u001a\u00020\t\u00a2\u0006\u0002\u0010\u000fJ\u001b\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00028\u00002\u0006\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\u0002\u0010\u001bJ\u001d\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0018\u001a\u00028\u00002\u0006\u0010\u0019\u001a\u00020\u001aH\u0002\u00a2\u0006\u0002\u0010\u001eJ\b\u0010\u001f\u001a\u00020\u0017H\u0016J\u0006\u0010 \u001a\u00020\u0017J \u0010!\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020\u00132\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0006\u0010#\u001a\u00020\u0017J\u001b\u0010$\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00028\u00002\u0006\u0010%\u001a\u00028\u0001\u00a2\u0006\u0002\u0010&J\u001d\u0010'\u001a\u00020\u001d2\u0006\u0010\u0018\u001a\u00028\u00002\u0006\u0010%\u001a\u00028\u0001H\u0002\u00a2\u0006\u0002\u0010(J\u0013\u0010)\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00028\u0000\u00a2\u0006\u0002\u0010*J\u0015\u0010+\u001a\u00020\u001d2\u0006\u0010\u0018\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010,J\f\u0010-\u001a\u00020\u0017*\u00020\u001dH\u0002J\u0014\u0010.\u001a\u00020\u0017*\u00020/2\u0006\u00100\u001a\u00020\u0011H\u0002J\f\u00101\u001a\u00020/*\u00020\u001aH\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u0013X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lorg/jetbrains/kotlin/com/intellij/util/io/PersistentMapWal;", "K", "V", "Ljava/io/Closeable;", "keyDescriptor", "Lorg/jetbrains/kotlin/com/intellij/util/io/KeyDescriptor;", "valueExternalizer", "Lorg/jetbrains/kotlin/com/intellij/util/io/DataExternalizer;", "useCompression", "", "file", "Ljava/nio/file/Path;", "walIoExecutor", "Ljava/util/concurrent/ExecutorService;", "compact", "(Lcom/intellij/util/io/KeyDescriptor;Lcom/intellij/util/io/DataExternalizer;ZLjava/nio/file/Path;Ljava/util/concurrent/ExecutorService;Z)V", "out", "Lorg/jetbrains/kotlin/com/intellij/util/io/DataOutputStream;", "version", "", "getVersion", "()I", "appendData", "", "key", "appender", "Lorg/jetbrains/kotlin/com/intellij/util/io/AppendablePersistentMap$ValueDataAppender;", "(Ljava/lang/Object;Lcom/intellij/util/io/AppendablePersistentMap$ValueDataAppender;)V", "appendRecord", "Lorg/jetbrains/kotlin/com/intellij/util/io/WalRecord;", "(Ljava/lang/Object;Lcom/intellij/util/io/AppendablePersistentMap$ValueDataAppender;)Lcom/intellij/util/io/WalRecord;", "close", "closeAndDelete", "ensureCompatible", "expectedVersion", "flush", "put", "value", "(Ljava/lang/Object;Ljava/lang/Object;)V", "putRecord", "(Ljava/lang/Object;Ljava/lang/Object;)Lcom/intellij/util/io/WalRecord;", "remove", "(Ljava/lang/Object;)V", "removeRecord", "(Ljava/lang/Object;)Lcom/intellij/util/io/WalRecord;", "submitWrite", "write", "", "outputStream", "writeToByteArray", "intellij.platform.util"})
public final class PersistentMapWal<K, V>
implements Closeable {
    @NotNull
    private final KeyDescriptor<K> keyDescriptor;
    @NotNull
    private final DataExternalizer<V> valueExternalizer;
    private final boolean useCompression;
    @NotNull
    private final Path file;
    @NotNull
    private final ExecutorService walIoExecutor;
    @NotNull
    private final DataOutputStream out;
    private final int version;

    @JvmOverloads
    public PersistentMapWal(@NotNull KeyDescriptor<K> keyDescriptor, @NotNull DataExternalizer<V> valueExternalizer, boolean useCompression, @NotNull Path file2, @NotNull ExecutorService walIoExecutor, boolean compact) throws IOException {
        Intrinsics.checkNotNullParameter(keyDescriptor, (String)"keyDescriptor");
        Intrinsics.checkNotNullParameter(valueExternalizer, (String)"valueExternalizer");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)walIoExecutor, (String)"walIoExecutor");
        this.keyDescriptor = keyDescriptor;
        this.valueExternalizer = valueExternalizer;
        this.useCompression = useCompression;
        this.file = file2;
        this.walIoExecutor = walIoExecutor;
        if (compact) {
            Path path = WriteAheadLogKt.access$tryCompact(this.file, this.keyDescriptor, this.valueExternalizer);
            if (path != null) {
                Path compactedWal = path;
                boolean bl = false;
                FileUtil.deleteWithRenaming(this.file);
                FileUtil.rename(compactedWal.toFile(), this.file.toFile());
            }
        }
        this.ensureCompatible(this.version, this.useCompression, this.file);
        OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.WRITE, StandardOpenOption.APPEND};
        OutputStream outputStream = Files.newOutputStream(this.file, openOptionArray);
        Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"newOutputStream(...)");
        OutputStream outputStream2 = outputStream;
        int n = 8192;
        this.out = new DataOutputStream(outputStream2 instanceof BufferedOutputStream ? (BufferedOutputStream)outputStream2 : new BufferedOutputStream(outputStream2, n));
    }

    public /* synthetic */ PersistentMapWal(KeyDescriptor keyDescriptor, DataExternalizer dataExternalizer, boolean bl, Path path, ExecutorService executorService, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) throws IOException {
        if ((n & 0x20) != 0) {
            bl2 = false;
        }
        this(keyDescriptor, dataExternalizer, bl, path, executorService, bl2);
    }

    public final int getVersion() {
        return this.version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void ensureCompatible(int expectedVersion, boolean useCompression, Path file2) throws IOException {
        Pair pair;
        if (!Files.exists(file2, new LinkOption[0])) {
            Files.createDirectories(file2.getParent(), new FileAttribute[0]);
            Object object = new OpenOption[]{StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE};
            object = new DataOutputStream(Files.newOutputStream(file2, object));
            Throwable throwable = null;
            try {
                DataOutputStream it = (DataOutputStream)object;
                boolean bl = false;
                DataInputOutputUtil.writeINT(it, expectedVersion);
                it.writeBoolean(useCompression);
                it = Unit.INSTANCE;
            }
            catch (Throwable it) {
                throwable = it;
                throw it;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            return;
        }
        Object object = new OpenOption[]{StandardOpenOption.READ};
        object = new DataInputStream(Files.newInputStream(file2, object));
        Throwable it = null;
        try {
            DataInputStream it2 = (DataInputStream)object;
            boolean bl = false;
            pair = TuplesKt.to((Object)DataInputOutputUtil.readINT(it2), (Object)it2.readBoolean());
        }
        catch (Throwable throwable) {
            it = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)it);
        }
        Pair pair2 = pair;
        int actualVersion = ((Number)pair2.component1()).intValue();
        boolean actualUsesCompression = (Boolean)pair2.component2();
        if (actualVersion != expectedVersion) {
            throw new VersionUpdatedException(file2, expectedVersion, actualVersion);
        }
        if (actualUsesCompression != useCompression) {
            throw new VersionUpdatedException(file2, useCompression, actualUsesCompression);
        }
    }

    private final void write(byte[] $this$write, DataOutputStream outputStream) {
        if (this.useCompression) {
            CompressionUtil.writeCompressed(outputStream, $this$write, 0, $this$write.length);
        } else {
            outputStream.writeInt($this$write.length);
            outputStream.write($this$write);
        }
    }

    private final byte[] writeToByteArray(AppendablePersistentMap.ValueDataAppender $this$writeToByteArray) {
        UnsyncByteArrayOutputStream baos = new UnsyncByteArrayOutputStream();
        $this$writeToByteArray.append(new DataOutputStream(baos));
        byte[] byArray = baos.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
        return byArray;
    }

    private final WalRecord appendRecord(K key, AppendablePersistentMap.ValueDataAppender appender) {
        return WalRecord.Companion.writeRecord(WalOpCode.APPEND, (Function1<? super DataOutputStream, Unit>)((Function1)new Function1<DataOutputStream, Unit>(this, key, appender){
            final /* synthetic */ PersistentMapWal<K, V> this$0;
            final /* synthetic */ K $key;
            final /* synthetic */ AppendablePersistentMap.ValueDataAppender $appender;
            {
                this.this$0 = $receiver;
                this.$key = $key;
                this.$appender = $appender;
                super(1);
            }

            public final void invoke(@NotNull DataOutputStream it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                PersistentMapWal.access$getKeyDescriptor$p(this.this$0).save(it, this.$key);
                PersistentMapWal.access$write(this.this$0, PersistentMapWal.access$writeToByteArray(this.this$0, this.$appender), it);
            }
        }));
    }

    private final WalRecord putRecord(K key, V value2) {
        return WalRecord.Companion.writeRecord(WalOpCode.PUT, (Function1<? super DataOutputStream, Unit>)((Function1)new Function1<DataOutputStream, Unit>(this, key, value2){
            final /* synthetic */ PersistentMapWal<K, V> this$0;
            final /* synthetic */ K $key;
            final /* synthetic */ V $value;
            {
                this.this$0 = $receiver;
                this.$key = $key;
                this.$value = $value;
                super(1);
            }

            public final void invoke(@NotNull DataOutputStream it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                PersistentMapWal.access$getKeyDescriptor$p(this.this$0).save(it, this.$key);
                PersistentMapWal.access$write(this.this$0, WriteAheadLogKt.access$writeData(this.$value, PersistentMapWal.access$getValueExternalizer$p(this.this$0)), it);
            }
        }));
    }

    private final WalRecord removeRecord(K key) {
        return WalRecord.Companion.writeRecord(WalOpCode.REMOVE, (Function1<? super DataOutputStream, Unit>)((Function1)new Function1<DataOutputStream, Unit>(this, key){
            final /* synthetic */ PersistentMapWal<K, V> this$0;
            final /* synthetic */ K $key;
            {
                this.this$0 = $receiver;
                this.$key = $key;
                super(1);
            }

            public final void invoke(@NotNull DataOutputStream it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                PersistentMapWal.access$getKeyDescriptor$p(this.this$0).save(it, this.$key);
            }
        }));
    }

    private final void submitWrite(WalRecord $this$submitWrite) {
        this.walIoExecutor.submit(() -> PersistentMapWal.submitWrite$lambda$3($this$submitWrite, this));
    }

    public final void appendData(K key, @NotNull AppendablePersistentMap.ValueDataAppender appender) throws IOException {
        Intrinsics.checkNotNullParameter((Object)appender, (String)"appender");
        this.submitWrite(this.appendRecord(key, appender));
    }

    public final void put(K key, V value2) throws IOException {
        this.submitWrite(this.putRecord(key, value2));
    }

    public final void remove(K key) throws IOException {
        this.submitWrite(this.removeRecord(key));
    }

    public final void flush() throws IOException {
        this.walIoExecutor.submit(() -> PersistentMapWal.flush$lambda$4(this)).get();
    }

    @Override
    public void close() throws IOException {
        this.walIoExecutor.submit(() -> PersistentMapWal.close$lambda$5(this)).get();
    }

    public final void closeAndDelete() throws IOException {
        this.close();
        FileUtil.deleteWithRenaming(this.file);
    }

    @JvmOverloads
    public PersistentMapWal(@NotNull KeyDescriptor<K> keyDescriptor, @NotNull DataExternalizer<V> valueExternalizer, boolean useCompression, @NotNull Path file2, @NotNull ExecutorService walIoExecutor) throws IOException {
        Intrinsics.checkNotNullParameter(keyDescriptor, (String)"keyDescriptor");
        Intrinsics.checkNotNullParameter(valueExternalizer, (String)"valueExternalizer");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)walIoExecutor, (String)"walIoExecutor");
        this(keyDescriptor, valueExternalizer, useCompression, file2, walIoExecutor, false, 32, null);
    }

    private static final void submitWrite$lambda$3(WalRecord $this_submitWrite, PersistentMapWal this$0) {
        Intrinsics.checkNotNullParameter((Object)$this_submitWrite, (String)"$this_submitWrite");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (WriteAheadLogKt.getDebugWalRecords()) {
            System.out.println((Object)("write: " + $this_submitWrite));
        }
        $this_submitWrite.write(this$0.out);
    }

    private static final void flush$lambda$4(PersistentMapWal this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.out.flush();
    }

    private static final void close$lambda$5(PersistentMapWal this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.out.close();
    }

    public static final /* synthetic */ KeyDescriptor access$getKeyDescriptor$p(PersistentMapWal $this) {
        return $this.keyDescriptor;
    }

    public static final /* synthetic */ void access$write(PersistentMapWal $this, byte[] $receiver, DataOutputStream outputStream) {
        $this.write($receiver, outputStream);
    }

    public static final /* synthetic */ byte[] access$writeToByteArray(PersistentMapWal $this, AppendablePersistentMap.ValueDataAppender $receiver) {
        return $this.writeToByteArray($receiver);
    }

    public static final /* synthetic */ DataExternalizer access$getValueExternalizer$p(PersistentMapWal $this) {
        return $this.valueExternalizer;
    }
}

