/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.internal.types;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.internal.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.gradle.internal.renderer.DescriptorRendererOptions;
import org.jetbrains.kotlin.gradle.internal.types.FlexibleType;
import org.jetbrains.kotlin.gradle.internal.types.KotlinType;
import org.jetbrains.kotlin.gradle.internal.types.SimpleType;
import org.jetbrains.kotlin.gradle.internal.types.TypeAttributes;
import org.jetbrains.kotlin.gradle.internal.types.TypeRefinement;
import org.jetbrains.kotlin.gradle.internal.types.TypeWithEnhancement;
import org.jetbrains.kotlin.gradle.internal.types.TypeWithEnhancementKt;
import org.jetbrains.kotlin.gradle.internal.types.UnwrappedType;
import org.jetbrains.kotlin.gradle.internal.types.checker.KotlinTypeRefiner;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0001\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u001fH\u0017J\b\u0010 \u001a\u00020\u0014H\u0016R\u0014\u0010\u0003\u001a\u00020\u0001X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0019\u001a\u00020\u001a8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/gradle/internal/types/FlexibleTypeWithEnhancement;", "Lorg/jetbrains/kotlin/gradle/internal/types/FlexibleType;", "Lorg/jetbrains/kotlin/gradle/internal/types/TypeWithEnhancement;", "origin", "enhancement", "Lorg/jetbrains/kotlin/gradle/internal/types/KotlinType;", "<init>", "(Lorg/jetbrains/kotlin/types/FlexibleType;Lorg/jetbrains/kotlin/types/KotlinType;)V", "getOrigin", "()Lorg/jetbrains/kotlin/types/FlexibleType;", "getEnhancement", "()Lorg/jetbrains/kotlin/types/KotlinType;", "replaceAttributes", "Lorg/jetbrains/kotlin/gradle/internal/types/UnwrappedType;", "newAttributes", "Lorg/jetbrains/kotlin/gradle/internal/types/TypeAttributes;", "makeNullableAsSpecified", "newNullability", "", "render", "", "renderer", "Lorg/jetbrains/kotlin/gradle/internal/renderer/DescriptorRenderer;", "options", "Lorg/jetbrains/kotlin/gradle/internal/renderer/DescriptorRendererOptions;", "delegate", "Lorg/jetbrains/kotlin/gradle/internal/types/SimpleType;", "getDelegate", "()Lorg/jetbrains/kotlin/types/SimpleType;", "refine", "kotlinTypeRefiner", "Lorg/jetbrains/kotlin/gradle/internal/types/checker/KotlinTypeRefiner;", "toString", "descriptors"})
public final class FlexibleTypeWithEnhancement
extends FlexibleType
implements TypeWithEnhancement {
    @NotNull
    private final FlexibleType origin;
    @NotNull
    private final KotlinType enhancement;

    public FlexibleTypeWithEnhancement(@NotNull FlexibleType origin, @NotNull KotlinType enhancement) {
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        Intrinsics.checkNotNullParameter((Object)enhancement, (String)"enhancement");
        super(origin.getLowerBound(), origin.getUpperBound());
        this.origin = origin;
        this.enhancement = enhancement;
    }

    @Override
    @NotNull
    public FlexibleType getOrigin() {
        return this.origin;
    }

    @Override
    @NotNull
    public KotlinType getEnhancement() {
        return this.enhancement;
    }

    @Override
    @NotNull
    public UnwrappedType replaceAttributes(@NotNull TypeAttributes newAttributes) {
        Intrinsics.checkNotNullParameter((Object)newAttributes, (String)"newAttributes");
        return TypeWithEnhancementKt.wrapEnhancement(this.getOrigin().replaceAttributes(newAttributes), this.getEnhancement());
    }

    @Override
    @NotNull
    public UnwrappedType makeNullableAsSpecified(boolean newNullability) {
        return TypeWithEnhancementKt.wrapEnhancement(this.getOrigin().makeNullableAsSpecified(newNullability), this.getEnhancement().unwrap().makeNullableAsSpecified(newNullability));
    }

    @Override
    @NotNull
    public String render(@NotNull DescriptorRenderer renderer, @NotNull DescriptorRendererOptions options) {
        Intrinsics.checkNotNullParameter((Object)renderer, (String)"renderer");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        if (options.getEnhancedTypes()) {
            return renderer.renderType(this.getEnhancement());
        }
        return this.getOrigin().render(renderer, options);
    }

    @Override
    @NotNull
    public SimpleType getDelegate() {
        return this.getOrigin().getDelegate();
    }

    @Override
    @TypeRefinement
    @NotNull
    public FlexibleTypeWithEnhancement refine(@NotNull KotlinTypeRefiner kotlinTypeRefiner) {
        Intrinsics.checkNotNullParameter((Object)kotlinTypeRefiner, (String)"kotlinTypeRefiner");
        KotlinType kotlinType = kotlinTypeRefiner.refineType(this.getOrigin());
        Intrinsics.checkNotNull((Object)kotlinType, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.types.FlexibleType");
        return new FlexibleTypeWithEnhancement((FlexibleType)kotlinType, kotlinTypeRefiner.refineType(this.getEnhancement()));
    }

    @Override
    @NotNull
    public String toString() {
        return "[@EnhancedForWarnings(" + this.getEnhancement() + ")] " + this.getOrigin();
    }
}

