/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.google.common.collect;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import javax.annotation.CheckForNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jetbrains.kotlin.com.google.common.annotations.GwtIncompatible;
import org.jetbrains.kotlin.com.google.common.annotations.J2ktIncompatible;
import org.jetbrains.kotlin.com.google.common.annotations.VisibleForTesting;
import org.jetbrains.kotlin.com.google.common.base.Objects;
import org.jetbrains.kotlin.com.google.common.base.Preconditions;
import org.jetbrains.kotlin.com.google.common.collect.AbstractMapEntry;
import org.jetbrains.kotlin.com.google.common.collect.CollectPreconditions;
import org.jetbrains.kotlin.com.google.common.collect.CollectSpliterators;
import org.jetbrains.kotlin.com.google.common.collect.CompactHashing;
import org.jetbrains.kotlin.com.google.common.collect.ElementTypesAreNonnullByDefault;
import org.jetbrains.kotlin.com.google.common.collect.Hashing;
import org.jetbrains.kotlin.com.google.common.collect.Maps;
import org.jetbrains.kotlin.com.google.common.collect.NullnessCasts;
import org.jetbrains.kotlin.com.google.common.collect.ObjectArrays;
import org.jetbrains.kotlin.com.google.common.collect.ParametricNullness;
import org.jetbrains.kotlin.com.google.common.primitives.Ints;
import org.jetbrains.kotlin.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.jetbrains.kotlin.com.google.errorprone.annotations.concurrent.LazyInit;

@ElementTypesAreNonnullByDefault
@GwtIncompatible
class CompactHashMap<K, V>
extends AbstractMap<K, V>
implements Serializable {
    private static final Object NOT_FOUND = new Object();
    @VisibleForTesting
    static final double HASH_FLOODING_FPP = 0.001;
    private static final int MAX_HASH_BUCKET_LENGTH = 9;
    @CheckForNull
    private transient Object table;
    @CheckForNull
    @VisibleForTesting
    transient int[] entries;
    @CheckForNull
    @VisibleForTesting
    transient @Nullable Object[] keys;
    @CheckForNull
    @VisibleForTesting
    transient @Nullable Object[] values;
    private transient int metadata;
    private transient int size;
    @LazyInit
    @CheckForNull
    private transient Set<K> keySetView;
    @LazyInit
    @CheckForNull
    private transient Set<Map.Entry<K, V>> entrySetView;
    @LazyInit
    @CheckForNull
    private transient Collection<V> valuesView;

    public static <K, V> CompactHashMap<K, V> create() {
        return new CompactHashMap<K, V>();
    }

    public static <K, V> CompactHashMap<K, V> createWithExpectedSize(int expectedSize) {
        return new CompactHashMap<K, V>(expectedSize);
    }

    CompactHashMap() {
        this.init(3);
    }

    CompactHashMap(int expectedSize) {
        this.init(expectedSize);
    }

    void init(int expectedSize) {
        Preconditions.checkArgument(expectedSize >= 0, "Expected size must be >= 0");
        this.metadata = Ints.constrainToRange(expectedSize, 1, 0x3FFFFFFF);
    }

    @VisibleForTesting
    boolean needsAllocArrays() {
        return this.table == null;
    }

    @CanIgnoreReturnValue
    int allocArrays() {
        Preconditions.checkState(this.needsAllocArrays(), "Arrays already allocated");
        int expectedSize = this.metadata;
        int buckets = CompactHashing.tableSize(expectedSize);
        this.table = CompactHashing.createTable(buckets);
        this.setHashTableMask(buckets - 1);
        this.entries = new int[expectedSize];
        this.keys = new Object[expectedSize];
        this.values = new Object[expectedSize];
        return expectedSize;
    }

    @CheckForNull
    @VisibleForTesting
    Map<K, V> delegateOrNull() {
        if (this.table instanceof Map) {
            return (Map)this.table;
        }
        return null;
    }

    Map<K, V> createHashFloodingResistantDelegate(int tableSize) {
        return new LinkedHashMap(tableSize, 1.0f);
    }

    @VisibleForTesting
    @CanIgnoreReturnValue
    Map<K, V> convertToHashFloodingResistantImplementation() {
        Map<K, V> newDelegate = this.createHashFloodingResistantDelegate(this.hashTableMask() + 1);
        int i2 = this.firstEntryIndex();
        while (i2 >= 0) {
            newDelegate.put(this.key(i2), this.value(i2));
            i2 = this.getSuccessor(i2);
        }
        this.table = newDelegate;
        this.entries = null;
        this.keys = null;
        this.values = null;
        this.incrementModCount();
        return newDelegate;
    }

    private void setHashTableMask(int mask) {
        int hashTableBits = 32 - Integer.numberOfLeadingZeros(mask);
        this.metadata = CompactHashing.maskCombine(this.metadata, hashTableBits, 31);
    }

    private int hashTableMask() {
        return (1 << (this.metadata & 0x1F)) - 1;
    }

    void incrementModCount() {
        this.metadata += 32;
    }

    void accessEntry(int index) {
    }

    @Override
    @CheckForNull
    @CanIgnoreReturnValue
    public V put(@ParametricNullness K key, @ParametricNullness V value2) {
        Map<K, V> delegate2;
        if (this.needsAllocArrays()) {
            this.allocArrays();
        }
        if ((delegate2 = this.delegateOrNull()) != null) {
            return delegate2.put(key, value2);
        }
        int[] entries2 = this.requireEntries();
        @Nullable Object[] keys = this.requireKeys();
        @Nullable Object[] values = this.requireValues();
        int newEntryIndex = this.size;
        int newSize = newEntryIndex + 1;
        int hash = Hashing.smearedHash(key);
        int mask = this.hashTableMask();
        int tableIndex = hash & mask;
        int next = CompactHashing.tableGet(this.requireTable(), tableIndex);
        if (next == 0) {
            if (newSize > mask) {
                mask = this.resizeTable(mask, CompactHashing.newCapacity(mask), hash, newEntryIndex);
            } else {
                CompactHashing.tableSet(this.requireTable(), tableIndex, newEntryIndex + 1);
            }
        } else {
            int entry2;
            int hashPrefix = CompactHashing.getHashPrefix(hash, mask);
            int bucketLength = 0;
            do {
                int entryIndex;
                if (CompactHashing.getHashPrefix(entry2 = entries2[entryIndex = next - 1], mask) == hashPrefix && Objects.equal(key, keys[entryIndex])) {
                    Object oldValue = values[entryIndex];
                    values[entryIndex] = value2;
                    this.accessEntry(entryIndex);
                    return (V)oldValue;
                }
                next = CompactHashing.getNext(entry2, mask);
                ++bucketLength;
            } while (next != 0);
            if (bucketLength >= 9) {
                return this.convertToHashFloodingResistantImplementation().put(key, value2);
            }
            if (newSize > mask) {
                mask = this.resizeTable(mask, CompactHashing.newCapacity(mask), hash, newEntryIndex);
            } else {
                entries2[entryIndex] = CompactHashing.maskCombine(entry2, newEntryIndex + 1, mask);
            }
        }
        this.resizeMeMaybe(newSize);
        this.insertEntry(newEntryIndex, key, value2, hash, mask);
        this.size = newSize;
        this.incrementModCount();
        return null;
    }

    void insertEntry(int entryIndex, @ParametricNullness K key, @ParametricNullness V value2, int hash, int mask) {
        this.setEntry(entryIndex, CompactHashing.maskCombine(hash, 0, mask));
        this.setKey(entryIndex, key);
        this.setValue(entryIndex, value2);
    }

    private void resizeMeMaybe(int newSize) {
        int newCapacity;
        int entriesSize = this.requireEntries().length;
        if (newSize > entriesSize && (newCapacity = Math.min(0x3FFFFFFF, entriesSize + Math.max(1, entriesSize >>> 1) | 1)) != entriesSize) {
            this.resizeEntries(newCapacity);
        }
    }

    void resizeEntries(int newCapacity) {
        this.entries = Arrays.copyOf(this.requireEntries(), newCapacity);
        this.keys = Arrays.copyOf(this.requireKeys(), newCapacity);
        this.values = Arrays.copyOf(this.requireValues(), newCapacity);
    }

    @CanIgnoreReturnValue
    private int resizeTable(int oldMask, int newCapacity, int targetHash, int targetEntryIndex) {
        Object newTable = CompactHashing.createTable(newCapacity);
        int newMask = newCapacity - 1;
        if (targetEntryIndex != 0) {
            CompactHashing.tableSet(newTable, targetHash & newMask, targetEntryIndex + 1);
        }
        Object oldTable = this.requireTable();
        int[] entries2 = this.requireEntries();
        for (int oldTableIndex = 0; oldTableIndex <= oldMask; ++oldTableIndex) {
            int oldNext = CompactHashing.tableGet(oldTable, oldTableIndex);
            while (oldNext != 0) {
                int entryIndex = oldNext - 1;
                int oldEntry = entries2[entryIndex];
                int hash = CompactHashing.getHashPrefix(oldEntry, oldMask) | oldTableIndex;
                int newTableIndex = hash & newMask;
                int newNext = CompactHashing.tableGet(newTable, newTableIndex);
                CompactHashing.tableSet(newTable, newTableIndex, oldNext);
                entries2[entryIndex] = CompactHashing.maskCombine(hash, newNext, newMask);
                oldNext = CompactHashing.getNext(oldEntry, oldMask);
            }
        }
        this.table = newTable;
        this.setHashTableMask(newMask);
        return newMask;
    }

    private int indexOf(@CheckForNull Object key) {
        int entry2;
        if (this.needsAllocArrays()) {
            return -1;
        }
        int hash = Hashing.smearedHash(key);
        int mask = this.hashTableMask();
        int next = CompactHashing.tableGet(this.requireTable(), hash & mask);
        if (next == 0) {
            return -1;
        }
        int hashPrefix = CompactHashing.getHashPrefix(hash, mask);
        do {
            int entryIndex;
            if (CompactHashing.getHashPrefix(entry2 = this.entry(entryIndex = next - 1), mask) != hashPrefix || !Objects.equal(key, this.key(entryIndex))) continue;
            return entryIndex;
        } while ((next = CompactHashing.getNext(entry2, mask)) != 0);
        return -1;
    }

    @Override
    public boolean containsKey(@CheckForNull Object key) {
        Map<K, V> delegate2 = this.delegateOrNull();
        return delegate2 != null ? delegate2.containsKey(key) : this.indexOf(key) != -1;
    }

    @Override
    @CheckForNull
    public V get(@CheckForNull Object key) {
        Map<K, V> delegate2 = this.delegateOrNull();
        if (delegate2 != null) {
            return delegate2.get(key);
        }
        int index = this.indexOf(key);
        if (index == -1) {
            return null;
        }
        this.accessEntry(index);
        return this.value(index);
    }

    @Override
    @CheckForNull
    @CanIgnoreReturnValue
    public V remove(@CheckForNull Object key) {
        Map<K, V> delegate2 = this.delegateOrNull();
        if (delegate2 != null) {
            return delegate2.remove(key);
        }
        Object oldValue = this.removeHelper(key);
        return (V)(oldValue == NOT_FOUND ? null : oldValue);
    }

    private @Nullable Object removeHelper(@CheckForNull Object key) {
        if (this.needsAllocArrays()) {
            return NOT_FOUND;
        }
        int mask = this.hashTableMask();
        int index = CompactHashing.remove(key, null, mask, this.requireTable(), this.requireEntries(), this.requireKeys(), null);
        if (index == -1) {
            return NOT_FOUND;
        }
        V oldValue = this.value(index);
        this.moveLastEntry(index, mask);
        --this.size;
        this.incrementModCount();
        return oldValue;
    }

    void moveLastEntry(int dstIndex, int mask) {
        Object table = this.requireTable();
        int[] entries2 = this.requireEntries();
        @Nullable Object[] keys = this.requireKeys();
        @Nullable Object[] values = this.requireValues();
        int srcIndex = this.size() - 1;
        if (dstIndex < srcIndex) {
            int srcNext;
            Object key;
            keys[dstIndex] = key = keys[srcIndex];
            values[dstIndex] = values[srcIndex];
            keys[srcIndex] = null;
            values[srcIndex] = null;
            entries2[dstIndex] = entries2[srcIndex];
            entries2[srcIndex] = 0;
            int tableIndex = Hashing.smearedHash(key) & mask;
            int next = CompactHashing.tableGet(table, tableIndex);
            if (next == (srcNext = srcIndex + 1)) {
                CompactHashing.tableSet(table, tableIndex, dstIndex + 1);
            } else {
                int entryIndex;
                int entry2;
                while ((next = CompactHashing.getNext(entry2 = entries2[entryIndex = next - 1], mask)) != srcNext) {
                }
                entries2[entryIndex] = CompactHashing.maskCombine(entry2, dstIndex + 1, mask);
            }
        } else {
            keys[dstIndex] = null;
            values[dstIndex] = null;
            entries2[dstIndex] = 0;
        }
    }

    int firstEntryIndex() {
        return this.isEmpty() ? -1 : 0;
    }

    int getSuccessor(int entryIndex) {
        return entryIndex + 1 < this.size ? entryIndex + 1 : -1;
    }

    int adjustAfterRemove(int indexBeforeRemove, int indexRemoved) {
        return indexBeforeRemove - 1;
    }

    @Override
    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        Preconditions.checkNotNull(function);
        Map<? super K, ? extends V> delegate2 = this.delegateOrNull();
        if (delegate2 != null) {
            delegate2.replaceAll(function);
        } else {
            for (int i2 = 0; i2 < this.size; ++i2) {
                this.setValue(i2, function.apply(this.key(i2), this.value(i2)));
            }
        }
    }

    @Override
    public Set<K> keySet() {
        return this.keySetView == null ? (this.keySetView = this.createKeySet()) : this.keySetView;
    }

    Set<K> createKeySet() {
        return new KeySetView();
    }

    Iterator<K> keySetIterator() {
        Map<K, V> delegate2 = this.delegateOrNull();
        if (delegate2 != null) {
            return delegate2.keySet().iterator();
        }
        return new Itr<K>(){

            @Override
            @ParametricNullness
            K getOutput(int entry2) {
                return CompactHashMap.this.key(entry2);
            }
        };
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> action2) {
        Preconditions.checkNotNull(action2);
        Map<? super K, ? super V> delegate2 = this.delegateOrNull();
        if (delegate2 != null) {
            delegate2.forEach(action2);
        } else {
            int i2 = this.firstEntryIndex();
            while (i2 >= 0) {
                action2.accept(this.key(i2), this.value(i2));
                i2 = this.getSuccessor(i2);
            }
        }
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.entrySetView == null ? (this.entrySetView = this.createEntrySet()) : this.entrySetView;
    }

    Set<Map.Entry<K, V>> createEntrySet() {
        return new EntrySetView();
    }

    Iterator<Map.Entry<K, V>> entrySetIterator() {
        Map<K, V> delegate2 = this.delegateOrNull();
        if (delegate2 != null) {
            return delegate2.entrySet().iterator();
        }
        return new Itr<Map.Entry<K, V>>(){

            @Override
            Map.Entry<K, V> getOutput(int entry2) {
                return new MapEntry(entry2);
            }
        };
    }

    @Override
    public int size() {
        Map<K, V> delegate2 = this.delegateOrNull();
        return delegate2 != null ? delegate2.size() : this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsValue(@CheckForNull Object value2) {
        Map<K, V> delegate2 = this.delegateOrNull();
        if (delegate2 != null) {
            return delegate2.containsValue(value2);
        }
        for (int i2 = 0; i2 < this.size; ++i2) {
            if (!Objects.equal(value2, this.value(i2))) continue;
            return true;
        }
        return false;
    }

    @Override
    public Collection<V> values() {
        return this.valuesView == null ? (this.valuesView = this.createValues()) : this.valuesView;
    }

    Collection<V> createValues() {
        return new ValuesView();
    }

    Iterator<V> valuesIterator() {
        Map<K, V> delegate2 = this.delegateOrNull();
        if (delegate2 != null) {
            return delegate2.values().iterator();
        }
        return new Itr<V>(){

            @Override
            @ParametricNullness
            V getOutput(int entry2) {
                return CompactHashMap.this.value(entry2);
            }
        };
    }

    public void trimToSize() {
        int mask;
        int minimumTableSize;
        if (this.needsAllocArrays()) {
            return;
        }
        Map<K, V> delegate2 = this.delegateOrNull();
        if (delegate2 != null) {
            Map<K, V> newDelegate = this.createHashFloodingResistantDelegate(this.size());
            newDelegate.putAll(delegate2);
            this.table = newDelegate;
            return;
        }
        int size = this.size;
        if (size < this.requireEntries().length) {
            this.resizeEntries(size);
        }
        if ((minimumTableSize = CompactHashing.tableSize(size)) < (mask = this.hashTableMask())) {
            this.resizeTable(mask, minimumTableSize, 0, 0);
        }
    }

    @Override
    public void clear() {
        if (this.needsAllocArrays()) {
            return;
        }
        this.incrementModCount();
        Map<K, V> delegate2 = this.delegateOrNull();
        if (delegate2 != null) {
            this.metadata = Ints.constrainToRange(this.size(), 3, 0x3FFFFFFF);
            delegate2.clear();
            this.table = null;
            this.size = 0;
        } else {
            Arrays.fill(this.requireKeys(), 0, this.size, null);
            Arrays.fill(this.requireValues(), 0, this.size, null);
            CompactHashing.tableClear(this.requireTable());
            Arrays.fill(this.requireEntries(), 0, this.size, 0);
            this.size = 0;
        }
    }

    @J2ktIncompatible
    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeInt(this.size());
        Iterator<Map.Entry<K, V>> entryIterator = this.entrySetIterator();
        while (entryIterator.hasNext()) {
            Map.Entry<K, V> e = entryIterator.next();
            stream.writeObject(e.getKey());
            stream.writeObject(e.getValue());
        }
    }

    @J2ktIncompatible
    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        int elementCount = stream.readInt();
        if (elementCount < 0) {
            throw new InvalidObjectException("Invalid size: " + elementCount);
        }
        this.init(elementCount);
        for (int i2 = 0; i2 < elementCount; ++i2) {
            Object key = stream.readObject();
            Object value2 = stream.readObject();
            this.put(key, value2);
        }
    }

    private Object requireTable() {
        return java.util.Objects.requireNonNull(this.table);
    }

    private int[] requireEntries() {
        return java.util.Objects.requireNonNull(this.entries);
    }

    private @Nullable Object[] requireKeys() {
        return java.util.Objects.requireNonNull(this.keys);
    }

    private @Nullable Object[] requireValues() {
        return java.util.Objects.requireNonNull(this.values);
    }

    private K key(int i2) {
        return (K)this.requireKeys()[i2];
    }

    private V value(int i2) {
        return (V)this.requireValues()[i2];
    }

    private int entry(int i2) {
        return this.requireEntries()[i2];
    }

    private void setKey(int i2, K key) {
        this.requireKeys()[i2] = key;
    }

    private void setValue(int i2, V value2) {
        this.requireValues()[i2] = value2;
    }

    private void setEntry(int i2, int value2) {
        this.requireEntries()[i2] = value2;
    }

    class ValuesView
    extends Maps.Values<K, V> {
        ValuesView() {
            super(CompactHashMap.this);
        }

        @Override
        public Iterator<V> iterator() {
            return CompactHashMap.this.valuesIterator();
        }

        @Override
        public void forEach(Consumer<? super V> action2) {
            Preconditions.checkNotNull(action2);
            Map delegate2 = CompactHashMap.this.delegateOrNull();
            if (delegate2 != null) {
                delegate2.values().forEach(action2);
            } else {
                int i2 = CompactHashMap.this.firstEntryIndex();
                while (i2 >= 0) {
                    action2.accept(CompactHashMap.this.value(i2));
                    i2 = CompactHashMap.this.getSuccessor(i2);
                }
            }
        }

        @Override
        public Spliterator<V> spliterator() {
            if (CompactHashMap.this.needsAllocArrays()) {
                return Spliterators.spliterator(new Object[0], 16);
            }
            Map delegate2 = CompactHashMap.this.delegateOrNull();
            return delegate2 != null ? delegate2.values().spliterator() : Spliterators.spliterator(CompactHashMap.this.requireValues(), 0, CompactHashMap.this.size, 16);
        }

        @Override
        public @Nullable Object[] toArray() {
            if (CompactHashMap.this.needsAllocArrays()) {
                return new Object[0];
            }
            Map delegate2 = CompactHashMap.this.delegateOrNull();
            return delegate2 != null ? delegate2.values().toArray() : ObjectArrays.copyAsObjectArray(CompactHashMap.this.requireValues(), 0, CompactHashMap.this.size);
        }

        @Override
        public <T> T[] toArray(T[] a) {
            if (CompactHashMap.this.needsAllocArrays()) {
                if (a.length > 0) {
                    @Nullable T[] unsoundlyCovariantArray = a;
                    unsoundlyCovariantArray[0] = null;
                }
                return a;
            }
            Map delegate2 = CompactHashMap.this.delegateOrNull();
            return delegate2 != null ? delegate2.values().toArray(a) : ObjectArrays.toArrayImpl(CompactHashMap.this.requireValues(), 0, CompactHashMap.this.size, a);
        }
    }

    final class MapEntry
    extends AbstractMapEntry<K, V> {
        @ParametricNullness
        private final K key;
        private int lastKnownIndex;

        MapEntry(int index) {
            this.key = CompactHashMap.this.key(index);
            this.lastKnownIndex = index;
        }

        @Override
        @ParametricNullness
        public K getKey() {
            return this.key;
        }

        private void updateLastKnownIndex() {
            if (this.lastKnownIndex == -1 || this.lastKnownIndex >= CompactHashMap.this.size() || !Objects.equal(this.key, CompactHashMap.this.key(this.lastKnownIndex))) {
                this.lastKnownIndex = CompactHashMap.this.indexOf(this.key);
            }
        }

        @Override
        @ParametricNullness
        public V getValue() {
            Map delegate2 = CompactHashMap.this.delegateOrNull();
            if (delegate2 != null) {
                return NullnessCasts.uncheckedCastNullableTToT(delegate2.get(this.key));
            }
            this.updateLastKnownIndex();
            return this.lastKnownIndex == -1 ? NullnessCasts.unsafeNull() : CompactHashMap.this.value(this.lastKnownIndex);
        }

        @Override
        @ParametricNullness
        public V setValue(@ParametricNullness V value2) {
            Map delegate2 = CompactHashMap.this.delegateOrNull();
            if (delegate2 != null) {
                return NullnessCasts.uncheckedCastNullableTToT(delegate2.put(this.key, value2));
            }
            this.updateLastKnownIndex();
            if (this.lastKnownIndex == -1) {
                CompactHashMap.this.put(this.key, value2);
                return NullnessCasts.unsafeNull();
            }
            Object old = CompactHashMap.this.value(this.lastKnownIndex);
            CompactHashMap.this.setValue(this.lastKnownIndex, value2);
            return old;
        }
    }

    class EntrySetView
    extends Maps.EntrySet<K, V> {
        EntrySetView() {
        }

        @Override
        Map<K, V> map() {
            return CompactHashMap.this;
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return CompactHashMap.this.entrySetIterator();
        }

        @Override
        public Spliterator<Map.Entry<K, V>> spliterator() {
            Map delegate2 = CompactHashMap.this.delegateOrNull();
            return delegate2 != null ? delegate2.entrySet().spliterator() : CollectSpliterators.indexed(CompactHashMap.this.size, 17, x$0 -> new MapEntry(x$0));
        }

        @Override
        public boolean contains(@CheckForNull Object o) {
            Map delegate2 = CompactHashMap.this.delegateOrNull();
            if (delegate2 != null) {
                return delegate2.entrySet().contains(o);
            }
            if (o instanceof Map.Entry) {
                Map.Entry entry2 = (Map.Entry)o;
                int index = CompactHashMap.this.indexOf(entry2.getKey());
                return index != -1 && Objects.equal(CompactHashMap.this.value(index), entry2.getValue());
            }
            return false;
        }

        @Override
        public boolean remove(@CheckForNull Object o) {
            Map delegate2 = CompactHashMap.this.delegateOrNull();
            if (delegate2 != null) {
                return delegate2.entrySet().remove(o);
            }
            if (o instanceof Map.Entry) {
                Map.Entry entry2 = (Map.Entry)o;
                if (CompactHashMap.this.needsAllocArrays()) {
                    return false;
                }
                int mask = CompactHashMap.this.hashTableMask();
                int index = CompactHashing.remove(entry2.getKey(), entry2.getValue(), mask, CompactHashMap.this.requireTable(), CompactHashMap.this.requireEntries(), CompactHashMap.this.requireKeys(), CompactHashMap.this.requireValues());
                if (index == -1) {
                    return false;
                }
                CompactHashMap.this.moveLastEntry(index, mask);
                CompactHashMap.this.size--;
                CompactHashMap.this.incrementModCount();
                return true;
            }
            return false;
        }
    }

    class KeySetView
    extends Maps.KeySet<K, V> {
        KeySetView() {
            super(CompactHashMap.this);
        }

        @Override
        public @Nullable Object[] toArray() {
            if (CompactHashMap.this.needsAllocArrays()) {
                return new Object[0];
            }
            Map delegate2 = CompactHashMap.this.delegateOrNull();
            return delegate2 != null ? delegate2.keySet().toArray() : ObjectArrays.copyAsObjectArray(CompactHashMap.this.requireKeys(), 0, CompactHashMap.this.size);
        }

        @Override
        public <T> T[] toArray(T[] a) {
            if (CompactHashMap.this.needsAllocArrays()) {
                if (a.length > 0) {
                    @Nullable T[] unsoundlyCovariantArray = a;
                    unsoundlyCovariantArray[0] = null;
                }
                return a;
            }
            Map delegate2 = CompactHashMap.this.delegateOrNull();
            return delegate2 != null ? delegate2.keySet().toArray(a) : ObjectArrays.toArrayImpl(CompactHashMap.this.requireKeys(), 0, CompactHashMap.this.size, a);
        }

        @Override
        public boolean remove(@CheckForNull Object o) {
            Map delegate2 = CompactHashMap.this.delegateOrNull();
            return delegate2 != null ? delegate2.keySet().remove(o) : CompactHashMap.this.removeHelper(o) != NOT_FOUND;
        }

        @Override
        public Iterator<K> iterator() {
            return CompactHashMap.this.keySetIterator();
        }

        @Override
        public Spliterator<K> spliterator() {
            if (CompactHashMap.this.needsAllocArrays()) {
                return Spliterators.spliterator(new Object[0], 17);
            }
            Map delegate2 = CompactHashMap.this.delegateOrNull();
            return delegate2 != null ? delegate2.keySet().spliterator() : Spliterators.spliterator(CompactHashMap.this.requireKeys(), 0, CompactHashMap.this.size, 17);
        }

        @Override
        public void forEach(Consumer<? super K> action2) {
            Preconditions.checkNotNull(action2);
            Map delegate2 = CompactHashMap.this.delegateOrNull();
            if (delegate2 != null) {
                delegate2.keySet().forEach(action2);
            } else {
                int i2 = CompactHashMap.this.firstEntryIndex();
                while (i2 >= 0) {
                    action2.accept(CompactHashMap.this.key(i2));
                    i2 = CompactHashMap.this.getSuccessor(i2);
                }
            }
        }
    }

    private abstract class Itr<T>
    implements Iterator<T> {
        int expectedMetadata;
        int currentIndex;
        int indexToRemove;

        private Itr() {
            this.expectedMetadata = CompactHashMap.this.metadata;
            this.currentIndex = CompactHashMap.this.firstEntryIndex();
            this.indexToRemove = -1;
        }

        @Override
        public boolean hasNext() {
            return this.currentIndex >= 0;
        }

        @ParametricNullness
        abstract T getOutput(int var1);

        @Override
        @ParametricNullness
        public T next() {
            this.checkForConcurrentModification();
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.indexToRemove = this.currentIndex;
            T result2 = this.getOutput(this.currentIndex);
            this.currentIndex = CompactHashMap.this.getSuccessor(this.currentIndex);
            return result2;
        }

        @Override
        public void remove() {
            this.checkForConcurrentModification();
            CollectPreconditions.checkRemove(this.indexToRemove >= 0);
            this.incrementExpectedModCount();
            CompactHashMap.this.remove(CompactHashMap.this.key(this.indexToRemove));
            this.currentIndex = CompactHashMap.this.adjustAfterRemove(this.currentIndex, this.indexToRemove);
            this.indexToRemove = -1;
        }

        void incrementExpectedModCount() {
            this.expectedMetadata += 32;
        }

        private void checkForConcurrentModification() {
            if (CompactHashMap.this.metadata != this.expectedMetadata) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

