/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.commons.compress.archivers.examples;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.EnumSet;
import java.util.Objects;
import org.jetbrains.kotlin.org.apache.commons.compress.archivers.ArchiveEntry;
import org.jetbrains.kotlin.org.apache.commons.compress.archivers.ArchiveException;
import org.jetbrains.kotlin.org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.jetbrains.kotlin.org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.jetbrains.kotlin.org.apache.commons.compress.archivers.examples.CloseableConsumer;
import org.jetbrains.kotlin.org.apache.commons.compress.archivers.examples.CloseableConsumerAdapter;
import org.jetbrains.kotlin.org.apache.commons.compress.archivers.sevenz.SevenZArchiveEntry;
import org.jetbrains.kotlin.org.apache.commons.compress.archivers.sevenz.SevenZOutputFile;
import org.jetbrains.kotlin.org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.jetbrains.kotlin.org.apache.commons.compress.utils.IOUtils;

public class Archiver {
    public static final EnumSet<FileVisitOption> EMPTY_FileVisitOption = EnumSet.noneOf(FileVisitOption.class);

    public void create(ArchiveOutputStream<?> target2, File directory) throws IOException {
        this.create(target2, directory.toPath(), EMPTY_FileVisitOption, new LinkOption[0]);
    }

    public void create(ArchiveOutputStream<?> target2, Path directory) throws IOException {
        this.create(target2, directory, EMPTY_FileVisitOption, new LinkOption[0]);
    }

    public void create(ArchiveOutputStream<?> target2, Path directory, EnumSet<FileVisitOption> fileVisitOptions, LinkOption ... linkOptions) throws IOException {
        Files.walkFileTree(directory, fileVisitOptions, Integer.MAX_VALUE, new ArchiverFileVisitor(target2, directory, linkOptions, null));
        target2.finish();
    }

    public void create(SevenZOutputFile target2, File directory) throws IOException {
        this.create(target2, directory.toPath());
    }

    public void create(final SevenZOutputFile target2, final Path directory) throws IOException {
        Files.walkFileTree(directory, new ArchiverFileVisitor(null, directory, new LinkOption[0]){

            @Override
            protected FileVisitResult visit(Path path, BasicFileAttributes attrs, boolean isFile) throws IOException {
                Objects.requireNonNull(path);
                Objects.requireNonNull(attrs);
                String name2 = directory.relativize(path).toString().replace('\\', '/');
                if (!name2.isEmpty()) {
                    SevenZArchiveEntry archiveEntry = target2.createArchiveEntry(path, isFile || name2.endsWith("/") ? name2 : name2 + "/", new LinkOption[0]);
                    target2.putArchiveEntry(archiveEntry);
                    if (isFile) {
                        target2.write(path, new OpenOption[0]);
                    }
                    target2.closeArchiveEntry();
                }
                return FileVisitResult.CONTINUE;
            }
        });
        target2.finish();
    }

    public void create(String format, File target2, File directory) throws IOException, ArchiveException {
        this.create(format, target2.toPath(), directory.toPath());
    }

    @Deprecated
    public void create(String format, OutputStream target2, File directory) throws IOException, ArchiveException {
        this.create(format, target2, directory, CloseableConsumer.NULL_CONSUMER);
    }

    public void create(String format, OutputStream target2, File directory, CloseableConsumer closeableConsumer) throws IOException, ArchiveException {
        try (CloseableConsumerAdapter c = new CloseableConsumerAdapter(closeableConsumer);){
            Object archiveOutputStream = ArchiveStreamFactory.DEFAULT.createArchiveOutputStream(format, target2);
            this.create((ArchiveOutputStream)c.track(archiveOutputStream), directory);
        }
    }

    public void create(String format, Path target2, Path directory) throws IOException, ArchiveException {
        if (this.prefersSeekableByteChannel(format)) {
            try (FileChannel channel = FileChannel.open(target2, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
                this.create(format, (SeekableByteChannel)channel, directory);
                return;
            }
        }
        try (Object outputStream = ArchiveStreamFactory.DEFAULT.createArchiveOutputStream(format, Files.newOutputStream(target2, new OpenOption[0]));){
            this.create((ArchiveOutputStream<?>)outputStream, directory, EMPTY_FileVisitOption, new LinkOption[0]);
        }
    }

    @Deprecated
    public void create(String format, SeekableByteChannel target2, File directory) throws IOException, ArchiveException {
        this.create(format, target2, directory, CloseableConsumer.NULL_CONSUMER);
    }

    public void create(String format, SeekableByteChannel target2, File directory, CloseableConsumer closeableConsumer) throws IOException, ArchiveException {
        block8: {
            try (CloseableConsumerAdapter c = new CloseableConsumerAdapter(closeableConsumer);){
                if (!this.prefersSeekableByteChannel(format)) {
                    this.create(format, c.track(Channels.newOutputStream(target2)), directory);
                    break block8;
                }
                if ("zip".equalsIgnoreCase(format)) {
                    this.create((ArchiveOutputStream)c.track(new ZipArchiveOutputStream(target2)), directory);
                    break block8;
                }
                if ("7z".equalsIgnoreCase(format)) {
                    this.create(c.track(new SevenZOutputFile(target2)), directory);
                    break block8;
                }
                throw new ArchiveException("Don't know how to handle format " + format);
            }
        }
    }

    public void create(String format, SeekableByteChannel target2, Path directory) throws IOException {
        if ("7z".equalsIgnoreCase(format)) {
            try (SevenZOutputFile sevenZFile = new SevenZOutputFile(target2);){
                this.create(sevenZFile, directory);
            }
        } else if ("zip".equalsIgnoreCase(format)) {
            try (ZipArchiveOutputStream archiveOutputStream = new ZipArchiveOutputStream(target2);){
                this.create(archiveOutputStream, directory, EMPTY_FileVisitOption, new LinkOption[0]);
            }
        } else {
            throw new IllegalStateException(format);
        }
    }

    private boolean prefersSeekableByteChannel(String format) {
        return "zip".equalsIgnoreCase(format) || "7z".equalsIgnoreCase(format);
    }

    private static class ArchiverFileVisitor<O extends ArchiveOutputStream<E>, E extends ArchiveEntry>
    extends SimpleFileVisitor<Path> {
        private final O target;
        private final Path directory;
        private final LinkOption[] linkOptions;

        private ArchiverFileVisitor(O target2, Path directory, LinkOption ... linkOptions) {
            this.target = target2;
            this.directory = directory;
            this.linkOptions = linkOptions == null ? IOUtils.EMPTY_LINK_OPTIONS : (LinkOption[])linkOptions.clone();
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir2, BasicFileAttributes attrs) throws IOException {
            return this.visit(dir2, attrs, false);
        }

        protected FileVisitResult visit(Path path, BasicFileAttributes attrs, boolean isFile) throws IOException {
            Objects.requireNonNull(path);
            Objects.requireNonNull(attrs);
            String name2 = this.directory.relativize(path).toString().replace('\\', '/');
            if (!name2.isEmpty()) {
                Object archiveEntry = ((ArchiveOutputStream)this.target).createArchiveEntry(path, isFile || name2.endsWith("/") ? name2 : name2 + "/", this.linkOptions);
                ((ArchiveOutputStream)this.target).putArchiveEntry(archiveEntry);
                if (isFile) {
                    Files.copy(path, this.target);
                }
                ((ArchiveOutputStream)this.target).closeArchiveEntry();
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file2, BasicFileAttributes attrs) throws IOException {
            return this.visit(file2, attrs, true);
        }

        /* synthetic */ ArchiverFileVisitor(ArchiveOutputStream x0, Path x1, LinkOption[] x2, 1 x3) {
            this(x0, x1, x2);
        }
    }
}

