/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin.mpp.apple.swiftexport.tasks;

import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Transformer;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.DeleteSpec;
import org.gradle.api.file.FileSystemOperations;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.work.DisableCachingByDefault;
import org.gradle.workers.ClassLoaderWorkerSpec;
import org.gradle.workers.WorkQueue;
import org.gradle.workers.WorkerExecutor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.plugin.mpp.apple.swiftexport.internal.SwiftExportAction;
import org.jetbrains.kotlin.gradle.plugin.mpp.apple.swiftexport.internal.SwiftExportTaskParameters;
import org.jetbrains.kotlin.gradle.plugin.mpp.apple.swiftexport.internal.SwiftExportedModule;
import org.jetbrains.kotlin.gradle.plugin.mpp.apple.swiftexport.internal.SwiftExportedModuleKt;
import org.jetbrains.kotlin.gradle.plugin.mpp.apple.swiftexport.tasks.SwiftExportTask;
import org.jetbrains.kotlin.gradle.targets.native.toolchain.KotlinNativeProvider;
import org.jetbrains.kotlin.gradle.utils.FileUtilsKt;

@DisableCachingByDefault(because="Swift Export is experimental, so no caching for now")
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b!\u0018\u00002\u00020\u0001:\u0001\u001bB\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0018\u001a\u00020\u0019H\u0002J\b\u0010\u001a\u001a\u00020\u0019H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00118gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00158gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/mpp/apple/swiftexport/tasks/SwiftExportTask;", "Lorg/gradle/api/DefaultTask;", "workerExecutor", "Lorg/gradle/workers/WorkerExecutor;", "fileSystem", "Lorg/gradle/api/file/FileSystemOperations;", "(Lorg/gradle/workers/WorkerExecutor;Lorg/gradle/api/file/FileSystemOperations;)V", "kotlinNativeProvider", "Lorg/gradle/api/provider/Property;", "Lorg/jetbrains/kotlin/gradle/targets/native/toolchain/KotlinNativeProvider;", "getKotlinNativeProvider", "()Lorg/gradle/api/provider/Property;", "mainModuleInput", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/apple/swiftexport/tasks/SwiftExportTask$ModuleInput;", "getMainModuleInput", "()Lorg/jetbrains/kotlin/gradle/plugin/mpp/apple/swiftexport/tasks/SwiftExportTask$ModuleInput;", "parameters", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/apple/swiftexport/internal/SwiftExportTaskParameters;", "getParameters", "()Lorg/jetbrains/kotlin/gradle/plugin/mpp/apple/swiftexport/internal/SwiftExportTaskParameters;", "swiftExportClasspath", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getSwiftExportClasspath", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "cleanup", "", "run", "ModuleInput", "kotlin-gradle-plugin_common"})
public abstract class SwiftExportTask
extends DefaultTask {
    @NotNull
    private final WorkerExecutor workerExecutor;
    @NotNull
    private final FileSystemOperations fileSystem;

    @Inject
    public SwiftExportTask(@NotNull WorkerExecutor workerExecutor, @NotNull FileSystemOperations fileSystem) {
        Intrinsics.checkNotNullParameter((Object)workerExecutor, (String)"workerExecutor");
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        this.workerExecutor = workerExecutor;
        this.fileSystem = fileSystem;
    }

    @Nested
    @NotNull
    public abstract ModuleInput getMainModuleInput();

    @Nested
    @NotNull
    public abstract Property<KotlinNativeProvider> getKotlinNativeProvider();

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public abstract ConfigurableFileCollection getSwiftExportClasspath();

    @Nested
    @NotNull
    public abstract SwiftExportTaskParameters getParameters();

    @TaskAction
    public final void run() {
        this.cleanup();
        WorkQueue swiftExportQueue2 = this.workerExecutor.classLoaderIsolation(new Action(this){
            final /* synthetic */ SwiftExportTask this$0;
            {
                this.this$0 = $receiver;
            }

            public final void execute(ClassLoaderWorkerSpec workerSpec) {
                Object[] objectArray = new Object[]{this.this$0.getSwiftExportClasspath()};
                workerSpec.getClasspath().from(objectArray);
            }
        });
        Provider swiftModules2 = this.getParameters().getSwiftModules().map(new Transformer(this){
            final /* synthetic */ SwiftExportTask this$0;
            {
                this.this$0 = $receiver;
            }

            public final List<SwiftExportedModule> transform(List<SwiftExportedModule> it) {
                Intrinsics.checkNotNullExpressionValue(it, (String)"it");
                List list = CollectionsKt.toMutableList((Collection)it);
                SwiftExportTask swiftExportTask = this.this$0;
                List $this$transform_u24lambda_u240 = list;
                boolean bl = false;
                Object object = swiftExportTask.getMainModuleInput().getModuleName().get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"mainModuleInput.moduleName.get()");
                $this$transform_u24lambda_u240.add(SwiftExportedModuleKt.createSwiftExportedModule((String)object, (String)swiftExportTask.getMainModuleInput().getFlattenPackage().getOrNull(), FileUtilsKt.getFile((Provider<RegularFile>)((Provider)swiftExportTask.getMainModuleInput().getArtifact()))));
                return list;
            }
        });
        swiftExportQueue2.submit(SwiftExportAction.class, new Action(this, (Provider<List<SwiftExportedModule>>)swiftModules2){
            final /* synthetic */ SwiftExportTask this$0;
            final /* synthetic */ Provider<List<SwiftExportedModule>> $swiftModules;
            {
                this.this$0 = $receiver;
                this.$swiftModules = $swiftModules;
            }

            public final void execute(SwiftExportAction.SwiftExportWorkParameters workParameters) {
                workParameters.getBridgeModuleName().set((Provider)this.this$0.getParameters().getBridgeModuleName());
                workParameters.getOutputPath().set((Provider)this.this$0.getParameters().getOutputPath());
                workParameters.getStableDeclarationsOrder().set((Provider)this.this$0.getParameters().getStableDeclarationsOrder());
                workParameters.getSwiftModulesFile().set((Provider)this.this$0.getParameters().getSwiftModulesFile());
                workParameters.getSwiftModules().set(this.$swiftModules);
                workParameters.getKonanDistribution().set(this.this$0.getKotlinNativeProvider().flatMap((Transformer)run.1.INSTANCE).map((Transformer)run.2.INSTANCE));
            }
        });
    }

    private final void cleanup() {
        this.fileSystem.delete(new Action(this){
            final /* synthetic */ SwiftExportTask this$0;
            {
                this.this$0 = $receiver;
            }

            public final void execute(DeleteSpec it) {
                Object[] objectArray = new Object[]{this.this$0.getParameters().getOutputPath()};
                it.delete(objectArray);
            }
        });
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b \u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000b\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/mpp/apple/swiftexport/tasks/SwiftExportTask$ModuleInput;", "", "()V", "artifact", "Lorg/gradle/api/file/RegularFileProperty;", "getArtifact", "()Lorg/gradle/api/file/RegularFileProperty;", "flattenPackage", "Lorg/gradle/api/provider/Property;", "", "getFlattenPackage", "()Lorg/gradle/api/provider/Property;", "moduleName", "getModuleName", "kotlin-gradle-plugin_common"})
    public static abstract class ModuleInput {
        @Input
        @NotNull
        public abstract Property<String> getModuleName();

        @Input
        @Optional
        @NotNull
        public abstract Property<String> getFlattenPackage();

        @InputFiles
        @PathSensitive(value=PathSensitivity.RELATIVE)
        @NotNull
        public abstract RegularFileProperty getArtifact();
    }
}

