/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.messages.serviceMessages;

import java.text.ParseException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapSerializerUtil {
    private static final String STD_EX_SUFFIX = "Valid service message has a form of \"##teamcity[messageName name1='escaped_value' name2='escaped_value']\" where escaped_value uses substitutions: '->|', [->|[, ]->|], |->||, newline->|n";
    protected static final String PARSING_ERROR_PREFIX = "Error while parsing TeamCity service message: ";
    @Deprecated
    public static final EscapeInfoProvider STD_ESCAPER = new EscapeInfoProvider(){

        public char escape(char c) {
            switch (c) {
                case '\n': {
                    return 'n';
                }
                case '\r': {
                    return 'r';
                }
                case '\u0085': {
                    return 'x';
                }
                case '\u2028': {
                    return 'l';
                }
                case '\u2029': {
                    return 'p';
                }
                case '|': {
                    return '|';
                }
                case '\'': {
                    return '\'';
                }
                case '[': {
                    return '[';
                }
                case ']': {
                    return ']';
                }
            }
            return '\u0000';
        }

        public char unescape(char c) {
            switch (c) {
                case 'n': {
                    return '\n';
                }
                case 'r': {
                    return '\r';
                }
                case 'x': {
                    return '\u0085';
                }
                case 'l': {
                    return '\u2028';
                }
                case 'p': {
                    return '\u2029';
                }
                case '\'': {
                    return '\'';
                }
                case '|': {
                    return '|';
                }
                case '[': {
                    return '[';
                }
                case ']': {
                    return ']';
                }
            }
            return '\u0000';
        }

        public char escapeCharacter() {
            return '|';
        }
    };
    public static final EscapeInfoProvider2 STD_ESCAPER2 = new EscapeInfoProvider2(){

        @Nullable
        public String escape(char c) {
            switch (c) {
                case '\n': {
                    return "n";
                }
                case '\r': {
                    return "r";
                }
                case '|': {
                    return "|";
                }
                case '\'': {
                    return "'";
                }
                case '[': {
                    return "[";
                }
                case ']': {
                    return "]";
                }
            }
            return c < '\u0080' ? null : String.format("0x%04x", c);
        }

        @Nullable
        public UnescapeResult unescape(@NotNull String str, int startPos) {
            if (str == null) {
                2.$$$reportNull$$$0(0);
            }
            switch (str.charAt(startPos)) {
                case 'n': {
                    return new UnescapeResult('\n', 1);
                }
                case 'r': {
                    return new UnescapeResult('\r', 1);
                }
                case 'x': {
                    return new UnescapeResult('\u0085', 1);
                }
                case 'l': {
                    return new UnescapeResult('\u2028', 1);
                }
                case 'p': {
                    return new UnescapeResult('\u2029', 1);
                }
                case '\'': {
                    return new UnescapeResult('\'', 1);
                }
                case '|': {
                    return new UnescapeResult('|', 1);
                }
                case '[': {
                    return new UnescapeResult('[', 1);
                }
                case ']': {
                    return new UnescapeResult(']', 1);
                }
                case '0': {
                    if (startPos + 5 >= str.length() || str.charAt(startPos + 1) != 'x') break;
                    try {
                        return new UnescapeResult((char)Integer.parseInt(str.substring(startPos + 2, startPos + 6), 16), 6);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            return null;
        }

        public char escapeCharacter() {
            return '|';
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "jetbrains/buildServer/messages/serviceMessages/MapSerializerUtil$2", "unescape"));
        }
    };

    @Deprecated
    @NotNull
    public static Map<String, String> stringToProperties(@NotNull String string2, @NotNull EscapeInfoProvider escaper) throws ParseException {
        if (string2 == null) {
            MapSerializerUtil.$$$reportNull$$$0(0);
        }
        if (escaper == null) {
            MapSerializerUtil.$$$reportNull$$$0(1);
        }
        Map<String, String> map2 = MapSerializerUtil.stringToProperties(string2, escaper, true);
        if (map2 == null) {
            MapSerializerUtil.$$$reportNull$$$0(2);
        }
        return map2;
    }

    @NotNull
    public static Map<String, String> stringToProperties(@NotNull String string2, @NotNull EscapeInfoProvider2 escaper) throws ParseException {
        if (string2 == null) {
            MapSerializerUtil.$$$reportNull$$$0(3);
        }
        if (escaper == null) {
            MapSerializerUtil.$$$reportNull$$$0(4);
        }
        Map<String, String> map2 = MapSerializerUtil.stringToProperties(string2, escaper, true);
        if (map2 == null) {
            MapSerializerUtil.$$$reportNull$$$0(5);
        }
        return map2;
    }

    @Deprecated
    public static String propertiesToString(Map<String, String> props, EscapeInfoProvider escaper) {
        return MapSerializerUtil.propertiesToString(props, MapSerializerUtil.convertProvider(escaper));
    }

    @NotNull
    public static String propertiesToString(@NotNull Map<String, String> props, @NotNull EscapeInfoProvider2 escaper) {
        if (props == null) {
            MapSerializerUtil.$$$reportNull$$$0(6);
        }
        if (escaper == null) {
            MapSerializerUtil.$$$reportNull$$$0(7);
        }
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, String> entry2 : props.entrySet()) {
            if (builder.length() > 0) {
                builder.append(' ');
            }
            builder.append(MapSerializerUtil.escapeStr(entry2.getKey(), escaper));
            builder.append('=');
            builder.append('\'').append(MapSerializerUtil.escapeStr(entry2.getValue(), escaper)).append('\'');
        }
        String string2 = builder.toString();
        if (string2 == null) {
            MapSerializerUtil.$$$reportNull$$$0(8);
        }
        return string2;
    }

    @Deprecated
    @NotNull
    public static Map<String, String> stringToProperties(@NotNull String string2, @NotNull EscapeInfoProvider escaper, boolean strictNameCheck) throws ParseException {
        if (string2 == null) {
            MapSerializerUtil.$$$reportNull$$$0(9);
        }
        if (escaper == null) {
            MapSerializerUtil.$$$reportNull$$$0(10);
        }
        Map<String, String> map2 = MapSerializerUtil.stringToProperties(string2, MapSerializerUtil.convertProvider(escaper), strictNameCheck);
        if (map2 == null) {
            MapSerializerUtil.$$$reportNull$$$0(11);
        }
        return map2;
    }

    @NotNull
    public static Map<String, String> stringToProperties(@NotNull String string2, @NotNull EscapeInfoProvider2 escaper, boolean strictNameCheck) throws ParseException {
        if (string2 == null) {
            MapSerializerUtil.$$$reportNull$$$0(12);
        }
        if (escaper == null) {
            MapSerializerUtil.$$$reportNull$$$0(13);
        }
        String currentString = string2;
        LinkedHashMap<String, String> result2 = new LinkedHashMap<String, String>();
        while (currentString.length() > 0) {
            int nameSep = currentString.indexOf("=");
            if (nameSep == -1) {
                throw new ParseException("Error while parsing TeamCity service message: Property value not found (no \"=\" sign). Valid service message has a form of \"##teamcity[messageName name1='escaped_value' name2='escaped_value']\" where escaped_value uses substitutions: '->|', [->|[, ]->|], |->||, newline->|n", 0);
            }
            String name2 = currentString.substring(0, nameSep).trim();
            MapSerializerUtil.checkPropName(name2, strictNameCheck);
            currentString = currentString.substring(nameSep + 1).trim();
            if (currentString.startsWith("'")) {
                int endOfValue = MapSerializerUtil.indexOf(currentString = currentString.substring(1), '\'', escaper);
                if (endOfValue >= 0) {
                    String escapedValue = currentString.substring(0, endOfValue);
                    currentString = currentString.substring(endOfValue + 1).trim();
                    result2.put(name2, MapSerializerUtil.unescapeStr(escapedValue, escaper));
                    continue;
                }
                throw new ParseException("Error while parsing TeamCity service message: Value should end with \"'\". Valid service message has a form of \"##teamcity[messageName name1='escaped_value' name2='escaped_value']\" where escaped_value uses substitutions: '->|', [->|[, ]->|], |->||, newline->|n", 0);
            }
            throw new ParseException("Error while parsing TeamCity service message: Value should start with \"'\". Valid service message has a form of \"##teamcity[messageName name1='escaped_value' name2='escaped_value']\" where escaped_value uses substitutions: '->|', [->|[, ]->|], |->||, newline->|n", 0);
        }
        LinkedHashMap<String, String> linkedHashMap = result2;
        if (linkedHashMap == null) {
            MapSerializerUtil.$$$reportNull$$$0(14);
        }
        return linkedHashMap;
    }

    private static void checkPropName(@NotNull String name2, boolean strict) throws ParseException {
        boolean isCorrect;
        if (name2 == null) {
            MapSerializerUtil.$$$reportNull$$$0(15);
        }
        boolean bl = strict ? MapSerializerUtil.isValidJavaIdentifier(name2) : (isCorrect = !MapSerializerUtil.hasSpaces(name2));
        if (!isCorrect) {
            String nameRestrictionDetails = strict ? "should start with a character/underscore and contain only alpha-numeric symbols or underscore" : "should contain no spaces";
            throw new ParseException("Error while parsing TeamCity service message: Incorrect property name \"" + name2 + "\": " + nameRestrictionDetails + ". " + STD_EX_SUFFIX, 0);
        }
    }

    private static boolean hasSpaces(@NotNull String name2) {
        if (name2 == null) {
            MapSerializerUtil.$$$reportNull$$$0(16);
        }
        return name2.indexOf(32) >= 0;
    }

    @Deprecated
    public static int indexOf(String currentString, char findWhat, EscapeInfoProvider escaper) {
        return MapSerializerUtil.indexOf(currentString, findWhat, MapSerializerUtil.convertProvider(escaper));
    }

    public static int indexOf(@NotNull String currentString, char findWhat, @NotNull EscapeInfoProvider2 escaper) {
        if (currentString == null) {
            MapSerializerUtil.$$$reportNull$$$0(17);
        }
        if (escaper == null) {
            MapSerializerUtil.$$$reportNull$$$0(18);
        }
        int length = currentString.length();
        for (int i2 = 0; i2 < length; ++i2) {
            UnescapeResult unescaped;
            char currentChar = currentString.charAt(i2);
            if (currentChar == escaper.escapeCharacter() && i2 + 1 < length && (unescaped = escaper.unescape(currentString, i2 + 1)) != null) {
                i2 += unescaped.getEscapedLength();
                continue;
            }
            if (currentChar != findWhat) continue;
            return i2;
        }
        return -1;
    }

    public static boolean isValidJavaIdentifier(@NotNull String name2) {
        if (name2 == null) {
            MapSerializerUtil.$$$reportNull$$$0(19);
        }
        if (name2.length() == 0) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(name2.charAt(0))) {
            return false;
        }
        for (int i2 = 1; i2 < name2.length(); ++i2) {
            if (Character.isJavaIdentifierPart(name2.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    @Deprecated
    public static String escapeStr(String str, EscapeInfoProvider p) {
        return MapSerializerUtil.escapeStr(str, MapSerializerUtil.convertProvider(p));
    }

    @NotNull
    private static EscapeInfoProvider2 convertProvider(final @NotNull EscapeInfoProvider p) {
        if (p == null) {
            MapSerializerUtil.$$$reportNull$$$0(20);
        }
        EscapeInfoProvider2 escapeInfoProvider2 = new EscapeInfoProvider2(){

            @Nullable
            public String escape(char c) {
                char result2 = p.escape(c);
                return result2 == '\u0000' ? null : String.valueOf(result2);
            }

            @Nullable
            public UnescapeResult unescape(@NotNull String str, int startPos) {
                char result2;
                if (str == null) {
                    3.$$$reportNull$$$0(0);
                }
                return (result2 = p.unescape(str.charAt(startPos))) == '\u0000' ? null : new UnescapeResult(result2, 1);
            }

            public char escapeCharacter() {
                return p.escapeCharacter();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "jetbrains/buildServer/messages/serviceMessages/MapSerializerUtil$3", "unescape"));
            }
        };
        if (escapeInfoProvider2 == null) {
            MapSerializerUtil.$$$reportNull$$$0(21);
        }
        return escapeInfoProvider2;
    }

    @Nullable
    @Contract(value="null,_->null; !null,_->!null")
    public static String escapeStr(@Nullable String str, @NotNull EscapeInfoProvider2 p) {
        if (p == null) {
            MapSerializerUtil.$$$reportNull$$$0(22);
        }
        if (str == null) {
            return null;
        }
        int finalCount = MapSerializerUtil.calcFinalEscapedStringCount(str, p);
        if (str.length() == finalCount) {
            return str;
        }
        char[] resultChars = new char[finalCount];
        int resultPos = 0;
        for (int i2 = 0; i2 < str.length(); ++i2) {
            char c = str.charAt(i2);
            String escaped = p.escape(c);
            if (escaped != null) {
                resultChars[resultPos++] = p.escapeCharacter();
                int escapedLength = escaped.length();
                System.arraycopy(escaped.toCharArray(), 0, resultChars, resultPos, escapedLength);
                resultPos += escapedLength;
                continue;
            }
            resultChars[resultPos++] = c;
        }
        if (resultPos != finalCount) {
            throw new RuntimeException("Incorrect escaping for '" + str + "'");
        }
        return new String(resultChars);
    }

    private static int calcFinalEscapedStringCount(@NotNull String str, @NotNull EscapeInfoProvider2 p) {
        if (str == null) {
            MapSerializerUtil.$$$reportNull$$$0(23);
        }
        if (p == null) {
            MapSerializerUtil.$$$reportNull$$$0(24);
        }
        int result2 = 0;
        for (int i2 = 0; i2 < str.length(); ++i2) {
            String escapePresentation = p.escape(str.charAt(i2));
            if (escapePresentation != null) {
                result2 += 1 + escapePresentation.length();
                continue;
            }
            ++result2;
        }
        return result2;
    }

    @Deprecated
    @Nullable
    public static String unescapeStr(@Nullable String str, @NotNull EscapeInfoProvider p) {
        if (p == null) {
            MapSerializerUtil.$$$reportNull$$$0(25);
        }
        return MapSerializerUtil.unescapeStr(str, MapSerializerUtil.convertProvider(p));
    }

    @Nullable
    public static String unescapeStr(@Nullable String str, @NotNull EscapeInfoProvider2 p) {
        if (p == null) {
            MapSerializerUtil.$$$reportNull$$$0(26);
        }
        if (str == null) {
            return null;
        }
        int finalCount = MapSerializerUtil.calcFinalUnescapedStringCount(str, p);
        int len = str.length();
        if (len == finalCount) {
            return str;
        }
        char[] resultChars = new char[finalCount];
        int resultPos = 0;
        for (int i2 = 0; i2 < len; ++i2) {
            UnescapeResult unescaped;
            char c = str.charAt(i2);
            if (c == p.escapeCharacter() && i2 + 1 < len && (unescaped = p.unescape(str, i2 + 1)) != null) {
                c = unescaped.getChar();
                i2 += unescaped.getEscapedLength();
            }
            resultChars[resultPos++] = c;
        }
        if (resultPos != finalCount) {
            throw new RuntimeException("Incorrect unescaping for '" + str + "'");
        }
        return new String(resultChars);
    }

    private static int calcFinalUnescapedStringCount(@NotNull String str, @NotNull EscapeInfoProvider2 p) {
        if (str == null) {
            MapSerializerUtil.$$$reportNull$$$0(27);
        }
        if (p == null) {
            MapSerializerUtil.$$$reportNull$$$0(28);
        }
        int result2 = 0;
        int len = str.length();
        for (int i2 = 0; i2 < len; ++i2) {
            UnescapeResult unescaped;
            if (str.charAt(i2) == p.escapeCharacter() && i2 + 1 < len && (unescaped = p.unescape(str, i2 + 1)) != null) {
                i2 += unescaped.getEscapedLength();
            }
            ++result2;
        }
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 11: 
            case 14: 
            case 21: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 11: 
            case 14: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: 
            case 13: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "escaper";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 11: 
            case 14: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/messages/serviceMessages/MapSerializerUtil";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "props";
                break;
            }
            case 15: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentString";
                break;
            }
            case 20: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 23: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/messages/serviceMessages/MapSerializerUtil";
                break;
            }
            case 2: 
            case 5: 
            case 11: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "stringToProperties";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "propertiesToString";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "convertProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "stringToProperties";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 11: 
            case 14: 
            case 21: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "propertiesToString";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "checkPropName";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "hasSpaces";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "indexOf";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isValidJavaIdentifier";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "convertProvider";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "escapeStr";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "calcFinalEscapedStringCount";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "unescapeStr";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "calcFinalUnescapedStringCount";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 11: 
            case 14: 
            case 21: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static class UnescapeResult {
        private final char myChar;
        private final int myEscapedLength;

        public UnescapeResult(char ch, int escapedLength) {
            this.myChar = ch;
            this.myEscapedLength = escapedLength;
        }

        public char getChar() {
            return this.myChar;
        }

        public int getEscapedLength() {
            return this.myEscapedLength;
        }
    }

    public static interface EscapeInfoProvider2 {
        @Nullable
        public String escape(char var1);

        @Nullable
        public UnescapeResult unescape(@NotNull String var1, int var2);

        public char escapeCharacter();
    }

    @Deprecated
    public static interface EscapeInfoProvider {
        public char escape(char var1);

        public char unescape(char var1);

        public char escapeCharacter();
    }
}

