/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.commons.compress.harmony.unpack200.bytecode.forms;

import org.jetbrains.kotlin.org.apache.commons.compress.harmony.pack200.Pack200Exception;
import org.jetbrains.kotlin.org.apache.commons.compress.harmony.unpack200.SegmentConstantPool;
import org.jetbrains.kotlin.org.apache.commons.compress.harmony.unpack200.bytecode.ByteCode;
import org.jetbrains.kotlin.org.apache.commons.compress.harmony.unpack200.bytecode.CPClass;
import org.jetbrains.kotlin.org.apache.commons.compress.harmony.unpack200.bytecode.ClassFileEntry;
import org.jetbrains.kotlin.org.apache.commons.compress.harmony.unpack200.bytecode.OperandManager;
import org.jetbrains.kotlin.org.apache.commons.compress.harmony.unpack200.bytecode.forms.ClassRefForm;

public class NewClassRefForm
extends ClassRefForm {
    public NewClassRefForm(int opcode, String name2, int[] rewrite) {
        super(opcode, name2, rewrite);
    }

    @Override
    public void setByteCodeOperands(ByteCode byteCode, OperandManager operandManager, int codeLength) {
        int offset = this.getOffset(operandManager);
        if (offset == 0) {
            SegmentConstantPool globalPool = operandManager.globalConstantPool();
            ClassFileEntry[] nested = new ClassFileEntry[]{globalPool.getClassPoolEntry(operandManager.getCurrentClass())};
            byteCode.setNested(nested);
            byteCode.setNestedPositions(new int[][]{{0, 2}});
        } else {
            try {
                this.setNestedEntries(byteCode, operandManager, offset);
            }
            catch (Pack200Exception ex) {
                throw new Error("Got a pack200 exception. What to do?");
            }
        }
        operandManager.setNewClass(((CPClass)byteCode.getNestedClassFileEntries()[0]).getName());
    }
}

