/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.report;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.build.report.FileReportSettings;
import org.jetbrains.kotlin.build.report.HttpReportSettings;
import org.jetbrains.kotlin.build.report.metrics.GradleBuildPerformanceMetric;
import org.jetbrains.kotlin.build.report.metrics.GradleBuildTime;
import org.jetbrains.kotlin.gradle.plugin.PropertiesProvider;
import org.jetbrains.kotlin.gradle.plugin.internal.ProjectIsolationStartParameterAccessorKt;
import org.jetbrains.kotlin.gradle.report.BuildReportMode;
import org.jetbrains.kotlin.gradle.report.BuildReportType;
import org.jetbrains.kotlin.gradle.report.BuildScanSettings;
import org.jetbrains.kotlin.gradle.report.ReportingSettings;
import org.jetbrains.kotlin.util.capitalizeDecapitalize.CapitalizeDecapitalizeKt;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"availableMetrics", "", "", "reportingSettings", "Lorg/jetbrains/kotlin/gradle/report/ReportingSettings;", "project", "Lorg/gradle/api/Project;", "kotlin-gradle-plugin_common"})
@SourceDebugExtension(value={"SMAP\nconfigureReporing.kt\nKotlin\n*S Kotlin\n*F\n+ 1 configureReporing.kt\norg/jetbrains/kotlin/gradle/report/ConfigureReporingKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,99:1\n1547#2:100\n1618#2,2:101\n1620#2:105\n1853#2,2:106\n1282#3,2:103\n11047#3:109\n11382#3,3:110\n1#4:108\n*S KotlinDebug\n*F\n+ 1 configureReporing.kt\norg/jetbrains/kotlin/gradle/report/ConfigureReporingKt\n*L\n25#1:100\n25#1:101,2\n25#1:105\n66#1:106,2\n26#1:103,2\n19#1:109\n19#1:110,3\n*E\n"})
public final class ConfigureReporingKt {
    @NotNull
    private static final List<String> availableMetrics;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final ReportingSettings reportingSettings(@NotNull Project project) {
        Object object;
        File file;
        BuildScanSettings buildScanSettings;
        BuildScanSettings buildScanSettings2;
        HttpReportSettings httpReportSettings;
        HttpReportSettings httpReportSettings2;
        FileReportSettings fileReportSettings;
        FileReportSettings fileReportSettings2;
        BuildReportMode buildReportMode;
        Object object2;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        PropertiesProvider properties2 = PropertiesProvider.Companion.invoke(project);
        Boolean experimentalTryNextEnabled = (Boolean)properties2.getKotlinExperimentalTryNext().get();
        Iterable iterable = properties2.getBuildReportOutputs();
        boolean $i$f$map = false;
        void var6_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            BuildReportType buildReportType;
            void it;
            Collection collection;
            block21: {
                object2 = (String[])item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                BuildReportType[] $this$firstOrNull$iv = BuildReportType.values();
                boolean $i$f$firstOrNull = false;
                int n = $this$firstOrNull$iv.length;
                for (int j = 0; j < n; ++j) {
                    BuildReportType element$iv;
                    BuildReportType brt = element$iv = $this$firstOrNull$iv[j];
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)brt.name(), (Object)CapitalizeDecapitalizeKt.toUpperCaseAsciiOnly((String)((Object)StringsKt.trim((CharSequence)((CharSequence)it))).toString()))) continue;
                    buildReportType = element$iv;
                    break block21;
                }
                buildReportType = null;
            }
            if (buildReportType == null) {
                throw new IllegalStateException("Unknown output type: " + (String)it);
            }
            collection.add(buildReportType);
        }
        Collection collection = (List)destination$iv$iv;
        Intrinsics.checkNotNullExpressionValue((Object)experimentalTryNextEnabled, (String)"experimentalTryNextEnabled");
        List buildReportOutputTypes = CollectionsKt.toMutableList((Collection)CollectionsKt.plus((Collection)collection, (Iterable)(experimentalTryNextEnabled != false ? CollectionsKt.listOf((Object)BuildReportType.TRY_NEXT_CONSOLE) : CollectionsKt.emptyList())));
        BuildReportMode buildReportMode2 = buildReportMode = buildReportOutputTypes.isEmpty() ? BuildReportMode.NONE : BuildReportMode.VERBOSE;
        if (buildReportOutputTypes.contains(BuildReportType.FILE)) {
            File file2 = properties2.getBuildReportFileOutputDir();
            if (file2 == null) {
                File file3;
                if (ProjectIsolationStartParameterAccessorKt.isProjectIsolationEnabled(project)) {
                    File file4 = project.getRootDir();
                    Intrinsics.checkNotNullExpressionValue((Object)file4, (String)"project.rootDir");
                    file3 = FilesKt.resolve((File)file4, (String)"build");
                } else {
                    file3 = (File)project.getRootProject().getLayout().getBuildDirectory().getAsFile().get();
                }
                File $i$f$mapTo2 = file3;
                Intrinsics.checkNotNullExpressionValue((Object)$i$f$mapTo2, (String)"if (project.isProjectIso\u2026ry.asFile.get()\n        }");
                file2 = FilesKt.resolve((File)$i$f$mapTo2, (String)"reports/kotlin-build");
            }
            File buildReportDir = file2;
            boolean includeMetricsInReport = properties2.getBuildReportMetrics() || buildReportMode == BuildReportMode.VERBOSE;
            fileReportSettings2 = new FileReportSettings(buildReportDir, null, includeMetricsInReport, 2, null);
        } else {
            fileReportSettings2 = fileReportSettings = null;
        }
        if (buildReportOutputTypes.contains(BuildReportType.HTTP)) {
            String string = properties2.getBuildReportHttpUrl();
            if (string == null) {
                throw new IllegalStateException("Can't configure http report: '" + PropertiesProvider.PropertyNames.INSTANCE.getKOTLIN_BUILD_REPORT_HTTP_URL() + "' property is mandatory");
            }
            String url = string;
            String password = properties2.getBuildReportHttpPassword();
            String user = properties2.getBuildReportHttpUser();
            boolean includeGitBranchName = properties2.getBuildReportHttpIncludeGitBranchName();
            httpReportSettings2 = new HttpReportSettings(url, password, user, properties2.getBuildReportHttpVerboseEnvironment(), includeGitBranchName);
        } else {
            httpReportSettings2 = httpReportSettings = null;
        }
        if (buildReportOutputTypes.contains(BuildReportType.BUILD_SCAN)) {
            Set metrics;
            Object object3 = properties2.getBuildReportBuildScanMetrics();
            Set set2 = metrics = object3 != null && (object3 = StringsKt.split$default((CharSequence)((CharSequence)object3), (String[])(object2 = new String[]{","}), (boolean)false, (int)0, (int)6, null)) != null ? CollectionsKt.toSet((Iterable)((Iterable)object3)) : null;
            if (set2 != null) {
                Iterable $this$forEach$iv = set2;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String it = (String)element$iv;
                    boolean bl = false;
                    String string = ((Object)StringsKt.trim((CharSequence)it)).toString().toUpperCase();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
                    if (availableMetrics.contains(string)) continue;
                    throw new IllegalStateException("Unknown metric: '" + it + "', list of available metrics: " + availableMetrics);
                }
            }
            buildScanSettings2 = new BuildScanSettings(properties2.getBuildReportBuildScanCustomValuesLimit(), metrics);
        } else {
            buildScanSettings2 = buildScanSettings = null;
        }
        if (buildReportOutputTypes.contains(BuildReportType.SINGLE_FILE)) {
            file = properties2.getBuildReportSingleFile();
            if (file == null) {
                throw new IllegalStateException("Can't configure single file report: '" + PropertiesProvider.PropertyNames.INSTANCE.getKOTLIN_BUILD_REPORT_SINGLE_FILE() + "' property is mandatory");
            }
        } else {
            file = null;
        }
        File singleOutputFile = file;
        File file5 = properties2.getSingleBuildMetricsFile();
        if (file5 != null) {
            object2 = file5;
            Object it = object2;
            boolean bl = false;
            buildReportOutputTypes.add(BuildReportType.SINGLE_FILE);
            object = object2;
        } else {
            object = null;
        }
        Object oldSingleBuildMetric = object;
        String string = properties2.getBuildReportLabel();
        Object object4 = singleOutputFile;
        if (object4 == null) {
            object4 = oldSingleBuildMetric;
        }
        object2 = object4;
        boolean bl = properties2.getBuildReportIncludeCompilerArguments();
        return new ReportingSettings(buildReportOutputTypes, buildReportMode, string, fileReportSettings, httpReportSettings, buildScanSettings, (File)object2, experimentalTryNextEnabled, bl);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        GradleBuildTime it;
        Collection collection;
        GradleBuildTime[] $this$mapTo$iv$iv;
        GradleBuildTime[] $this$map$iv = GradleBuildTime.values();
        boolean $i$f$map = false;
        GradleBuildTime[] gradleBuildTimeArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        for (GradleBuildTime item$iv$iv : $this$mapTo$iv$iv) {
            void var8_8 = item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.name());
        }
        $this$map$iv = GradleBuildPerformanceMetric.values();
        collection = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.length);
        $i$f$mapTo = false;
        int n = $this$mapTo$iv$iv.length;
        for (int j = 0; j < n; ++j) {
            GradleBuildTime item$iv$iv;
            it = item$iv$iv = $this$mapTo$iv$iv[j];
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(it.name());
        }
        availableMetrics = CollectionsKt.plus((Collection)collection, (Iterable)((List)var3_3));
    }
}

