/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin.statistics;

import java.io.Closeable;
import java.io.File;
import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.plugin.internal.ConfigurationTimePropertiesAccessor;
import org.jetbrains.kotlin.gradle.plugin.internal.ConfigurationTimePropertiesAccessorKt;
import org.jetbrains.kotlin.gradle.plugin.statistics.KotlinBuildStatsConfiguration;
import org.jetbrains.kotlin.gradle.plugin.statistics.KotlinBuildStatsLoggerService;
import org.jetbrains.kotlin.gradle.plugin.statistics.KotlinBuildStatsServicesRegistry;
import org.jetbrains.kotlin.gradle.utils.ReportUtilsKt;
import org.jetbrains.kotlin.statistics.BuildSessionLogger;
import org.jetbrains.kotlin.statistics.metrics.BooleanMetrics;
import org.jetbrains.kotlin.statistics.metrics.NumericalMetrics;
import org.jetbrains.kotlin.statistics.metrics.StatisticsValuesConsumer;
import org.jetbrains.kotlin.statistics.metrics.StringMetrics;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b \u0018\u0000 !2\u00020\u00012\u00020\u0002:\u0001!B\u0017\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\f\u001a\u00020\rH\u0016J\u000e\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010J=\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00122\b\u0010\u0018\u001a\u0004\u0018\u00010\u00102\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0000\u00a2\u0006\u0004\b\u001b\u0010\u001cJ=\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u001d2\u0006\u0010\u0017\u001a\u00020\u001a2\b\u0010\u0018\u001a\u0004\u0018\u00010\u00102\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0000\u00a2\u0006\u0004\b\u001b\u0010\u001eJ=\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u001f2\u0006\u0010\u0017\u001a\u00020\u00102\b\u0010\u0018\u001a\u0004\u0018\u00010\u00102\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0000\u00a2\u0006\u0004\b\u001b\u0010 R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/statistics/KotlinBuildStatsBeanService;", "Lorg/jetbrains/kotlin/statistics/metrics/StatisticsValuesConsumer;", "Ljava/io/Closeable;", "project", "Lorg/gradle/api/Project;", "beanName", "Ljavax/management/ObjectName;", "(Lorg/gradle/api/Project;Ljavax/management/ObjectName;)V", "kotlinBuildLogger", "Lorg/jetbrains/kotlin/gradle/plugin/statistics/KotlinBuildStatsLoggerService;", "getKotlinBuildLogger", "()Lorg/jetbrains/kotlin/gradle/plugin/statistics/KotlinBuildStatsLoggerService;", "close", "", "recordBuildStart", "buildId", "", "report", "", "sessionLogger", "Lorg/jetbrains/kotlin/statistics/BuildSessionLogger;", "metric", "Lorg/jetbrains/kotlin/statistics/metrics/BooleanMetrics;", "value", "subprojectName", "weight", "", "report$kotlin_gradle_plugin_common", "(Lorg/jetbrains/kotlin/statistics/BuildSessionLogger;Lorg/jetbrains/kotlin/statistics/metrics/BooleanMetrics;ZLjava/lang/String;Ljava/lang/Long;)Z", "Lorg/jetbrains/kotlin/statistics/metrics/NumericalMetrics;", "(Lorg/jetbrains/kotlin/statistics/BuildSessionLogger;Lorg/jetbrains/kotlin/statistics/metrics/NumericalMetrics;JLjava/lang/String;Ljava/lang/Long;)Z", "Lorg/jetbrains/kotlin/statistics/metrics/StringMetrics;", "(Lorg/jetbrains/kotlin/statistics/BuildSessionLogger;Lorg/jetbrains/kotlin/statistics/metrics/StringMetrics;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Long;)Z", "Companion", "kotlin-gradle-plugin_common"})
public abstract class KotlinBuildStatsBeanService
implements StatisticsValuesConsumer,
Closeable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ObjectName beanName;
    @NotNull
    private final KotlinBuildStatsLoggerService kotlinBuildLogger;
    @NotNull
    private static final String ENABLE_STATISTICS_PROPERTY_NAME = "enable_kotlin_performance_profile";
    private static final boolean DEFAULT_STATISTICS_STATE = true;
    @NotNull
    private static final String DISABLE_STATISTICS_FILE_NAME = "kotlin-profile/.disable";
    private static final Logger logger = Logging.getLogger(KotlinBuildStatsBeanService.class);
    @Nullable
    private static KotlinBuildStatsServicesRegistry kotlinBuildStatsServicesRegistry;

    public KotlinBuildStatsBeanService(@NotNull Project project, @NotNull ObjectName beanName) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)beanName, (String)"beanName");
        this.beanName = beanName;
        this.kotlinBuildLogger = new KotlinBuildStatsLoggerService(new KotlinBuildStatsConfiguration(project));
    }

    @NotNull
    protected final KotlinBuildStatsLoggerService getKotlinBuildLogger() {
        return this.kotlinBuildLogger;
    }

    @Override
    public synchronized void close() {
        Logger logger = KotlinBuildStatsBeanService.logger;
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"logger");
        ReportUtilsKt.runMetricMethodSafely(logger, KotlinBuildStatsBeanService.class + ".buildFinished", (Function0)new Function0<Unit>(this){
            final /* synthetic */ KotlinBuildStatsBeanService this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
                Intrinsics.checkNotNullExpressionValue((Object)mBeanServer, (String)"getPlatformMBeanServer()");
                MBeanServer mbs = mBeanServer;
                if (mbs.isRegistered(KotlinBuildStatsBeanService.access$getBeanName$p(this.this$0))) {
                    mbs.unregisterMBean(KotlinBuildStatsBeanService.access$getBeanName$p(this.this$0));
                    KotlinBuildStatsBeanService.Companion.getLogger$kotlin_gradle_plugin_common().debug("Unregistered " + this.this$0);
                }
            }
        });
    }

    public final synchronized void recordBuildStart(@NotNull String buildId) {
        Intrinsics.checkNotNullParameter((Object)buildId, (String)"buildId");
        this.kotlinBuildLogger.initSessionLogger(buildId);
    }

    public final boolean report$kotlin_gradle_plugin_common(@NotNull BuildSessionLogger sessionLogger, @NotNull BooleanMetrics metric, boolean value2, @Nullable String subprojectName, @Nullable Long weight) {
        Intrinsics.checkNotNullParameter((Object)sessionLogger, (String)"sessionLogger");
        Intrinsics.checkNotNullParameter((Object)((Object)metric), (String)"metric");
        Logger logger = KotlinBuildStatsBeanService.logger;
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"logger");
        Boolean bl = (Boolean)ReportUtilsKt.runMetricMethodSafely(logger, "report metric " + metric.name(), (Function0)new Function0<Boolean>(sessionLogger, metric, value2, subprojectName, weight){
            final /* synthetic */ BuildSessionLogger $sessionLogger;
            final /* synthetic */ BooleanMetrics $metric;
            final /* synthetic */ boolean $value;
            final /* synthetic */ String $subprojectName;
            final /* synthetic */ Long $weight;
            {
                this.$sessionLogger = $sessionLogger;
                this.$metric = $metric;
                this.$value = $value;
                this.$subprojectName = $subprojectName;
                this.$weight = $weight;
                super(0);
            }

            public final Boolean invoke() {
                return this.$sessionLogger.report(this.$metric, this.$value, this.$subprojectName, this.$weight);
            }
        });
        return bl != null ? bl : false;
    }

    public static /* synthetic */ boolean report$kotlin_gradle_plugin_common$default(KotlinBuildStatsBeanService kotlinBuildStatsBeanService, BuildSessionLogger buildSessionLogger, BooleanMetrics booleanMetrics, boolean bl, String string, Long l, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: report");
        }
        if ((n & 0x10) != 0) {
            l = null;
        }
        return kotlinBuildStatsBeanService.report$kotlin_gradle_plugin_common(buildSessionLogger, booleanMetrics, bl, string, l);
    }

    public final boolean report$kotlin_gradle_plugin_common(@NotNull BuildSessionLogger sessionLogger, @NotNull NumericalMetrics metric, long value2, @Nullable String subprojectName, @Nullable Long weight) {
        Intrinsics.checkNotNullParameter((Object)sessionLogger, (String)"sessionLogger");
        Intrinsics.checkNotNullParameter((Object)((Object)metric), (String)"metric");
        Logger logger = KotlinBuildStatsBeanService.logger;
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"logger");
        Boolean bl = (Boolean)ReportUtilsKt.runMetricMethodSafely(logger, "report metric " + metric.name(), (Function0)new Function0<Boolean>(sessionLogger, metric, value2, subprojectName, weight){
            final /* synthetic */ BuildSessionLogger $sessionLogger;
            final /* synthetic */ NumericalMetrics $metric;
            final /* synthetic */ long $value;
            final /* synthetic */ String $subprojectName;
            final /* synthetic */ Long $weight;
            {
                this.$sessionLogger = $sessionLogger;
                this.$metric = $metric;
                this.$value = $value;
                this.$subprojectName = $subprojectName;
                this.$weight = $weight;
                super(0);
            }

            public final Boolean invoke() {
                return this.$sessionLogger.report(this.$metric, this.$value, this.$subprojectName, this.$weight);
            }
        });
        return bl != null ? bl : false;
    }

    public static /* synthetic */ boolean report$kotlin_gradle_plugin_common$default(KotlinBuildStatsBeanService kotlinBuildStatsBeanService, BuildSessionLogger buildSessionLogger, NumericalMetrics numericalMetrics, long l, String string, Long l2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: report");
        }
        if ((n & 0x10) != 0) {
            l2 = null;
        }
        return kotlinBuildStatsBeanService.report$kotlin_gradle_plugin_common(buildSessionLogger, numericalMetrics, l, string, l2);
    }

    public final boolean report$kotlin_gradle_plugin_common(@NotNull BuildSessionLogger sessionLogger, @NotNull StringMetrics metric, @NotNull String value2, @Nullable String subprojectName, @Nullable Long weight) {
        Intrinsics.checkNotNullParameter((Object)sessionLogger, (String)"sessionLogger");
        Intrinsics.checkNotNullParameter((Object)((Object)metric), (String)"metric");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        Logger logger = KotlinBuildStatsBeanService.logger;
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"logger");
        Boolean bl = (Boolean)ReportUtilsKt.runMetricMethodSafely(logger, "report metric " + metric.name(), (Function0)new Function0<Boolean>(sessionLogger, metric, value2, subprojectName, weight){
            final /* synthetic */ BuildSessionLogger $sessionLogger;
            final /* synthetic */ StringMetrics $metric;
            final /* synthetic */ String $value;
            final /* synthetic */ String $subprojectName;
            final /* synthetic */ Long $weight;
            {
                this.$sessionLogger = $sessionLogger;
                this.$metric = $metric;
                this.$value = $value;
                this.$subprojectName = $subprojectName;
                this.$weight = $weight;
                super(0);
            }

            public final Boolean invoke() {
                return this.$sessionLogger.report(this.$metric, this.$value, this.$subprojectName, this.$weight);
            }
        });
        return bl != null ? bl : false;
    }

    public static /* synthetic */ boolean report$kotlin_gradle_plugin_common$default(KotlinBuildStatsBeanService kotlinBuildStatsBeanService, BuildSessionLogger buildSessionLogger, StringMetrics stringMetrics, String string, String string2, Long l, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: report");
        }
        if ((n & 0x10) != 0) {
            l = null;
        }
        return kotlinBuildStatsBeanService.report$kotlin_gradle_plugin_common(buildSessionLogger, stringMetrics, string, string2, l);
    }

    public static final Logger getLogger$kotlin_gradle_plugin_common() {
        return Companion.getLogger$kotlin_gradle_plugin_common();
    }

    @JvmStatic
    public static final synchronized void initStatsService$kotlin_gradle_plugin_common(@NotNull Project project) {
        Companion.initStatsService$kotlin_gradle_plugin_common(project);
    }

    public static final /* synthetic */ ObjectName access$getBeanName$p(KotlinBuildStatsBeanService $this) {
        return $this.beanName;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0006\u0010\u0017\u001a\u00020\u0018J\u0015\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0001\u00a2\u0006\u0002\b\u001cJ\u0015\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\u001fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000b8\u0000X\u0081\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\r\u0010\u0002\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/statistics/KotlinBuildStatsBeanService$Companion;", "", "()V", "DEFAULT_STATISTICS_STATE", "", "DISABLE_STATISTICS_FILE_NAME", "", "ENABLE_STATISTICS_PROPERTY_NAME", "kotlinBuildStatsServicesRegistry", "Lorg/jetbrains/kotlin/gradle/plugin/statistics/KotlinBuildStatsServicesRegistry;", "logger", "Lorg/gradle/api/logging/Logger;", "kotlin.jvm.PlatformType", "getLogger$kotlin_gradle_plugin_common$annotations", "getLogger$kotlin_gradle_plugin_common", "()Lorg/gradle/api/logging/Logger;", "checkStatisticsEnabled", "gradle", "Lorg/gradle/api/invocation/Gradle;", "providerFactory", "Lorg/gradle/api/provider/ProviderFactory;", "configurationTimePropertiesAccessor", "Lorg/jetbrains/kotlin/gradle/plugin/internal/ConfigurationTimePropertiesAccessor;", "closeServices", "", "initStatsService", "project", "Lorg/gradle/api/Project;", "initStatsService$kotlin_gradle_plugin_common", "recordBuildStart", "buildId", "recordBuildStart$kotlin_gradle_plugin_common", "kotlin-gradle-plugin_common"})
    public static final class Companion {
        private Companion() {
        }

        public final Logger getLogger$kotlin_gradle_plugin_common() {
            return logger;
        }

        @JvmStatic
        public static /* synthetic */ void getLogger$kotlin_gradle_plugin_common$annotations() {
        }

        @JvmStatic
        public final synchronized void initStatsService$kotlin_gradle_plugin_common(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Logger logger = this.getLogger$kotlin_gradle_plugin_common();
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"logger");
            ReportUtilsKt.runMetricMethodSafely(logger, KotlinBuildStatsBeanService.class + ".initStatsService", (Function0)new Function0<Unit>(project){
                final /* synthetic */ Project $project;
                {
                    this.$project = $project;
                    super(0);
                }

                public final Unit invoke() {
                    Unit unit;
                    Gradle gradle = this.$project.getGradle();
                    ConfigurationTimePropertiesAccessor configurationTimePropertiesAccessor2 = ConfigurationTimePropertiesAccessorKt.getConfigurationTimePropertiesAccessor(this.$project);
                    Intrinsics.checkNotNullExpressionValue((Object)gradle, (String)"gradle");
                    ProviderFactory providerFactory = this.$project.getProviders();
                    Intrinsics.checkNotNullExpressionValue((Object)providerFactory, (String)"project.providers");
                    boolean statisticsIsEnabled = org.jetbrains.kotlin.gradle.plugin.statistics.KotlinBuildStatsBeanService$Companion.access$checkStatisticsEnabled(KotlinBuildStatsBeanService.Companion, gradle, providerFactory, configurationTimePropertiesAccessor2);
                    if (!statisticsIsEnabled) {
                        unit = null;
                    } else {
                        KotlinBuildStatsServicesRegistry kotlinBuildStatsServicesRegistry = KotlinBuildStatsBeanService.access$getKotlinBuildStatsServicesRegistry$cp();
                        if (kotlinBuildStatsServicesRegistry == null) {
                            KotlinBuildStatsServicesRegistry kotlinBuildStatsServicesRegistry2;
                            KotlinBuildStatsServicesRegistry it = kotlinBuildStatsServicesRegistry2 = new KotlinBuildStatsServicesRegistry();
                            boolean bl = false;
                            KotlinBuildStatsBeanService.access$setKotlinBuildStatsServicesRegistry$cp(it);
                            kotlinBuildStatsServicesRegistry = kotlinBuildStatsServicesRegistry2;
                        }
                        KotlinBuildStatsServicesRegistry registry = kotlinBuildStatsServicesRegistry;
                        registry.registerServices(this.$project);
                        unit = Unit.INSTANCE;
                    }
                    return unit;
                }
            });
        }

        public final void recordBuildStart$kotlin_gradle_plugin_common(@NotNull String buildId) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)buildId, (String)"buildId");
                KotlinBuildStatsServicesRegistry kotlinBuildStatsServicesRegistry = kotlinBuildStatsServicesRegistry;
                if (kotlinBuildStatsServicesRegistry == null) break block0;
                kotlinBuildStatsServicesRegistry.recordBuildStart(buildId);
            }
        }

        public final void closeServices() {
            KotlinBuildStatsServicesRegistry kotlinBuildStatsServicesRegistry = kotlinBuildStatsServicesRegistry;
            if (kotlinBuildStatsServicesRegistry != null) {
                kotlinBuildStatsServicesRegistry.close();
            }
            KotlinBuildStatsBeanService.kotlinBuildStatsServicesRegistry = null;
        }

        private final boolean checkStatisticsEnabled(Gradle gradle, ProviderFactory providerFactory, ConfigurationTimePropertiesAccessor configurationTimePropertiesAccessor2) {
            boolean bl;
            if (new File(gradle.getGradleUserHomeDir(), KotlinBuildStatsBeanService.DISABLE_STATISTICS_FILE_NAME).exists()) {
                bl = false;
            } else {
                Provider provider = providerFactory.gradleProperty(KotlinBuildStatsBeanService.ENABLE_STATISTICS_PROPERTY_NAME);
                Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"providerFactory.gradlePr\u2026STATISTICS_PROPERTY_NAME)");
                String string = (String)ConfigurationTimePropertiesAccessorKt.usedAtConfigurationTime(provider, configurationTimePropertiesAccessor2).getOrNull();
                bl = string != null ? Boolean.parseBoolean(string) : true;
            }
            return bl;
        }

        public static final /* synthetic */ boolean access$checkStatisticsEnabled(Companion $this, Gradle gradle, ProviderFactory providerFactory, ConfigurationTimePropertiesAccessor configurationTimePropertiesAccessor2) {
            return $this.checkStatisticsEnabled(gradle, providerFactory, configurationTimePropertiesAccessor2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

