/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.google.common.util.concurrent;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.jetbrains.kotlin.com.google.common.annotations.Beta;
import org.jetbrains.kotlin.com.google.common.annotations.GwtIncompatible;
import org.jetbrains.kotlin.com.google.common.base.Preconditions;
import org.jetbrains.kotlin.com.google.common.util.concurrent.ElementTypesAreNonnullByDefault;
import org.jetbrains.kotlin.com.google.common.util.concurrent.ExecutionError;
import org.jetbrains.kotlin.com.google.common.util.concurrent.ParametricNullness;
import org.jetbrains.kotlin.com.google.common.util.concurrent.TimeLimiter;
import org.jetbrains.kotlin.com.google.common.util.concurrent.UncheckedExecutionException;
import org.jetbrains.kotlin.com.google.errorprone.annotations.CanIgnoreReturnValue;

@ElementTypesAreNonnullByDefault
@Beta
@CanIgnoreReturnValue
@GwtIncompatible
public final class FakeTimeLimiter
implements TimeLimiter {
    @Override
    public <T> T newProxy(T target2, Class<T> interfaceType, long timeoutDuration, TimeUnit timeoutUnit) {
        Preconditions.checkNotNull(target2);
        Preconditions.checkNotNull(interfaceType);
        Preconditions.checkNotNull(timeoutUnit);
        return target2;
    }

    @Override
    @ParametricNullness
    public <T> T callWithTimeout(Callable<T> callable, long timeoutDuration, TimeUnit timeoutUnit) throws ExecutionException {
        Preconditions.checkNotNull(callable);
        Preconditions.checkNotNull(timeoutUnit);
        try {
            return callable.call();
        }
        catch (RuntimeException e) {
            throw new UncheckedExecutionException(e);
        }
        catch (Exception e) {
            throw new ExecutionException(e);
        }
        catch (Error e) {
            throw new ExecutionError(e);
        }
        catch (Throwable e) {
            throw new ExecutionException(e);
        }
    }

    @Override
    @ParametricNullness
    public <T> T callUninterruptiblyWithTimeout(Callable<T> callable, long timeoutDuration, TimeUnit timeoutUnit) throws ExecutionException {
        return this.callWithTimeout(callable, timeoutDuration, timeoutUnit);
    }

    @Override
    public void runWithTimeout(Runnable runnable, long timeoutDuration, TimeUnit timeoutUnit) {
        Preconditions.checkNotNull(runnable);
        Preconditions.checkNotNull(timeoutUnit);
        try {
            runnable.run();
        }
        catch (RuntimeException e) {
            throw new UncheckedExecutionException(e);
        }
        catch (Error e) {
            throw new ExecutionError(e);
        }
        catch (Throwable e) {
            throw new UncheckedExecutionException(e);
        }
    }

    @Override
    public void runUninterruptiblyWithTimeout(Runnable runnable, long timeoutDuration, TimeUnit timeoutUnit) {
        this.runWithTimeout(runnable, timeoutDuration, timeoutUnit);
    }
}

