/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.google.common.graph;

import org.jetbrains.kotlin.com.google.common.graph.AbstractGraphBuilder;
import org.jetbrains.kotlin.com.google.common.graph.BaseGraph;
import org.jetbrains.kotlin.com.google.common.graph.ElementTypesAreNonnullByDefault;
import org.jetbrains.kotlin.com.google.common.graph.EndpointPair;
import org.jetbrains.kotlin.com.google.common.graph.ForwardingGraph;
import org.jetbrains.kotlin.com.google.common.graph.GraphConstants;
import org.jetbrains.kotlin.com.google.common.graph.MutableGraph;
import org.jetbrains.kotlin.com.google.common.graph.MutableValueGraph;
import org.jetbrains.kotlin.com.google.common.graph.StandardMutableValueGraph;

@ElementTypesAreNonnullByDefault
final class StandardMutableGraph<N>
extends ForwardingGraph<N>
implements MutableGraph<N> {
    private final MutableValueGraph<N, GraphConstants.Presence> backingValueGraph;

    StandardMutableGraph(AbstractGraphBuilder<? super N> builder) {
        this.backingValueGraph = new StandardMutableValueGraph<N, GraphConstants.Presence>(builder);
    }

    @Override
    BaseGraph<N> delegate() {
        return this.backingValueGraph;
    }

    @Override
    public boolean addNode(N node2) {
        return this.backingValueGraph.addNode(node2);
    }

    @Override
    public boolean putEdge(N nodeU, N nodeV) {
        return this.backingValueGraph.putEdgeValue(nodeU, nodeV, GraphConstants.Presence.EDGE_EXISTS) == null;
    }

    @Override
    public boolean putEdge(EndpointPair<N> endpoints) {
        this.validateEndpoints(endpoints);
        return this.putEdge(endpoints.nodeU(), endpoints.nodeV());
    }

    @Override
    public boolean removeNode(N node2) {
        return this.backingValueGraph.removeNode(node2);
    }

    @Override
    public boolean removeEdge(N nodeU, N nodeV) {
        return this.backingValueGraph.removeEdge(nodeU, nodeV) != null;
    }

    @Override
    public boolean removeEdge(EndpointPair<N> endpoints) {
        this.validateEndpoints(endpoints);
        return this.removeEdge(endpoints.nodeU(), endpoints.nodeV());
    }
}

