/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.google.common.collect;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import javax.annotation.CheckForNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jetbrains.kotlin.com.google.common.annotations.GwtCompatible;
import org.jetbrains.kotlin.com.google.common.annotations.GwtIncompatible;
import org.jetbrains.kotlin.com.google.common.annotations.VisibleForTesting;
import org.jetbrains.kotlin.com.google.common.base.Objects;
import org.jetbrains.kotlin.com.google.common.base.Preconditions;
import org.jetbrains.kotlin.com.google.common.collect.CollectPreconditions;
import org.jetbrains.kotlin.com.google.common.collect.CollectSpliterators;
import org.jetbrains.kotlin.com.google.common.collect.ElementTypesAreNonnullByDefault;
import org.jetbrains.kotlin.com.google.common.collect.Hashing;
import org.jetbrains.kotlin.com.google.common.collect.ImmutableEntry;
import org.jetbrains.kotlin.com.google.common.collect.LinkedHashMultimapGwtSerializationDependencies;
import org.jetbrains.kotlin.com.google.common.collect.Maps;
import org.jetbrains.kotlin.com.google.common.collect.Multimap;
import org.jetbrains.kotlin.com.google.common.collect.ParametricNullness;
import org.jetbrains.kotlin.com.google.common.collect.Platform;
import org.jetbrains.kotlin.com.google.common.collect.Sets;
import org.jetbrains.kotlin.com.google.errorprone.annotations.CanIgnoreReturnValue;

@ElementTypesAreNonnullByDefault
@GwtCompatible(serializable=true, emulated=true)
public final class LinkedHashMultimap<K, V>
extends LinkedHashMultimapGwtSerializationDependencies<K, V> {
    private static final int DEFAULT_KEY_CAPACITY = 16;
    private static final int DEFAULT_VALUE_SET_CAPACITY = 2;
    @VisibleForTesting
    static final double VALUE_SET_LOAD_FACTOR = 1.0;
    @VisibleForTesting
    transient int valueSetCapacity = 2;
    private transient ValueEntry<K, V> multimapHeaderEntry;
    @GwtIncompatible
    private static final long serialVersionUID = 1L;

    public static <K, V> LinkedHashMultimap<K, V> create() {
        return new LinkedHashMultimap<K, V>(16, 2);
    }

    public static <K, V> LinkedHashMultimap<K, V> create(int expectedKeys, int expectedValuesPerKey) {
        return new LinkedHashMultimap<K, V>(Maps.capacity(expectedKeys), Maps.capacity(expectedValuesPerKey));
    }

    public static <K, V> LinkedHashMultimap<K, V> create(Multimap<? extends K, ? extends V> multimap) {
        LinkedHashMultimap<K, V> result2 = LinkedHashMultimap.create(multimap.keySet().size(), 2);
        result2.putAll((Multimap)multimap);
        return result2;
    }

    private static <K, V> void succeedsInValueSet(ValueSetLink<K, V> pred, ValueSetLink<K, V> succ) {
        pred.setSuccessorInValueSet(succ);
        succ.setPredecessorInValueSet(pred);
    }

    private static <K, V> void succeedsInMultimap(ValueEntry<K, V> pred, ValueEntry<K, V> succ) {
        pred.setSuccessorInMultimap(succ);
        succ.setPredecessorInMultimap(pred);
    }

    private static <K, V> void deleteFromValueSet(ValueSetLink<K, V> entry2) {
        LinkedHashMultimap.succeedsInValueSet(entry2.getPredecessorInValueSet(), entry2.getSuccessorInValueSet());
    }

    private static <K, V> void deleteFromMultimap(ValueEntry<K, V> entry2) {
        LinkedHashMultimap.succeedsInMultimap(entry2.getPredecessorInMultimap(), entry2.getSuccessorInMultimap());
    }

    private LinkedHashMultimap(int keyCapacity, int valueSetCapacity) {
        super(Platform.newLinkedHashMapWithExpectedSize(keyCapacity));
        CollectPreconditions.checkNonnegative(valueSetCapacity, "expectedValuesPerKey");
        this.valueSetCapacity = valueSetCapacity;
        this.multimapHeaderEntry = ValueEntry.newHeader();
        LinkedHashMultimap.succeedsInMultimap(this.multimapHeaderEntry, this.multimapHeaderEntry);
    }

    @Override
    Set<V> createCollection() {
        return Platform.newLinkedHashSetWithExpectedSize(this.valueSetCapacity);
    }

    @Override
    Collection<V> createCollection(@ParametricNullness K key) {
        return new ValueSet(key, this.valueSetCapacity);
    }

    @Override
    @CanIgnoreReturnValue
    public Set<V> replaceValues(@ParametricNullness K key, Iterable<? extends V> values) {
        return super.replaceValues((Object)key, (Iterable)values);
    }

    @Override
    public Set<Map.Entry<K, V>> entries() {
        return super.entries();
    }

    @Override
    public Set<K> keySet() {
        return super.keySet();
    }

    @Override
    public Collection<V> values() {
        return super.values();
    }

    @Override
    Iterator<Map.Entry<K, V>> entryIterator() {
        return new Iterator<Map.Entry<K, V>>(){
            ValueEntry<K, V> nextEntry;
            @CheckForNull
            ValueEntry<K, V> toRemove;
            {
                this.nextEntry = LinkedHashMultimap.this.multimapHeaderEntry.getSuccessorInMultimap();
            }

            @Override
            public boolean hasNext() {
                return this.nextEntry != LinkedHashMultimap.this.multimapHeaderEntry;
            }

            @Override
            public Map.Entry<K, V> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                ValueEntry result2 = this.nextEntry;
                this.toRemove = result2;
                this.nextEntry = this.nextEntry.getSuccessorInMultimap();
                return result2;
            }

            @Override
            public void remove() {
                Preconditions.checkState(this.toRemove != null, "no calls to next() since the last call to remove()");
                LinkedHashMultimap.this.remove(this.toRemove.getKey(), this.toRemove.getValue());
                this.toRemove = null;
            }
        };
    }

    @Override
    Spliterator<Map.Entry<K, V>> entrySpliterator() {
        return Spliterators.spliterator(this.entries(), 17);
    }

    @Override
    Iterator<V> valueIterator() {
        return Maps.valueIterator(this.entryIterator());
    }

    @Override
    Spliterator<V> valueSpliterator() {
        return CollectSpliterators.map(this.entrySpliterator(), Map.Entry::getValue);
    }

    @Override
    public void clear() {
        super.clear();
        LinkedHashMultimap.succeedsInMultimap(this.multimapHeaderEntry, this.multimapHeaderEntry);
    }

    @GwtIncompatible
    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeInt(this.keySet().size());
        for (K key : this.keySet()) {
            stream.writeObject(key);
        }
        stream.writeInt(this.size());
        for (Map.Entry entry2 : this.entries()) {
            stream.writeObject(entry2.getKey());
            stream.writeObject(entry2.getValue());
        }
    }

    @GwtIncompatible
    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.multimapHeaderEntry = ValueEntry.newHeader();
        LinkedHashMultimap.succeedsInMultimap(this.multimapHeaderEntry, this.multimapHeaderEntry);
        this.valueSetCapacity = 2;
        int distinctKeys = stream.readInt();
        Map<Object, Collection<V>> map2 = Platform.newLinkedHashMapWithExpectedSize(12);
        for (int i2 = 0; i2 < distinctKeys; ++i2) {
            Object key = stream.readObject();
            map2.put(key, this.createCollection(key));
        }
        int entries2 = stream.readInt();
        for (int i3 = 0; i3 < entries2; ++i3) {
            Object key = stream.readObject();
            Object value2 = stream.readObject();
            java.util.Objects.requireNonNull((Collection)map2.get(key)).add(value2);
        }
        this.setMap(map2);
    }

    @VisibleForTesting
    final class ValueSet
    extends Sets.ImprovedAbstractSet<V>
    implements ValueSetLink<K, V> {
        @ParametricNullness
        private final K key;
        @VisibleForTesting
        @Nullable ValueEntry<K, V>[] hashTable;
        private int size = 0;
        private int modCount = 0;
        private ValueSetLink<K, V> firstEntry;
        private ValueSetLink<K, V> lastEntry;

        ValueSet(K key, int expectedValues) {
            this.key = key;
            this.firstEntry = this;
            this.lastEntry = this;
            int tableSize = Hashing.closedTableSize(expectedValues, 1.0);
            @Nullable ValueEntry[] hashTable = new ValueEntry[tableSize];
            this.hashTable = hashTable;
        }

        private int mask() {
            return this.hashTable.length - 1;
        }

        @Override
        public ValueSetLink<K, V> getPredecessorInValueSet() {
            return this.lastEntry;
        }

        @Override
        public ValueSetLink<K, V> getSuccessorInValueSet() {
            return this.firstEntry;
        }

        @Override
        public void setPredecessorInValueSet(ValueSetLink<K, V> entry2) {
            this.lastEntry = entry2;
        }

        @Override
        public void setSuccessorInValueSet(ValueSetLink<K, V> entry2) {
            this.firstEntry = entry2;
        }

        @Override
        public Iterator<V> iterator() {
            return new Iterator<V>(){
                ValueSetLink<K, V> nextEntry;
                @CheckForNull
                ValueEntry<K, V> toRemove;
                int expectedModCount;
                {
                    this.nextEntry = ValueSet.this.firstEntry;
                    this.expectedModCount = ValueSet.this.modCount;
                }

                private void checkForComodification() {
                    if (ValueSet.this.modCount != this.expectedModCount) {
                        throw new ConcurrentModificationException();
                    }
                }

                @Override
                public boolean hasNext() {
                    this.checkForComodification();
                    return this.nextEntry != ValueSet.this;
                }

                @Override
                @ParametricNullness
                public V next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    ValueEntry entry2 = (ValueEntry)this.nextEntry;
                    Object result2 = entry2.getValue();
                    this.toRemove = entry2;
                    this.nextEntry = entry2.getSuccessorInValueSet();
                    return result2;
                }

                @Override
                public void remove() {
                    this.checkForComodification();
                    Preconditions.checkState(this.toRemove != null, "no calls to next() since the last call to remove()");
                    ValueSet.this.remove(this.toRemove.getValue());
                    this.expectedModCount = ValueSet.this.modCount;
                    this.toRemove = null;
                }
            };
        }

        @Override
        public void forEach(Consumer<? super V> action2) {
            Preconditions.checkNotNull(action2);
            for (ValueSetLink entry2 = this.firstEntry; entry2 != this; entry2 = entry2.getSuccessorInValueSet()) {
                action2.accept(((ValueEntry)entry2).getValue());
            }
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public boolean contains(@CheckForNull Object o) {
            int smearedHash = Hashing.smearedHash(o);
            ValueEntry entry2 = this.hashTable[smearedHash & this.mask()];
            while (entry2 != null) {
                if (entry2.matchesValue(o, smearedHash)) {
                    return true;
                }
                entry2 = entry2.nextInValueBucket;
            }
            return false;
        }

        @Override
        public boolean add(@ParametricNullness V value2) {
            ValueEntry rowHead;
            int smearedHash = Hashing.smearedHash(value2);
            int bucket = smearedHash & this.mask();
            ValueEntry entry2 = rowHead = this.hashTable[bucket];
            while (entry2 != null) {
                if (entry2.matchesValue(value2, smearedHash)) {
                    return false;
                }
                entry2 = entry2.nextInValueBucket;
            }
            ValueEntry newEntry = new ValueEntry(this.key, value2, smearedHash, rowHead);
            LinkedHashMultimap.succeedsInValueSet(this.lastEntry, newEntry);
            LinkedHashMultimap.succeedsInValueSet(newEntry, this);
            LinkedHashMultimap.succeedsInMultimap(LinkedHashMultimap.this.multimapHeaderEntry.getPredecessorInMultimap(), newEntry);
            LinkedHashMultimap.succeedsInMultimap(newEntry, LinkedHashMultimap.this.multimapHeaderEntry);
            this.hashTable[bucket] = newEntry;
            ++this.size;
            ++this.modCount;
            this.rehashIfNecessary();
            return true;
        }

        private void rehashIfNecessary() {
            if (Hashing.needsResizing(this.size, this.hashTable.length, 1.0)) {
                ValueEntry[] hashTable = new ValueEntry[this.hashTable.length * 2];
                this.hashTable = hashTable;
                int mask = hashTable.length - 1;
                for (ValueSetLink entry2 = this.firstEntry; entry2 != this; entry2 = entry2.getSuccessorInValueSet()) {
                    ValueEntry valueEntry = (ValueEntry)entry2;
                    int bucket = valueEntry.smearedValueHash & mask;
                    valueEntry.nextInValueBucket = hashTable[bucket];
                    hashTable[bucket] = valueEntry;
                }
            }
        }

        @Override
        @CanIgnoreReturnValue
        public boolean remove(@CheckForNull Object o) {
            int smearedHash = Hashing.smearedHash(o);
            int bucket = smearedHash & this.mask();
            ValueEntry prev = null;
            ValueEntry entry2 = this.hashTable[bucket];
            while (entry2 != null) {
                if (entry2.matchesValue(o, smearedHash)) {
                    if (prev == null) {
                        this.hashTable[bucket] = entry2.nextInValueBucket;
                    } else {
                        prev.nextInValueBucket = entry2.nextInValueBucket;
                    }
                    LinkedHashMultimap.deleteFromValueSet(entry2);
                    LinkedHashMultimap.deleteFromMultimap(entry2);
                    --this.size;
                    ++this.modCount;
                    return true;
                }
                prev = entry2;
                entry2 = entry2.nextInValueBucket;
            }
            return false;
        }

        @Override
        public void clear() {
            Arrays.fill(this.hashTable, null);
            this.size = 0;
            for (ValueSetLink entry2 = this.firstEntry; entry2 != this; entry2 = entry2.getSuccessorInValueSet()) {
                ValueEntry valueEntry = (ValueEntry)entry2;
                LinkedHashMultimap.deleteFromMultimap(valueEntry);
            }
            LinkedHashMultimap.succeedsInValueSet(this, this);
            ++this.modCount;
        }
    }

    @VisibleForTesting
    static final class ValueEntry<K, V>
    extends ImmutableEntry<K, V>
    implements ValueSetLink<K, V> {
        final int smearedValueHash;
        @CheckForNull
        ValueEntry<K, V> nextInValueBucket;
        @CheckForNull
        ValueSetLink<K, V> predecessorInValueSet;
        @CheckForNull
        ValueSetLink<K, V> successorInValueSet;
        @CheckForNull
        ValueEntry<K, V> predecessorInMultimap;
        @CheckForNull
        ValueEntry<K, V> successorInMultimap;

        ValueEntry(@ParametricNullness K key, @ParametricNullness V value2, int smearedValueHash, @CheckForNull ValueEntry<K, V> nextInValueBucket) {
            super(key, value2);
            this.smearedValueHash = smearedValueHash;
            this.nextInValueBucket = nextInValueBucket;
        }

        static <K, V> ValueEntry<K, V> newHeader() {
            return new ValueEntry<Object, Object>(null, null, 0, null);
        }

        boolean matchesValue(@CheckForNull Object v, int smearedVHash) {
            return this.smearedValueHash == smearedVHash && Objects.equal(this.getValue(), v);
        }

        @Override
        public ValueSetLink<K, V> getPredecessorInValueSet() {
            return java.util.Objects.requireNonNull(this.predecessorInValueSet);
        }

        @Override
        public ValueSetLink<K, V> getSuccessorInValueSet() {
            return java.util.Objects.requireNonNull(this.successorInValueSet);
        }

        @Override
        public void setPredecessorInValueSet(ValueSetLink<K, V> entry2) {
            this.predecessorInValueSet = entry2;
        }

        @Override
        public void setSuccessorInValueSet(ValueSetLink<K, V> entry2) {
            this.successorInValueSet = entry2;
        }

        public ValueEntry<K, V> getPredecessorInMultimap() {
            return java.util.Objects.requireNonNull(this.predecessorInMultimap);
        }

        public ValueEntry<K, V> getSuccessorInMultimap() {
            return java.util.Objects.requireNonNull(this.successorInMultimap);
        }

        public void setSuccessorInMultimap(ValueEntry<K, V> multimapSuccessor) {
            this.successorInMultimap = multimapSuccessor;
        }

        public void setPredecessorInMultimap(ValueEntry<K, V> multimapPredecessor) {
            this.predecessorInMultimap = multimapPredecessor;
        }
    }

    private static interface ValueSetLink<K, V> {
        public ValueSetLink<K, V> getPredecessorInValueSet();

        public ValueSetLink<K, V> getSuccessorInValueSet();

        public void setPredecessorInValueSet(ValueSetLink<K, V> var1);

        public void setSuccessorInValueSet(ValueSetLink<K, V> var1);
    }
}

