/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.tasks.internal;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.dsl.KotlinMultiplatformCommonCompilerOptions;
import org.jetbrains.kotlin.gradle.dsl.KotlinMultiplatformCommonOptions;
import org.jetbrains.kotlin.gradle.tasks.AbstractKotlinCompile;
import org.jetbrains.kotlin.gradle.tasks.KotlinCompileCommon;
import org.jetbrains.kotlin.gradle.tasks.internal.KotlinOptionsFreeArgsDeprecationKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007R0\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0012R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/gradle/tasks/internal/KotlinMultiplatformCommonOptionsCompat;", "Lorg/jetbrains/kotlin/gradle/dsl/KotlinMultiplatformCommonOptions;", "task", "Lkotlin/Function0;", "Lorg/jetbrains/kotlin/gradle/tasks/KotlinCompileCommon;", "options", "Lorg/jetbrains/kotlin/gradle/dsl/KotlinMultiplatformCommonCompilerOptions;", "(Lkotlin/jvm/functions/Function0;Lorg/jetbrains/kotlin/gradle/dsl/KotlinMultiplatformCommonCompilerOptions;)V", "value", "", "", "freeCompilerArgs", "getFreeCompilerArgs", "()Ljava/util/List;", "setFreeCompilerArgs", "(Ljava/util/List;)V", "isTaskExecuting", "", "()Z", "getOptions", "()Lorg/jetbrains/kotlin/gradle/dsl/KotlinMultiplatformCommonCompilerOptions;", "kotlin-gradle-plugin_common"})
public final class KotlinMultiplatformCommonOptionsCompat
implements KotlinMultiplatformCommonOptions {
    @NotNull
    private final Function0<KotlinCompileCommon> task;
    @NotNull
    private final KotlinMultiplatformCommonCompilerOptions options;

    public KotlinMultiplatformCommonOptionsCompat(@NotNull Function0<? extends KotlinCompileCommon> task2, @NotNull KotlinMultiplatformCommonCompilerOptions options) {
        Intrinsics.checkNotNullParameter(task2, (String)"task");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        this.task = task2;
        this.options = options;
    }

    @NotNull
    public KotlinMultiplatformCommonCompilerOptions getOptions() {
        return this.options;
    }

    @NotNull
    public List<String> getFreeCompilerArgs() {
        List list;
        List executionTimeFreeCompilerArgs = ((KotlinCompileCommon)this.task.invoke()).getExecutionTimeFreeCompilerArgs$kotlin_gradle_plugin_common();
        if (this.isTaskExecuting() && executionTimeFreeCompilerArgs != null) {
            list = executionTimeFreeCompilerArgs;
        } else {
            Object object = this.getOptions().getFreeCompilerArgs().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"{\n                option\u2026rArgs.get()\n            }");
            list = (List)object;
        }
        return list;
    }

    public void setFreeCompilerArgs(@NotNull List<String> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        if (this.isTaskExecuting()) {
            KotlinOptionsFreeArgsDeprecationKt.nagUserFreeArgsModifiedOnExecution((AbstractKotlinCompile)this.task.invoke(), value);
            ((KotlinCompileCommon)this.task.invoke()).setExecutionTimeFreeCompilerArgs$kotlin_gradle_plugin_common(value);
        } else {
            this.getOptions().getFreeCompilerArgs().set((Iterable)value);
        }
    }

    private final boolean isTaskExecuting() {
        return ((KotlinCompileCommon)this.task.invoke()).getState().getExecuting();
    }

    public boolean getAllWarningsAsErrors() {
        return KotlinMultiplatformCommonOptions.DefaultImpls.getAllWarningsAsErrors((KotlinMultiplatformCommonOptions)this);
    }

    public void setAllWarningsAsErrors(boolean value) {
        KotlinMultiplatformCommonOptions.DefaultImpls.setAllWarningsAsErrors((KotlinMultiplatformCommonOptions)this, (boolean)value);
    }

    @Nullable
    public String getApiVersion() {
        return KotlinMultiplatformCommonOptions.DefaultImpls.getApiVersion((KotlinMultiplatformCommonOptions)this);
    }

    public void setApiVersion(@Nullable String value) {
        KotlinMultiplatformCommonOptions.DefaultImpls.setApiVersion((KotlinMultiplatformCommonOptions)this, (String)value);
    }

    @Nullable
    public String getLanguageVersion() {
        return KotlinMultiplatformCommonOptions.DefaultImpls.getLanguageVersion((KotlinMultiplatformCommonOptions)this);
    }

    public void setLanguageVersion(@Nullable String value) {
        KotlinMultiplatformCommonOptions.DefaultImpls.setLanguageVersion((KotlinMultiplatformCommonOptions)this, (String)value);
    }

    public boolean getSuppressWarnings() {
        return KotlinMultiplatformCommonOptions.DefaultImpls.getSuppressWarnings((KotlinMultiplatformCommonOptions)this);
    }

    public void setSuppressWarnings(boolean value) {
        KotlinMultiplatformCommonOptions.DefaultImpls.setSuppressWarnings((KotlinMultiplatformCommonOptions)this, (boolean)value);
    }

    public boolean getUseK2() {
        return KotlinMultiplatformCommonOptions.DefaultImpls.getUseK2((KotlinMultiplatformCommonOptions)this);
    }

    public void setUseK2(boolean value) {
        KotlinMultiplatformCommonOptions.DefaultImpls.setUseK2((KotlinMultiplatformCommonOptions)this, (boolean)value);
    }

    public boolean getVerbose() {
        return KotlinMultiplatformCommonOptions.DefaultImpls.getVerbose((KotlinMultiplatformCommonOptions)this);
    }

    public void setVerbose(boolean value) {
        KotlinMultiplatformCommonOptions.DefaultImpls.setVerbose((KotlinMultiplatformCommonOptions)this, (boolean)value);
    }
}

