/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin.mpp.pm20;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.FileCollection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.plugin.FilesSubpluginOption;
import org.jetbrains.kotlin.gradle.plugin.SubpluginOption;
import org.jetbrains.kotlin.gradle.tasks.CompilerPluginOptions;
import org.jetbrains.kotlin.gradle.tasks.KotlinCompilerPluginData;
import org.jetbrains.kotlin.gradle.utils.GradleConfigurationUtilsKt;
import org.jetbrains.kotlin.project.model.FilesOption;
import org.jetbrains.kotlin.project.model.PluginData;
import org.jetbrains.kotlin.project.model.PluginOption;
import org.jetbrains.kotlin.project.model.StringOption;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0006\u0010\u0016\u001a\u00020\u0017J\u0017\u0010\u0018\u001a\u00020\u00122\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0086\u0002J\u0011\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u001bH\u0086\u0002J*\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u001e*\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u001f0\u001eH\u0002J\f\u0010 \u001a\u00020\u0005*\u00020!H\u0002J\f\u0010\"\u001a\u00020#*\u00020\u0015H\u0002R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\b0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/mpp/pm20/CompilerPluginOptionsBuilder;", "", "project", "Lorg/gradle/api/Project;", "configurationName", "", "(Lorg/gradle/api/Project;Ljava/lang/String;)V", "artifacts", "", "gradleInputFiles", "", "Ljava/io/File;", "gradleInputs", "", "gradleOutputFiles", "pluginOptions", "Lorg/jetbrains/kotlin/gradle/tasks/CompilerPluginOptions;", "addToInputsOutputs", "", "pluginId", "option", "Lorg/jetbrains/kotlin/project/model/PluginOption;", "build", "Lorg/jetbrains/kotlin/gradle/tasks/KotlinCompilerPluginData;", "plusAssign", "pluginDataCollection", "", "Lorg/jetbrains/kotlin/project/model/PluginData;", "pluginData", "flattenWithIndex", "", "", "toGradleCoordinates", "Lorg/jetbrains/kotlin/project/model/PluginData$ArtifactCoordinates;", "toSubpluginOption", "Lorg/jetbrains/kotlin/gradle/plugin/SubpluginOption;", "kotlin-gradle-plugin_common"})
@SourceDebugExtension(value={"SMAP\ncompilerPluginProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 compilerPluginProvider.kt\norg/jetbrains/kotlin/gradle/plugin/mpp/pm20/CompilerPluginOptionsBuilder\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,131:1\n372#2,7:132\n1855#3,2:139\n*S KotlinDebug\n*F\n+ 1 compilerPluginProvider.kt\norg/jetbrains/kotlin/gradle/plugin/mpp/pm20/CompilerPluginOptionsBuilder\n*L\n85#1:132,7\n98#1:139,2\n*E\n"})
final class CompilerPluginOptionsBuilder {
    @NotNull
    private final Project project;
    @NotNull
    private final String configurationName;
    @NotNull
    private final CompilerPluginOptions pluginOptions;
    @NotNull
    private final List<String> artifacts;
    @NotNull
    private final Map<String, List<String>> gradleInputs;
    @NotNull
    private final Set<File> gradleInputFiles;
    @NotNull
    private final Set<File> gradleOutputFiles;

    public CompilerPluginOptionsBuilder(@NotNull Project project, @NotNull String configurationName) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)configurationName, (String)"configurationName");
        this.project = project;
        this.configurationName = configurationName;
        this.pluginOptions = new CompilerPluginOptions();
        this.artifacts = new ArrayList();
        this.gradleInputs = new LinkedHashMap();
        this.gradleInputFiles = new LinkedHashSet();
        this.gradleOutputFiles = new LinkedHashSet();
    }

    public final void plusAssign(@NotNull PluginData pluginData) {
        Intrinsics.checkNotNullParameter((Object)pluginData, (String)"pluginData");
        ((Collection)this.artifacts).add(this.toGradleCoordinates(pluginData.getArtifact()));
        for (PluginOption option : pluginData.getOptions()) {
            this.pluginOptions.addPluginArgument(pluginData.getPluginId(), this.toSubpluginOption(option));
            if (option.isTransient()) continue;
            this.addToInputsOutputs(pluginData.getPluginId(), option);
        }
    }

    public final void plusAssign(@NotNull Collection<PluginData> pluginDataCollection) {
        Intrinsics.checkNotNullParameter(pluginDataCollection, (String)"pluginDataCollection");
        for (PluginData pluginData : pluginDataCollection) {
            this.plusAssign(pluginData);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void addToInputsOutputs(String pluginId, PluginOption option) {
        PluginOption pluginOption = option;
        if (pluginOption instanceof FilesOption) {
            if (((FilesOption)option).isOutput()) {
                CollectionsKt.addAll((Collection)this.gradleOutputFiles, (Iterable)((FilesOption)option).getFiles());
            } else {
                CollectionsKt.addAll((Collection)this.gradleInputFiles, (Iterable)((FilesOption)option).getFiles());
            }
        } else if (pluginOption instanceof StringOption) {
            Object object;
            void $this$getOrPut$iv;
            Map<String, List<String>> map2 = this.gradleInputs;
            String key$iv = pluginId + '.' + option.getKey();
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                List answer$iv = new ArrayList();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            ((List)object).add(((StringOption)option).getValue());
        }
    }

    @NotNull
    public final KotlinCompilerPluginData build() {
        Object object = this.project.getConfigurations().maybeCreate(this.configurationName);
        Configuration $this$build_u24lambda_u241 = (Configuration)object;
        boolean bl = false;
        $this$build_u24lambda_u241.setCanBeConsumed(false);
        $this$build_u24lambda_u241.setCanBeResolved(true);
        $this$build_u24lambda_u241.setVisible(false);
        Intrinsics.checkNotNullExpressionValue((Object)$this$build_u24lambda_u241, (String)"build$lambda$1");
        GradleConfigurationUtilsKt.addGradlePluginMetadataAttributes($this$build_u24lambda_u241, this.project);
        Configuration pluginClasspathConfiguration = (Configuration)object;
        Iterable $this$forEach$iv = this.artifacts;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl2 = false;
            this.project.getDependencies().add(this.configurationName, (Object)it);
        }
        Intrinsics.checkNotNullExpressionValue((Object)pluginClasspathConfiguration, (String)"pluginClasspathConfiguration");
        return new KotlinCompilerPluginData((FileCollection)pluginClasspathConfiguration, this.pluginOptions, new KotlinCompilerPluginData.InputsOutputsState(this.flattenWithIndex(this.gradleInputs), this.gradleInputFiles, this.gradleOutputFiles));
    }

    private final Map<String, String> flattenWithIndex(Map<String, ? extends List<String>> $this$flattenWithIndex) {
        Map result2 = new LinkedHashMap();
        for (Map.Entry<String, ? extends List<String>> entry2 : $this$flattenWithIndex.entrySet()) {
            String key = entry2.getKey();
            List<String> values = entry2.getValue();
            Iterator<String> iterator = values.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                int index = n++;
                String value = iterator.next();
                result2.put(key + '.' + index, value);
            }
        }
        return result2;
    }

    private final SubpluginOption toSubpluginOption(PluginOption $this$toSubpluginOption) {
        SubpluginOption subpluginOption;
        PluginOption pluginOption = $this$toSubpluginOption;
        if (pluginOption instanceof FilesOption) {
            subpluginOption = (SubpluginOption)new FilesSubpluginOption($this$toSubpluginOption.getKey(), ((FilesOption)$this$toSubpluginOption).getFiles(), null, null, 12, null);
        } else if (pluginOption instanceof StringOption) {
            subpluginOption = new SubpluginOption($this$toSubpluginOption.getKey(), ((StringOption)$this$toSubpluginOption).getValue());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return subpluginOption;
    }

    private final String toGradleCoordinates(PluginData.ArtifactCoordinates $this$toGradleCoordinates) {
        Object[] objectArray = new String[]{$this$toGradleCoordinates.getGroup(), $this$toGradleCoordinates.getArtifact(), $this$toGradleCoordinates.getVersion()};
        return CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOfNotNull((Object[])objectArray), (CharSequence)":", null, null, (int)0, null, null, (int)62, null);
    }
}

