/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.de.undercouch.gradle.tasks.download;

import groovy.lang.Closure;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.jetbrains.kotlin.de.undercouch.gradle.tasks.download.VerifySpec;
import org.jetbrains.kotlin.de.undercouch.gradle.tasks.download.internal.ProjectApiHelper;
import org.jetbrains.kotlin.de.undercouch.gradle.tasks.download.internal.ProviderHelper;

public class VerifyAction
implements VerifySpec {
    private final ProjectApiHelper projectApi;
    private File src;
    private String algorithm = "MD5";
    private String checksum;

    public VerifyAction(Project project) {
        this.projectApi = ProjectApiHelper.newInstance(project);
    }

    private String toHex(byte[] barr) {
        StringBuilder result2 = new StringBuilder();
        for (byte b : barr) {
            result2.append(String.format("%02X", b));
        }
        return result2.toString();
    }

    public void execute() throws IOException, NoSuchAlgorithmException {
        String calculatedChecksum;
        if (this.src == null) {
            throw new IllegalArgumentException("Please provide a file to verify");
        }
        if (this.algorithm == null) {
            throw new IllegalArgumentException("Please provide the algorithm to use to calculate the checksum");
        }
        if (this.checksum == null) {
            throw new IllegalArgumentException("Please provide a checksum to verify against");
        }
        MessageDigest md = MessageDigest.getInstance(this.algorithm);
        try (FileInputStream fis = new FileInputStream(this.src);){
            int read;
            byte[] buf = new byte[1024];
            while ((read = fis.read(buf)) != -1) {
                md.update(buf, 0, read);
            }
            calculatedChecksum = this.toHex(md.digest());
        }
        if (!calculatedChecksum.equalsIgnoreCase(this.checksum)) {
            throw new GradleException("Invalid checksum for file '" + this.src.getName() + "'. Expected " + this.checksum.toLowerCase() + " but got " + calculatedChecksum.toLowerCase() + ".");
        }
    }

    @Override
    public void src(Object src) {
        if (src instanceof Closure) {
            Closure closure = (Closure)src;
            src = closure.call();
        }
        if ((src = ProviderHelper.tryGetProvider(src)) instanceof CharSequence) {
            src = this.projectApi.file(src.toString());
        }
        if (!(src instanceof File)) {
            throw new IllegalArgumentException("Verification source must either be a CharSequence or a File");
        }
        this.src = (File)src;
    }

    @Override
    public void algorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    @Override
    public void checksum(String checksum2) {
        this.checksum = checksum2;
    }

    @Override
    public File getSrc() {
        return this.src;
    }

    @Override
    public String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public String getChecksum() {
        return this.checksum;
    }
}

