/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.konan.file;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.FileSystem;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.konan.file.File;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000@\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0000\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u001a\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u001a\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u0007\u001a\n\u0010\n\u001a\u00020\u0005*\u00020\u000b\u001a\n\u0010\n\u001a\u00020\u0005*\u00020\u0007\u001a\u001c\u0010\f\u001a\u00020\r*\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000b2\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u001a;\u0010\u0011\u001a\u0002H\u0012\"\n\b\u0000\u0010\u0013*\u0004\u0018\u00010\u0014\"\u0004\b\u0001\u0010\u0012*\u0002H\u00132\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u0002H\u0013\u0012\u0004\u0012\u0002H\u00120\u0016H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0017\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u0018"}, d2={"bufferedReader", "Ljava/io/BufferedReader;", "errorStream", "Ljava/io/InputStream;", "createTempDir", "Lorg/jetbrains/kotlin/konan/file/File;", "name", "", "createTempFile", "suffix", "File", "Ljava/nio/file/Path;", "recursiveCopyTo", "", "destPath", "resetTimeAttributes", "", "use", "R", "T", "Ljava/lang/AutoCloseable;", "block", "Lkotlin/Function1;", "(Ljava/lang/AutoCloseable;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "kotlin-util-io"})
public final class FileKt {
    @NotNull
    public static final File File(@NotNull String $this$File) {
        Intrinsics.checkNotNullParameter((Object)$this$File, (String)"$this$File");
        return new File($this$File);
    }

    @NotNull
    public static final File File(@NotNull Path $this$File) {
        Intrinsics.checkNotNullParameter((Object)$this$File, (String)"$this$File");
        return new File($this$File);
    }

    @NotNull
    public static final File createTempFile(@NotNull String name2, @Nullable String suffix) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Path path = Files.createTempFile(name2, suffix, new FileAttribute[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"Files.createTempFile(name, suffix)");
        return FileKt.File(path);
    }

    public static /* synthetic */ File createTempFile$default(String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        return FileKt.createTempFile(string, string2);
    }

    @NotNull
    public static final File createTempDir(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Path path = Files.createTempDirectory(name2, new FileAttribute[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"Files.createTempDirectory(name)");
        return FileKt.File(path);
    }

    public static final void recursiveCopyTo(@NotNull Path $this$recursiveCopyTo, @NotNull Path destPath, boolean resetTimeAttributes) {
        Intrinsics.checkNotNullParameter((Object)$this$recursiveCopyTo, (String)"$this$recursiveCopyTo");
        Intrinsics.checkNotNullParameter((Object)destPath, (String)"destPath");
        Path sourcePath = $this$recursiveCopyTo;
        Files.walk(sourcePath, new FileVisitOption[0]).forEach(new Consumer(sourcePath, destPath, resetTimeAttributes){
            final /* synthetic */ Path $sourcePath;
            final /* synthetic */ Path $destPath;
            final /* synthetic */ boolean $resetTimeAttributes;

            public final void invoke(Path oldPath) {
                Path relative = this.$sourcePath.relativize(oldPath);
                FileSystem destFs = this.$destPath.getFileSystem();
                Path newPath = destFs.getPath(((Object)this.$destPath).toString(), ((Object)relative).toString());
                if (Intrinsics.areEqual((Object)newPath, (Object)newPath.getRoot())) {
                    return;
                }
                if (Files.isDirectory(newPath, new LinkOption[0])) {
                    Files.createDirectories(newPath, new FileAttribute[0]);
                } else {
                    Files.copy(oldPath, newPath, StandardCopyOption.REPLACE_EXISTING);
                }
                if (this.$resetTimeAttributes) {
                    FileTime zero = FileTime.fromMillis(0L);
                    Files.getFileAttributeView(newPath, BasicFileAttributeView.class, new LinkOption[0]).setTimes(zero, zero, zero);
                }
            }
            {
                this.$sourcePath = path;
                this.$destPath = path2;
                this.$resetTimeAttributes = bl;
            }
        });
    }

    public static /* synthetic */ void recursiveCopyTo$default(Path path, Path path2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        FileKt.recursiveCopyTo(path, path2, bl);
    }

    @NotNull
    public static final BufferedReader bufferedReader(@Nullable InputStream errorStream) {
        return new BufferedReader(new InputStreamReader(errorStream));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <T extends AutoCloseable, R> R use(T $this$use, @NotNull Function1<? super T, ? extends R> block) {
        Object object;
        int $i$f$use = 0;
        Intrinsics.checkNotNullParameter(block, (String)"block");
        boolean closed = false;
        try {
            object = block.invoke($this$use);
        }
        catch (Exception e) {
            try {
                closed = true;
                try {
                    T t = $this$use;
                    if (t != null) {
                        t.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw (Throwable)e;
            }
            catch (Throwable throwable) {
                InlineMarker.finallyStart((int)1);
                if (!closed) {
                    T t = $this$use;
                    if (t != null) {
                        t.close();
                    }
                }
                InlineMarker.finallyEnd((int)1);
                throw throwable;
            }
        }
        InlineMarker.finallyStart((int)1);
        T t = $this$use;
        if (t != null) {
            t.close();
        }
        InlineMarker.finallyEnd((int)1);
        return (R)object;
    }
}

