/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.tasks;

import java.time.Duration;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.DefaultTask;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.tasks.internal.CleanableStore;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0007R$\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001e\u0010\n\u001a\u00020\u000b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/gradle/tasks/CleanDataTask;", "Lorg/gradle/api/DefaultTask;", "()V", "cleanableStoreProvider", "Lorg/gradle/api/provider/Provider;", "Lorg/jetbrains/kotlin/gradle/tasks/internal/CleanableStore;", "getCleanableStoreProvider", "()Lorg/gradle/api/provider/Provider;", "setCleanableStoreProvider", "(Lorg/gradle/api/provider/Provider;)V", "timeToLiveInDays", "", "getTimeToLiveInDays", "()J", "setTimeToLiveInDays", "(J)V", "exec", "", "Companion", "kotlin-gradle-plugin_common"})
public class CleanDataTask
extends DefaultTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Input
    public Provider<CleanableStore> cleanableStoreProvider;
    @Input
    private long timeToLiveInDays = 30L;
    @NotNull
    public static final String NAME_SUFFIX = "KotlinClean";

    @NotNull
    public final Provider<CleanableStore> getCleanableStoreProvider() {
        Provider<CleanableStore> provider = this.cleanableStoreProvider;
        if (provider != null) {
            return provider;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"cleanableStoreProvider");
        return null;
    }

    public final void setCleanableStoreProvider(@NotNull Provider<CleanableStore> provider) {
        Intrinsics.checkNotNullParameter(provider, (String)"<set-?>");
        this.cleanableStoreProvider = provider;
    }

    public final long getTimeToLiveInDays() {
        return this.timeToLiveInDays;
    }

    public final void setTimeToLiveInDays(long l) {
        this.timeToLiveInDays = l;
    }

    @TaskAction
    public final void exec() {
        Instant expirationDate = Instant.now().minus(Duration.ofDays(this.timeToLiveInDays));
        CleanableStore cleanableStore = (CleanableStore)this.getCleanableStoreProvider().get();
        Intrinsics.checkNotNullExpressionValue((Object)expirationDate, (String)"expirationDate");
        cleanableStore.cleanDir(expirationDate);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/gradle/tasks/CleanDataTask$Companion;", "", "()V", "NAME_SUFFIX", "", "kotlin-gradle-plugin_common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

