/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.google.common.primitives;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.RandomAccess;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jetbrains.kotlin.com.google.common.annotations.GwtCompatible;
import org.jetbrains.kotlin.com.google.common.base.Preconditions;

@GwtCompatible
public final class Bytes {
    private Bytes() {
    }

    public static int hashCode(byte value) {
        return value;
    }

    public static boolean contains(byte[] array2, byte target2) {
        for (byte value : array2) {
            if (value != target2) continue;
            return true;
        }
        return false;
    }

    public static int indexOf(byte[] array2, byte target2) {
        return Bytes.indexOf(array2, target2, 0, array2.length);
    }

    private static int indexOf(byte[] array2, byte target2, int start, int end) {
        for (int i2 = start; i2 < end; ++i2) {
            if (array2[i2] != target2) continue;
            return i2;
        }
        return -1;
    }

    public static int indexOf(byte[] array2, byte[] target2) {
        Preconditions.checkNotNull(array2, "array");
        Preconditions.checkNotNull(target2, "target");
        if (target2.length == 0) {
            return 0;
        }
        block0: for (int i2 = 0; i2 < array2.length - target2.length + 1; ++i2) {
            for (int j = 0; j < target2.length; ++j) {
                if (array2[i2 + j] != target2[j]) continue block0;
            }
            return i2;
        }
        return -1;
    }

    public static int lastIndexOf(byte[] array2, byte target2) {
        return Bytes.lastIndexOf(array2, target2, 0, array2.length);
    }

    private static int lastIndexOf(byte[] array2, byte target2, int start, int end) {
        for (int i2 = end - 1; i2 >= start; --i2) {
            if (array2[i2] != target2) continue;
            return i2;
        }
        return -1;
    }

    public static byte[] concat(byte[] ... arrays) {
        int length = 0;
        for (byte[] array2 : arrays) {
            length += array2.length;
        }
        byte[] result2 = new byte[length];
        int pos = 0;
        for (byte[] array3 : arrays) {
            System.arraycopy(array3, 0, result2, pos, array3.length);
            pos += array3.length;
        }
        return result2;
    }

    public static byte[] ensureCapacity(byte[] array2, int minLength, int padding) {
        Preconditions.checkArgument(minLength >= 0, "Invalid minLength: %s", minLength);
        Preconditions.checkArgument(padding >= 0, "Invalid padding: %s", padding);
        return array2.length < minLength ? Arrays.copyOf(array2, minLength + padding) : array2;
    }

    public static byte[] toArray(Collection<? extends Number> collection) {
        if (collection instanceof ByteArrayAsList) {
            return ((ByteArrayAsList)collection).toByteArray();
        }
        Object[] boxedArray = collection.toArray();
        int len = boxedArray.length;
        byte[] array2 = new byte[len];
        for (int i2 = 0; i2 < len; ++i2) {
            array2[i2] = ((Number)Preconditions.checkNotNull(boxedArray[i2])).byteValue();
        }
        return array2;
    }

    public static List<Byte> asList(byte ... backingArray) {
        if (backingArray.length == 0) {
            return Collections.emptyList();
        }
        return new ByteArrayAsList(backingArray);
    }

    public static void reverse(byte[] array2) {
        Preconditions.checkNotNull(array2);
        Bytes.reverse(array2, 0, array2.length);
    }

    public static void reverse(byte[] array2, int fromIndex, int toIndex) {
        Preconditions.checkNotNull(array2);
        Preconditions.checkPositionIndexes(fromIndex, toIndex, array2.length);
        int i2 = fromIndex;
        for (int j = toIndex - 1; i2 < j; ++i2, --j) {
            byte tmp = array2[i2];
            array2[i2] = array2[j];
            array2[j] = tmp;
        }
    }

    @GwtCompatible
    private static class ByteArrayAsList
    extends AbstractList<Byte>
    implements RandomAccess,
    Serializable {
        final byte[] array;
        final int start;
        final int end;
        private static final long serialVersionUID = 0L;

        ByteArrayAsList(byte[] array2) {
            this(array2, 0, array2.length);
        }

        ByteArrayAsList(byte[] array2, int start, int end) {
            this.array = array2;
            this.start = start;
            this.end = end;
        }

        @Override
        public int size() {
            return this.end - this.start;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public Byte get(int index) {
            Preconditions.checkElementIndex(index, this.size());
            return this.array[this.start + index];
        }

        @Override
        public boolean contains(Object target2) {
            return target2 instanceof Byte && Bytes.indexOf(this.array, (Byte)target2, this.start, this.end) != -1;
        }

        @Override
        public int indexOf(Object target2) {
            int i2;
            if (target2 instanceof Byte && (i2 = Bytes.indexOf(this.array, (Byte)target2, this.start, this.end)) >= 0) {
                return i2 - this.start;
            }
            return -1;
        }

        @Override
        public int lastIndexOf(Object target2) {
            int i2;
            if (target2 instanceof Byte && (i2 = Bytes.lastIndexOf(this.array, (Byte)target2, this.start, this.end)) >= 0) {
                return i2 - this.start;
            }
            return -1;
        }

        @Override
        public Byte set(int index, Byte element) {
            Preconditions.checkElementIndex(index, this.size());
            byte oldValue = this.array[this.start + index];
            this.array[this.start + index] = Preconditions.checkNotNull(element);
            return oldValue;
        }

        @Override
        public List<Byte> subList(int fromIndex, int toIndex) {
            int size = this.size();
            Preconditions.checkPositionIndexes(fromIndex, toIndex, size);
            if (fromIndex == toIndex) {
                return Collections.emptyList();
            }
            return new ByteArrayAsList(this.array, this.start + fromIndex, this.start + toIndex);
        }

        @Override
        public boolean equals(@Nullable Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof ByteArrayAsList) {
                ByteArrayAsList that = (ByteArrayAsList)object;
                int size = this.size();
                if (that.size() != size) {
                    return false;
                }
                for (int i2 = 0; i2 < size; ++i2) {
                    if (this.array[this.start + i2] == that.array[that.start + i2]) continue;
                    return false;
                }
                return true;
            }
            return super.equals(object);
        }

        @Override
        public int hashCode() {
            int result2 = 1;
            for (int i2 = this.start; i2 < this.end; ++i2) {
                result2 = 31 * result2 + Bytes.hashCode(this.array[i2]);
            }
            return result2;
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder(this.size() * 5);
            builder.append('[').append(this.array[this.start]);
            for (int i2 = this.start + 1; i2 < this.end; ++i2) {
                builder.append(", ").append(this.array[i2]);
            }
            return builder.append(']').toString();
        }

        byte[] toByteArray() {
            return Arrays.copyOfRange(this.array, this.start, this.end);
        }
    }
}

