/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.google.common.collect;

import org.checkerframework.checker.nullness.qual.Nullable;
import org.jetbrains.kotlin.com.google.common.annotations.GwtIncompatible;
import org.jetbrains.kotlin.com.google.common.collect.Range;
import org.jetbrains.kotlin.com.google.common.collect.RangeSet;

@GwtIncompatible
abstract class AbstractRangeSet<C extends Comparable>
implements RangeSet<C> {
    AbstractRangeSet() {
    }

    @Override
    public boolean contains(C value) {
        return this.rangeContaining(value) != null;
    }

    @Override
    public abstract Range<C> rangeContaining(C var1);

    @Override
    public boolean isEmpty() {
        return this.asRanges().isEmpty();
    }

    @Override
    public void add(Range<C> range) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void remove(Range<C> range) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        this.remove(Range.all());
    }

    @Override
    public boolean enclosesAll(RangeSet<C> other) {
        return this.enclosesAll(other.asRanges());
    }

    @Override
    public void addAll(RangeSet<C> other) {
        this.addAll(other.asRanges());
    }

    @Override
    public void removeAll(RangeSet<C> other) {
        this.removeAll(other.asRanges());
    }

    @Override
    public boolean intersects(Range<C> otherRange) {
        return !this.subRangeSet(otherRange).isEmpty();
    }

    @Override
    public abstract boolean encloses(Range<C> var1);

    @Override
    public boolean equals(@Nullable Object obj2) {
        if (obj2 == this) {
            return true;
        }
        if (obj2 instanceof RangeSet) {
            RangeSet other = (RangeSet)obj2;
            return this.asRanges().equals(other.asRanges());
        }
        return false;
    }

    @Override
    public final int hashCode() {
        return this.asRanges().hashCode();
    }

    @Override
    public final String toString() {
        return this.asRanges().toString();
    }
}

