/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.internal;

import com.android.build.gradle.BaseExtension;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import kotlin.IntRange;
import kotlin.Sequence;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.api.UnknownDomainObjectException;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.gradle.api.tasks.compile.JavaCompile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.internal.AnnotationProcessingManager;
import org.jetbrains.kotlin.gradle.plugin.KaptExtension;
import org.jetbrains.kotlin.gradle.plugin.KotlinPluginWrapperKt;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"g\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001C\u0004\u0006\u0001\u0015\t\u0001\"E\u0003\u0002\u0019\u0005)\u0011\u0001b\u0001\u0006\u00031\tQ!\u0001C\u0002\u000b\u0005a\u0011!B\u0001\u0005\u0003\u0015\t\u0001\"A\u0003\u0002\t\u0015)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001\u0007\u0002\u000b\u0005!1!B\u0001\t\u0012\u0015\tA\u0011B\u0003\u0002\u0019\u0005)\u0011\u0001\u0002\u0002\u0006\u0003!\u0005R\u0001\u0001\u0007\u0001!uI\u0012\u0001'\u0001\u001e\u0002u\t{%C\u0002\t\u00035\t\u00014A\u0005\u0004\u0011\ti\u0011\u0001'\u0002\n\u0007!\u0019Q\"\u0001M\u0004\u0013\u0019AA!\u0004\u0003\n\u0005%\t\u0001$\u0002M\u0005\u0013\rAY!D\u0001\u0019\u000b%\u0019\u0001BB\u0007\u00021\u0015I1\u0001#\u0004\u000e\u0003a9\u0011\"\u0002\u0003\u0002\u0011\u001fi!\u0001$\u0001\u0019\u0002E\u001b\u0011\u0001\u0003\u0005&\u0019\u0011\t\u0001BC\u0007\u00021+I2\u0001\u0003\u0002\u000e\u0003a\u0015\u0011d\u0001\u0005\f\u001b\u0005AR!\n\u0007\u0005\u0003!]Q\"\u0001M\u000b3\rA!!D\u0001\u0019\u0006e\u0019\u0001\u0002D\u0007\u00021\u000f)3\u0001#\u0007\u000e\u0003aUQ\u0005\u0002\u0003\u0002\u00115i\u0011\u0001'\u0006&\t\u0011\t\u00012D\u0007\u00021+)3\u0003B\u0001\t\u001d5\t\u0001TC\r\u0004\u0011\ti\u0011\u0001'\u0002\u001a\r!uQ\u0002B\u0005\u0003\u0013\u0005A:\u0001'\u0003\u001a\u0007!YQ\"\u0001\r\u0006K\rAq\"D\u0001\u0019\u0016\u0015*A!\u0001E\u0010\u001b\ta\t\u0001\u0007\t&\u0007!\u0005R\"\u0001\r\u0006K\u0019!\u0011\u0001C\t\u000e\u0007%\tA1\u0001M\u0012K\rA!#D\u0001\u0019\u000b\u0015BA!\u0001E\u0013\u001b\u0005A:!G\u0002\t'5\t\u0001tAS\u0015\t\u0005A9#D\u0001\u0019\u0002e\u0019\u0001\u0002F\u0007\u00021\u000fI\u0012\u0002#\u000b\u000e\u000b%\u0019A\u0011A\u0005\u00021\u0003AR#E\u0001\u0019\u0002E\u001b\u0011\u0001c\u000b&\u001d\u0011\t\u0001BF\u0007\u0005\u0013\tI\u0011\u0001g\u0002\u0019\ne1\u0001RF\u0007\u0005\u0013\tI\u0011\u0001G\u0003\u0019\n\u0015bA!\u0001\u0005\u0018\u001b\u0005A*\"G\u0002\t\u00055\t\u0001TA\r\u0004\u0011_i\u0011\u0001g\u0002&\u0007!AR\"\u0001M\u000bKc!\u0011\t\u0005E\u0019\u001b\u0005A*\"F\u0001\u0019\u0006e%\u0001\"G\u0007\u00021\u000f\u00016\u0011AM\f\u0011gi\u0001\"C\u0002\n\u00051\u0005\u0001tA\u0005\u0003\u0013\u0005A:\u0001\u0007\u000eQ\u0007\u0005);\u0002B\u0001\t65\t\u0001TC\u000b\u00021\u000bIJ\u0001C\u000e\u000e\u0003a)\u0001k!\u0001&+\u0011\t\u0005\u0003c\u000e\u000e\u0003aUQ#\u0001M\u000337AA$\u0004\u0006\n\u000b%!\u0011BA\u0005\u00021\u000fAJ$\u0003\u0002\n\u0003aU\u0001D\u0007)\u0004\u0002%BA!\u0011\u0005\t\u00105\u0011A\u0012\u0001M\u0001#\u000e\tQ\u0001A\u0015\u000b\t\u0005C\u0001\u0002B\u0007\u0005\u0013\tI\u0011\u0001G\u0003\u0019\nE\u001b\u0011!\u0002\u0001*\u000f\u0011\t\u0005\u0002c\u0003\u000e\u0003a)\u0011kA\u0001\u0006\u0001%:A!\u0011\u0005\t\r5\t\u0001$B)\u0004\u0003\u0015\u0001\u0011f\u0002\u0003B\u0011!5Q\"\u0001\r\b#\u000e\tQ\u0001A\u0015\b\t\u0005C\u0001BA\u0007\u00021\u000b\t6!A\u0003\u0001S-!\u0011\t\u0003E\t\u001b\u0015\u0001\u001a\"\u0006\u0002\r\u0002aI\u0001$C)\u0004\u0003\u0015\u0001\u0011f\u0002\u0003B\u0011!\tQ\"\u0001M\u0002#\u000e\tQ\u0001A\u0015\b\t\u0005C\u0001bA\u0007\u00021\u000f\t6!A\u0003\u0001"}, strings={"Lorg/jetbrains/kotlin/gradle/internal/AnnotationProcessingManager;", "", "task", "Lorg/gradle/api/tasks/compile/AbstractCompile;", "javaTask", "Lorg/gradle/api/tasks/compile/JavaCompile;", "taskQualifier", "", "aptFiles", "", "Ljava/io/File;", "aptOutputDir", "aptWorkingDir", "coreClassLoader", "Ljava/lang/ClassLoader;", "androidVariant", "(Lorg/gradle/api/tasks/compile/AbstractCompile;Lorg/gradle/api/tasks/compile/JavaCompile;Ljava/lang/String;Ljava/util/Set;Ljava/io/File;Ljava/io/File;Ljava/lang/ClassLoader;Ljava/lang/Object;)V", "project", "Lorg/gradle/api/Project;", "kotlin.jvm.PlatformType", "addGeneratedSourcesOutputToCompilerArgs", "", "outputDir", "addWrappersToCompilerArgs", "wrapperFqNames", "afterJavaCompile", "appendAdditionalComplerArgs", "appendAnnotationsArguments", "generateAnnotationProcessorStubs", "processorFqNames", "generateJavaHackFile", "getAndroidExtension", "Lcom/android/build/gradle/BaseExtension;", "getAnnotationFile", "getCoreKaptPackageClass", "Ljava/lang/Class;", "getGeneratedKotlinSourceDir", "getProcessorStubClassName", "processorFqName", "invokeCoreKaptMethod", "methodName", "args", "", "(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/Object;", "lookupAnnotationProcessors", "files", "setProcessorPath", "path", "setupKapt", "addCompilerArgument", "name", "value", "Lkotlin/Function1;", "appendClasspath", "file", "modifyCompilerArguments", "modifier", "", "Companion"}, moduleName="kotlin-gradle-plugin")
public final class AnnotationProcessingManager {
    private final Project project;
    private final AbstractCompile task;
    private final JavaCompile javaTask;
    private final String taskQualifier;
    private final Set<File> aptFiles;
    private final File aptOutputDir;
    private final File aptWorkingDir;
    private final ClassLoader coreClassLoader;
    private final Object androidVariant;
    @NotNull
    public static final Regex JAVA_FQNAME_PATTERN;
    @NotNull
    public static final String WRAPPERS_DIRECTORY = "wrappers";
    @NotNull
    public static final String GEN_ANNOTATION = "__gen/annotation";
    private static final String ANDROID_APT_PLUGIN_ID = "com.neenbedankt.android-apt";
    public static final Companion Companion;

    @NotNull
    public final File getAnnotationFile() {
        if (!this.aptWorkingDir.exists()) {
            this.aptWorkingDir.mkdirs();
        }
        return new File(this.aptWorkingDir, Companion.getWRAPPERS_DIRECTORY() + "/annotations." + this.taskQualifier + ".txt");
    }

    @NotNull
    public final File getGeneratedKotlinSourceDir() {
        File kotlinGeneratedDir = new File(this.aptWorkingDir, "kotlinGenerated");
        if (!kotlinGeneratedDir.exists()) {
            kotlinGeneratedDir.mkdirs();
        }
        return kotlinGeneratedDir;
    }

    public final void setupKapt() {
        if (this.aptFiles.isEmpty()) {
            return;
        }
        if (this.project.getPlugins().findPlugin(AnnotationProcessingManager.Companion.getANDROID_APT_PLUGIN_ID()) != null) {
            this.project.getLogger().warn("Please do not use `" + AnnotationProcessingManager.Companion.getANDROID_APT_PLUGIN_ID() + "` with kapt.");
        }
        Set<String> annotationProcessorFqNames = this.lookupAnnotationProcessors(this.aptFiles);
        File stubOutputDir = new File(this.aptWorkingDir, Companion.getWRAPPERS_DIRECTORY());
        this.generateAnnotationProcessorStubs(this.javaTask, annotationProcessorFqNames, stubOutputDir);
        Set processorPath = SetsKt.plus((Set)SetsKt.setOf((Object)stubOutputDir), (Iterable)this.aptFiles);
        Iterable iterable = processorPath;
        CharSequence charSequence = File.pathSeparator;
        Intrinsics.checkExpressionValueIsNotNull((Object)charSequence, (String)"File.pathSeparator");
        this.setProcessorPath(this.javaTask, CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)charSequence, null, null, (int)0, null, null, (int)62));
        this.appendClasspath(this.javaTask, stubOutputDir);
        this.addGeneratedSourcesOutputToCompilerArgs(this.javaTask, this.aptOutputDir);
        this.appendAnnotationsArguments();
        this.appendAdditionalComplerArgs();
    }

    public final void afterJavaCompile() {
        File generatedFile = new File(this.javaTask.getDestinationDir(), Companion.getGEN_ANNOTATION() + "/Cl.class");
        if (generatedFile.exists()) {
            generatedFile.delete();
        } else {
            KotlinPluginWrapperKt.kotlinDebug(this.project.getLogger(), "kapt: Java file stub was not found at " + generatedFile);
        }
    }

    public final void generateJavaHackFile() {
        File javaHackClFile;
        File javaAptSourceDir = new File(this.aptWorkingDir, "java_src");
        File javaHackPackageDir = new File(javaAptSourceDir, Companion.getGEN_ANNOTATION());
        if (!javaHackPackageDir.exists()) {
            javaHackPackageDir.mkdirs();
        }
        if (!(javaHackClFile = new File(javaHackPackageDir, "Cl.java")).exists()) {
            FilesKt.writeText$default((File)javaHackClFile, (String)"package __gen.annotation; class Cl { @__gen.KotlinAptAnnotation boolean v; }", null, (int)2);
            KotlinPluginWrapperKt.kotlinDebug(this.project.getLogger(), "kapt: Java file stub generated: " + javaHackClFile);
        }
        if (!this.javaTask.getSource().contains(javaHackClFile)) {
            this.javaTask.source(new Object[]{javaAptSourceDir});
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void appendAnnotationsArguments() {
        void destination$iv$iv;
        void $receiver$iv$iv;
        void $receiver$iv;
        JavaCompile javaCompile = this.javaTask;
        AnnotationProcessingManager this_$iv = this;
        List list = $receiver$iv.getOptions().getCompilerArgs();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"this.options.compilerArgs");
        List compilerArgs$iv = list;
        Iterable iterable = compilerArgs$iv;
        Collection collection = CollectionsKt.arrayListOf((Object[])new String[0]);
        Iterator iterator = $receiver$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it$iv;
            Object item$iv$iv;
            Object t = item$iv$iv = iterator.next();
            void var9_9 = destination$iv$iv;
            String string = it$iv.toString();
            var9_9.add(string);
        }
        ArrayList newCompilerArgs$iv = (ArrayList)destination$iv$iv;
        List list2 = newCompilerArgs$iv;
        list2.add("-Akapt.annotations=" + this.getAnnotationFile());
        list2.add("-Akapt.kotlin.generated=" + this.getGeneratedKotlinSourceDir());
        $receiver$iv.getOptions().setCompilerArgs((List)newCompilerArgs$iv);
    }

    /*
     * WARNING - void declaration
     */
    private final void appendAdditionalComplerArgs() {
        void destination$iv$iv;
        void $receiver$iv$iv;
        void $receiver$iv;
        KaptExtension kaptExtension = (KaptExtension)this.project.getExtensions().getByType(KaptExtension.class);
        Project project = this.project;
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        List<String> args = kaptExtension.getAdditionalArguments(project, this.androidVariant, this.getAndroidExtension());
        if (args.isEmpty()) {
            return;
        }
        JavaCompile javaCompile = this.javaTask;
        AnnotationProcessingManager this_$iv = this;
        List list = $receiver$iv.getOptions().getCompilerArgs();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"this.options.compilerArgs");
        List compilerArgs$iv = list;
        Iterable iterable = compilerArgs$iv;
        Collection collection = CollectionsKt.arrayListOf((Object[])new String[0]);
        Iterator iterator = $receiver$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it$iv;
            Object item$iv$iv;
            Object t = item$iv$iv = iterator.next();
            void var11_11 = destination$iv$iv;
            String string = it$iv.toString();
            var11_11.add(string);
        }
        ArrayList newCompilerArgs$iv = (ArrayList)destination$iv$iv;
        List list2 = newCompilerArgs$iv;
        list2.addAll((Collection)args);
        $receiver$iv.getOptions().setCompilerArgs((List)newCompilerArgs$iv);
    }

    /*
     * WARNING - void declaration
     */
    private final void generateAnnotationProcessorStubs(JavaCompile javaTask, Set<String> processorFqNames, File outputDir) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        void $receiver$iv;
        File wrapperFile;
        Object object = this.invokeCoreKaptMethod("generateKotlinAptAnnotation", outputDir);
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.io.File");
        }
        File aptAnnotationFile = (File)object;
        KotlinPluginWrapperKt.kotlinDebug(this.project.getLogger(), "kapt: Stub annotation generated: " + aptAnnotationFile);
        File stubOutputPackageDir = new File(outputDir, "__gen");
        stubOutputPackageDir.mkdirs();
        for (String processorFqName : processorFqNames) {
            Object object2 = this.invokeCoreKaptMethod("generateAnnotationProcessorWrapper", processorFqName, "__gen", stubOutputPackageDir, this.getProcessorStubClassName(processorFqName), this.taskQualifier);
            if (object2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.io.File");
            }
            wrapperFile = (File)object2;
            KotlinPluginWrapperKt.kotlinDebug(this.project.getLogger(), "kapt: Wrapper for " + processorFqName + " generated: " + wrapperFile);
        }
        Iterable iterable = processorFqNames;
        wrapperFile = $receiver$iv;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void fqName;
            String string = (String)item$iv$iv;
            void var16_13 = destination$iv$iv;
            String string2 = "__gen." + this.getProcessorStubClassName((String)fqName);
            var16_13.add(string2);
        }
        String annotationProcessorWrapperFqNames = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)",", null, null, (int)0, null, null, (int)62);
        this.addWrappersToCompilerArgs(javaTask, annotationProcessorWrapperFqNames);
    }

    private final void appendClasspath(JavaCompile $receiver, File file) {
        JavaCompile javaCompile = $receiver;
        javaCompile.setClasspath(javaCompile.getClasspath().plus((FileCollection)this.project.files(new Object[]{file})));
    }

    /*
     * WARNING - void declaration
     */
    private final void addWrappersToCompilerArgs(JavaCompile javaTask, String wrapperFqNames) {
        int argIndex$iv;
        void name$iv;
        List args$iv;
        ArrayList newCompilerArgs$iv$iv;
        void $receiver$iv$iv;
        block6: {
            int n;
            int n2;
            void $receiver$iv$iv2;
            void destination$iv$iv$iv;
            void $receiver$iv$iv$iv;
            void this_$iv;
            void $receiver$iv;
            JavaCompile javaCompile = javaTask;
            AnnotationProcessingManager annotationProcessingManager = this;
            String string = "-processor";
            void var6_6 = $receiver$iv;
            void var7_7 = this_$iv;
            List list = $receiver$iv$iv.getOptions().getCompilerArgs();
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"this.options.compilerArgs");
            List compilerArgs$iv$iv = list;
            Iterable iterable = compilerArgs$iv$iv;
            Collection collection = CollectionsKt.arrayListOf((Object[])new String[0]);
            Iterator iterator = $receiver$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                void it$iv$iv;
                Object item$iv$iv$iv;
                Object t = item$iv$iv$iv = iterator.next();
                void var14_14 = destination$iv$iv$iv;
                String string2 = it$iv$iv.toString();
                var14_14.add(string2);
            }
            newCompilerArgs$iv$iv = (ArrayList)destination$iv$iv$iv;
            List list2 = args$iv = (List)newCompilerArgs$iv$iv;
            IntRange intRange = CollectionsKt.getIndices((Collection)((Collection)$receiver$iv$iv2));
            int n3 = intRange.getFirst();
            if (n3 <= (n2 = intRange.getLast())) {
                while (true) {
                    void index$iv$iv;
                    String it$iv;
                    if (Intrinsics.areEqual((Object)name$iv, (Object)(it$iv = (String)$receiver$iv$iv2.get((int)index$iv$iv)))) {
                        n = index$iv$iv;
                        break block6;
                    }
                    if (index$iv$iv == n2) break;
                    ++index$iv$iv;
                }
            }
            n = argIndex$iv = -1;
        }
        if (argIndex$iv >= 0 && args$iv.size() > argIndex$iv + 1) {
            void prevValue;
            String string = (String)args$iv.get(argIndex$iv + 1);
            int n = argIndex$iv + 1;
            List list = args$iv;
            String string3 = prevValue != null ? (String)prevValue + "," + wrapperFqNames : wrapperFqNames;
            list.set(n, string3);
        } else {
            args$iv.add(name$iv);
            String prevValue = null;
            List list = args$iv;
            String string = prevValue != null ? prevValue + "," + wrapperFqNames : wrapperFqNames;
            list.add(string);
        }
        $receiver$iv$iv.getOptions().setCompilerArgs((List)newCompilerArgs$iv$iv);
    }

    private final BaseExtension getAndroidExtension() {
        try {
            Object object = this.project.getExtensions().getByName("android");
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.android.build.gradle.BaseExtension");
            }
            return (BaseExtension)object;
        }
        catch (UnknownDomainObjectException e) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void addGeneratedSourcesOutputToCompilerArgs(JavaCompile javaTask, File outputDir) {
        int argIndex$iv;
        void name$iv;
        List args$iv;
        ArrayList newCompilerArgs$iv$iv;
        void $receiver$iv$iv;
        block8: {
            int n;
            int n2;
            void $receiver$iv$iv2;
            void destination$iv$iv$iv;
            void $receiver$iv$iv$iv;
            void this_$iv;
            void $receiver$iv;
            outputDir.mkdirs();
            JavaCompile javaCompile = javaTask;
            AnnotationProcessingManager annotationProcessingManager = this;
            String string = "-s";
            void var6_6 = $receiver$iv;
            void var7_7 = this_$iv;
            List list = $receiver$iv$iv.getOptions().getCompilerArgs();
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"this.options.compilerArgs");
            List compilerArgs$iv$iv = list;
            Iterable iterable = compilerArgs$iv$iv;
            Collection collection = CollectionsKt.arrayListOf((Object[])new String[0]);
            Iterator iterator = $receiver$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                void it$iv$iv;
                Object item$iv$iv$iv;
                Object t = item$iv$iv$iv = iterator.next();
                void var14_14 = destination$iv$iv$iv;
                String string2 = it$iv$iv.toString();
                var14_14.add(string2);
            }
            newCompilerArgs$iv$iv = (ArrayList)destination$iv$iv$iv;
            List list2 = args$iv = (List)newCompilerArgs$iv$iv;
            IntRange intRange = CollectionsKt.getIndices((Collection)((Collection)$receiver$iv$iv2));
            int n3 = intRange.getFirst();
            if (n3 <= (n2 = intRange.getLast())) {
                while (true) {
                    void index$iv$iv;
                    String it$iv;
                    if (Intrinsics.areEqual((Object)name$iv, (Object)(it$iv = (String)$receiver$iv$iv2.get((int)index$iv$iv)))) {
                        n = index$iv$iv;
                        break block8;
                    }
                    if (index$iv$iv == n2) break;
                    ++index$iv$iv;
                }
            }
            n = argIndex$iv = -1;
        }
        if (argIndex$iv >= 0 && args$iv.size() > argIndex$iv + 1) {
            void prevValue;
            String string = (String)args$iv.get(argIndex$iv + 1);
            int n = argIndex$iv + 1;
            List list = args$iv;
            if (prevValue != null) {
                javaTask.getLogger().warn("Destination for generated sources was modified by kapt. Previous value = " + (String)prevValue);
            }
            String string3 = outputDir.getAbsolutePath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"outputDir.getAbsolutePath()");
            String string4 = string3;
            list.set(n, string4);
        } else {
            args$iv.add(name$iv);
            String prevValue = null;
            List list = args$iv;
            if (prevValue != null) {
                javaTask.getLogger().warn("Destination for generated sources was modified by kapt. Previous value = " + prevValue);
            }
            String string = outputDir.getAbsolutePath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"outputDir.getAbsolutePath()");
            String string5 = string;
            list.add(string5);
        }
        $receiver$iv$iv.getOptions().setCompilerArgs((List)newCompilerArgs$iv$iv);
    }

    /*
     * WARNING - void declaration
     */
    private final void setProcessorPath(JavaCompile javaTask, String path) {
        int argIndex$iv;
        void name$iv;
        List args$iv;
        ArrayList newCompilerArgs$iv$iv;
        void $receiver$iv$iv;
        block8: {
            int n;
            int n2;
            void $receiver$iv$iv2;
            void destination$iv$iv$iv;
            void $receiver$iv$iv$iv;
            void this_$iv;
            void $receiver$iv;
            JavaCompile javaCompile = javaTask;
            AnnotationProcessingManager annotationProcessingManager = this;
            String string = "-processorpath";
            void var6_6 = $receiver$iv;
            void var7_7 = this_$iv;
            List list = $receiver$iv$iv.getOptions().getCompilerArgs();
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"this.options.compilerArgs");
            List compilerArgs$iv$iv = list;
            Iterable iterable = compilerArgs$iv$iv;
            Collection collection = CollectionsKt.arrayListOf((Object[])new String[0]);
            Iterator iterator = $receiver$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                void it$iv$iv;
                Object item$iv$iv$iv;
                Object t = item$iv$iv$iv = iterator.next();
                void var14_14 = destination$iv$iv$iv;
                String string2 = it$iv$iv.toString();
                var14_14.add(string2);
            }
            newCompilerArgs$iv$iv = (ArrayList)destination$iv$iv$iv;
            List list2 = args$iv = (List)newCompilerArgs$iv$iv;
            IntRange intRange = CollectionsKt.getIndices((Collection)((Collection)$receiver$iv$iv2));
            int n3 = intRange.getFirst();
            if (n3 <= (n2 = intRange.getLast())) {
                while (true) {
                    void index$iv$iv;
                    String it$iv;
                    if (Intrinsics.areEqual((Object)name$iv, (Object)(it$iv = (String)$receiver$iv$iv2.get((int)index$iv$iv)))) {
                        n = index$iv$iv;
                        break block8;
                    }
                    if (index$iv$iv == n2) break;
                    ++index$iv$iv;
                }
            }
            n = argIndex$iv = -1;
        }
        if (argIndex$iv >= 0 && args$iv.size() > argIndex$iv + 1) {
            void prevValue;
            String string = (String)args$iv.get(argIndex$iv + 1);
            int n = argIndex$iv + 1;
            List list = args$iv;
            if (prevValue != null) {
                javaTask.getLogger().warn("Processor path was modified by kapt. Previous value = " + (String)prevValue);
            }
            String string3 = path;
            list.set(n, string3);
        } else {
            args$iv.add(name$iv);
            String prevValue = null;
            List list = args$iv;
            if (prevValue != null) {
                javaTask.getLogger().warn("Processor path was modified by kapt. Previous value = " + prevValue);
            }
            String string = path;
            list.add(string);
        }
        $receiver$iv$iv.getOptions().setCompilerArgs((List)newCompilerArgs$iv$iv);
    }

    private final String getProcessorStubClassName(String processorFqName) {
        return "AnnotationProcessorWrapper_" + this.taskQualifier + "_" + StringsKt.replace$default((String)processorFqName, (char)'.', (char)'_', (boolean)false, (int)4);
    }

    /*
     * WARNING - void declaration
     */
    private final void addCompilerArgument(JavaCompile $receiver, String name, Function1<? super String, String> value) {
        int argIndex;
        List args;
        ArrayList newCompilerArgs$iv;
        void $receiver$iv;
        block6: {
            int n;
            int n2;
            void $receiver$iv2;
            void destination$iv$iv;
            void $receiver$iv$iv;
            JavaCompile javaCompile = $receiver;
            AnnotationProcessingManager annotationProcessingManager = this;
            List list = $receiver$iv.getOptions().getCompilerArgs();
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"this.options.compilerArgs");
            List compilerArgs$iv = list;
            Iterable iterable = compilerArgs$iv;
            Collection collection = CollectionsKt.arrayListOf((Object[])new String[0]);
            Iterator iterator = $receiver$iv$iv.iterator();
            while (iterator.hasNext()) {
                void it$iv;
                Object item$iv$iv;
                Object t = item$iv$iv = iterator.next();
                void var13_12 = destination$iv$iv;
                String string = it$iv.toString();
                var13_12.add(string);
            }
            newCompilerArgs$iv = (ArrayList)destination$iv$iv;
            List list2 = args = (List)newCompilerArgs$iv;
            IntRange intRange = CollectionsKt.getIndices((Collection)((Collection)$receiver$iv2));
            int n3 = intRange.getFirst();
            if (n3 <= (n2 = intRange.getLast())) {
                while (true) {
                    void index$iv;
                    String it;
                    if (Intrinsics.areEqual((Object)name, (Object)(it = (String)$receiver$iv2.get((int)index$iv)))) {
                        n = index$iv;
                        break block6;
                    }
                    if (index$iv == n2) break;
                    ++index$iv;
                }
            }
            n = argIndex = -1;
        }
        if (argIndex >= 0 && args.size() > argIndex + 1) {
            args.set(argIndex + 1, value.invoke(args.get(argIndex + 1)));
        } else {
            args.add(name);
            args.add(value.invoke(null));
        }
        $receiver$iv.getOptions().setCompilerArgs((List)newCompilerArgs$iv);
    }

    /*
     * WARNING - void declaration
     */
    private final void modifyCompilerArguments(JavaCompile $receiver, Function1<? super List<String>, Unit> modifier) {
        void destination$iv;
        void $receiver$iv;
        List list = $receiver.getOptions().getCompilerArgs();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"this.options.compilerArgs");
        List compilerArgs = list;
        Iterable iterable = compilerArgs;
        Collection collection = CollectionsKt.arrayListOf((Object[])new String[0]);
        Iterator iterator = $receiver$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            Object item$iv;
            Object t = item$iv = iterator.next();
            void var13_9 = destination$iv;
            String string = it.toString();
            var13_9.add(string);
        }
        ArrayList newCompilerArgs = (ArrayList)destination$iv;
        modifier.invoke((Object)newCompilerArgs);
        $receiver.getOptions().setCompilerArgs((List)newCompilerArgs);
    }

    private final Set<String> lookupAnnotationProcessors(Set<? extends File> files) {
        lookupAnnotationProcessors.1 withZipFile$ = lookupAnnotationProcessors.1.INSTANCE;
        HashSet annotationProcessors = SetsKt.hashSetOf((Object[])new String[0]);
        Function1<Sequence<? extends String>, Unit> processLines$ = new Function1<Sequence<? extends String>, Unit>(annotationProcessors){
            final /* synthetic */ HashSet $annotationProcessors;

            public final void invoke(@NotNull Sequence<String> lines) {
                Intrinsics.checkParameterIsNotNull(lines, (String)"lines");
                for (String line : lines) {
                    if (StringsKt.isBlank((CharSequence)line) || !AnnotationProcessingManager.Companion.getJAVA_FQNAME_PATTERN().matches((CharSequence)line)) continue;
                    this.$annotationProcessors.add(line);
                }
            }
            {
                this.$annotationProcessors = hashSet;
                super(1);
            }
        };
        for (File file : files) {
            withZipFile$.invoke(file, (Function1<? super ZipFile, Unit>)((Function1)new Function1<ZipFile, Unit>(processLines$){
                final /* synthetic */ lookupAnnotationProcessors.2 $processLines;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull ZipFile zipFile) {
                    Intrinsics.checkParameterIsNotNull((Object)zipFile, (String)"zipFile");
                    ZipEntry entry = zipFile.getEntry("META-INF/services/javax.annotation.processing.Processor");
                    if (entry != null) {
                        void $receiver$iv$iv;
                        Reader $receiver$iv = ByteStreamsKt.reader$default((InputStream)zipFile.getInputStream(entry), null, (int)1);
                        Closeable closeable = TextStreamsKt.buffered$default((Reader)$receiver$iv, (int)0, (int)1);
                        boolean closed$iv$iv = false;
                        try {
                            BufferedReader it$iv = (BufferedReader)$receiver$iv$iv;
                            Sequence lines = TextStreamsKt.lineSequence((BufferedReader)it$iv);
                            this.$processLines.invoke((Sequence<String>)lines);
                            it$iv = Unit.INSTANCE;
                        }
                        catch (Exception e$iv$iv) {
                            closed$iv$iv = true;
                            try {
                                $receiver$iv$iv.close();
                            }
                            catch (Exception closeException$iv$iv) {
                                // empty catch block
                            }
                            throw (Throwable)e$iv$iv;
                        }
                        finally {
                            if (!closed$iv$iv) {
                                $receiver$iv$iv.close();
                            }
                        }
                    }
                }
                {
                    this.$processLines = var1_1;
                    super(1);
                }
            }));
        }
        KotlinPluginWrapperKt.kotlinDebug(this.project.getLogger(), "kapt: Discovered annotation processors: " + CollectionsKt.joinToString$default((Iterable)annotationProcessors, null, null, null, (int)0, null, null, (int)63));
        return annotationProcessors;
    }

    /*
     * WARNING - void declaration
     */
    private final Object invokeCoreKaptMethod(String methodName, Object ... args) {
        void $receiver$iv;
        Class[] array = new Class[args.length];
        Object[] objectArray = args;
        int index$iv = 0;
        for (int i = 0; i < ((void)$receiver$iv).length; ++i) {
            void arg;
            void item$iv = $receiver$iv[i];
            int n = index$iv++;
            void var8_8 = item$iv;
            int i2 = n;
            array[i2] = arg.getClass();
        }
        Method method = this.getCoreKaptPackageClass().getMethod(methodName, Arrays.copyOf(array, array.length));
        Object object = method.invoke(null, Arrays.copyOf(args, args.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"method.invoke(null, *args)");
        return object;
    }

    private final Class<?> getCoreKaptPackageClass() {
        Class<?> clazz = Class.forName("org.jetbrains.kotlin.gradle.tasks.kapt.KaptStubGeneratorUtilsKt", false, this.coreClassLoader);
        Intrinsics.checkExpressionValueIsNotNull(clazz, (String)"Class.forName(\"org.jetbr\u2026, false, coreClassLoader)");
        return clazz;
    }

    public AnnotationProcessingManager(@NotNull AbstractCompile task, @NotNull JavaCompile javaTask, @NotNull String taskQualifier, @NotNull Set<? extends File> aptFiles, @NotNull File aptOutputDir, @NotNull File aptWorkingDir, @NotNull ClassLoader coreClassLoader, @Nullable Object androidVariant) {
        Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
        Intrinsics.checkParameterIsNotNull((Object)javaTask, (String)"javaTask");
        Intrinsics.checkParameterIsNotNull((Object)taskQualifier, (String)"taskQualifier");
        Intrinsics.checkParameterIsNotNull(aptFiles, (String)"aptFiles");
        Intrinsics.checkParameterIsNotNull((Object)aptOutputDir, (String)"aptOutputDir");
        Intrinsics.checkParameterIsNotNull((Object)aptWorkingDir, (String)"aptWorkingDir");
        Intrinsics.checkParameterIsNotNull((Object)coreClassLoader, (String)"coreClassLoader");
        this.task = task;
        this.javaTask = javaTask;
        this.taskQualifier = taskQualifier;
        this.aptFiles = aptFiles;
        this.aptOutputDir = aptOutputDir;
        this.aptWorkingDir = aptWorkingDir;
        this.coreClassLoader = coreClassLoader;
        this.androidVariant = androidVariant;
        this.project = this.task.getProject();
    }

    public /* synthetic */ AnnotationProcessingManager(AbstractCompile abstractCompile, JavaCompile javaCompile, String string, Set set, File file, File file2, ClassLoader classLoader, Object object, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x80) != 0) {
            object = null;
        }
        this(abstractCompile, javaCompile, string, set, file, file2, classLoader, object);
    }

    static {
        Companion = org.jetbrains.kotlin.gradle.internal.AnnotationProcessingManager$Companion.INSTANCE;
        JAVA_FQNAME_PATTERN = StringsKt.toRegex((String)"^([\\p{L}_$][\\p{L}\\p{N}_$]*\\.)*[\\p{L}_$][\\p{L}\\p{N}_$]*$");
        WRAPPERS_DIRECTORY = WRAPPERS_DIRECTORY;
        GEN_ANNOTATION = GEN_ANNOTATION;
        ANDROID_APT_PLUGIN_ID = ANDROID_APT_PLUGIN_ID;
    }

    public static final /* synthetic */ void access$modifyCompilerArguments(AnnotationProcessingManager $this, JavaCompile $receiver, @NotNull Function1 modifier) {
        $this.modifyCompilerArguments($receiver, (Function1<? super List<String>, Unit>)modifier);
    }

    @KotlinClass(version={1, 0, 1}, abiVersion=32, data={"\u001d\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u0003!9Q!\u0001C\u0003\u000b\u0005a\u0011!B\u0001\u0005\u0005\u0011\t\u001d\u0001\u0004\u0001\u001a\u0003a\u0005\u0011u\u0001\u0003\u0002#\u000e\t\u0001\"AU\f\t\u0005C\u0015\u0001c\u0001\u000e\u0003a\u0011\u0011kA\u0003\u0006\u00031\u0005QB\u0001C\u0003\u0011\rI;\u0002B\"I\u0003!\u001dQ\"\u0001\r\u0003#\u000e)Q!\u0001G\u0001\u001b\t!A\u0001C\u0002*\u0017\u0011\u0019\u0005\u0002#\u0003\u000e\u0003a)\u0011kA\u0003\u0006\u00031\u0005QB\u0001C\u0006\u0011\u0019I;\u0002B\"I\u0003!5Q\"\u0001\r\u0003#\u000e)Q!\u0001G\u0001\u001b\t!q\u0001C\u0002"}, strings={"Lorg/jetbrains/kotlin/gradle/internal/AnnotationProcessingManager$Companion;", "", "()V", "ANDROID_APT_PLUGIN_ID", "", "getANDROID_APT_PLUGIN_ID", "()Ljava/lang/String;", "GEN_ANNOTATION", "getGEN_ANNOTATION", "JAVA_FQNAME_PATTERN", "Lkotlin/text/Regex;", "getJAVA_FQNAME_PATTERN", "()Lkotlin/text/Regex;", "WRAPPERS_DIRECTORY", "getWRAPPERS_DIRECTORY"}, moduleName="kotlin-gradle-plugin")
    private static final class Companion {
        public static final Companion INSTANCE;

        @NotNull
        public final Regex getJAVA_FQNAME_PATTERN() {
            return JAVA_FQNAME_PATTERN;
        }

        @NotNull
        public final String getWRAPPERS_DIRECTORY() {
            return WRAPPERS_DIRECTORY;
        }

        @NotNull
        public final String getGEN_ANNOTATION() {
            return GEN_ANNOTATION;
        }

        private final String getANDROID_APT_PLUGIN_ID() {
            return ANDROID_APT_PLUGIN_ID;
        }

        private Companion() {
            INSTANCE = this;
        }

        static {
            new Companion();
        }
    }
}

