/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin;

import java.io.File;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.reflect.KProperty;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.internal.HasConvention;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.plugins.JavaBasePlugin;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.gradle.api.tasks.util.PatternFilterable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.internal.KotlinSourceSet;
import org.jetbrains.kotlin.gradle.internal.KotlinSourceSetImpl;
import org.jetbrains.kotlin.gradle.plugin.KotlinPluginWrapperKt;
import org.jetbrains.kotlin.gradle.plugin.KotlinSourceSetProcessor$kotlinDirSet$1;
import org.jetbrains.kotlin.gradle.plugin.KotlinSourceSetProcessor$kotlinSourceSet$1;
import org.jetbrains.kotlin.gradle.plugin.KotlinSourceSetProcessor$kotlinTask$1;
import org.jetbrains.kotlin.gradle.plugin.KotlinSourceSetProcessor$kotlinTaskName$1;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"S\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!B\u0001\t\u0001\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0001\u000b\u0005Aq!B\u0001\u0005\u0004\u0015\tA\"A\u0003\u0002\t\u0015)\u0011\u0001D\u0001\u0006\u0003\u0011\u0015Q!\u0001\u0007\u0002\u000b\u0005!Y!B\u0001\r\u0003\u0015\tAaB\u0003\u0002\u0011\u0005)\u0011\u0001\u0002\u0003\u0005'1\u0001Q\u0003\u0002\u0003\u0001\u0011\u0003)\u0012\u0001G\u0001\u001a\u0003a\r\u00115I\u0005\u0004\u0011\ti\u0011\u0001'\u0002\n\u0007!\u0019Q\"\u0001M\u0004\u0013\rAA!D\u0001\u0019\n%\u0019\u0001\"B\u0007\u00021\u0017I1\u0001\u0003\u0004\u000e\u0003a-\u0011b\u0001E\u0007\u001b\u0005AZ!\u0003\u0004\t\u000f5!\u0011BA\u0005\u00029\u0001Az!U\u0002\u0002\u0011!)C\u0001\u0002\u0006\t;5\t\u00014H\u0013\u0005\t)Aa$D\u0001\u0019<\u0015^AA\u0003E\u001f\u001b\u0005a\u0002!\u0007\u0003\u0005\u0003!yR\"\u0001M\u0006#\u000e\t\u0001rH\u0013\u0006\t)A\u0001%\u0004\u0002\r\u0002aiQ%\u0002\u0003\u000b\u0011\u0003j!\u0001$\u0001\u0019!\u0015\"AA\u0005\u0005\"\u001b\u0005AZ$J\u0002\tD5\t\u00014H\u0015\u000b\t\tC\u0001\u0012C\u0007\u00021\u0017\t6\u0001B\u0003\u0001\u001b\t!\u0011\u0002c\u0005*\u0015\u0011\u0019\u0005\u0002\u0003\u0004\u000e\u0003a-\u0011k\u0001\u0003\u0006\u00015\u0011AA\u0003E\nS5!1\t\u0003\u0005\b\u001b\u0011I!!C\u0001\u001d\u0001a=\u0011k\u0001\u0003\u0006\u00015\u0011AQ\u0003\u0005\fS)!1\t\u0003\u0005\u0004\u001b\u0005A:!U\u0002\u0005\u000b\u0001i!\u0001b\u0006\t\u0019%rAA\u0011\u0005\t\u001a5\u0011A\u0012\u0001\r\u000e9\t\n6AB\u0003\u0003\t;Aq\"\u0004\u0002\u0005\u001c!q\u0011F\u0004\u0003C\u0011!}QB\u0001G\u00011Aa\"%U\u0002\u0007\u000b\t!\u0019\u0003C\b\u000e\u0005\u0011\u0005\u0002\"E\u0015\u000e\t\tC\u0001BE\u0007\u00029\u0001a\"%U\u0002\u0007\u000b\t!9\u0003C\b\u000e\u0005\u0011\u0015\u0002bE\u0015\u000e\t\tC\u0001\u0002F\u0007\u00021\u0017a\"%U\u0002\u0007\u000b\t!Q\u0003C\b\u000e\u0005\u0011%\u00022C\u0015\u000f\t\rC\u00012F\u0007\u0006![)\"\u0001$\u0001\u0019-a1\u0012k\u0001\u0003\u0006\u00015\u0011Aa\u0006E\u0018S)!1\t\u0003\u0005\u0006\u001b\u0005AZ!U\u0002\u0005\u000b\u0001i!\u0001\u0002\r\t\u0014%RAa\u0011\u0005\t\u00055\t\u0001TA)\u0004\t\u0015\u0001QB\u0001C\u0019\u0011eI#\u0002\u0002\"\t\u0011gi\u0011\u0001g\u0003R\u0007\u0011)\u0001!\u0004\u0002\u00055!M\u0011F\u0003\u0003D\u0011!!Q\"\u0001M\u0005#\u000e!Q\u0001A\u0007\u0003\tkA1$\u000b\u0006\u0005\u0005\"A9$D\u0001\u0019\fE\u001bA!\u0002\u0001\u000e\u0005\u0011a\u00022C\u0015\u000b\t\rC\u0001RB\u0007\u00021\u0017\t6\u0001B\u0003\u0001\u001b\t!I\u0004c\u0005"}, strings={"Lorg/jetbrains/kotlin/gradle/plugin/KotlinSourceSetProcessor;", "T", "Lorg/gradle/api/tasks/compile/AbstractCompile;", "", "project", "Lorg/gradle/api/internal/project/ProjectInternal;", "javaBasePlugin", "Lorg/gradle/api/plugins/JavaBasePlugin;", "sourceSet", "Lorg/gradle/api/tasks/SourceSet;", "pluginName", "", "compileTaskNameSuffix", "taskDescription", "compilerClass", "Ljava/lang/Class;", "(Lorg/gradle/api/internal/project/ProjectInternal;Lorg/gradle/api/plugins/JavaBasePlugin;Lorg/gradle/api/tasks/SourceSet;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Class;)V", "absoluteSourceRootDir", "getAbsoluteSourceRootDir", "()Ljava/lang/String;", "getCompileTaskNameSuffix", "getCompilerClass", "()Ljava/lang/Class;", "getJavaBasePlugin", "()Lorg/gradle/api/plugins/JavaBasePlugin;", "kotlinDirSet", "Lorg/gradle/api/file/SourceDirectorySet;", "getKotlinDirSet", "()Lorg/gradle/api/file/SourceDirectorySet;", "kotlinDirSet$delegate", "Lkotlin/Lazy;", "kotlinSourceSet", "Lorg/jetbrains/kotlin/gradle/internal/KotlinSourceSet;", "getKotlinSourceSet", "()Lorg/jetbrains/kotlin/gradle/internal/KotlinSourceSet;", "kotlinSourceSet$delegate", "kotlinTask", "getKotlinTask", "()Lorg/gradle/api/tasks/compile/AbstractCompile;", "kotlinTask$delegate", "kotlinTaskName", "getKotlinTaskName", "kotlinTaskName$delegate", "logger", "Lorg/gradle/api/logging/Logger;", "kotlin.jvm.PlatformType", "getLogger", "()Lorg/gradle/api/logging/Logger;", "getPluginName", "getProject", "()Lorg/gradle/api/internal/project/ProjectInternal;", "sourceRootDir", "getSourceRootDir", "getSourceSet", "()Lorg/gradle/api/tasks/SourceSet;", "sourceSetName", "getSourceSetName", "getTaskDescription", "addSourcesToKotlinDirSet", "", "commonTaskConfiguration", "createKotlinCompileTask", "suffix", "(Ljava/lang/String;)Lorg/gradle/api/tasks/compile/AbstractCompile;", "createKotlinDirSet", "createKotlinSourceSet", "doTargetSpecificProcessing", "run"}, moduleName="kotlin-gradle-plugin")
public abstract class KotlinSourceSetProcessor<T extends AbstractCompile> {
    private final Logger logger;
    @NotNull
    private final String sourceSetName;
    @NotNull
    private final String sourceRootDir;
    @NotNull
    private final String absoluteSourceRootDir;
    @Nullable
    private final Lazy<? extends KotlinSourceSet> kotlinSourceSet$delegate;
    @Nullable
    private final Lazy<? extends SourceDirectorySet> kotlinDirSet$delegate;
    @NotNull
    private final Lazy<? extends T> kotlinTask$delegate;
    @NotNull
    private final Lazy<? extends String> kotlinTaskName$delegate;
    @NotNull
    private final ProjectInternal project;
    @NotNull
    private final JavaBasePlugin javaBasePlugin;
    @NotNull
    private final SourceSet sourceSet;
    @NotNull
    private final String pluginName;
    @NotNull
    private final String compileTaskNameSuffix;
    @NotNull
    private final String taskDescription;
    @NotNull
    private final Class<T> compilerClass;
    private static final /* synthetic */ KProperty[] $$delegatedProperties;

    protected abstract void doTargetSpecificProcessing();

    public final Logger getLogger() {
        return this.logger;
    }

    @NotNull
    protected final String getSourceSetName() {
        return this.sourceSetName;
    }

    @NotNull
    protected final String getSourceRootDir() {
        return this.sourceRootDir;
    }

    @NotNull
    protected final String getAbsoluteSourceRootDir() {
        return this.absoluteSourceRootDir;
    }

    @Nullable
    protected final KotlinSourceSet getKotlinSourceSet() {
        return (KotlinSourceSet)LazyKt.getValue(this.kotlinSourceSet$delegate, (Object)this, (KProperty)$$delegatedProperties[0]);
    }

    @Nullable
    protected final SourceDirectorySet getKotlinDirSet() {
        return (SourceDirectorySet)LazyKt.getValue(this.kotlinDirSet$delegate, (Object)this, (KProperty)$$delegatedProperties[1]);
    }

    @NotNull
    protected final T getKotlinTask() {
        return (T)((AbstractCompile)LazyKt.getValue(this.kotlinTask$delegate, (Object)this, (KProperty)$$delegatedProperties[2]));
    }

    @NotNull
    protected final String getKotlinTaskName() {
        return (String)LazyKt.getValue(this.kotlinTaskName$delegate, (Object)this, (KProperty)$$delegatedProperties[3]);
    }

    public final void run() {
        if (this.getKotlinSourceSet() == null || this.getKotlinDirSet() == null) {
            return;
        }
        this.addSourcesToKotlinDirSet();
        this.commonTaskConfiguration();
        this.doTargetSpecificProcessing();
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    protected KotlinSourceSet createKotlinSourceSet() {
        KotlinSourceSetImpl kotlinSourceSetImpl;
        if (this.sourceSet instanceof HasConvention) {
            void var1_1;
            KotlinPluginWrapperKt.kotlinDebug(this.logger, "Creating KotlinSourceSet for source set " + this.sourceSet);
            KotlinSourceSetImpl kotlinSourceSet2 = new KotlinSourceSetImpl(this.sourceSet.getName(), this.project.getFileResolver());
            ((HasConvention)this.sourceSet).getConvention().getPlugins().put(this.pluginName, kotlinSourceSet2);
            kotlinSourceSetImpl = var1_1;
        } else {
            kotlinSourceSetImpl = null;
        }
        return kotlinSourceSetImpl;
    }

    @Nullable
    protected SourceDirectorySet createKotlinDirSet() {
        SourceDirectorySet kotlinDirSet2;
        File srcDir = this.project.file((Object)this.sourceRootDir);
        KotlinPluginWrapperKt.kotlinDebug(this.logger, "Creating Kotlin SourceDirectorySet for source set " + this.getKotlinSourceSet() + " with src dir " + srcDir);
        KotlinSourceSet kotlinSourceSet2 = this.getKotlinSourceSet();
        SourceDirectorySet sourceDirectorySet = kotlinDirSet2 = kotlinSourceSet2 != null ? kotlinSourceSet2.getKotlin() : null;
        Object object = sourceDirectorySet != null ? sourceDirectorySet.srcDir((Object)srcDir) : null;
        return kotlinDirSet2;
    }

    protected void addSourcesToKotlinDirSet() {
        KotlinPluginWrapperKt.kotlinDebug(this.logger, "Adding Kotlin SourceDirectorySet " + this.getKotlinDirSet() + " to source set " + this.sourceSet);
        SourceDirectorySet sourceDirectorySet = this.sourceSet.getAllJava();
        SourceDirectorySet sourceDirectorySet2 = sourceDirectorySet != null ? sourceDirectorySet.source(this.getKotlinDirSet()) : null;
        SourceDirectorySet sourceDirectorySet3 = this.sourceSet.getAllSource();
        SourceDirectorySet sourceDirectorySet4 = sourceDirectorySet3 != null ? sourceDirectorySet3.source(this.getKotlinDirSet()) : null;
        SourceDirectorySet sourceDirectorySet5 = this.sourceSet.getResources();
        PatternFilterable patternFilterable = sourceDirectorySet5 != null && (sourceDirectorySet5 = sourceDirectorySet5.getFilter()) != null ? sourceDirectorySet5.exclude((Spec)new Spec<FileTreeElement>(this){
            final /* synthetic */ KotlinSourceSetProcessor this$0;

            public final boolean isSatisfiedBy(FileTreeElement it) {
                SourceDirectorySet sourceDirectorySet = this.this$0.getKotlinDirSet();
                if (sourceDirectorySet == null) {
                    Intrinsics.throwNpe();
                }
                return sourceDirectorySet.contains(it.getFile());
            }
            {
                this.this$0 = kotlinSourceSetProcessor;
            }
        }) : null;
    }

    @NotNull
    protected T createKotlinCompileTask(@NotNull String suffix) {
        Intrinsics.checkParameterIsNotNull((Object)suffix, (String)"suffix");
        String name = this.sourceSet.getCompileTaskName(this.compileTaskNameSuffix) + suffix;
        KotlinPluginWrapperKt.kotlinDebug(this.logger, "Creating kotlin compile task " + name + " with class " + this.compilerClass);
        AbstractCompile compile = (AbstractCompile)this.project.getTasks().create(name, this.compilerClass);
        compile.getExtensions().getExtraProperties().set("defaultModuleName", (Object)(this.project.getName() + "-" + name));
        AbstractCompile abstractCompile = compile;
        Intrinsics.checkExpressionValueIsNotNull((Object)abstractCompile, (String)"compile");
        return (T)abstractCompile;
    }

    @NotNull
    protected static /* bridge */ /* synthetic */ AbstractCompile createKotlinCompileTask$default(KotlinSourceSetProcessor kotlinSourceSetProcessor, String string, int n) {
        if ((n & 1) != 0) {
            string = "";
        }
        return kotlinSourceSetProcessor.createKotlinCompileTask(string);
    }

    protected void commonTaskConfiguration() {
        this.javaBasePlugin.configureForSourceSet(this.sourceSet, this.getKotlinTask());
        this.getKotlinTask().setDescription(this.taskDescription);
        this.getKotlinTask().source(new Object[]{this.getKotlinDirSet()});
    }

    @NotNull
    public final ProjectInternal getProject() {
        return this.project;
    }

    @NotNull
    public final JavaBasePlugin getJavaBasePlugin() {
        return this.javaBasePlugin;
    }

    @NotNull
    public final SourceSet getSourceSet() {
        return this.sourceSet;
    }

    @NotNull
    public final String getPluginName() {
        return this.pluginName;
    }

    @NotNull
    public final String getCompileTaskNameSuffix() {
        return this.compileTaskNameSuffix;
    }

    @NotNull
    public final String getTaskDescription() {
        return this.taskDescription;
    }

    @NotNull
    public final Class<T> getCompilerClass() {
        return this.compilerClass;
    }

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)KotlinSourceSetProcessor$kotlinSourceSet$1.INSTANCE, (KProperty)KotlinSourceSetProcessor$kotlinDirSet$1.INSTANCE, (KProperty)KotlinSourceSetProcessor$kotlinTask$1.INSTANCE, (KProperty)KotlinSourceSetProcessor$kotlinTaskName$1.INSTANCE};
    }

    public KotlinSourceSetProcessor(@NotNull ProjectInternal project, @NotNull JavaBasePlugin javaBasePlugin, @NotNull SourceSet sourceSet, @NotNull String pluginName, @NotNull String compileTaskNameSuffix, @NotNull String taskDescription, @NotNull Class<T> compilerClass) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)javaBasePlugin, (String)"javaBasePlugin");
        Intrinsics.checkParameterIsNotNull((Object)sourceSet, (String)"sourceSet");
        Intrinsics.checkParameterIsNotNull((Object)pluginName, (String)"pluginName");
        Intrinsics.checkParameterIsNotNull((Object)compileTaskNameSuffix, (String)"compileTaskNameSuffix");
        Intrinsics.checkParameterIsNotNull((Object)taskDescription, (String)"taskDescription");
        Intrinsics.checkParameterIsNotNull(compilerClass, (String)"compilerClass");
        this.project = project;
        this.javaBasePlugin = javaBasePlugin;
        this.sourceSet = sourceSet;
        this.pluginName = pluginName;
        this.compileTaskNameSuffix = compileTaskNameSuffix;
        this.taskDescription = taskDescription;
        this.compilerClass = compilerClass;
        this.logger = Logging.getLogger(this.getClass());
        String string = this.sourceSet.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sourceSet.getName()");
        this.sourceSetName = string;
        this.sourceRootDir = "src/" + this.sourceSetName + "/kotlin";
        this.absoluteSourceRootDir = this.project.getProjectDir().getPath() + "/" + this.sourceRootDir;
        this.kotlinSourceSet$delegate = LazyKt.lazy((Function0)((Function0)new Function0<KotlinSourceSet>(this){
            final /* synthetic */ KotlinSourceSetProcessor this$0;

            @Nullable
            public final KotlinSourceSet invoke() {
                return this.this$0.createKotlinSourceSet();
            }
            {
                this.this$0 = kotlinSourceSetProcessor;
                super(0);
            }
        }));
        this.kotlinDirSet$delegate = LazyKt.lazy((Function0)((Function0)new Function0<SourceDirectorySet>(this){
            final /* synthetic */ KotlinSourceSetProcessor this$0;

            @Nullable
            public final SourceDirectorySet invoke() {
                return this.this$0.createKotlinDirSet();
            }
            {
                this.this$0 = kotlinSourceSetProcessor;
                super(0);
            }
        }));
        this.kotlinTask$delegate = LazyKt.lazy((Function0)new Function0<T>(this){
            final /* synthetic */ KotlinSourceSetProcessor this$0;

            @NotNull
            public final T invoke() {
                return (T)KotlinSourceSetProcessor.createKotlinCompileTask$default(this.this$0, null, 1);
            }
            {
                this.this$0 = kotlinSourceSetProcessor;
                super(0);
            }
        });
        this.kotlinTaskName$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ KotlinSourceSetProcessor this$0;

            public final String invoke() {
                return this.this$0.getKotlinTask().getName();
            }
            {
                this.this$0 = kotlinSourceSetProcessor;
                super(0);
            }
        }));
    }
}

