/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin;

import kotlin.StringsKt;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.gradle.BuildAdapter;
import org.gradle.BuildResult;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.plugin.CompilerServicesCleanup;
import org.jetbrains.kotlin.gradle.plugin.FinishBuildListenerKt;
import org.jetbrains.kotlin.gradle.plugin.KotlinPluginWrapperKt;
import org.jetbrains.kotlin.gradle.plugin.ThreadTracker;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"7\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001E\u0005\u000b\u0005!\u0011!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!1!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0005\u0002\u000b\u0001)\u0011\u0001D\u0001\r\u0001e\t\u0001\u0014AQ\u000b\u0013\rA\u0011!D\u0001\u0019\u0004%\u0019\u0001BA\u0007\u00021\u000b\t6!\u0001\u0005\u0004K%!1\u0002C\u0005\u000e\u0003aM\u0011\u0004\u0002\u0005\u000b\u001b\ta\t\u0001'\u0006*\u000f\u0011\t\u0005\u0002c\u0002\u000e\u0003a!\u0011kA\u0001\u0006\u0001%rAa\u0011\u0005\t\n5)\u00013B\u000b\u0003\u0019\u0003AR\u0001G\u0003R\u0007\u0011)\u0001!\u0004\u0002\u0005\r!5\u0011F\u0003\u0003D\u0011!\u0011Q\"\u0001M\u0003#\u000e!Q\u0001A\u0007\u0003\t\u001dAy!\u000b\u0005\u0005\u0003rA\u0001\"\u0004\u0002\r\u0002aE\u0011kA\u0001\u0006\u0001\u0001"}, strings={"Lorg/jetbrains/kotlin/gradle/plugin/FinishBuildListener;", "Lorg/gradle/BuildAdapter;", "pluginClassLoader", "Ljava/lang/ClassLoader;", "startMemory", "", "(Ljava/lang/ClassLoader;J)V", "cleanup", "Lorg/jetbrains/kotlin/gradle/plugin/CompilerServicesCleanup;", "log", "Lorg/gradle/api/logging/Logger;", "kotlin.jvm.PlatformType", "getLog", "()Lorg/gradle/api/logging/Logger;", "getStartMemory", "()J", "threadTracker", "Lorg/jetbrains/kotlin/gradle/plugin/ThreadTracker;", "buildFinished", "", "result", "Lorg/gradle/BuildResult;"}, moduleName="kotlin-gradle-plugin")
public final class FinishBuildListener
extends BuildAdapter {
    private final Logger log;
    private ThreadTracker threadTracker;
    private final CompilerServicesCleanup cleanup;
    private final long startMemory;

    public final Logger getLog() {
        return this.log;
    }

    public void buildFinished(@Nullable BuildResult result) {
        Gradle gradle;
        KotlinPluginWrapperKt.kotlinDebug(this.log, "Build finished listener");
        BuildResult buildResult = result;
        Object object = gradle = buildResult != null ? buildResult.getGradle() : null;
        if (gradle != null) {
            Unit unit;
            String string = gradle.getGradleVersion();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"gradle.gradleVersion");
            this.cleanup.invoke(string);
            ThreadTracker threadTracker = this.threadTracker;
            if (threadTracker != null) {
                threadTracker.checkThreadLeak(gradle);
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            this.threadTracker = null;
            gradle.removeListener((Object)this);
        }
        long $receiver = FinishBuildListenerKt.getUsedMemoryKb();
        long it = $receiver;
        KotlinPluginWrapperKt.kotlinDebug(this.getLog(), "[PERF] Used memory after build: " + it + " kb (" + StringsKt.format((String)"%+d", (Object[])new Object[]{it - this.getStartMemory()}) + " kb)");
    }

    public final long getStartMemory() {
        return this.startMemory;
    }

    public FinishBuildListener(@NotNull ClassLoader pluginClassLoader, long startMemory) {
        Intrinsics.checkParameterIsNotNull((Object)pluginClassLoader, (String)"pluginClassLoader");
        this.startMemory = startMemory;
        this.log = Logging.getLogger(((Object)((Object)this)).getClass());
        this.threadTracker = new ThreadTracker();
        this.cleanup = new CompilerServicesCleanup(pluginClassLoader);
    }
}

