/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.CollectionsKt;
import kotlin.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.SourceTask;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.internal.AnnotationProcessingManager;
import org.jetbrains.kotlin.gradle.plugin.KaptExtension;
import org.jetbrains.kotlin.gradle.plugin.KotlinPluginKt;
import org.jetbrains.kotlin.gradle.plugin.KotlinPluginWrapperKt;
import org.jetbrains.kotlin.gradle.plugin.SubpluginEnvironment;

@KotlinFileFacade(version={1, 0, 0}, abiVersion=32, data={"-\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005a\u0011!B\u0001\u0005\u0003\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!B\u0001\t\u000f\u0015\tAAA\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u00031\tQB\b\u0003\u0002\u0011\u0001i\u0011\u0001'\u0001\u0016\u0003a\t\u0011\u0014\u0002E\u0002\u001b\u0005A\n\u0001UB\u00013\u0013A!!D\u0001\u0019\u0006A\u001b\u0011!'\u0006\t\u000759\u0011BA\u0005\u00021\u0011I!!C\u0001\u0019\u0002a\u001d\u0001ka\u0001U\u0007\u0013iA\u0007C\u0003\u000e\u00051\u0005\u0001\u0014A\u000b\u00021\u0005IJ\u0001c\u0003\u000e\u0003a\u0005\u0001k!\u0001\u001a\n!\rQ\"\u0001M\u0001!\u000e\t\u0011\u0014\u0002\u0005\u0007\u001b\u0005Aj\u0001UB\u00023\u0013Aq!D\u0001\u0019\tA\u001b!!'\u0003\t\u00055\t\u0001T\u0001)\u0004\u0006e%\u0001rB\u0007\u00021!\u00016aAM\u000b\u0011\riq!\u0003\u0002\n\u0003a!\u0011BA\u0005\u00021\u0003A:\u0001UB\u0004)\u000e%\u0001"}, strings={"createKotlinAfterJavaTask", "Lorg/gradle/api/tasks/compile/AbstractCompile;", "Lorg/gradle/api/Project;", "javaTask", "kotlinOutputDir", "Ljava/io/File;", "taskFactory", "Lkotlin/Function1;", "", "AnnotationProcessingManagerKt", "initKapt", "kotlinTask", "kaptManager", "Lorg/jetbrains/kotlin/gradle/internal/AnnotationProcessingManager;", "variantName", "subpluginEnvironment", "Lorg/jetbrains/kotlin/gradle/plugin/SubpluginEnvironment;"}, moduleName="kotlin-gradle-plugin")
public final class AnnotationProcessingManagerKt {
    @Nullable
    public static final AbstractCompile initKapt(Project $receiver, @NotNull AbstractCompile kotlinTask2, @NotNull AbstractCompile javaTask, @NotNull AnnotationProcessingManager kaptManager, @NotNull String variantName, @NotNull File kotlinOutputDir, @NotNull SubpluginEnvironment subpluginEnvironment, @NotNull Function1<? super String, ? extends AbstractCompile> taskFactory) {
        AbstractCompile kotlinAfterJavaTask2;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)kotlinTask2, (String)"kotlinTask");
        Intrinsics.checkParameterIsNotNull((Object)javaTask, (String)"javaTask");
        Intrinsics.checkParameterIsNotNull((Object)kaptManager, (String)"kaptManager");
        Intrinsics.checkParameterIsNotNull((Object)variantName, (String)"variantName");
        Intrinsics.checkParameterIsNotNull((Object)kotlinOutputDir, (String)"kotlinOutputDir");
        Intrinsics.checkParameterIsNotNull((Object)subpluginEnvironment, (String)"subpluginEnvironment");
        Intrinsics.checkParameterIsNotNull(taskFactory, (String)"taskFactory");
        KaptExtension kaptExtension = (KaptExtension)$receiver.getExtensions().getByType(KaptExtension.class);
        if (kaptExtension.getGenerateStubs()) {
            kotlinAfterJavaTask2 = AnnotationProcessingManagerKt.createKotlinAfterJavaTask($receiver, javaTask, kotlinOutputDir, taskFactory);
            KotlinPluginWrapperKt.kotlinDebug(kotlinTask2.getLogger(), "kapt: Using class file stubs");
            File stubsDir = new File($receiver.getBuildDir(), "tmp/kapt/" + variantName + "/classFileStubs");
            kotlinTask2.getExtensions().getExtraProperties().set("kaptStubsDir", (Object)stubsDir);
            javaTask.doFirst((Action)new Action<Task>($receiver, javaTask, stubsDir){
                final /* synthetic */ Project receiver$0;
                final /* synthetic */ AbstractCompile $javaTask;
                final /* synthetic */ File $stubsDir;

                public final void execute(Task it) {
                    AbstractCompile abstractCompile = this.$javaTask;
                    abstractCompile.setClasspath(abstractCompile.getClasspath().plus((FileCollection)this.receiver$0.files(new Object[]{this.$stubsDir})));
                }
                {
                    this.receiver$0 = project;
                    this.$javaTask = abstractCompile;
                    this.$stubsDir = file;
                }
            });
            kotlinTask2.doFirst((Action)new Action<Task>(kotlinAfterJavaTask2, kotlinTask2){
                final /* synthetic */ AbstractCompile $kotlinAfterJavaTask;
                final /* synthetic */ AbstractCompile $kotlinTask;

                public final void execute(Task it) {
                    this.$kotlinAfterJavaTask.source(new Object[]{this.$kotlinTask.getSource()});
                }
                {
                    this.$kotlinAfterJavaTask = abstractCompile;
                    this.$kotlinTask = abstractCompile2;
                }
            });
            subpluginEnvironment.addSubpluginArguments($receiver, kotlinAfterJavaTask2);
        } else {
            kotlinAfterJavaTask2 = null;
            KotlinPluginWrapperKt.kotlinDebug(kotlinTask2.getLogger(), "kapt: Class file stubs are not used");
        }
        if (kaptExtension.getInheritedAnnotations()) {
            kotlinTask2.getExtensions().getExtraProperties().set("kaptInheritedAnnotations", (Object)true);
        }
        kotlinTask2.doFirst((Action)new Action<Task>(kaptManager, kotlinAfterJavaTask2){
            final /* synthetic */ AnnotationProcessingManager $kaptManager;
            final /* synthetic */ AbstractCompile $kotlinAfterJavaTask;

            public final void execute(Task it) {
                this.$kaptManager.generateJavaHackFile();
                AbstractCompile abstractCompile = this.$kotlinAfterJavaTask;
                SourceTask sourceTask = abstractCompile != null ? abstractCompile.source(new Object[]{this.$kaptManager.getGeneratedKotlinSourceDir()}) : null;
            }
            {
                this.$kaptManager = annotationProcessingManager;
                this.$kotlinAfterJavaTask = abstractCompile;
            }
        });
        javaTask.doFirst((Action)new Action<Task>(kaptManager, kotlinAfterJavaTask2){
            final /* synthetic */ AnnotationProcessingManager $kaptManager;
            final /* synthetic */ AbstractCompile $kotlinAfterJavaTask;

            public final void execute(Task it) {
                this.$kaptManager.setupKapt();
                this.$kaptManager.generateJavaHackFile();
                AbstractCompile abstractCompile = this.$kotlinAfterJavaTask;
                SourceTask sourceTask = abstractCompile != null ? abstractCompile.source(new Object[]{this.$kaptManager.getGeneratedKotlinSourceDir()}) : null;
            }
            {
                this.$kaptManager = annotationProcessingManager;
                this.$kotlinAfterJavaTask = abstractCompile;
            }
        });
        javaTask.doLast((Action)new Action<Task>(kaptManager){
            final /* synthetic */ AnnotationProcessingManager $kaptManager;

            public final void execute(Task it) {
                this.$kaptManager.afterJavaCompile();
            }
            {
                this.$kaptManager = annotationProcessingManager;
            }
        });
        KotlinPluginKt.storeKaptAnnotationsFile(kotlinTask2, kaptManager);
        return kotlinAfterJavaTask2;
    }

    private static final AbstractCompile createKotlinAfterJavaTask(Project $receiver, AbstractCompile javaTask, File kotlinOutputDir, Function1<? super String, ? extends AbstractCompile> taskFactory) {
        Collection destination;
        Map.Entry it;
        Map.Entry element;
        Iterable $receiver2;
        Map receiver;
        Object object = taskFactory.invoke((Object)KotlinPluginKt.getKOTLIN_AFTER_JAVA_TASK_SUFFIX());
        Object $receiver3 = (AbstractCompile)receiver;
        $receiver3.setProperty("kotlinDestinationDir", (Object)kotlinOutputDir);
        $receiver3.setDestinationDir(javaTask.getDestinationDir());
        $receiver3.setClasspath(javaTask.getClasspath());
        AbstractCompile kotlinAfterJavaTask2 = $receiver3;
        receiver = $receiver.getAllTasks(false);
        $receiver3 = $receiver2;
        Collection $i$a$1 = new ArrayList();
        Iterator $i$f$with = MapsKt.iterator((Map)$receiver3);
        while ($i$f$with.hasNext()) {
            it = element = (Map.Entry)$i$f$with.next();
            Iterable list = (Set)CollectionsKt.getValue((Map.Entry)it);
            CollectionsKt.addAll((Collection)destination, (Iterable)list);
        }
        $receiver2 = (List)destination;
        $receiver3 = $receiver2;
        destination = new ArrayList();
        $i$f$with = $receiver3.iterator();
        while ($i$f$with.hasNext()) {
            element = $i$f$with.next();
            it = (Task)element;
            if (!CollectionsKt.contains((Iterable)it.getTaskDependencies().getDependencies((Task)it), (Object)javaTask)) continue;
            destination.add(element);
        }
        $receiver2 = (List)destination;
        for (Object element2 : $receiver2) {
            Task it2 = (Task)element2;
            it2.dependsOn(new Object[]{kotlinAfterJavaTask2});
        }
        kotlinAfterJavaTask2.dependsOn(new Object[]{javaTask});
        return kotlinAfterJavaTask2;
    }
}

