/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin;

import java.io.File;
import kotlin.StringsKt;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.gradle.BuildListener;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.initialization.dsl.ScriptHandler;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.plugins.ExtraPropertiesExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.plugin.FinishBuildListener;
import org.jetbrains.kotlin.gradle.plugin.FinishBuildListenerKt;
import org.jetbrains.kotlin.gradle.plugin.KotlinPluginVersionKt;
import org.jetbrains.kotlin.gradle.plugin.KotlinPluginWrapperKt;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"/\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001\u0007\u0002\u000b\u0005!!!B\u0001\t\u0003\u0015\tA!A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u00031\tQ\u0001\u0001\u0003\u0014\u0019\u0001IB!\u0003\u0002\n\u0003a\t\u0001\u0014AQ\u0003#\u000e\t\u00012A\u0013\t\t-AI!D\u0001\u0019\u000be\u0019\u00012B\u0007\u00021\u0005)\u0013\u0002B\u0001\t\r5\u0011A\u0012\u0001M\u00073\rAY!D\u0001\u0019\u0003\u0015zAA\u0005\u0005\b\u001b\u0011I!!C\u0001\u0019\u0003a\u0005\u0011d\u0001E\b\u001b\u0005A\u0002\"G\u0002\t\u00125\t\u0001TB\u0015\u000f\t\rC\u0001BA\u0007\u0006!\r)\"\u0001$\u0001\u0019\u0006a\u0015\u0011k\u0001\u0003\u0006\u00015\u0011Aq\u0001\u0005\u0005"}, strings={"Lorg/jetbrains/kotlin/gradle/plugin/KotlinBasePluginWrapper;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "()V", "log", "Lorg/gradle/api/logging/Logger;", "kotlin.jvm.PlatformType", "getLog", "()Lorg/gradle/api/logging/Logger;", "apply", "", "project", "findSourceBuildScript", "Lorg/gradle/api/initialization/dsl/ScriptHandler;", "getPlugin", "pluginClassLoader", "Ljava/lang/ClassLoader;", "scriptHandler"}, moduleName="kotlin-gradle-plugin")
public abstract class KotlinBasePluginWrapper
implements Plugin<Project> {
    private final Logger log = Logging.getLogger(this.getClass());

    public final Logger getLog() {
        return this.log;
    }

    public void apply(@NotNull Project project) {
        Unit unit;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        long startMemory = FinishBuildListenerKt.getUsedMemoryKb();
        ScriptHandler sourceBuildScript = this.findSourceBuildScript(project);
        if (sourceBuildScript == null) {
            this.log.error("Failed to determine source cofiguration of kotlin plugin. Can not download core. Please verify that this or any parent project " + "contains 'kotlin-gradle-plugin' in buildscript's classpath configuration.");
            return;
        }
        Logger logger = this.log;
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"log");
        String kotlinPluginVersion = KotlinPluginVersionKt.loadKotlinVersionFromResource(this, logger);
        ExtraPropertiesExtension extraPropertiesExtension = project.getExtensions().getExtraProperties();
        if (extraPropertiesExtension != null) {
            extraPropertiesExtension.set("kotlin.gradle.plugin.version", (Object)kotlinPluginVersion);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        ClassLoader classLoader = this.getClass().getClassLoader();
        Intrinsics.checkExpressionValueIsNotNull((Object)classLoader, (String)"this.javaClass.getClassLoader()");
        Plugin<Project> plugin = this.getPlugin(classLoader, sourceBuildScript);
        plugin.apply((Object)project);
        Gradle gradle = project.getGradle();
        ClassLoader classLoader2 = this.getClass().getClassLoader();
        Intrinsics.checkExpressionValueIsNotNull((Object)classLoader2, (String)"this.javaClass.getClassLoader()");
        gradle.addBuildListener((BuildListener)new FinishBuildListener(classLoader2, startMemory));
    }

    @NotNull
    protected abstract Plugin<Project> getPlugin(@NotNull ClassLoader var1, @NotNull ScriptHandler var2);

    /*
     * WARNING - void declaration
     */
    private final ScriptHandler findSourceBuildScript(Project project) {
        KotlinPluginWrapperKt.kotlinDebug(this.log, "Looking for proper script handler");
        Project curProject = project;
        while (Intrinsics.areEqual((Object)curProject, (Object)curProject.getParent()) ^ true) {
            boolean found;
            File file;
            KotlinPluginWrapperKt.kotlinDebug(this.log, "Looking in project " + project);
            ScriptHandler scriptHandler = curProject.getBuildscript();
            Configuration configuration = (Configuration)scriptHandler.getConfigurations().findByName("classpath");
            if (configuration != null) {
                Object v1;
                block5: {
                    void $receiver;
                    Iterable iterable = (Iterable)configuration;
                    for (Object element : $receiver) {
                        File it = (File)element;
                        if (!StringsKt.contains$default((String)it.getName(), (CharSequence)"kotlin-gradle-plugin", (boolean)false, (int)2)) continue;
                        v1 = element;
                        break block5;
                    }
                    v1 = null;
                }
                file = v1;
            } else {
                file = null;
            }
            boolean bl = found = file != null;
            if (found) {
                KotlinPluginWrapperKt.kotlinDebug(this.log, "Found! returning...");
                return scriptHandler;
            }
            KotlinPluginWrapperKt.kotlinDebug(this.log, "not found, switching to parent");
            if (curProject.getParent() != null) continue;
            break;
        }
        return null;
    }
}

