/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.concurrent.ScheduledExecutorService;
import kotlin.PreconditionsKt;
import kotlin.StringsKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.apache.commons.lang.SystemUtils;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.plugin.FinishBuildListenerKt;
import org.jetbrains.kotlin.gradle.plugin.KotlinPluginWrapperKt;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={")\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0001!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0019\u0005)\u0011\u0001\u0002\u0002\u0006\u0003!\tQ\u0001A\u0003\u0002\u0011\u001d)\u0011\u0001B\u0002\r\u0001e\t\u0001\u0014AQ\b\u0013\u0011A\u0011!\u0004\u0002\r\u0002a\r\u0011kA\u0001\t\u0005\u0015bA!\u0001\u0005\u0006\u001b\u0005AZ!G\u0002\t\r5\t\u0001TB\r\u0004\u0011\u001di\u0011\u0001'\u0004&\t\u0011\t\u0001rB\u0007\u00021\u0017)\u000b\u0002B\"\u0005\u0011!i\u0011\u0001g\u0003\u001a\u0007!EQ\"\u0001M\u0007K\u0011!\u0011\u0001C\u0005\u000e\u0003a-Q\u0005\u0002\u0003\u0002\u0011'i\u0011\u0001g\u0003*\u001d\u0011\u0019\u0005\u0002#\u0002\u000e\u000bA\u001dQC\u0001G\u00011\rA2!U\u0002\u0005\u000b\u0001i!\u0001\u0002\u0003\t\n%BA!\u0011\u000f\t\u00035\u0011A\u0012\u0001M\u0002#\u000e\tQ\u0001\u0001"}, strings={"Lorg/jetbrains/kotlin/gradle/plugin/CompilerServicesCleanup;", "", "pluginClassLoader", "Ljava/lang/ClassLoader;", "(Ljava/lang/ClassLoader;)V", "log", "Lorg/gradle/api/logging/Logger;", "kotlin.jvm.PlatformType", "getLog", "()Lorg/gradle/api/logging/Logger;", "callVoidStaticMethod", "", "classFqName", "", "methodName", "cleanJarCache", "invoke", "gradleVersion", "stopJobScheduler", "stopZipFileCache"}, moduleName="kotlin-gradle-plugin")
public final class CompilerServicesCleanup {
    private final Logger log;
    private ClassLoader pluginClassLoader;

    public final Logger getLog() {
        return this.log;
    }

    public final void invoke(@NotNull String gradleVersion) {
        Unit unit;
        Intrinsics.checkParameterIsNotNull((Object)gradleVersion, (String)"gradleVersion");
        PreconditionsKt.assert((this.pluginClassLoader != null ? 1 : 0) != 0);
        KotlinPluginWrapperKt.kotlinDebug(this.log, "compiler services cleanup");
        if (SystemUtils.IS_OS_WINDOWS) {
            this.cleanJarCache();
        }
        String string = FinishBuildListenerKt.access$comparableVersionStr(gradleVersion);
        if (string != null) {
            String $receiver = string;
            String it = $receiver;
            KotlinPluginWrapperKt.kotlinDebug(this.getLog(), "detected gradle version " + it);
            String string2 = FinishBuildListenerKt.access$comparableVersionStr("2.4");
            if (string2 == null) {
                Intrinsics.throwNpe();
            }
            if (it.compareTo(string2) < 0) {
                this.stopZipFileCache();
                this.stopJobScheduler();
            }
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        this.pluginClassLoader = null;
    }

    private final void stopZipFileCache() {
        this.callVoidStaticMethod("com.intellij.openapi.util.io.ZipFileCache", "stopBackgroundThread");
        KotlinPluginWrapperKt.kotlinDebug(this.log, "ZipFileCache finished successfully");
    }

    private final void stopJobScheduler() {
        KotlinPluginWrapperKt.kotlinDebug(this.log, "Stop JobScheduler");
        Class<?> jobSchedulerClass = Class.forName("com.intellij.concurrency.JobScheduler", false, this.pluginClassLoader);
        Method getSchedulerMethod = jobSchedulerClass.getMethod("getScheduler", new Class[0]);
        Object object = getSchedulerMethod.invoke((Object)this, new Object[0]);
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.concurrent.ScheduledExecutorService");
        }
        ScheduledExecutorService executorService = (ScheduledExecutorService)object;
        executorService.shutdown();
        KotlinPluginWrapperKt.kotlinDebug(this.log, "JobScheduler stopped");
    }

    private final void callVoidStaticMethod(String classFqName, String methodName) {
        String shortName = StringsKt.substring((String)classFqName, (int)(StringsKt.lastIndexOf$default((String)classFqName, (char)'.', (int)0, (boolean)false, (int)6) + 1));
        KotlinPluginWrapperKt.kotlinDebug(this.log, "Looking for " + shortName + " class");
        Class<?> lowMemoryWatcherClass = Class.forName(classFqName, false, this.pluginClassLoader);
        KotlinPluginWrapperKt.kotlinDebug(this.log, "Looking for " + methodName + "() method");
        Method shutdownMethod = lowMemoryWatcherClass.getMethod(methodName, new Class[0]);
        KotlinPluginWrapperKt.kotlinDebug(this.log, "Call " + shortName + "." + methodName + "()");
        shutdownMethod.invoke(null, new Object[0]);
    }

    /*
     * WARNING - void declaration
     */
    private final void cleanJarCache() {
        block12: {
            Object object;
            Field privateCacheField;
            block9: {
                block11: {
                    Object object2;
                    Field innerCache;
                    Object it;
                    block10: {
                        void $receiver;
                        ClassLoader classLoader = this.pluginClassLoader;
                        if (classLoader == null) {
                            Intrinsics.throwNpe();
                        }
                        Class<?> zipHandlerClass = classLoader.loadClass("com.intellij.openapi.vfs.impl.ZipHandler");
                        privateCacheField = zipHandlerClass.getDeclaredField("ourZipFileFileAccessorCache");
                        privateCacheField.setAccessible(true);
                        object = privateCacheField.get(null);
                        if (object == null) break block9;
                        Object $receiver2 = object;
                        it = $receiver2;
                        innerCache = privateCacheField.getType().getDeclaredField("myCache");
                        innerCache.setAccessible(true);
                        object2 = innerCache.get(it);
                        if (object2 == null) break block10;
                        Object object3 = object2;
                        void it2 = $receiver;
                        Method clearMethod = innerCache.getType().getMethod("clear", new Class[0]);
                        if (clearMethod != null) {
                            clearMethod.invoke((Object)it2, new Object[0]);
                            KotlinPluginWrapperKt.kotlinDebug(this.getLog(), "successfuly cleared ZipHandler.ourZipFileFileAccessorCache.myCache");
                        } else {
                            KotlinPluginWrapperKt.kotlinDebug(this.getLog(), "unable to access ZipHandler.ourZipFileFileAccessorCache.myCache.clear");
                        }
                        if ((object2 = Unit.INSTANCE) != null) break block11;
                    }
                    KotlinPluginWrapperKt.kotlinDebug(this.getLog(), "unable to access ZipHandler.ourZipFileFileAccessorCache.myCache (" + innerCache.get(it) + ")");
                    object2 = Unit.INSTANCE;
                }
                if ((object = Unit.INSTANCE) != null) break block12;
            }
            KotlinPluginWrapperKt.kotlinDebug(this.log, "unable to access ZipHandler.ourZipFileFileAccessorCache (" + privateCacheField.get(null) + ")");
            object = Unit.INSTANCE;
        }
    }

    public CompilerServicesCleanup(@Nullable ClassLoader pluginClassLoader) {
        this.pluginClassLoader = pluginClassLoader;
        this.log = Logging.getLogger(this.getClass());
    }
}

