/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin;

import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.FileCollection;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.plugin.Kotlin2JsPluginWrapper;
import org.jetbrains.kotlin.gradle.tasks.Kotlin2JsCompile;
import org.jetbrains.kotlin.gradle.tasks.KotlinJsDce;

@Metadata(mv={1, 1, 12}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \n2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\nB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u0018\u0010\u0007\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/KotlinJsDcePlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "()V", "apply", "", "project", "processSourceSet", "sourceSet", "Lorg/gradle/api/tasks/SourceSet;", "Companion", "kotlin-gradle-plugin"})
public final class KotlinJsDcePlugin
implements Plugin<Project> {
    private static final String TASK_SUFFIX = "kotlinJs";
    private static final String DCE_TASK_PREFIX = "runDce";
    private static final String DEFAULT_OUT_DIR = "kotlin-js-min";
    public static final Companion Companion = new Companion(null);

    public void apply(@NotNull Project project) {
        JavaPluginConvention javaPluginConvention;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        project.getPluginManager().apply(Kotlin2JsPluginWrapper.class);
        JavaPluginConvention javaPluginConvention2 = javaPluginConvention = (JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)javaPluginConvention2, (String)"javaPluginConvention");
        SourceSetContainer sourceSetContainer = javaPluginConvention2.getSourceSets();
        Intrinsics.checkExpressionValueIsNotNull((Object)sourceSetContainer, (String)"javaPluginConvention.sourceSets");
        Iterable $receiver$iv = (Iterable)sourceSetContainer;
        for (Object element$iv : $receiver$iv) {
            SourceSet it;
            SourceSet sourceSet = it = (SourceSet)element$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)sourceSet, (String)"it");
            this.processSourceSet(project, sourceSet);
        }
    }

    private final void processSourceSet(Project project, SourceSet sourceSet) {
        String kotlinTaskName = sourceSet.getCompileTaskName("kotlin2Js");
        Object object = project.getTasks().findByName(kotlinTaskName);
        if (!(object instanceof Kotlin2JsCompile)) {
            object = null;
        }
        Kotlin2JsCompile kotlin2JsCompile = (Kotlin2JsCompile)object;
        if (kotlin2JsCompile == null) {
            return;
        }
        Kotlin2JsCompile kotlinTask = kotlin2JsCompile;
        String dceTaskName = sourceSet.getTaskName(DCE_TASK_PREFIX, TASK_SUFFIX);
        Task task = project.getTasks().create(dceTaskName, KotlinJsDce.class);
        KotlinJsDce it = (KotlinJsDce)task;
        it.dependsOn(new Object[]{kotlinTask});
        Object object2 = project.getTasks().findByName("build");
        if (object2 == null) {
            Intrinsics.throwNpe();
        }
        ((Task)object2).dependsOn(new Object[]{it});
        KotlinJsDce dceTask = (KotlinJsDce)task;
        project.afterEvaluate((Action)new Action<Project>(project, sourceSet, dceTask, kotlinTask){
            final /* synthetic */ Project $project;
            final /* synthetic */ SourceSet $sourceSet;
            final /* synthetic */ KotlinJsDce $dceTask;
            final /* synthetic */ Kotlin2JsCompile $kotlinTask;

            public final void execute(Project it) {
                File file;
                KotlinJsDce kotlinJsDce;
                File outputDir = new File(new File(this.$project.getBuildDir(), "kotlin-js-min"), this.$sourceSet.getName());
                Object object = this.$project.getConfigurations().findByName(this.$sourceSet.getCompileConfigurationName());
                if (object == null) {
                    Intrinsics.throwNpe();
                }
                Configuration configuration = (Configuration)object;
                KotlinJsDce $receiver = kotlinJsDce = this.$dceTask;
                $receiver.setClasspath((FileCollection)configuration);
                KotlinJsDce kotlinJsDce2 = $receiver;
                String string = this.$dceTask.getDceOptions().getOutputDirectory();
                if (string != null) {
                    String string2 = string;
                    KotlinJsDce kotlinJsDce3 = kotlinJsDce2;
                    String it2 = string2;
                    File file2 = new File(it2);
                    kotlinJsDce2 = kotlinJsDce3;
                    file = file2;
                } else {
                    file = outputDir;
                }
                kotlinJsDce2.setDestinationDir(file);
                $receiver.source(new Object[]{this.$kotlinTask.getOutputFile()});
            }
            {
                this.$project = project;
                this.$sourceSet = sourceSet;
                this.$dceTask = kotlinJsDce;
                this.$kotlinTask = kotlin2JsCompile;
            }
        });
    }

    @Metadata(mv={1, 1, 12}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/KotlinJsDcePlugin$Companion;", "", "()V", "DCE_TASK_PREFIX", "", "DEFAULT_OUT_DIR", "TASK_SUFFIX", "kotlin-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

