/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.ecosystem;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.gradle.api.Plugin;
import org.gradle.api.initialization.Settings;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.ecosystem.internal.declarative.KotlinDclStatus;
import org.jetbrains.kotlin.gradle.ecosystem.internal.declarative.KotlinDclStatusKt;
import org.jetbrains.kotlin.gradle.ecosystem.internal.declarative.KotlinDeclarativePlugin;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \u000b2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0002H\u0016J\f\u0010\n\u001a\u00020\b*\u00020\u0002H\u0002R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/gradle/ecosystem/KotlinEcosystemPlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/initialization/Settings;", "()V", "logger", "Lorg/gradle/api/logging/Logger;", "kotlin.jvm.PlatformType", "apply", "", "settings", "applyDeclarativeGradleIfEnabled", "Companion", "kotlin-gradle-ecosystem-plugin_common"})
public final class KotlinEcosystemPlugin
implements Plugin<Settings> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final Logger logger = Logging.getLogger((String)"KotlinEcosystemPlugin");
    @NotNull
    public static final String EXPERIMENTAL_WARNING_MESSAGE = "The Kotlin Ecosystem plugin ('org.jetbrains.kotlin.ecosystem') is experimental and may change in future releases!";
    @NotNull
    public static final String DCL_DISABLED_MESSAGE = "Kotlin Declarative Gradle is disabled by the property 'kotlin.dclEnabled'.";

    public void apply(@NotNull Settings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        this.logger.warn(EXPERIMENTAL_WARNING_MESSAGE);
        this.applyDeclarativeGradleIfEnabled(settings);
    }

    private final void applyDeclarativeGradleIfEnabled(Settings $this$applyDeclarativeGradleIfEnabled) {
        ProviderFactory providerFactory = $this$applyDeclarativeGradleIfEnabled.getProviders();
        Intrinsics.checkNotNullExpressionValue((Object)providerFactory, (String)"providers");
        KotlinDclStatus dclStatus2 = (KotlinDclStatus)((Object)KotlinDclStatusKt.getDclStatus(providerFactory).get());
        if (dclStatus2 == KotlinDclStatus.ENABLED) {
            if (RangesKt.rangeTo((Comparable)((Comparable)KotlinDeclarativePlugin.Companion.getMIN_SUPPORTED_GRADLE_VERSION$kotlin_gradle_ecosystem_plugin_common()), (Comparable)((Comparable)KotlinDeclarativePlugin.Companion.getMAX_SUPPORTED_GRADLE_VERSION$kotlin_gradle_ecosystem_plugin_common())).contains((Comparable)GradleVersion.current())) {
                $this$applyDeclarativeGradleIfEnabled.getSettings().getPlugins().apply(KotlinDeclarativePlugin.class);
            } else {
                GradleVersion gradleVersion = GradleVersion.current();
                Intrinsics.checkNotNullExpressionValue((Object)gradleVersion, (String)"current()");
                this.logger.warn(Companion.buildDclUnsupportedMessage$kotlin_gradle_ecosystem_plugin_common(gradleVersion));
            }
        } else {
            this.logger.info(DCL_DISABLED_MESSAGE);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/gradle/ecosystem/KotlinEcosystemPlugin$Companion;", "", "()V", "DCL_DISABLED_MESSAGE", "", "EXPERIMENTAL_WARNING_MESSAGE", "buildDclUnsupportedMessage", "currentGradleVersion", "Lorg/gradle/util/GradleVersion;", "buildDclUnsupportedMessage$kotlin_gradle_ecosystem_plugin_common", "kotlin-gradle-ecosystem-plugin_common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String buildDclUnsupportedMessage$kotlin_gradle_ecosystem_plugin_common(@NotNull GradleVersion currentGradleVersion) {
            Intrinsics.checkNotNullParameter((Object)currentGradleVersion, (String)"currentGradleVersion");
            return "Support for Kotlin Declarative Gradle is only available with Gradle version '" + KotlinDeclarativePlugin.Companion.getMIN_SUPPORTED_GRADLE_VERSION$kotlin_gradle_ecosystem_plugin_common() + ".*'. The current Gradle version is " + currentGradleVersion + '.';
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

