/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dataframe.math;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClassifier;
import kotlin.reflect.KType;
import kotlin.reflect.full.KTypes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.dataframe.api.DefaultsKt;
import org.jetbrains.kotlinx.dataframe.impl.RenderingKt;
import org.jetbrains.kotlinx.dataframe.math.BasicStats;
import org.jetbrains.kotlinx.dataframe.math.StdMeanKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000T\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0004\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a:\u0010\u0000\u001a\u00020\u0001\"\b\b\u0000\u0010\u0002*\u00020\u0003*\n\u0012\u0006\u0012\u0004\u0018\u0001H\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\nH\u0001\u001a+\u0010\u0000\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00010\u00042\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\nH\u0001\u00a2\u0006\u0002\b\u0013\u001a+\u0010\u0000\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00140\u00042\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\nH\u0001\u00a2\u0006\u0002\b\u0015\u001a!\u0010\u0000\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\n0\u00042\b\b\u0002\u0010\t\u001a\u00020\nH\u0001\u00a2\u0006\u0002\b\u0016\u001a!\u0010\u0000\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00170\u00042\b\b\u0002\u0010\t\u001a\u00020\nH\u0001\u00a2\u0006\u0002\b\u0018\u001a!\u0010\u0000\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00190\u00042\b\b\u0002\u0010\t\u001a\u00020\nH\u0001\u00a2\u0006\u0002\b\u001a\u001a!\u0010\u0000\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\u001b0\u00042\b\b\u0002\u0010\t\u001a\u00020\nH\u0001\u00a2\u0006\u0002\b\u001c\"J\u0010\u000b\u001a8\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u0005\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u000f\u0012\u0006\u0012\u0004\u0018\u00010\u00060\fj\u0002`\u0010X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001d"}, d2={"std", "", "T", "", "", "type", "Lkotlin/reflect/KType;", "skipNA", "", "ddof", "", "stdTypeConversion", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "emptyInput", "Lorg/jetbrains/kotlinx/dataframe/impl/aggregation/aggregators/CalculateReturnTypeOrNull;", "getStdTypeConversion", "()Lkotlin/jvm/functions/Function2;", "doubleStd", "", "floatStd", "intStd", "", "longStd", "Ljava/math/BigDecimal;", "bigDecimalStd", "Ljava/math/BigInteger;", "bigIntegerStd", "core"})
@SourceDebugExtension(value={"SMAP\nstd.kt\nKotlin\n*S Kotlin\n*F\n+ 1 std.kt\norg/jetbrains/kotlinx/dataframe/math/StdKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,64:1\n1557#2:65\n1628#2,3:66\n*S KotlinDebug\n*F\n+ 1 std.kt\norg/jetbrains/kotlinx/dataframe/math/StdKt\n*L\n34#1:65\n34#1:66,3\n*E\n"})
public final class StdKt {
    @NotNull
    private static final Function2<KType, Boolean, KType> stdTypeConversion = StdKt::stdTypeConversion$lambda$1;

    /*
     * WARNING - void declaration
     */
    @PublishedApi
    public static final <T extends Number> double std(@NotNull Iterable<? extends T> $this$std, @NotNull KType type, boolean skipNA, int ddof) {
        double d;
        Intrinsics.checkNotNullParameter($this$std, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        if (type.isMarkedNullable()) {
            return skipNA ? StdKt.std(CollectionsKt.filterNotNull($this$std), KTypes.withNullability((KType)type, (boolean)false), true, ddof) : (CollectionsKt.contains($this$std, null) ? Double.NaN : StdKt.std($this$std, KTypes.withNullability((KType)type, (boolean)false), false, ddof));
        }
        KClassifier kClassifier = type.getClassifier();
        if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Double.TYPE))) {
            d = StdKt.doubleStd($this$std, skipNA, ddof);
        } else if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE))) {
            d = StdKt.floatStd($this$std, skipNA, ddof);
        } else if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE)) || Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Short.TYPE)) || Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Byte.TYPE))) {
            d = StdKt.intStd($this$std, ddof);
        } else if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE))) {
            d = StdKt.longStd($this$std, ddof);
        } else if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(BigDecimal.class))) {
            d = StdKt.bigDecimalStd($this$std, ddof);
        } else if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(BigInteger.class))) {
            d = StdKt.bigIntegerStd($this$std, ddof);
        } else if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Number.class))) {
            void $this$mapTo$iv$iv;
            Iterable<? extends T> $this$map$iv = $this$std;
            boolean $i$f$map = false;
            Iterable<? extends T> iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Number number = (Number)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.doubleValue());
            }
            d = StdKt.doubleStd((List)destination$iv$iv, skipNA, ddof);
        } else if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Void.class))) {
            d = Double.NaN;
        } else {
            throw new IllegalArgumentException("Unable to compute the std for type " + RenderingKt.renderType(type));
        }
        return d;
    }

    public static /* synthetic */ double std$default(Iterable iterable, KType kType, boolean bl, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = DefaultsKt.getSkipNA_default();
        }
        if ((n2 & 4) != 0) {
            n = DefaultsKt.getDdof_default();
        }
        return StdKt.std(iterable, kType, bl, n);
    }

    @NotNull
    public static final Function2<KType, Boolean, KType> getStdTypeConversion() {
        return stdTypeConversion;
    }

    @JvmName(name="doubleStd")
    public static final double doubleStd(@NotNull Iterable<Double> $this$std, boolean skipNA, int ddof) {
        Intrinsics.checkNotNullParameter($this$std, (String)"<this>");
        BasicStats basicStats = StdMeanKt.doubleVarianceAndMean($this$std, skipNA);
        return basicStats != null ? basicStats.std(ddof) : Double.NaN;
    }

    public static /* synthetic */ double doubleStd$default(Iterable iterable, boolean bl, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            bl = DefaultsKt.getSkipNA_default();
        }
        if ((n2 & 2) != 0) {
            n = DefaultsKt.getDdof_default();
        }
        return StdKt.doubleStd(iterable, bl, n);
    }

    @JvmName(name="floatStd")
    public static final double floatStd(@NotNull Iterable<Float> $this$std, boolean skipNA, int ddof) {
        Intrinsics.checkNotNullParameter($this$std, (String)"<this>");
        BasicStats basicStats = StdMeanKt.floatVarianceAndMean($this$std, skipNA);
        return basicStats != null ? basicStats.std(ddof) : Double.NaN;
    }

    public static /* synthetic */ double floatStd$default(Iterable iterable, boolean bl, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            bl = DefaultsKt.getSkipNA_default();
        }
        if ((n2 & 2) != 0) {
            n = DefaultsKt.getDdof_default();
        }
        return StdKt.floatStd(iterable, bl, n);
    }

    @JvmName(name="intStd")
    public static final double intStd(@NotNull Iterable<Integer> $this$std, int ddof) {
        Intrinsics.checkNotNullParameter($this$std, (String)"<this>");
        return StdMeanKt.intVarianceAndMean($this$std).std(ddof);
    }

    public static /* synthetic */ double intStd$default(Iterable iterable, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = DefaultsKt.getDdof_default();
        }
        return StdKt.intStd(iterable, n);
    }

    @JvmName(name="longStd")
    public static final double longStd(@NotNull Iterable<Long> $this$std, int ddof) {
        Intrinsics.checkNotNullParameter($this$std, (String)"<this>");
        return StdMeanKt.longVarianceAndMean($this$std).std(ddof);
    }

    public static /* synthetic */ double longStd$default(Iterable iterable, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = DefaultsKt.getDdof_default();
        }
        return StdKt.longStd(iterable, n);
    }

    @JvmName(name="bigDecimalStd")
    public static final double bigDecimalStd(@NotNull Iterable<? extends BigDecimal> $this$std, int ddof) {
        Intrinsics.checkNotNullParameter($this$std, (String)"<this>");
        return StdMeanKt.bigDecimalVarianceAndMean($this$std).std(ddof);
    }

    public static /* synthetic */ double bigDecimalStd$default(Iterable iterable, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = DefaultsKt.getDdof_default();
        }
        return StdKt.bigDecimalStd(iterable, n);
    }

    @JvmName(name="bigIntegerStd")
    public static final double bigIntegerStd(@NotNull Iterable<? extends BigInteger> $this$std, int ddof) {
        Intrinsics.checkNotNullParameter($this$std, (String)"<this>");
        return StdMeanKt.bigIntegerVarianceAndMean($this$std).std(ddof);
    }

    public static /* synthetic */ double bigIntegerStd$default(Iterable iterable, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = DefaultsKt.getDdof_default();
        }
        return StdKt.bigIntegerStd(iterable, n);
    }

    private static final KType stdTypeConversion$lambda$1(KType kType, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)kType, (String)"<unused var>");
        return Reflection.typeOf(Double.TYPE);
    }
}

