/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dataframe.math;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.reflect.KClassifier;
import kotlin.reflect.KType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.dataframe.impl.UtilsKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000(\n\u0002\b\u0002\n\u0002\u0010\u000f\n\u0002\u0010\u001c\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u001a@\u0010\u0000\u001a\u0004\u0018\u0001H\u0001\"\u0010\b\u0000\u0010\u0001\u0018\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u0002*\n\u0012\u0006\u0012\u0004\u0018\u0001H\u00010\u00032\u0006\u0010\u0000\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u0081\b\u00a2\u0006\u0002\u0010\u0007\u001a/\u0010\b\u001a\u0002H\u0001\"\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u0002*\b\u0012\u0004\u0012\u0002H\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0001\u00a2\u0006\u0002\u0010\f\u00a8\u0006\r"}, d2={"percentile", "T", "", "", "", "type", "Lkotlin/reflect/KType;", "(Ljava/lang/Iterable;DLkotlin/reflect/KType;)Ljava/lang/Comparable;", "quickSelect", "", "k", "", "(Ljava/util/List;I)Ljava/lang/Comparable;", "core"})
@SourceDebugExtension(value={"SMAP\npercentile.kt\nKotlin\n*S Kotlin\n*F\n+ 1 percentile.kt\norg/jetbrains/kotlinx/dataframe/math/PercentileKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,122:1\n1#2:123\n*E\n"})
public final class PercentileKt {
    @PublishedApi
    public static final /* synthetic */ <T extends Comparable<? super T>> T percentile(Iterable<? extends T> $this$percentile, double percentile, KType type) {
        Comparable comparable;
        Intrinsics.checkNotNullParameter($this$percentile, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        boolean $i$f$percentile = false;
        if (!(0.0 <= percentile ? percentile <= 100.0 : false)) {
            boolean $i$a$-require-PercentileKt$percentile$22 = false;
            String $i$a$-require-PercentileKt$percentile$22 = "Percentile must be in range [0, 100]";
            throw new IllegalArgumentException($i$a$-require-PercentileKt$percentile$22.toString());
        }
        List<T> list = type.isMarkedNullable() ? CollectionsKt.filterNotNull($this$percentile) : UtilsKt.asList($this$percentile);
        int size = list.size();
        if (size == 0) {
            return null;
        }
        int index = (int)(percentile / 100.0 * (double)(size - 1));
        double fraction = percentile / 100.0 * (double)(size - 1) - (double)index;
        if (percentile == 50.0 && size % 2 == 0) {
            Comparable comparable2;
            T lower = PercentileKt.quickSelect(list, index);
            T upper = PercentileKt.quickSelect(list, index + 1);
            KClassifier kClassifier = type.getClassifier();
            if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Double.TYPE))) {
                Intrinsics.checkNotNull(lower, (String)"null cannot be cast to non-null type kotlin.Double");
                double d = (Double)lower;
                Intrinsics.checkNotNull(upper, (String)"null cannot be cast to non-null type kotlin.Double");
                Double d2 = (d + (Double)upper) / 2.0;
                Intrinsics.reifiedOperationMarker((int)1, (String)"T");
                comparable2 = d2;
            } else if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE))) {
                Intrinsics.checkNotNull(lower, (String)"null cannot be cast to non-null type kotlin.Float");
                float f = ((Float)lower).floatValue();
                Intrinsics.checkNotNull(upper, (String)"null cannot be cast to non-null type kotlin.Float");
                Float f2 = Float.valueOf((f + ((Float)upper).floatValue()) / 2.0f);
                Intrinsics.reifiedOperationMarker((int)1, (String)"T");
                comparable2 = f2;
            } else if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
                Intrinsics.checkNotNull(lower, (String)"null cannot be cast to non-null type kotlin.Int");
                int n = (Integer)lower;
                Intrinsics.checkNotNull(upper, (String)"null cannot be cast to non-null type kotlin.Int");
                Integer n2 = (n + (Integer)upper) / 2;
                Intrinsics.reifiedOperationMarker((int)1, (String)"T");
                comparable2 = n2;
            } else if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Short.TYPE))) {
                Intrinsics.checkNotNull(lower, (String)"null cannot be cast to non-null type kotlin.Short");
                short s = (Short)lower;
                Intrinsics.checkNotNull(upper, (String)"null cannot be cast to non-null type kotlin.Short");
                Short s2 = (short)((s + (Short)upper) / 2);
                Intrinsics.reifiedOperationMarker((int)1, (String)"T");
                comparable2 = s2;
            } else if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE))) {
                Intrinsics.checkNotNull(lower, (String)"null cannot be cast to non-null type kotlin.Long");
                long l = (Long)lower;
                Intrinsics.checkNotNull(upper, (String)"null cannot be cast to non-null type kotlin.Long");
                Long l2 = (l + (Long)upper) / 2L;
                Intrinsics.reifiedOperationMarker((int)1, (String)"T");
                comparable2 = l2;
            } else if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Byte.TYPE))) {
                Intrinsics.checkNotNull(lower, (String)"null cannot be cast to non-null type kotlin.Byte");
                byte by2 = (Byte)lower;
                Intrinsics.checkNotNull(upper, (String)"null cannot be cast to non-null type kotlin.Byte");
                Byte by3 = (byte)((by2 + (Byte)upper) / 2);
                Intrinsics.reifiedOperationMarker((int)1, (String)"T");
                comparable2 = by3;
            } else if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(BigDecimal.class))) {
                Intrinsics.checkNotNull(lower, (String)"null cannot be cast to non-null type java.math.BigDecimal");
                BigDecimal bigDecimal = (BigDecimal)lower;
                Intrinsics.checkNotNull(upper, (String)"null cannot be cast to non-null type java.math.BigDecimal");
                BigDecimal bigDecimal2 = bigDecimal.add((BigDecimal)upper);
                Intrinsics.checkNotNullExpressionValue((Object)bigDecimal2, (String)"add(...)");
                BigDecimal bigDecimal3 = BigDecimal.valueOf(2);
                Intrinsics.checkNotNullExpressionValue((Object)bigDecimal3, (String)"valueOf(...)");
                BigDecimal bigDecimal4 = bigDecimal2.divide(bigDecimal3, RoundingMode.HALF_EVEN);
                Intrinsics.checkNotNullExpressionValue((Object)bigDecimal4, (String)"divide(...)");
                Intrinsics.reifiedOperationMarker((int)1, (String)"T");
                comparable2 = bigDecimal4;
            } else if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(BigInteger.class))) {
                Intrinsics.checkNotNull(lower, (String)"null cannot be cast to non-null type java.math.BigInteger");
                BigInteger bigInteger = (BigInteger)lower;
                Intrinsics.checkNotNull(upper, (String)"null cannot be cast to non-null type java.math.BigInteger");
                BigInteger bigInteger2 = bigInteger.add((BigInteger)upper);
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger2, (String)"add(...)");
                BigInteger bigInteger3 = BigInteger.valueOf(2);
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger3, (String)"valueOf(...)");
                BigInteger bigInteger4 = bigInteger2.divide(bigInteger3);
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger4, (String)"divide(...)");
                Intrinsics.reifiedOperationMarker((int)1, (String)"T");
                comparable2 = bigInteger4;
            } else {
                comparable2 = (Comparable)lower;
            }
            return (T)comparable2;
        }
        if (fraction == 0.0) {
            return PercentileKt.quickSelect(list, index);
        }
        T lower = PercentileKt.quickSelect(list, index);
        T upper = PercentileKt.quickSelect(list, index + 1);
        KClassifier kClassifier = type.getClassifier();
        if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Double.TYPE))) {
            Intrinsics.checkNotNull(lower, (String)"null cannot be cast to non-null type kotlin.Double");
            double d = (Double)lower;
            Intrinsics.checkNotNull(upper, (String)"null cannot be cast to non-null type kotlin.Double");
            Double d3 = d + ((Double)upper - (Double)lower) * fraction;
            Intrinsics.reifiedOperationMarker((int)1, (String)"T");
            comparable = d3;
        } else if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE))) {
            Intrinsics.checkNotNull(lower, (String)"null cannot be cast to non-null type kotlin.Float");
            double d = ((Float)lower).floatValue();
            Intrinsics.checkNotNull(upper, (String)"null cannot be cast to non-null type kotlin.Float");
            Double d4 = d + (double)(((Float)upper).floatValue() - ((Float)lower).floatValue()) * fraction;
            Intrinsics.reifiedOperationMarker((int)1, (String)"T");
            comparable = d4;
        } else if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
            Intrinsics.checkNotNull(lower, (String)"null cannot be cast to non-null type kotlin.Int");
            double d = ((Integer)lower).intValue();
            Intrinsics.checkNotNull(upper, (String)"null cannot be cast to non-null type kotlin.Int");
            Integer n = (int)(d + (double)((Integer)upper - (Integer)lower) * fraction);
            Intrinsics.reifiedOperationMarker((int)1, (String)"T");
            comparable = n;
        } else if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Short.TYPE))) {
            Intrinsics.checkNotNull(lower, (String)"null cannot be cast to non-null type kotlin.Short");
            double d = ((Short)lower).shortValue();
            Intrinsics.checkNotNull(upper, (String)"null cannot be cast to non-null type kotlin.Short");
            Short s = (short)(d + (double)((Short)upper - (Short)lower) * fraction);
            Intrinsics.reifiedOperationMarker((int)1, (String)"T");
            comparable = s;
        } else if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE))) {
            Intrinsics.checkNotNull(lower, (String)"null cannot be cast to non-null type kotlin.Long");
            double d = ((Long)lower).longValue();
            Intrinsics.checkNotNull(upper, (String)"null cannot be cast to non-null type kotlin.Long");
            Long l = (long)(d + (double)((Long)upper - (Long)lower) * fraction);
            Intrinsics.reifiedOperationMarker((int)1, (String)"T");
            comparable = l;
        } else if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Byte.TYPE))) {
            Intrinsics.checkNotNull(lower, (String)"null cannot be cast to non-null type kotlin.Byte");
            double d = ((Byte)lower).byteValue();
            Intrinsics.checkNotNull(upper, (String)"null cannot be cast to non-null type kotlin.Byte");
            Byte by4 = (byte)(d + (double)((Byte)upper - (Byte)lower) * fraction);
            Intrinsics.reifiedOperationMarker((int)1, (String)"T");
            comparable = by4;
        } else if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(BigDecimal.class))) {
            Intrinsics.checkNotNull(lower, (String)"null cannot be cast to non-null type java.math.BigDecimal");
            BigDecimal bigDecimal = (BigDecimal)lower;
            Intrinsics.checkNotNull(upper, (String)"null cannot be cast to non-null type java.math.BigDecimal");
            BigDecimal bigDecimal5 = ((BigDecimal)upper).subtract((BigDecimal)lower);
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal5, (String)"subtract(...)");
            BigDecimal bigDecimal6 = bigDecimal5.multiply(new BigDecimal(String.valueOf(fraction)));
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal6, (String)"multiply(...)");
            BigDecimal bigDecimal7 = bigDecimal.add(bigDecimal6);
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal7, (String)"add(...)");
            Intrinsics.reifiedOperationMarker((int)1, (String)"T");
            comparable = bigDecimal7;
        } else if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(BigInteger.class))) {
            Intrinsics.checkNotNull(lower, (String)"null cannot be cast to non-null type java.math.BigInteger");
            BigInteger bigInteger = (BigInteger)lower;
            Intrinsics.checkNotNull(upper, (String)"null cannot be cast to non-null type java.math.BigInteger");
            BigInteger bigInteger5 = ((BigInteger)upper).subtract((BigInteger)lower);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger5, (String)"subtract(...)");
            BigInteger bigInteger6 = bigInteger5;
            BigInteger bigInteger7 = new BigDecimal(String.valueOf(fraction)).toBigInteger();
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger7, (String)"toBigInteger(...)");
            BigInteger bigInteger8 = bigInteger7;
            BigInteger bigInteger9 = bigInteger6.multiply(bigInteger8);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger9, (String)"multiply(...)");
            bigInteger6 = bigInteger9;
            BigInteger bigInteger10 = bigInteger.add(bigInteger6);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger10, (String)"add(...)");
            Intrinsics.reifiedOperationMarker((int)1, (String)"T");
            comparable = bigInteger10;
        } else {
            comparable = (Comparable)lower;
        }
        return (T)comparable;
    }

    public static /* synthetic */ Comparable percentile$default(Iterable $this$percentile_u24default, double percentile, KType type, int n, Object object) {
        Comparable comparable;
        if ((n & 2) != 0) {
            Intrinsics.reifiedOperationMarker((int)6, (String)"T");
            type = null;
        }
        Intrinsics.checkNotNullParameter((Object)$this$percentile_u24default, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        boolean $i$f$percentile = false;
        if (!(0.0 <= percentile ? percentile <= 100.0 : false)) {
            boolean $i$a$-require-PercentileKt$percentile$22 = false;
            String $i$a$-require-PercentileKt$percentile$22 = "Percentile must be in range [0, 100]";
            throw new IllegalArgumentException($i$a$-require-PercentileKt$percentile$22.toString());
        }
        List list = type.isMarkedNullable() ? CollectionsKt.filterNotNull((Iterable)$this$percentile_u24default) : UtilsKt.asList($this$percentile_u24default);
        int size = list.size();
        if (size == 0) {
            return null;
        }
        int index = (int)(percentile / 100.0 * (double)(size - 1));
        double fraction = percentile / 100.0 * (double)(size - 1) - (double)index;
        if (percentile == 50.0 && size % 2 == 0) {
            Comparable comparable2;
            Object lower = PercentileKt.quickSelect(list, index);
            Object upper = PercentileKt.quickSelect(list, index + 1);
            KClassifier kClassifier = type.getClassifier();
            if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Double.TYPE))) {
                Intrinsics.checkNotNull(lower, (String)"null cannot be cast to non-null type kotlin.Double");
                double d = (Double)lower;
                Intrinsics.checkNotNull(upper, (String)"null cannot be cast to non-null type kotlin.Double");
                Double d2 = (d + (Double)upper) / 2.0;
                Intrinsics.reifiedOperationMarker((int)1, (String)"T");
                comparable2 = d2;
            } else if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE))) {
                Intrinsics.checkNotNull(lower, (String)"null cannot be cast to non-null type kotlin.Float");
                float f = ((Float)lower).floatValue();
                Intrinsics.checkNotNull(upper, (String)"null cannot be cast to non-null type kotlin.Float");
                Float f2 = Float.valueOf((f + ((Float)upper).floatValue()) / 2.0f);
                Intrinsics.reifiedOperationMarker((int)1, (String)"T");
                comparable2 = f2;
            } else if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
                Intrinsics.checkNotNull(lower, (String)"null cannot be cast to non-null type kotlin.Int");
                int n2 = (Integer)lower;
                Intrinsics.checkNotNull(upper, (String)"null cannot be cast to non-null type kotlin.Int");
                Integer n3 = (n2 + (Integer)upper) / 2;
                Intrinsics.reifiedOperationMarker((int)1, (String)"T");
                comparable2 = n3;
            } else if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Short.TYPE))) {
                Intrinsics.checkNotNull(lower, (String)"null cannot be cast to non-null type kotlin.Short");
                short s = (Short)lower;
                Intrinsics.checkNotNull(upper, (String)"null cannot be cast to non-null type kotlin.Short");
                Short s2 = (short)((s + (Short)upper) / 2);
                Intrinsics.reifiedOperationMarker((int)1, (String)"T");
                comparable2 = s2;
            } else if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE))) {
                Intrinsics.checkNotNull(lower, (String)"null cannot be cast to non-null type kotlin.Long");
                long l = (Long)lower;
                Intrinsics.checkNotNull(upper, (String)"null cannot be cast to non-null type kotlin.Long");
                Long l2 = (l + (Long)upper) / 2L;
                Intrinsics.reifiedOperationMarker((int)1, (String)"T");
                comparable2 = l2;
            } else if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Byte.TYPE))) {
                Intrinsics.checkNotNull(lower, (String)"null cannot be cast to non-null type kotlin.Byte");
                byte by2 = (Byte)lower;
                Intrinsics.checkNotNull(upper, (String)"null cannot be cast to non-null type kotlin.Byte");
                Byte by3 = (byte)((by2 + (Byte)upper) / 2);
                Intrinsics.reifiedOperationMarker((int)1, (String)"T");
                comparable2 = by3;
            } else if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(BigDecimal.class))) {
                Intrinsics.checkNotNull(lower, (String)"null cannot be cast to non-null type java.math.BigDecimal");
                BigDecimal bigDecimal = (BigDecimal)lower;
                Intrinsics.checkNotNull(upper, (String)"null cannot be cast to non-null type java.math.BigDecimal");
                BigDecimal bigDecimal2 = bigDecimal.add((BigDecimal)upper);
                Intrinsics.checkNotNullExpressionValue((Object)bigDecimal2, (String)"add(...)");
                BigDecimal bigDecimal3 = BigDecimal.valueOf(2);
                Intrinsics.checkNotNullExpressionValue((Object)bigDecimal3, (String)"valueOf(...)");
                BigDecimal bigDecimal4 = bigDecimal2.divide(bigDecimal3, RoundingMode.HALF_EVEN);
                Intrinsics.checkNotNullExpressionValue((Object)bigDecimal4, (String)"divide(...)");
                Intrinsics.reifiedOperationMarker((int)1, (String)"T");
                comparable2 = bigDecimal4;
            } else if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(BigInteger.class))) {
                Intrinsics.checkNotNull(lower, (String)"null cannot be cast to non-null type java.math.BigInteger");
                BigInteger bigInteger = (BigInteger)lower;
                Intrinsics.checkNotNull(upper, (String)"null cannot be cast to non-null type java.math.BigInteger");
                BigInteger bigInteger2 = bigInteger.add((BigInteger)upper);
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger2, (String)"add(...)");
                BigInteger bigInteger3 = BigInteger.valueOf(2);
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger3, (String)"valueOf(...)");
                BigInteger bigInteger4 = bigInteger2.divide(bigInteger3);
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger4, (String)"divide(...)");
                Intrinsics.reifiedOperationMarker((int)1, (String)"T");
                comparable2 = bigInteger4;
            } else {
                comparable2 = (Comparable)lower;
            }
            return comparable2;
        }
        if (fraction == 0.0) {
            return PercentileKt.quickSelect(list, index);
        }
        Object lower = PercentileKt.quickSelect(list, index);
        Object upper = PercentileKt.quickSelect(list, index + 1);
        KClassifier kClassifier = type.getClassifier();
        if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Double.TYPE))) {
            Intrinsics.checkNotNull(lower, (String)"null cannot be cast to non-null type kotlin.Double");
            double d = (Double)lower;
            Intrinsics.checkNotNull(upper, (String)"null cannot be cast to non-null type kotlin.Double");
            Double d3 = d + ((Double)upper - (Double)lower) * fraction;
            Intrinsics.reifiedOperationMarker((int)1, (String)"T");
            comparable = d3;
        } else if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE))) {
            Intrinsics.checkNotNull(lower, (String)"null cannot be cast to non-null type kotlin.Float");
            double d = ((Float)lower).floatValue();
            Intrinsics.checkNotNull(upper, (String)"null cannot be cast to non-null type kotlin.Float");
            Double d4 = d + (double)(((Float)upper).floatValue() - ((Float)lower).floatValue()) * fraction;
            Intrinsics.reifiedOperationMarker((int)1, (String)"T");
            comparable = d4;
        } else if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
            Intrinsics.checkNotNull(lower, (String)"null cannot be cast to non-null type kotlin.Int");
            double d = ((Integer)lower).intValue();
            Intrinsics.checkNotNull(upper, (String)"null cannot be cast to non-null type kotlin.Int");
            Integer n4 = (int)(d + (double)((Integer)upper - (Integer)lower) * fraction);
            Intrinsics.reifiedOperationMarker((int)1, (String)"T");
            comparable = n4;
        } else if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Short.TYPE))) {
            Intrinsics.checkNotNull(lower, (String)"null cannot be cast to non-null type kotlin.Short");
            double d = ((Short)lower).shortValue();
            Intrinsics.checkNotNull(upper, (String)"null cannot be cast to non-null type kotlin.Short");
            Short s = (short)(d + (double)((Short)upper - (Short)lower) * fraction);
            Intrinsics.reifiedOperationMarker((int)1, (String)"T");
            comparable = s;
        } else if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE))) {
            Intrinsics.checkNotNull(lower, (String)"null cannot be cast to non-null type kotlin.Long");
            double d = ((Long)lower).longValue();
            Intrinsics.checkNotNull(upper, (String)"null cannot be cast to non-null type kotlin.Long");
            Long l = (long)(d + (double)((Long)upper - (Long)lower) * fraction);
            Intrinsics.reifiedOperationMarker((int)1, (String)"T");
            comparable = l;
        } else if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Byte.TYPE))) {
            Intrinsics.checkNotNull(lower, (String)"null cannot be cast to non-null type kotlin.Byte");
            double d = ((Byte)lower).byteValue();
            Intrinsics.checkNotNull(upper, (String)"null cannot be cast to non-null type kotlin.Byte");
            Byte by4 = (byte)(d + (double)((Byte)upper - (Byte)lower) * fraction);
            Intrinsics.reifiedOperationMarker((int)1, (String)"T");
            comparable = by4;
        } else if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(BigDecimal.class))) {
            Intrinsics.checkNotNull(lower, (String)"null cannot be cast to non-null type java.math.BigDecimal");
            BigDecimal bigDecimal = (BigDecimal)lower;
            Intrinsics.checkNotNull(upper, (String)"null cannot be cast to non-null type java.math.BigDecimal");
            BigDecimal bigDecimal5 = ((BigDecimal)upper).subtract((BigDecimal)lower);
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal5, (String)"subtract(...)");
            BigDecimal bigDecimal6 = bigDecimal5.multiply(new BigDecimal(String.valueOf(fraction)));
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal6, (String)"multiply(...)");
            BigDecimal bigDecimal7 = bigDecimal.add(bigDecimal6);
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal7, (String)"add(...)");
            Intrinsics.reifiedOperationMarker((int)1, (String)"T");
            comparable = bigDecimal7;
        } else if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(BigInteger.class))) {
            Intrinsics.checkNotNull(lower, (String)"null cannot be cast to non-null type java.math.BigInteger");
            BigInteger bigInteger = (BigInteger)lower;
            Intrinsics.checkNotNull(upper, (String)"null cannot be cast to non-null type java.math.BigInteger");
            BigInteger bigInteger5 = ((BigInteger)upper).subtract((BigInteger)lower);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger5, (String)"subtract(...)");
            BigInteger bigInteger6 = bigInteger5;
            BigInteger bigInteger7 = new BigDecimal(String.valueOf(fraction)).toBigInteger();
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger7, (String)"toBigInteger(...)");
            BigInteger bigInteger8 = bigInteger7;
            BigInteger bigInteger9 = bigInteger6.multiply(bigInteger8);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger9, (String)"multiply(...)");
            bigInteger6 = bigInteger9;
            BigInteger bigInteger10 = bigInteger.add(bigInteger6);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger10, (String)"add(...)");
            Intrinsics.reifiedOperationMarker((int)1, (String)"T");
            comparable = bigInteger10;
        } else {
            comparable = (Comparable)lower;
        }
        return comparable;
    }

    @PublishedApi
    @NotNull
    public static final <T extends Comparable<? super T>> T quickSelect(@NotNull List<? extends T> $this$quickSelect, int k) {
        Intrinsics.checkNotNullParameter($this$quickSelect, (String)"<this>");
        if (k < 0 || k >= $this$quickSelect.size()) {
            throw new IndexOutOfBoundsException("k = " + k + ", size = " + $this$quickSelect.size());
        }
        List list = $this$quickSelect;
        List temp = new ArrayList();
        List less = new ArrayList();
        int k2 = k;
        List greater = new ArrayList();
        while (list.size() > 1) {
            int equal = 0;
            Comparable x = (Comparable)CollectionsKt.random((Collection)list, (Random)((Random)Random.Default));
            greater.clear();
            less.clear();
            for (Comparable v : list) {
                int comp = v.compareTo(x);
                if (comp < 0) {
                    less.add(v);
                    continue;
                }
                if (comp > 0) {
                    greater.add(v);
                    continue;
                }
                ++equal;
            }
            if (k2 < less.size()) {
                list = less;
                less = temp;
                temp = list;
                continue;
            }
            if (k2 < less.size() + equal) {
                return (T)x;
            }
            list = greater;
            greater = temp;
            temp = list;
            k2 -= less.size() + equal;
        }
        return (T)((Comparable)list.get(0));
    }
}

