/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dataframe.io;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Path;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipInputStream;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u00e6\u0080\u0001\u0018\u0000 \u000b*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0004\u000b\f\r\u000eJ\u0015\u0010\u0004\u001a\u00028\u00002\u0006\u0010\u0005\u001a\u00020\u0002H&\u00a2\u0006\u0002\u0010\u0006J\u0015\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\tJ\u0015\u0010\n\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\t\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u000f\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/kotlinx/dataframe/io/Compression;", "I", "Ljava/io/InputStream;", "", "wrapStream", "inputStream", "(Ljava/io/InputStream;)Ljava/io/InputStream;", "doFirst", "", "(Ljava/io/InputStream;)V", "doFinally", "Companion", "Gzip", "Zip", "None", "core"})
public interface Compression<I extends InputStream> {
    @NotNull
    public static final Companion Companion = org.jetbrains.kotlinx.dataframe.io.Compression$Companion.$$INSTANCE;

    @NotNull
    public I wrapStream(@NotNull InputStream var1);

    default public void doFirst(@NotNull I inputStream) {
        Intrinsics.checkNotNullParameter(inputStream, (String)"inputStream");
    }

    default public void doFinally(@NotNull I inputStream) {
        Intrinsics.checkNotNullParameter(inputStream, (String)"inputStream");
        ((InputStream)inputStream).close();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0012\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u00052\u0006\u0010\b\u001a\u00020\tJ\u0012\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u00052\u0006\u0010\n\u001a\u00020\u000bJ\u0012\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u00052\u0006\u0010\f\u001a\u00020\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlinx/dataframe/io/Compression$Companion;", "", "<init>", "()V", "of", "Lorg/jetbrains/kotlinx/dataframe/io/Compression;", "fileOrUrl", "", "file", "Ljava/io/File;", "path", "Ljava/nio/file/Path;", "url", "Ljava/net/URL;", "core"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        @NotNull
        public final Compression<?> of(@NotNull String fileOrUrl) {
            Intrinsics.checkNotNullParameter((Object)fileOrUrl, (String)"fileOrUrl");
            String[] stringArray = new String[]{"."};
            String string = (String)CollectionsKt.last((List)StringsKt.split$default((CharSequence)fileOrUrl, (String[])stringArray, (boolean)false, (int)0, (int)6, null));
            return Intrinsics.areEqual((Object)string, (Object)"gz") ? (Compression)Gzip.INSTANCE : (Intrinsics.areEqual((Object)string, (Object)"zip") ? (Compression)Zip.INSTANCE : (Compression)None.INSTANCE);
        }

        @NotNull
        public final Compression<?> of(@NotNull File file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            String string = file.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            return this.of(string);
        }

        @NotNull
        public final Compression<?> of(@NotNull Path path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Object object = path.getFileName();
            if (object == null || (object = object.toString()) == null) {
                object = "";
            }
            return this.of((String)object);
        }

        @NotNull
        public final Compression<?> of(@NotNull URL url) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            String string = url.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            return this.of(string);
        }

        static {
            $$INSTANCE = new Companion();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\n\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0011\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0096\u0001J\u0011\u0010\b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0096\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\u0011\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0012H\u0096\u0001\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlinx/dataframe/io/Compression$Gzip;", "Lorg/jetbrains/kotlinx/dataframe/io/Compression;", "Ljava/util/zip/GZIPInputStream;", "<init>", "()V", "doFinally", "", "inputStream", "doFirst", "equals", "", "other", "", "hashCode", "", "toString", "", "wrapStream", "Ljava/io/InputStream;", "core"})
    public static final class Gzip
    implements Compression<GZIPInputStream> {
        @NotNull
        public static final Gzip INSTANCE = new Gzip();
        private final /* synthetic */ Compression<GZIPInputStream> $$delegate_0;

        private Gzip() {
            this.$$delegate_0 = 1.INSTANCE;
        }

        @NotNull
        public String toString() {
            return "Gzip";
        }

        public int hashCode() {
            return -964151418;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Gzip)) {
                return false;
            }
            Gzip cfr_ignored_0 = (Gzip)other;
            return true;
        }

        @Override
        @NotNull
        public GZIPInputStream wrapStream(@NotNull InputStream inputStream) {
            Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
            return this.$$delegate_0.wrapStream(inputStream);
        }

        @Override
        public void doFirst(@NotNull GZIPInputStream inputStream) {
            Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
            this.$$delegate_0.doFirst((GZIPInputStream)((InputStream)inputStream));
        }

        @Override
        public void doFinally(@NotNull GZIPInputStream inputStream) {
            Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
            this.$$delegate_0.doFinally((GZIPInputStream)((InputStream)inputStream));
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\n\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0011\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0096\u0001J\u0011\u0010\b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0096\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\u0011\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0002H\u0096\u0001\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlinx/dataframe/io/Compression$None;", "Lorg/jetbrains/kotlinx/dataframe/io/Compression;", "Ljava/io/InputStream;", "<init>", "()V", "doFinally", "", "inputStream", "doFirst", "equals", "", "other", "", "hashCode", "", "toString", "", "wrapStream", "core"})
    public static final class None
    implements Compression<InputStream> {
        @NotNull
        public static final None INSTANCE = new None();
        private final /* synthetic */ Compression<InputStream> $$delegate_0;

        private None() {
            this.$$delegate_0 = None::__delegate_0$lambda$0;
        }

        @NotNull
        public String toString() {
            return "None";
        }

        public int hashCode() {
            return -963953308;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof None)) {
                return false;
            }
            None cfr_ignored_0 = (None)other;
            return true;
        }

        @Override
        @NotNull
        public InputStream wrapStream(@NotNull InputStream inputStream) {
            Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
            return this.$$delegate_0.wrapStream(inputStream);
        }

        @Override
        public void doFirst(@NotNull InputStream inputStream) {
            Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
            this.$$delegate_0.doFirst(inputStream);
        }

        @Override
        public void doFinally(@NotNull InputStream inputStream) {
            Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
            this.$$delegate_0.doFinally(inputStream);
        }

        private static final InputStream __delegate_0$lambda$0(InputStream it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\n\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u0010\u0010\b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\u0011\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0012H\u0096\u0001\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlinx/dataframe/io/Compression$Zip;", "Lorg/jetbrains/kotlinx/dataframe/io/Compression;", "Ljava/util/zip/ZipInputStream;", "<init>", "()V", "doFirst", "", "inputStream", "doFinally", "equals", "", "other", "", "hashCode", "", "toString", "", "wrapStream", "Ljava/io/InputStream;", "core"})
    public static final class Zip
    implements Compression<ZipInputStream> {
        @NotNull
        public static final Zip INSTANCE = new Zip();
        private final /* synthetic */ Compression<ZipInputStream> $$delegate_0;

        private Zip() {
            this.$$delegate_0 = 1.INSTANCE;
        }

        @Override
        public void doFirst(@NotNull ZipInputStream inputStream) {
            Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
            if (inputStream.getNextEntry() == null) {
                throw new IllegalStateException("No entries in zip file".toString());
            }
        }

        @Override
        public void doFinally(@NotNull ZipInputStream inputStream) {
            Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
            if (inputStream.getNextEntry() != null) {
                inputStream.close();
                throw new IllegalArgumentException("Zip file contains more than one entry");
            }
            inputStream.close();
        }

        @NotNull
        public String toString() {
            return "Zip";
        }

        public int hashCode() {
            return 246010741;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Zip)) {
                return false;
            }
            Zip cfr_ignored_0 = (Zip)other;
            return true;
        }

        @Override
        @NotNull
        public ZipInputStream wrapStream(@NotNull InputStream inputStream) {
            Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
            return this.$$delegate_0.wrapStream(inputStream);
        }
    }
}

