/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dataframe.plugin.impl.api;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.dataframe.columns.ColumnPath;
import org.jetbrains.kotlinx.dataframe.columns.ColumnReference;
import org.jetbrains.kotlinx.dataframe.columns.ColumnResolutionContext;
import org.jetbrains.kotlinx.dataframe.columns.ColumnWithPath;
import org.jetbrains.kotlinx.dataframe.columns.ColumnWithPathKt;
import org.jetbrains.kotlinx.dataframe.columns.SingleColumn;
import org.jetbrains.kotlinx.dataframe.plugin.impl.DataFrameAdapterKt;
import org.jetbrains.kotlinx.dataframe.plugin.impl.PluginDataFrameSchema;
import org.jetbrains.kotlinx.dataframe.plugin.impl.api.ColumnsResolver;
import org.jetbrains.kotlinx.dataframe.plugin.impl.data.ColumnWithPathApproximation;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u00022\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0004B\u000f\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u00042\u0006\u0010\u000e\u001a\u00020\fH\u0016J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u001e\u0010\u000f\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u00130\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u0016\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlinx/dataframe/plugin/impl/api/SingleColumnApproximation;", "Lorg/jetbrains/kotlinx/dataframe/plugin/impl/api/ColumnsResolver;", "Lorg/jetbrains/kotlinx/dataframe/columns/SingleColumn;", "", "Lorg/jetbrains/kotlinx/dataframe/columns/ColumnReference;", "col", "Lorg/jetbrains/kotlinx/dataframe/plugin/impl/data/ColumnWithPathApproximation;", "<init>", "(Lorg/jetbrains/kotlinx/dataframe/plugin/impl/data/ColumnWithPathApproximation;)V", "getCol", "()Lorg/jetbrains/kotlinx/dataframe/plugin/impl/data/ColumnWithPathApproximation;", "name", "", "rename", "newName", "resolve", "", "df", "Lorg/jetbrains/kotlinx/dataframe/plugin/impl/PluginDataFrameSchema;", "Lorg/jetbrains/kotlinx/dataframe/columns/ColumnWithPath;", "context", "Lorg/jetbrains/kotlinx/dataframe/columns/ColumnResolutionContext;", "resolveSingle", "kotlin-dataframe-compiler-plugin"})
public final class SingleColumnApproximation
implements ColumnsResolver,
SingleColumn<Object>,
ColumnReference<Object> {
    @NotNull
    private final ColumnWithPathApproximation col;

    public SingleColumnApproximation(@NotNull ColumnWithPathApproximation col) {
        Intrinsics.checkNotNullParameter((Object)col, (String)"col");
        this.col = col;
    }

    @NotNull
    public final ColumnWithPathApproximation getCol() {
        return this.col;
    }

    @NotNull
    public String name() {
        return this.col.getColumn().getName();
    }

    @NotNull
    public ColumnReference<Object> rename(@NotNull String newName) {
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        return new SingleColumnApproximation(new ColumnWithPathApproximation(this.col.getPath(), this.col.getColumn().rename(newName)));
    }

    @Override
    @NotNull
    public List<ColumnWithPathApproximation> resolve(@NotNull PluginDataFrameSchema df) {
        Intrinsics.checkNotNullParameter((Object)df, (String)"df");
        return CollectionsKt.listOf((Object)this.col);
    }

    @Override
    @NotNull
    public List<ColumnWithPath<Object>> resolve(@NotNull ColumnResolutionContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return CollectionsKt.listOf(this.resolveSingle(context));
    }

    @NotNull
    public ColumnWithPath<Object> resolveSingle(@NotNull ColumnResolutionContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return ColumnWithPathKt.ColumnWithPath(DataFrameAdapterKt.asDataColumn(this.col.getColumn()), (ColumnPath)this.col.getPath());
    }
}

