/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dataframe.math;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KType;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.dataframe.api.DefaultsKt;
import org.jetbrains.kotlinx.dataframe.impl.RenderingKt;
import org.jetbrains.kotlinx.dataframe.impl.TypeUtilsKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a,\u0010\u0000\u001a\u00020\u0001\"\b\b\u0000\u0010\u0002*\u00020\u0003*\b\u0012\u0004\u0012\u0002H\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0000\u001a\u001c\u0010\u0000\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00010\u00042\b\b\u0002\u0010\u0007\u001a\u00020\bH\u0000\"H\u0010\t\u001a6\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\u0005\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\u0004\u0012\u00020\u00060\nj\u0002`\u000eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"mean", "", "T", "", "Lkotlin/sequences/Sequence;", "type", "Lkotlin/reflect/KType;", "skipNaN", "", "meanTypeConversion", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "emptyInput", "Lorg/jetbrains/kotlinx/dataframe/impl/aggregation/aggregators/CalculateReturnType;", "getMeanTypeConversion", "()Lkotlin/jvm/functions/Function2;", "core"})
public final class MeanKt {
    @NotNull
    private static final Function2<KType, Boolean, KType> meanTypeConversion = MeanKt::meanTypeConversion$lambda$5;

    public static final <T extends Number> double mean(@NotNull Sequence<? extends T> $this$mean, @NotNull KType type, boolean skipNaN) {
        double d;
        Intrinsics.checkNotNullParameter($this$mean, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        if (type.isMarkedNullable()) {
            throw new IllegalStateException(("Encountered nullable type " + RenderingKt.renderType(type) + " in mean function. This should not occur.").toString());
        }
        KType kType = type;
        if (Intrinsics.areEqual((Object)kType, (Object)Reflection.typeOf(Double.TYPE))) {
            d = MeanKt.mean($this$mean, skipNaN);
        } else if (Intrinsics.areEqual((Object)kType, (Object)Reflection.typeOf(Float.TYPE))) {
            d = MeanKt.mean((Sequence<Double>)SequencesKt.map($this$mean, MeanKt::mean$lambda$0), skipNaN);
        } else if (Intrinsics.areEqual((Object)kType, (Object)Reflection.typeOf(Integer.TYPE))) {
            d = MeanKt.mean((Sequence<Double>)SequencesKt.map($this$mean, MeanKt::mean$lambda$1), false);
        } else if (Intrinsics.areEqual((Object)kType, (Object)Reflection.typeOf(Short.TYPE))) {
            d = MeanKt.mean((Sequence<Double>)SequencesKt.map($this$mean, MeanKt::mean$lambda$2), false);
        } else if (Intrinsics.areEqual((Object)kType, (Object)Reflection.typeOf(Byte.TYPE))) {
            d = MeanKt.mean((Sequence<Double>)SequencesKt.map($this$mean, MeanKt::mean$lambda$3), false);
        } else if (Intrinsics.areEqual((Object)kType, (Object)Reflection.typeOf(Long.TYPE))) {
            d = MeanKt.mean((Sequence<Double>)SequencesKt.map($this$mean, MeanKt::mean$lambda$4), false);
        } else {
            if (Intrinsics.areEqual((Object)kType, (Object)Reflection.typeOf(BigInteger.class)) || Intrinsics.areEqual((Object)kType, (Object)Reflection.typeOf(BigDecimal.class))) {
                throw new IllegalArgumentException("Cannot calculate the mean for big numbers in DataFrame. Only primitive numbers are supported.");
            }
            if (Intrinsics.areEqual((Object)kType, (Object)Reflection.typeOf(Number.class))) {
                throw new IllegalStateException("Encountered non-specific Number type in mean function. This should not occur.".toString());
            }
            if (Intrinsics.areEqual((Object)kType, (Object)TypeUtilsKt.getNothingType())) {
                d = Double.NaN;
            } else {
                throw new IllegalArgumentException("Unable to compute the mean for " + RenderingKt.renderType(type) + ". Only primitive numbers are supported.");
            }
        }
        return d;
    }

    @NotNull
    public static final Function2<KType, Boolean, KType> getMeanTypeConversion() {
        return meanTypeConversion;
    }

    public static final double mean(@NotNull Sequence<Double> $this$mean, boolean skipNaN) {
        Intrinsics.checkNotNullParameter($this$mean, (String)"<this>");
        int count2 = 0;
        double sum = 0.0;
        Iterator iterator2 = $this$mean.iterator();
        while (iterator2.hasNext()) {
            double element = ((Number)iterator2.next()).doubleValue();
            if (Double.isNaN(element)) {
                if (skipNaN) continue;
                return Double.NaN;
            }
            sum += element;
            ++count2;
        }
        return count2 > 0 ? sum / (double)count2 : Double.NaN;
    }

    public static /* synthetic */ double mean$default(Sequence sequence, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = DefaultsKt.getSkipNaNDefault();
        }
        return MeanKt.mean((Sequence<Double>)sequence, bl);
    }

    private static final double mean$lambda$0(float it) {
        return it;
    }

    private static final double mean$lambda$1(int it) {
        return it;
    }

    private static final double mean$lambda$2(short it) {
        return it;
    }

    private static final double mean$lambda$3(byte it) {
        return it;
    }

    private static final double mean$lambda$4(long it) {
        return it;
    }

    private static final KType meanTypeConversion$lambda$5(KType kType, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)kType, (String)"<unused var>");
        return Reflection.typeOf(Double.TYPE);
    }
}

