/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dataframe.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.dataframe.ColumnsContainer;
import org.jetbrains.kotlinx.dataframe.DataColumn;
import org.jetbrains.kotlinx.dataframe.DataFrame;
import org.jetbrains.kotlinx.dataframe.DataRow;
import org.jetbrains.kotlinx.dataframe.api.DataFrameGetKt;
import org.jetbrains.kotlinx.dataframe.columns.ColumnReference;
import org.jetbrains.kotlinx.dataframe.impl.ColumnAccessTracker;
import org.jetbrains.kotlinx.dataframe.io.StringKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0010\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006H\u0016J\u0013\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0096\u0002J\"\u0010\t\u001a\u0002H\r\"\u0004\b\u0001\u0010\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\r0\u000fH\u0096\u0002\u00a2\u0006\u0002\u0010\u0010J#\u0010\u0011\u001a\u0004\u0018\u0001H\r\"\u0004\b\u0001\u0010\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\r0\u000fH\u0016\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u0010\u0010\u0012\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\u0013H\u0016J\u0013\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0018\u001a\u00020\u0004H\u0096\u0002J\b\u0010\u0019\u001a\u00020\fH\u0016J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\nH\u0096\u0002J\b\u0010\u001d\u001a\u00020\u0004H\u0016J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\u0012\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\u00138BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlinx/dataframe/impl/DataRowImpl;", "T", "Lorg/jetbrains/kotlinx/dataframe/DataRow;", "index", "", "df", "Lorg/jetbrains/kotlinx/dataframe/DataFrame;", "<init>", "(ILorg/jetbrains/kotlinx/dataframe/DataFrame;)V", "get", "", "name", "", "R", "column", "Lorg/jetbrains/kotlinx/dataframe/columns/ColumnReference;", "(Lorg/jetbrains/kotlinx/dataframe/columns/ColumnReference;)Ljava/lang/Object;", "getValueOrNull", "values", "", "getValues", "()Ljava/util/List;", "values$delegate", "Lkotlin/Lazy;", "columnIndex", "toString", "equals", "", "other", "hashCode", "getOrNull", "core"})
@SourceDebugExtension(value={"SMAP\nDataRowImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataRowImpl.kt\norg/jetbrains/kotlinx/dataframe/impl/DataRowImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,71:1\n1563#2:72\n1634#2,3:73\n*S KotlinDebug\n*F\n+ 1 DataRowImpl.kt\norg/jetbrains/kotlinx/dataframe/impl/DataRowImpl\n*L\n34#1:72\n34#1:73,3\n*E\n"})
public class DataRowImpl<T>
implements DataRow<T> {
    private final int index;
    @NotNull
    private final DataFrame<T> df;
    @NotNull
    private final Lazy values$delegate;

    public DataRowImpl(int index, @NotNull DataFrame<? extends T> df2) {
        Intrinsics.checkNotNullParameter(df2, (String)"df");
        this.index = index;
        this.df = df2;
        this.values$delegate = LazyKt.lazy(() -> DataRowImpl.values_delegate$lambda$1(this));
    }

    @Override
    @NotNull
    public DataFrame<T> df() {
        return this.df;
    }

    @Override
    @Nullable
    public Object get(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        ColumnAccessTracker.Companion.registerColumnAccess(name);
        return this.df.get(name).get(this.index);
    }

    @Override
    public <R> R get(@NotNull ColumnReference<? extends R> column2) {
        Intrinsics.checkNotNullParameter(column2, (String)"column");
        ColumnAccessTracker.Companion.registerColumnAccess(column2.name());
        return column2.getValue(this);
    }

    @Override
    @Nullable
    public <R> R getValueOrNull(@NotNull ColumnReference<? extends R> column2) {
        Intrinsics.checkNotNullParameter(column2, (String)"column");
        ColumnAccessTracker.Companion.registerColumnAccess(column2.name());
        return column2.getValueOrNull(this);
    }

    @Override
    public int index() {
        return this.index;
    }

    private final List<Object> getValues() {
        Lazy lazy = this.values$delegate;
        return (List)lazy.getValue();
    }

    @Override
    @NotNull
    public List<Object> values() {
        return this.getValues();
    }

    @Override
    @Nullable
    public Object get(int columnIndex) {
        DataColumn<?> column2 = DataFrameGetKt.getColumn((ColumnsContainer)this.df, columnIndex);
        ColumnAccessTracker.Companion.registerColumnAccess(column2.name());
        return column2.get(this.index);
    }

    @NotNull
    public String toString() {
        return StringKt.renderToString((DataRow)this);
    }

    public boolean equals(@Nullable Object other) {
        DataRowImpl dataRowImpl = other instanceof DataRowImpl ? (DataRowImpl)other : null;
        if (dataRowImpl == null) {
            return false;
        }
        DataRowImpl o = dataRowImpl;
        return ((Object)this.getValues()).equals(o.getValues());
    }

    public int hashCode() {
        return ((Object)this.getValues()).hashCode();
    }

    @Override
    @Nullable
    public Object getOrNull(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        ColumnAccessTracker.Companion.registerColumnAccess(name);
        DataColumn<?> dataColumn = this.df.getColumnOrNull(name);
        return dataColumn != null ? dataColumn.get(this.index) : null;
    }

    /*
     * WARNING - void declaration
     */
    private static final List values_delegate$lambda$1(DataRowImpl this$0) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this$0.df.columns();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DataColumn dataColumn = (DataColumn)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.get(this$0.index));
        }
        return (List)destination$iv$iv;
    }
}

