/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.daemon.report;

import java.io.Serializable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSourceLocation;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageRenderer;
import org.jetbrains.kotlin.daemon.KotlinCompileDaemon;
import org.jetbrains.kotlin.daemon.common.CompilationOptions;
import org.jetbrains.kotlin.daemon.common.CompilerServicesFacadeBase;
import org.jetbrains.kotlin.daemon.common.CompilerServicesFacadeBaseKt;
import org.jetbrains.kotlin.daemon.common.ReportCategory;
import org.jetbrains.kotlin.daemon.common.ReportSeverity;

@Metadata(mv={1, 5, 0}, k=1, xi=50, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\"\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/daemon/report/CompileServicesFacadeMessageCollector;", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "servicesFacade", "Lorg/jetbrains/kotlin/daemon/common/CompilerServicesFacadeBase;", "compilationOptions", "Lorg/jetbrains/kotlin/daemon/common/CompilationOptions;", "(Lorg/jetbrains/kotlin/daemon/common/CompilerServicesFacadeBase;Lorg/jetbrains/kotlin/daemon/common/CompilationOptions;)V", "hasErrors", "", "mySeverity", "", "clear", "", "report", "severity", "Lorg/jetbrains/kotlin/cli/common/messages/CompilerMessageSeverity;", "message", "", "location", "Lorg/jetbrains/kotlin/cli/common/messages/CompilerMessageSourceLocation;", "kotlin-daemon"})
public final class CompileServicesFacadeMessageCollector
implements MessageCollector {
    @NotNull
    private final CompilerServicesFacadeBase servicesFacade;
    private final int mySeverity;
    private boolean hasErrors;

    public CompileServicesFacadeMessageCollector(@NotNull CompilerServicesFacadeBase servicesFacade, @NotNull CompilationOptions compilationOptions) {
        Intrinsics.checkNotNullParameter((Object)servicesFacade, (String)"servicesFacade");
        Intrinsics.checkNotNullParameter((Object)compilationOptions, (String)"compilationOptions");
        this.servicesFacade = servicesFacade;
        this.mySeverity = compilationOptions.getReportSeverity();
    }

    public void clear() {
        this.hasErrors = false;
    }

    public void report(@NotNull CompilerMessageSeverity severity, @NotNull String message, @Nullable CompilerMessageSourceLocation location) {
        Intrinsics.checkNotNullParameter((Object)severity, (String)"severity");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        KotlinCompileDaemon.INSTANCE.getLog().info(Intrinsics.stringPlus((String)"Message: ", (Object)MessageRenderer.WITHOUT_PATHS.render(severity, message, location)));
        CompilerMessageSeverity compilerMessageSeverity = severity;
        int n = WhenMappings.$EnumSwitchMapping$0[compilerMessageSeverity.ordinal()];
        switch (n) {
            case 1: {
                CompilerServicesFacadeBaseKt.report$default(this.servicesFacade, ReportCategory.OUTPUT_MESSAGE, ReportSeverity.ERROR, message, null, 8, null);
                break;
            }
            case 2: {
                CompilerServicesFacadeBaseKt.report$default(this.servicesFacade, ReportCategory.EXCEPTION, ReportSeverity.ERROR, message, null, 8, null);
                break;
            }
            default: {
                ReportSeverity reportSeverity;
                CompilerMessageSeverity compilerMessageSeverity2 = severity;
                int n2 = WhenMappings.$EnumSwitchMapping$0[compilerMessageSeverity2.ordinal()];
                switch (n2) {
                    case 3: {
                        ReportSeverity reportSeverity2 = ReportSeverity.ERROR;
                        break;
                    }
                    case 4: 
                    case 5: {
                        ReportSeverity reportSeverity2 = ReportSeverity.WARNING;
                        break;
                    }
                    case 6: {
                        ReportSeverity reportSeverity2 = ReportSeverity.INFO;
                        break;
                    }
                    default: {
                        ReportSeverity reportSeverity2 = reportSeverity = ReportSeverity.DEBUG;
                    }
                }
                if (reportSeverity.getCode() > this.mySeverity) break;
                CompilerServicesFacadeBaseKt.report(this.servicesFacade, ReportCategory.COMPILER_MESSAGE, reportSeverity, message, (Serializable)location);
            }
        }
        this.hasErrors = this.hasErrors || severity.isError();
    }

    public boolean hasErrors() {
        return this.hasErrors;
    }

    @Metadata(mv={1, 5, 0}, k=3, xi=50)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CompilerMessageSeverity.values().length];
            nArray[CompilerMessageSeverity.OUTPUT.ordinal()] = 1;
            nArray[CompilerMessageSeverity.EXCEPTION.ordinal()] = 2;
            nArray[CompilerMessageSeverity.ERROR.ordinal()] = 3;
            nArray[CompilerMessageSeverity.WARNING.ordinal()] = 4;
            nArray[CompilerMessageSeverity.STRONG_WARNING.ordinal()] = 5;
            nArray[CompilerMessageSeverity.INFO.ordinal()] = 6;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

