/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.daemon;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, xi=50, d1={"\u0000$\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\u001a\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r\u001a\n\u0010\u000e\u001a\u00020\u000f*\u00020\r\"\u0014\u0010\u0000\u001a\u00020\u0001X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0014\u0010\u0004\u001a\u00020\u0005X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0014\u0010\b\u001a\u00020\u0005X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\u0010"}, d2={"CLASSPATH_FILE_ID_DIGEST", "", "getCLASSPATH_FILE_ID_DIGEST", "()Ljava/lang/String;", "DEFAULT_CLASSPATH_DIGEST_WATCH_PERIOD_MS", "", "getDEFAULT_CLASSPATH_DIGEST_WATCH_PERIOD_MS", "()J", "DEFAULT_CLASSPATH_WATCH_PERIOD_MS", "getDEFAULT_CLASSPATH_WATCH_PERIOD_MS", "isClasspathFile", "", "file", "Ljava/io/File;", "md5Digest", "", "kotlin-daemon"})
public final class LazyClasspathWatcherKt {
    @NotNull
    private static final String CLASSPATH_FILE_ID_DIGEST = "MD5";
    private static final long DEFAULT_CLASSPATH_WATCH_PERIOD_MS = 1000L;
    private static final long DEFAULT_CLASSPATH_DIGEST_WATCH_PERIOD_MS = 300000L;

    @NotNull
    public static final String getCLASSPATH_FILE_ID_DIGEST() {
        return CLASSPATH_FILE_ID_DIGEST;
    }

    public static final long getDEFAULT_CLASSPATH_WATCH_PERIOD_MS() {
        return DEFAULT_CLASSPATH_WATCH_PERIOD_MS;
    }

    public static final long getDEFAULT_CLASSPATH_DIGEST_WATCH_PERIOD_MS() {
        return DEFAULT_CLASSPATH_DIGEST_WATCH_PERIOD_MS;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isClasspathFile(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!file.isFile()) return false;
        Object object = new String[]{"class", "jar"};
        List list = CollectionsKt.listOf((Object[])object);
        object = FilesKt.getExtension((File)file);
        boolean bl = false;
        Object object2 = object;
        if (object2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string = ((String)object2).toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"(this as java.lang.String).toLowerCase()");
        if (!list.contains(string)) return false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final byte[] md5Digest(@NotNull File $this$md5Digest) {
        Intrinsics.checkNotNullParameter((Object)$this$md5Digest, (String)"<this>");
        MessageDigest md = MessageDigest.getInstance(CLASSPATH_FILE_ID_DIGEST);
        Object object = $this$md5Digest;
        boolean bl = false;
        object = new DigestInputStream(new FileInputStream((File)object), md);
        bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            DigestInputStream it = (DigestInputStream)object;
            boolean bl3 = false;
            byte[] buf = new byte[1024];
            while (it.read(buf) != -1) {
            }
            it.close();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        object = md.digest();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"md.digest()");
        return object;
    }
}

