/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.daemon;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.concurrent.ThreadsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.daemon.LazyClasspathWatcher;
import org.jetbrains.kotlin.daemon.LazyClasspathWatcherKt;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=50, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001c\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001 B'\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0016\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\u0019\u001a\n \u001b*\u0004\u0018\u00010\u001a0\u001a8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001e\u0010\u001f\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/daemon/LazyClasspathWatcher;", "", "classpath", "", "", "checkPeriod", "", "digestCheckPeriod", "(Ljava/lang/Iterable;JJ)V", "getCheckPeriod", "()J", "getDigestCheckPeriod", "fileIds", "", "Lorg/jetbrains/kotlin/daemon/LazyClasspathWatcher$FileId;", "fileIdsLock", "Ljava/util/concurrent/Semaphore;", "isChanged", "", "()Z", "lastChangedStatus", "Ljava/util/concurrent/atomic/AtomicBoolean;", "lastDigestUpdate", "Ljava/util/concurrent/atomic/AtomicLong;", "lastUpdate", "log", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "getLog", "()Ljava/util/logging/Logger;", "log$delegate", "Lkotlin/Lazy;", "FileId", "kotlin-daemon"})
public final class LazyClasspathWatcher {
    private final long checkPeriod;
    private final long digestCheckPeriod;
    @NotNull
    private final Semaphore fileIdsLock;
    @Nullable
    private List<FileId> fileIds;
    @NotNull
    private final AtomicBoolean lastChangedStatus;
    @NotNull
    private final AtomicLong lastUpdate;
    @NotNull
    private final AtomicLong lastDigestUpdate;
    @NotNull
    private final Lazy log$delegate;

    public LazyClasspathWatcher(final @NotNull Iterable<String> classpath, long checkPeriod, long digestCheckPeriod) {
        Intrinsics.checkNotNullParameter(classpath, (String)"classpath");
        this.checkPeriod = checkPeriod;
        this.digestCheckPeriod = digestCheckPeriod;
        this.fileIdsLock = new Semaphore(1);
        this.lastChangedStatus = new AtomicBoolean(false);
        this.lastUpdate = new AtomicLong(0L);
        this.lastDigestUpdate = new AtomicLong(0L);
        this.log$delegate = LazyKt.lazy((Function0)log.2.INSTANCE);
        this.fileIdsLock.acquire();
        ThreadsKt.thread$default((boolean)true, (boolean)true, null, null, (int)0, (Function0)((Function0)new Function0<Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public final void invoke() {
                try {
                    Collection<File> collection;
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    Iterable<String> iterable = classpath;
                    LazyClasspathWatcher lazyClasspathWatcher = this;
                    boolean $i$f$map = false;
                    void var3_7 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void p0;
                        String string = (String)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl = false;
                        File file = new File((String)p0);
                        collection.add(file);
                    }
                    collection = (List)destination$iv$iv;
                    lazyClasspathWatcher.fileIds = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)collection), (Function1)2.INSTANCE), (Function1)3.INSTANCE));
                    long nowMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
                    lastUpdate.set(nowMs);
                    lastDigestUpdate.set(nowMs);
                }
                catch (IOException e) {
                    this.getLog().log(Level.WARNING, "Error on walking classpath", e);
                }
                finally {
                    fileIdsLock.release();
                }
            }
        }), (int)28, null);
    }

    public /* synthetic */ LazyClasspathWatcher(Iterable iterable, long l, long l2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            l = LazyClasspathWatcherKt.getDEFAULT_CLASSPATH_WATCH_PERIOD_MS();
        }
        if ((n & 4) != 0) {
            l2 = LazyClasspathWatcherKt.getDEFAULT_CLASSPATH_DIGEST_WATCH_PERIOD_MS();
        }
        this(iterable, l, l2);
    }

    public final long getCheckPeriod() {
        return this.checkPeriod;
    }

    public final long getDigestCheckPeriod() {
        return this.digestCheckPeriod;
    }

    private final Logger getLog() {
        Lazy lazy = this.log$delegate;
        boolean bl = false;
        return (Logger)lazy.getValue();
    }

    public final boolean isChanged() {
        FileId fileId;
        if (this.lastChangedStatus.get()) {
            return true;
        }
        long nowMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
        if (nowMs - this.lastUpdate.get() < this.checkPeriod) {
            return false;
        }
        boolean checkDigest = nowMs - this.lastDigestUpdate.get() > this.digestCheckPeriod;
        this.fileIdsLock.acquire();
        this.fileIdsLock.release();
        List<FileId> list = this.fileIds;
        if (list == null) {
            fileId = null;
        } else {
            Object v2;
            block12: {
                Iterable iterable = list;
                boolean bl = false;
                Iterable iterable2 = iterable;
                boolean bl2 = false;
                for (Object t : iterable2) {
                    boolean bl3;
                    FileId it = (FileId)t;
                    boolean bl4 = false;
                    try {
                        boolean bl5;
                        if (!it.getFile().exists()) {
                            this.getLog().info("cp changed: " + it.getFile() + " doesn't exist any more");
                            bl5 = true;
                        } else if ((it.getFile().lastModified() != it.getLastModified() || checkDigest) && !Arrays.equals(it.getDigest(), LazyClasspathWatcherKt.md5Digest(it.getFile()))) {
                            this.getLog().info("cp changed: " + it.getFile() + " digests differ");
                            bl5 = true;
                        } else {
                            bl5 = false;
                        }
                        bl3 = bl5;
                    }
                    catch (IOException e) {
                        this.getLog().log(Level.INFO, "cp changed: " + it.getFile() + " access throws the exception", e);
                        bl3 = true;
                    }
                    if (!bl3) continue;
                    v2 = t;
                    break block12;
                }
                v2 = null;
            }
            fileId = v2;
        }
        boolean changed = fileId != null;
        this.lastUpdate.set(TimeUnit.NANOSECONDS.toMillis(System.nanoTime()));
        if (checkDigest) {
            this.lastDigestUpdate.set(this.lastUpdate.get());
        }
        return changed;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=50, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0012\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/daemon/LazyClasspathWatcher$FileId;", "", "file", "Ljava/io/File;", "lastModified", "", "digest", "", "(Ljava/io/File;J[B)V", "getDigest", "()[B", "getFile", "()Ljava/io/File;", "getLastModified", "()J", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "kotlin-daemon"})
    private static final class FileId {
        @NotNull
        private final File file;
        private final long lastModified;
        @NotNull
        private final byte[] digest;

        public FileId(@NotNull File file, long lastModified, @NotNull byte[] digest) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)digest, (String)"digest");
            this.file = file;
            this.lastModified = lastModified;
            this.digest = digest;
        }

        @NotNull
        public final File getFile() {
            return this.file;
        }

        public final long getLastModified() {
            return this.lastModified;
        }

        @NotNull
        public final byte[] getDigest() {
            return this.digest;
        }

        @NotNull
        public final File component1() {
            return this.file;
        }

        public final long component2() {
            return this.lastModified;
        }

        @NotNull
        public final byte[] component3() {
            return this.digest;
        }

        @NotNull
        public final FileId copy(@NotNull File file, long lastModified, @NotNull byte[] digest) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)digest, (String)"digest");
            return new FileId(file, lastModified, digest);
        }

        public static /* synthetic */ FileId copy$default(FileId fileId, File file, long l, byte[] byArray, int n, Object object) {
            if ((n & 1) != 0) {
                file = fileId.file;
            }
            if ((n & 2) != 0) {
                l = fileId.lastModified;
            }
            if ((n & 4) != 0) {
                byArray = fileId.digest;
            }
            return fileId.copy(file, l, byArray);
        }

        @NotNull
        public String toString() {
            return "FileId(file=" + this.file + ", lastModified=" + this.lastModified + ", digest=" + Arrays.toString(this.digest) + ')';
        }

        public int hashCode() {
            int result = this.file.hashCode();
            result = result * 31 + Long.hashCode(this.lastModified);
            result = result * 31 + Arrays.hashCode(this.digest);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FileId)) {
                return false;
            }
            FileId fileId = (FileId)other;
            if (!Intrinsics.areEqual((Object)this.file, (Object)fileId.file)) {
                return false;
            }
            if (this.lastModified != fileId.lastModified) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.digest, (Object)fileId.digest);
        }
    }
}

