/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.daemon.report;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.daemon.common.CompilationOptions;
import org.jetbrains.kotlin.daemon.common.CompilerServicesFacadeBase;
import org.jetbrains.kotlin.daemon.common.ReportCategory;
import org.jetbrains.kotlin.daemon.common.ReportSeverity;
import org.jetbrains.kotlin.daemon.report.DaemonMessageReporter;
import org.jetbrains.kotlin.daemon.report.DaemonMessageReporterImpl;
import org.jetbrains.kotlin.daemon.report.DummyDaemonMessageReporter;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=2, d1={"\u0000\u0014\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"DaemonMessageReporter", "Lorg/jetbrains/kotlin/daemon/report/DaemonMessageReporter;", "servicesFacade", "Lorg/jetbrains/kotlin/daemon/common/CompilerServicesFacadeBase;", "compilationOptions", "Lorg/jetbrains/kotlin/daemon/common/CompilationOptions;", "kotlin-daemon"})
public final class DaemonMessageReporterKt {
    @NotNull
    public static final DaemonMessageReporter DaemonMessageReporter(@NotNull CompilerServicesFacadeBase servicesFacade, @NotNull CompilationOptions compilationOptions) {
        DaemonMessageReporter daemonMessageReporter;
        Intrinsics.checkNotNullParameter((Object)servicesFacade, (String)"servicesFacade");
        Intrinsics.checkNotNullParameter((Object)compilationOptions, (String)"compilationOptions");
        if (ArraysKt.contains((Object[])compilationOptions.getReportCategories(), (Object)ReportCategory.DAEMON_MESSAGE.getCode())) {
            ReportSeverity reportSeverity = ReportSeverity.Companion.fromCode(compilationOptions.getReportSeverity());
            Intrinsics.checkNotNull((Object)((Object)reportSeverity));
            ReportSeverity mySeverity = reportSeverity;
            daemonMessageReporter = new DaemonMessageReporterImpl(servicesFacade, mySeverity);
        } else {
            daemonMessageReporter = DummyDaemonMessageReporter.INSTANCE;
        }
        return daemonMessageReporter;
    }
}

