/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.daemon;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Timer;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.CLICompiler;
import org.jetbrains.kotlin.cli.common.environment.UtilKt;
import org.jetbrains.kotlin.cli.js.K2JSCompiler;
import org.jetbrains.kotlin.cli.jvm.K2JVMCompiler;
import org.jetbrains.kotlin.cli.jvm.compiler.CompatKt;
import org.jetbrains.kotlin.cli.metadata.K2MetadataCompiler;
import org.jetbrains.kotlin.daemon.CompileServiceImplBase;
import org.jetbrains.kotlin.daemon.CompilerSelector;
import org.jetbrains.kotlin.daemon.KotlinCompileDaemonBase;
import org.jetbrains.kotlin.daemon.KotlinCompileDaemonBase$WhenMappings;
import org.jetbrains.kotlin.daemon.LogStream;
import org.jetbrains.kotlin.daemon.common.CompileService;
import org.jetbrains.kotlin.daemon.common.CompilerId;
import org.jetbrains.kotlin.daemon.common.DaemonJVMOptions;
import org.jetbrains.kotlin.daemon.common.DaemonOptions;
import org.jetbrains.kotlin.daemon.common.DaemonParamsKt;
import org.jetbrains.kotlin.daemon.common.NetworkUtilsKt;
import org.jetbrains.kotlin.daemon.common.OptionsGroup;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u0014J<\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH$J\n\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0002J\u001b\u0010\u001d\u001a\u00020\u000b2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001fH\u0004\u00a2\u0006\u0002\u0010 J\u0012\u0010!\u001a\u0004\u0018\u00010\u00012\u0006\u0010\"\u001a\u00020\u000fH\u0014J!\u0010#\u001a\u0002H$\"\u0004\b\u0000\u0010$2\f\u0010%\u001a\b\u0012\u0004\u0012\u0002H$0&H\u0014\u00a2\u0006\u0002\u0010'R#\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlin/daemon/KotlinCompileDaemonBase;", "", "()V", "log", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "getLog", "()Ljava/util/logging/Logger;", "log$delegate", "Lkotlin/Lazy;", "awaitServerRun", "", "serverRun", "getCompileServiceAndPort", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/daemon/CompileServiceImplBase;", "", "compilerSelector", "Lorg/jetbrains/kotlin/daemon/CompilerSelector;", "compilerId", "Lorg/jetbrains/kotlin/daemon/common/CompilerId;", "daemonOptions", "Lorg/jetbrains/kotlin/daemon/common/DaemonOptions;", "daemonJVMOptions", "Lorg/jetbrains/kotlin/daemon/common/DaemonJVMOptions;", "timer", "Ljava/util/Timer;", "loadVersionFromResource", "", "mainImpl", "args", "", "([Ljava/lang/String;)V", "runCompileService", "compileService", "runSynchronized", "T", "block", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "kotlin-daemon"})
public abstract class KotlinCompileDaemonBase {
    private final Lazy log$delegate;

    public final Logger getLog() {
        Lazy lazy = this.log$delegate;
        KotlinCompileDaemonBase kotlinCompileDaemonBase = this;
        Object var3_3 = null;
        boolean bl = false;
        return (Logger)lazy.getValue();
    }

    private final String loadVersionFromResource() {
        Object object;
        ClassLoader classLoader = KotlinCompileDaemonBase.class.getClassLoader();
        if (!(classLoader instanceof URLClassLoader)) {
            classLoader = null;
        }
        if ((object = (URLClassLoader)classLoader) != null && (object = ((URLClassLoader)object).findResource("META-INF/MANIFEST.MF")) != null) {
            Object object2 = object;
            boolean bl = false;
            boolean bl2 = false;
            Object it = object2;
            boolean bl3 = false;
            try {
                String string = new Manifest(((URL)it).openStream()).getMainAttributes().getValue("Implementation-Version");
                if (string == null) {
                    string = null;
                }
                return string;
            }
            catch (IOException iOException) {
            }
        }
        return null;
    }

    protected <T> T runSynchronized(@NotNull Function0<? extends T> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        return (T)block.invoke();
    }

    @NotNull
    protected abstract Pair<CompileServiceImplBase, Integer> getCompileServiceAndPort(@NotNull CompilerSelector var1, @NotNull CompilerId var2, @NotNull DaemonOptions var3, @NotNull DaemonJVMOptions var4, @NotNull Timer var5);

    @Nullable
    protected Object runCompileService(@NotNull CompileServiceImplBase compileService) {
        Intrinsics.checkNotNullParameter((Object)compileService, (String)"compileService");
        return null;
    }

    protected void awaitServerRun(@Nullable Object serverRun) {
    }

    protected final void mainImpl(@NotNull String[] args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        NetworkUtilsKt.ensureServerHostnameIsSetUp();
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        Intrinsics.checkNotNullExpressionValue((Object)runtimeMXBean, (String)"ManagementFactory.getRuntimeMXBean()");
        List<String> jvmArguments = runtimeMXBean.getInputArguments();
        Logger logger = this.getLog();
        StringBuilder stringBuilder = new StringBuilder().append("Kotlin compiler daemon version ");
        String string = this.loadVersionFromResource();
        if (string == null) {
            string = "<unknown>";
        }
        logger.info(stringBuilder.append(string).toString());
        Logger logger2 = this.getLog();
        StringBuilder stringBuilder2 = new StringBuilder().append("daemon JVM args: ");
        List<String> list = jvmArguments;
        Intrinsics.checkNotNullExpressionValue(list, (String)"jvmArguments");
        logger2.info(stringBuilder2.append(CollectionsKt.joinToString$default((Iterable)list, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null)).toString());
        this.getLog().info("daemon args: " + ArraysKt.joinToString$default((Object[])args, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null));
        UtilKt.setIdeaIoUseFallback();
        CompatKt.setupIdeaStandaloneExecution();
        CompilerId compilerId = new CompilerId(null, null, 3, null);
        DaemonOptions daemonOptions = new DaemonOptions(null, 0L, 0, 0, 0L, 0L, false, false, 255, null);
        this.runSynchronized((Function0)new Function0<Unit>(this, args, compilerId, daemonOptions){
            final /* synthetic */ KotlinCompileDaemonBase this$0;
            final /* synthetic */ String[] $args;
            final /* synthetic */ CompilerId $compilerId;
            final /* synthetic */ DaemonOptions $daemonOptions;

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                Object serverRun = null;
                try {
                    void compilerService;
                    String[] stringArray = new String[]{};
                    boolean bl = true;
                    boolean bl2 = true;
                    boolean bl3 = true;
                    DaemonJVMOptions daemonJVMOptions = DaemonParamsKt.configureDaemonJVMOptions(stringArray, bl3, bl2, bl);
                    Iterable<String> filteredArgs = DaemonParamsKt.filterExtractProps(ArraysKt.asIterable((Object[])this.$args), new OptionsGroup[]{this.$compilerId, this.$daemonOptions}, DaemonParamsKt.getCOMPILE_DAEMON_CMDLINE_OPTIONS_PREFIX());
                    if (CollectionsKt.any(filteredArgs)) {
                        String helpLine = "usage: <daemon> <compilerId options> <daemon options>";
                        this.this$0.getLog().info(helpLine);
                        bl2 = false;
                        System.out.println((Object)helpLine);
                        throw (Throwable)new IllegalArgumentException("Unknown arguments: " + CollectionsKt.joinToString$default(filteredArgs, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null));
                    }
                    this.this$0.getLog().info("starting daemon");
                    CompilerSelector compilerSelector2 = new CompilerSelector(){
                        private final Lazy jvm$delegate;
                        private final Lazy js$delegate;
                        private final Lazy metadata$delegate;

                        private final K2JVMCompiler getJvm() {
                            Lazy lazy = this.jvm$delegate;
                            mainImpl.compilerSelector.1 var2_2 = this;
                            Object var3_3 = null;
                            boolean bl = false;
                            return (K2JVMCompiler)lazy.getValue();
                        }

                        private final K2JSCompiler getJs() {
                            Lazy lazy = this.js$delegate;
                            mainImpl.compilerSelector.1 var2_2 = this;
                            Object var3_3 = null;
                            boolean bl = false;
                            return (K2JSCompiler)lazy.getValue();
                        }

                        private final K2MetadataCompiler getMetadata() {
                            Lazy lazy = this.metadata$delegate;
                            mainImpl.compilerSelector.1 var2_2 = this;
                            Object var3_3 = null;
                            boolean bl = false;
                            return (K2MetadataCompiler)lazy.getValue();
                        }

                        @NotNull
                        public CLICompiler<?> get(@NotNull CompileService.TargetPlatform targetPlatform) {
                            CLICompiler cLICompiler;
                            Intrinsics.checkNotNullParameter((Object)targetPlatform, (String)"targetPlatform");
                            switch (KotlinCompileDaemonBase$WhenMappings.$EnumSwitchMapping$0[targetPlatform.ordinal()]) {
                                case 1: {
                                    cLICompiler = (CLICompiler)this.getJvm();
                                    break;
                                }
                                case 2: {
                                    cLICompiler = (CLICompiler)this.getJs();
                                    break;
                                }
                                case 3: {
                                    cLICompiler = (CLICompiler)this.getMetadata();
                                    break;
                                }
                                default: {
                                    throw new NoWhenBranchMatchedException();
                                }
                            }
                            return cLICompiler;
                        }
                        {
                            this.jvm$delegate = LazyKt.lazy((Function0)mainImpl.compilerSelector.jvm.2.INSTANCE);
                            this.js$delegate = LazyKt.lazy((Function0)mainImpl.compilerSelector.js.2.INSTANCE);
                            this.metadata$delegate = LazyKt.lazy((Function0)mainImpl.compilerSelector.metadata.2.INSTANCE);
                        }
                    };
                    Timer timer = new Timer(true);
                    Object object = this.this$0.getCompileServiceAndPort(compilerSelector2, this.$compilerId, this.$daemonOptions, daemonJVMOptions, timer);
                    CompileServiceImplBase compileServiceImplBase = (CompileServiceImplBase)object.component1();
                    int port = ((Number)object.component2()).intValue();
                    compilerService.startDaemonElections();
                    compilerService.configurePeriodicActivities();
                    serverRun = this.this$0.runCompileService((CompileServiceImplBase)compilerService);
                    object = DaemonParamsKt.getCOMPILE_DAEMON_IS_READY_MESSAGE();
                    boolean bl4 = false;
                    System.out.println(object);
                    this.this$0.getLog().info("daemon is listening on port: " + port);
                    System.out.close();
                    System.err.close();
                    System.setErr(new PrintStream(new LogStream("stderr")));
                    System.setOut(new PrintStream(new LogStream("stdout")));
                }
                catch (Exception e) {
                    System.err.println("Exception: " + e.getMessage());
                    e.printStackTrace(System.err);
                    this.this$0.getLog().log(Level.INFO, "Exception: ", e);
                    throw (Throwable)e;
                }
                this.this$0.awaitServerRun(serverRun);
            }
            {
                this.this$0 = kotlinCompileDaemonBase;
                this.$args = stringArray;
                this.$compilerId = compilerId;
                this.$daemonOptions = daemonOptions;
                super(0);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public KotlinCompileDaemonBase() {
        void logPath;
        Pair pair;
        boolean bl;
        String string;
        String string2 = new SimpleDateFormat("yyyy-MM-dd.HH-mm-ss-SSS").format(new Date());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"SimpleDateFormat(\"yyyy-M\u2026m-ss-SSS\").format(Date())");
        String logTime = string2;
        String string3 = System.getProperty(DaemonParamsKt.getCOMPILE_DAEMON_LOG_PATH_PROPERTY());
        if (string3 != null && (string3 = DaemonParamsKt.trimQuotes(string3)) != null) {
            string = string3;
            boolean bl2 = false;
            bl = false;
            String it = string;
            boolean bl3 = false;
            pair = new Pair((Object)it, (Object)new File(it).isFile());
        } else {
            pair = new Pair((Object)"%t", (Object)false);
        }
        Pair pair2 = pair;
        String string4 = (String)pair2.component1();
        boolean fileIsGiven = (Boolean)pair2.component2();
        String cfg = "handlers = java.util.logging.FileHandler\njava.util.logging.FileHandler.level     = ALL\njava.util.logging.FileHandler.formatter = java.util.logging.SimpleFormatter\njava.util.logging.FileHandler.encoding  = UTF-8\n" + "java.util.logging.FileHandler.limit     = " + (fileIsGiven ? 0 : 0x100000) + '\n' + "java.util.logging.FileHandler.count     = " + (fileIsGiven ? 1 : 3) + '\n' + "java.util.logging.FileHandler.append    = " + fileIsGiven + '\n' + "java.util.logging.FileHandler.pattern   = " + (String)(fileIsGiven ? logPath : (String)logPath + File.separator + DaemonParamsKt.getCOMPILE_DAEMON_DEFAULT_FILES_PREFIX() + '.' + logTime + ".%u%g.log") + '\n' + "java.util.logging.SimpleFormatter.format = %1$tF %1$tT.%1$tL [%3$s] %4$s: %5$s%n\n";
        LogManager logManager = LogManager.getLogManager();
        string = cfg;
        Charset charset = Charsets.UTF_8;
        bl = false;
        String string5 = string;
        boolean bl4 = false;
        String string6 = string5;
        if (string6 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string6.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        logManager.readConfiguration(new ByteArrayInputStream(byArray));
        this.log$delegate = LazyKt.lazy((Function0)log.2.INSTANCE);
    }
}

