/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.compiler.plugins.kotlin.analysis;

import androidx.compose.compiler.plugins.kotlin.analysis.FqNameMatcher;
import androidx.compose.compiler.plugins.kotlin.analysis.FqNameMatcherCollection;
import androidx.compose.compiler.plugins.kotlin.analysis.KnownStableConstructs;
import androidx.compose.compiler.plugins.kotlin.analysis.Stability;
import androidx.compose.compiler.plugins.kotlin.analysis.StabilityKt;
import androidx.compose.compiler.plugins.kotlin.analysis.SymbolForAnalysis;
import androidx.compose.compiler.plugins.kotlin.lower.AbstractComposeLoweringKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrTypeUtilsKt;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrScript;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrComposite;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrLocalDelegatedPropertyReference;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeParameterSymbol;
import org.jetbrains.kotlin.ir.types.IrDynamicType;
import org.jetbrains.kotlin.ir.types.IrErrorType;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrStarProjection;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypeProjection;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.InlineClassesKt;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ2\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u00122\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u0005H\u0002J\f\u0010\u0017\u001a\u00020\u0018*\u00020\u0019H\u0002J\f\u0010\u001a\u001a\u00020\u0018*\u00020\u0010H\u0002J\f\u0010\u001b\u001a\u00020\u0018*\u00020\u0010H\u0002J\u0010\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J2\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\u001e2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u00122\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u0005H\u0002J2\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020\u00142\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u00122\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u0005H\u0002J2\u0010\u000b\u001a\u00020\f2\u0006\u0010 \u001a\u00020\u000e2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u00122\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u0005H\u0002J\u0018\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0012*\u00020\"H\u0002J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\fH\u0002J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010#\u001a\u00020&R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Landroidx/compose/compiler/plugins/kotlin/analysis/StabilityInferencer;", "", "currentModule", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "externalStableTypeMatchers", "", "Landroidx/compose/compiler/plugins/kotlin/analysis/FqNameMatcher;", "<init>", "(Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;Ljava/util/Set;)V", "externalTypeMatcherCollection", "Landroidx/compose/compiler/plugins/kotlin/analysis/FqNameMatcherCollection;", "stabilityOf", "Landroidx/compose/compiler/plugins/kotlin/analysis/Stability;", "irType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "substitutions", "", "Lorg/jetbrains/kotlin/ir/symbols/IrTypeParameterSymbol;", "Lorg/jetbrains/kotlin/ir/types/IrTypeArgument;", "currentlyAnalyzing", "Landroidx/compose/compiler/plugins/kotlin/analysis/SymbolForAnalysis;", "isInCurrentModule", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "isProtobufType", "isExternalStableType", "canInferStability", "classifier", "Lorg/jetbrains/kotlin/ir/symbols/IrClassifierSymbol;", "argument", "type", "substitutionMap", "Lorg/jetbrains/kotlin/ir/types/IrSimpleType;", "expr", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "baseStability", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "kotlin-compose-compiler-plugin"})
@SourceDebugExtension(value={"SMAP\nStability.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Stability.kt\nandroidx/compose/compiler/plugins/kotlin/analysis/StabilityInferencer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,479:1\n1585#2:480\n1660#2,3:481\n1605#2:484\n1616#2:485\n1923#2,2:486\n1925#2:489\n1617#2:490\n545#2,6:491\n1585#2:497\n1660#2,3:498\n776#2:501\n872#2,2:502\n1641#2,10:504\n1914#2:514\n1915#2:516\n1651#2:517\n1785#2,3:519\n1#3:488\n1#3:515\n1#3:518\n*S KotlinDebug\n*F\n+ 1 Stability.kt\nandroidx/compose/compiler/plugins/kotlin/analysis/StabilityInferencer\n*L\n214#1:480\n214#1:481,3\n264#1:484\n264#1:485\n264#1:486,2\n264#1:489\n264#1:490\n316#1:491,6\n421#1:497\n421#1:498,3\n423#1:501\n423#1:502,2\n436#1:504,10\n436#1:514\n436#1:516\n436#1:517\n468#1:519,3\n264#1:488\n436#1:515\n*E\n"})
public final class StabilityInferencer {
    @NotNull
    private final ModuleDescriptor currentModule;
    @NotNull
    private final FqNameMatcherCollection externalTypeMatcherCollection;

    public StabilityInferencer(@NotNull ModuleDescriptor currentModule, @NotNull Set<FqNameMatcher> externalStableTypeMatchers) {
        Intrinsics.checkNotNullParameter((Object)currentModule, (String)"currentModule");
        Intrinsics.checkNotNullParameter(externalStableTypeMatchers, (String)"externalStableTypeMatchers");
        this.currentModule = currentModule;
        this.externalTypeMatcherCollection = new FqNameMatcherCollection(externalStableTypeMatchers);
    }

    @NotNull
    public final Stability stabilityOf(@NotNull IrType irType) {
        Intrinsics.checkNotNullParameter((Object)irType, (String)"irType");
        return this.stabilityOf(irType, (Map<IrTypeParameterSymbol, ? extends IrTypeArgument>)MapsKt.emptyMap(), (Set<SymbolForAnalysis>)SetsKt.emptySet());
    }

    /*
     * WARNING - void declaration
     */
    private final Stability stabilityOf(IrClass declaration, Map<IrTypeParameterSymbol, ? extends IrTypeArgument> substitutions, Set<SymbolForAnalysis> currentlyAnalyzing) {
        Stability stability;
        block25: {
            Object object;
            void $this$mapTo$iv$iv;
            IrClassSymbol symbol = declaration.getSymbol();
            Iterable $this$map$iv = declaration.getTypeParameters();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                IrTypeParameter irTypeParameter = (IrTypeParameter)item$iv$iv;
                object = destination$iv$iv;
                boolean bl = false;
                object.add(substitutions.get(it.getSymbol()));
            }
            List typeArguments = (List)destination$iv$iv;
            SymbolForAnalysis fullSymbol = new SymbolForAnalysis((IrClassifierSymbol)symbol, typeArguments);
            if (currentlyAnalyzing.contains(fullSymbol)) {
                return Stability.Companion.getUnstable();
            }
            if (StabilityKt.access$hasStableMarkedDescendant(declaration)) {
                return Stability.Companion.getStable();
            }
            if (IrUtilsKt.isEnumClass((IrClass)declaration) || IrUtilsKt.isEnumEntry((IrClass)declaration)) {
                return Stability.Companion.getStable();
            }
            if (IrTypePredicatesKt.isPrimitiveType$default((IrType)((IrType)IrUtilsKt.getDefaultType((IrClass)declaration)), (boolean)false, (int)1, null)) {
                return Stability.Companion.getStable();
            }
            if (this.isProtobufType(declaration)) {
                return Stability.Companion.getStable();
            }
            if (Intrinsics.areEqual((Object)declaration.getOrigin(), (Object)IrDeclarationOrigin.Companion.getIR_BUILTINS_STUB())) {
                throw new IllegalStateException(("Builtins Stub: " + declaration.getName()).toString());
            }
            Set analyzing = SetsKt.plus(currentlyAnalyzing, (Object)fullSymbol);
            if (this.canInferStability(declaration) || this.isExternalStableType(declaration)) {
                Stability stability2;
                Object object2 = IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)((IrDeclarationWithName)declaration));
                if (object2 == null || (object2 = object2.toString()) == null) {
                    object2 = "";
                }
                Object fqName = object2;
                List typeParameters = declaration.getTypeParameters();
                Stability stability3 = null;
                int mask = 0;
                if (KnownStableConstructs.INSTANCE.getStableTypes().containsKey(fqName)) {
                    Integer n = KnownStableConstructs.INSTANCE.getStableTypes().get(fqName);
                    mask = n != null ? n : 0;
                    stability3 = Stability.Companion.getStable();
                } else if (this.isExternalStableType(declaration)) {
                    Integer n = this.externalTypeMatcherCollection.maskForName(IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)((IrDeclarationWithName)declaration)));
                    mask = n != null ? n : 0;
                    stability3 = Stability.Companion.getStable();
                } else {
                    if (IrUtilsKt.isInterface((IrClass)declaration) && this.isInCurrentModule((IrDeclaration)declaration)) {
                        return new Stability.Unknown(declaration);
                    }
                    Integer n = StabilityKt.access$stabilityParamBitmask((IrAnnotationContainer)declaration);
                    if (n == null) {
                        return Stability.Companion.getUnstable();
                    }
                    int bitmask = n;
                    int knownStableMask = typeParameters.size() < 32 ? 1 << typeParameters.size() : 0;
                    boolean isKnownStable = (bitmask & knownStableMask) != 0;
                    mask = bitmask & ~knownStableMask;
                    stability3 = isKnownStable && this.isInCurrentModule((IrDeclaration)declaration) ? Stability.Companion.getStable() : (Stability)new Stability.Runtime(declaration);
                }
                if (mask == 0 || typeParameters.isEmpty()) {
                    stability2 = stability3;
                } else {
                    void $this$mapIndexedNotNullTo$iv$iv;
                    void $this$mapIndexedNotNull$iv;
                    Iterable bitmask = typeParameters;
                    object = stability3;
                    boolean $i$f$mapIndexedNotNull = false;
                    void isKnownStable = $this$mapIndexedNotNull$iv;
                    Collection destination$iv$iv2 = new ArrayList();
                    boolean $i$f$mapIndexedNotNullTo = false;
                    void $this$forEachIndexed$iv$iv$iv = $this$mapIndexedNotNullTo$iv$iv;
                    boolean $i$f$forEachIndexed = false;
                    int index$iv$iv$iv = 0;
                    for (Object item$iv$iv$iv : $this$forEachIndexed$iv$iv$iv) {
                        Stability it$iv$iv;
                        void irTypeParameter;
                        IrTypeArgument sub;
                        void element$iv$iv;
                        int n;
                        if ((n = index$iv$iv$iv++) < 0) {
                            CollectionsKt.throwIndexOverflow();
                        }
                        Object t = item$iv$iv$iv;
                        int index$iv$iv = n;
                        boolean bl = false;
                        IrTypeParameter irTypeParameter2 = (IrTypeParameter)element$iv$iv;
                        int index = index$iv$iv;
                        boolean bl2 = false;
                        if ((index >= 32 ? null : ((mask & 1 << index) != 0 ? ((sub = substitutions.get(irTypeParameter.getSymbol())) != null ? this.stabilityOf(sub, substitutions, (Set<SymbolForAnalysis>)analyzing) : (Stability)new Stability.Parameter((IrTypeParameter)irTypeParameter)) : null)) == null) continue;
                        it$iv$iv = it$iv$iv;
                        boolean bl3 = false;
                        destination$iv$iv2.add(it$iv$iv);
                    }
                    List list = (List)destination$iv$iv2;
                    stability2 = ((Stability)object).plus(new Stability.Combined(list));
                }
                return stability2;
            }
            if (Intrinsics.areEqual((Object)declaration.getOrigin(), (Object)IrDeclarationOrigin.Companion.getIR_EXTERNAL_JAVA_DECLARATION_STUB())) {
                return Stability.Companion.getUnstable();
            }
            if (IrUtilsKt.isInterface((IrClass)declaration)) {
                return new Stability.Unknown(declaration);
            }
            stability = null;
            stability = Stability.Companion.getStable();
            for (IrDeclaration member : declaration.getDeclarations()) {
                IrDeclaration mask = member;
                if (mask instanceof IrProperty) {
                    if (((IrProperty)member).getBackingField() != null) {
                        IrField it;
                        boolean bl = false;
                        if (((IrProperty)member).isVar() && !((IrProperty)member).isDelegated()) {
                            return Stability.Companion.getUnstable();
                        }
                        stability = stability.plus(this.stabilityOf(it.getType(), substitutions, (Set<SymbolForAnalysis>)analyzing));
                    }
                    continue;
                }
                if (!(mask instanceof IrField)) continue;
                stability = stability.plus(this.stabilityOf(((IrField)member).getType(), substitutions, (Set<SymbolForAnalysis>)analyzing));
            }
            IrClass irClass = IrUtilsKt.getSuperClass((IrClass)declaration);
            if (irClass == null) break block25;
            IrClass it = irClass;
            boolean bl = false;
            stability = stability.plus(this.stabilityOf(it, substitutions, (Set<SymbolForAnalysis>)analyzing));
        }
        return stability;
    }

    private final boolean isInCurrentModule(IrDeclaration $this$isInCurrentModule) {
        return Intrinsics.areEqual((Object)AdditionalIrUtilsKt.getModule((IrDeclaration)$this$isInCurrentModule), (Object)this.currentModule);
    }

    private final boolean isProtobufType(IrClass $this$isProtobufType) {
        FqName fqName;
        IrClass irClass;
        IrClassSymbol irClassSymbol;
        Object v0;
        block2: {
            if (!IrUtilsKt.isFinalClass((IrClass)$this$isProtobufType)) {
                return false;
            }
            List $this$lastOrNull$iv = $this$isProtobufType.getSuperTypes();
            boolean $i$f$lastOrNull = false;
            ListIterator iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
            while (iterator$iv.hasPrevious()) {
                Object element$iv = iterator$iv.previous();
                IrType it = (IrType)element$iv;
                boolean bl = false;
                if (!(!IrTypeUtilsKt.isInterface((IrType)it))) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        IrType irType = v0;
        String directParentClassName = irType != null && (irClassSymbol = IrTypesKt.getClassOrNull((IrType)irType)) != null && (irClass = (IrClass)irClassSymbol.getOwner()) != null && (fqName = IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)((IrDeclarationWithName)irClass))) != null ? fqName.toString() : null;
        return Intrinsics.areEqual(directParentClassName, (Object)"com.google.protobuf.GeneratedMessageLite") || Intrinsics.areEqual(directParentClassName, (Object)"com.google.protobuf.GeneratedMessage");
    }

    private final boolean isExternalStableType(IrClass $this$isExternalStableType) {
        return this.externalTypeMatcherCollection.matches(IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)((IrDeclarationWithName)$this$isExternalStableType)), $this$isExternalStableType.getSuperTypes());
    }

    private final boolean canInferStability(IrClass declaration) {
        Object object = IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)((IrDeclarationWithName)declaration));
        if (object == null || (object = object.toString()) == null) {
            object = "";
        }
        Object fqName = object;
        return KnownStableConstructs.INSTANCE.getStableTypes().containsKey(fqName) || Intrinsics.areEqual((Object)declaration.getOrigin(), (Object)IrDeclarationOrigin.Companion.getIR_EXTERNAL_DECLARATION_STUB());
    }

    private final Stability stabilityOf(IrClassifierSymbol classifier, Map<IrTypeParameterSymbol, ? extends IrTypeArgument> substitutions, Set<SymbolForAnalysis> currentlyAnalyzing) {
        Stability stability;
        IrSymbolOwner owner = classifier.getOwner();
        if (owner instanceof IrClass) {
            stability = this.stabilityOf((IrClass)owner, substitutions, currentlyAnalyzing);
        } else if (owner instanceof IrTypeParameter) {
            stability = Stability.Companion.getUnstable();
        } else if (owner instanceof IrScript) {
            stability = Stability.Companion.getStable();
        } else {
            throw new IllegalStateException(("Unexpected IrClassifier: " + owner).toString());
        }
        return stability;
    }

    private final Stability stabilityOf(IrTypeArgument argument, Map<IrTypeParameterSymbol, ? extends IrTypeArgument> substitutions, Set<SymbolForAnalysis> currentlyAnalyzing) {
        Stability stability;
        IrTypeArgument irTypeArgument = argument;
        if (irTypeArgument instanceof IrStarProjection) {
            stability = Stability.Companion.getUnstable();
        } else if (irTypeArgument instanceof IrTypeProjection) {
            stability = this.stabilityOf(((IrTypeProjection)argument).getType(), substitutions, currentlyAnalyzing);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return stability;
    }

    private final Stability stabilityOf(IrType type, Map<IrTypeParameterSymbol, ? extends IrTypeArgument> substitutions, Set<SymbolForAnalysis> currentlyAnalyzing) {
        Stability stability;
        if (type instanceof IrErrorType) {
            stability = Stability.Companion.getUnstable();
        } else if (type instanceof IrDynamicType) {
            stability = Stability.Companion.getUnstable();
        } else if (IrTypePredicatesKt.isUnit((IrType)type) || IrTypePredicatesKt.isPrimitiveType$default((IrType)type, (boolean)false, (int)1, null) || IrTypeUtilsKt.isFunctionOrKFunction((IrType)type) || AbstractComposeLoweringKt.isSyntheticComposableFunction(type) || IrTypePredicatesKt.isString((IrType)type)) {
            stability = Stability.Companion.getStable();
        } else if (IrTypeUtilsKt.isTypeParameter((IrType)type)) {
            IrClassifierSymbol classifier = IrTypesKt.getClassifierOrFail((IrType)type);
            IrTypeArgument arg = substitutions.get(classifier);
            SymbolForAnalysis symbol = new SymbolForAnalysis(classifier, CollectionsKt.emptyList());
            if (arg != null && !currentlyAnalyzing.contains(symbol)) {
                stability = this.stabilityOf(arg, substitutions, (Set<SymbolForAnalysis>)SetsKt.plus(currentlyAnalyzing, (Object)symbol));
            } else {
                IrSymbolOwner irSymbolOwner = classifier.getOwner();
                Intrinsics.checkNotNull((Object)irSymbolOwner, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrTypeParameter");
                stability = new Stability.Parameter((IrTypeParameter)irSymbolOwner);
            }
        } else if (IrTypeUtilsKt.isNullable((IrType)type)) {
            stability = this.stabilityOf(IrTypesKt.makeNotNull((IrType)type), substitutions, currentlyAnalyzing);
        } else if (JvmIrTypeUtilsKt.isInlineClassType((IrType)type)) {
            IrClass irClass = IrTypesKt.getClass((IrType)type);
            if (irClass == null) {
                throw new IllegalStateException(("Failed to resolve the class definition of inline type " + type).toString());
            }
            IrClass inlineClassDeclaration = irClass;
            stability = StabilityKt.hasStableMarker((IrAnnotationContainer)inlineClassDeclaration) ? Stability.Companion.getStable() : this.stabilityOf((IrType)InlineClassesKt.getInlineClassUnderlyingType((IrClass)inlineClassDeclaration), substitutions, currentlyAnalyzing);
        } else if (type instanceof IrSimpleType) {
            stability = this.stabilityOf(((IrSimpleType)type).getClassifier(), (Map<IrTypeParameterSymbol, ? extends IrTypeArgument>)MapsKt.plus(substitutions, this.substitutionMap((IrSimpleType)type)), currentlyAnalyzing);
        } else {
            throw new IllegalStateException(("Unexpected IrType: " + type).toString());
        }
        return stability;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<IrTypeParameterSymbol, IrTypeArgument> substitutionMap(IrSimpleType $this$substitutionMap) {
        void $this$filterTo$iv$iv;
        void $this$mapTo$iv$iv;
        IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull((IrType)((IrType)$this$substitutionMap));
        if (irClassSymbol == null) {
            return MapsKt.emptyMap();
        }
        IrClassSymbol cls = irClassSymbol;
        Iterable $this$map$iv = ((IrClass)cls.getOwner()).getTypeParameters();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IrTypeParameter irTypeParameter = (IrTypeParameter)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getSymbol());
        }
        List params = (List)destination$iv$iv;
        List args = $this$substitutionMap.getArguments();
        Iterable $this$filter$iv = CollectionsKt.zip((Iterable)params, (Iterable)args);
        boolean $i$f$filter = false;
        destination$iv$iv = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Pair pair = (Pair)element$iv$iv;
            boolean bl = false;
            IrTypeParameterSymbol param = (IrTypeParameterSymbol)pair.component1();
            IrTypeArgument arg = (IrTypeArgument)pair.component2();
            IrSimpleType irSimpleType = arg instanceof IrSimpleType ? (IrSimpleType)arg : null;
            if (!(!Intrinsics.areEqual((Object)param, (Object)(irSimpleType != null ? irSimpleType.getClassifier() : null)))) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv2));
    }

    /*
     * WARNING - void declaration
     */
    private final Stability stabilityOf(IrCall expr, Stability baseStability) {
        Stability stability;
        IrSimpleFunction function = (IrSimpleFunction)expr.getSymbol().getOwner();
        FqName fqName = AdditionalIrUtilsKt.getKotlinFqName((IrDeclarationParent)((IrDeclarationParent)function));
        Integer mask = KnownStableConstructs.INSTANCE.getStableFunctions().get(fqName.asString());
        if (mask == null) {
            stability = baseStability;
        } else if (mask == 0) {
            stability = Stability.Companion.getStable();
        } else {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = (Iterable)CollectionsKt.getIndices((Collection)expr.getTypeArguments());
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                Stability it$iv$iv;
                IrType sub;
                int element$iv$iv$iv;
                int element$iv$iv = element$iv$iv$iv = ((IntIterator)iterator).nextInt();
                boolean bl = false;
                int index = element$iv$iv;
                boolean bl2 = false;
                if (((mask & 1 << index) != 0 ? ((sub = (IrType)expr.getTypeArguments().get(index)) != null ? this.stabilityOf(sub) : Stability.Companion.getUnstable()) : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List list = (List)destination$iv$iv;
            stability = new Stability.Combined(list);
        }
        return stability;
    }

    @NotNull
    public final Stability stabilityOf(@NotNull IrExpression expr) {
        Stability stability;
        block12: {
            IrExpression irExpression;
            Stability stability2;
            block14: {
                block15: {
                    block16: {
                        block13: {
                            block11: {
                                Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
                                stability2 = this.stabilityOf(expr.getType());
                                if (StabilityKt.knownStable(stability2)) {
                                    return stability2;
                                }
                                irExpression = expr;
                                if (!(irExpression instanceof IrConst)) break block11;
                                stability = Stability.Companion.getStable();
                                break block12;
                            }
                            if (!(irExpression instanceof IrCall)) break block13;
                            stability = this.stabilityOf((IrCall)expr, stability2);
                            break block12;
                        }
                        if (!(irExpression instanceof IrGetValue)) break block14;
                        IrValueDeclaration owner = ((IrGetValue)expr).getSymbol().getOwner();
                        if (!(owner instanceof IrVariable) || ((IrVariable)owner).isVar()) break block15;
                        stability = ((IrVariable)owner).getInitializer();
                        if (stability == null) break block16;
                        Stability it = stability;
                        boolean bl = false;
                        Stability stability3 = this.stabilityOf((IrExpression)it);
                        stability = stability3;
                        if (stability3 != null) break block12;
                    }
                    stability = stability2;
                    break block12;
                }
                stability = stability2;
                break block12;
            }
            if (irExpression instanceof IrLocalDelegatedPropertyReference) {
                stability = Stability.Companion.getStable();
            } else if (irExpression instanceof IrComposite) {
                boolean bl;
                block10: {
                    Iterable $this$all$iv = ((IrComposite)expr).getStatements();
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$all$iv) {
                            IrStatement it = (IrStatement)element$iv;
                            boolean bl2 = false;
                            if (it instanceof IrExpression && StabilityKt.knownStable(this.stabilityOf((IrExpression)it))) continue;
                            bl = false;
                            break block10;
                        }
                        bl = true;
                    }
                }
                stability = bl ? Stability.Companion.getStable() : stability2;
            } else {
                stability = stability2;
            }
        }
        return stability;
    }
}

