/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.compiler.plugins.kotlin.k2;

import androidx.compose.compiler.plugins.kotlin.inference.LazyScheme;
import androidx.compose.compiler.plugins.kotlin.k2.ComposableTargetCheckerKt;
import androidx.compose.compiler.plugins.kotlin.k2.FirElementInferenceNode;
import androidx.compose.compiler.plugins.kotlin.k2.FirFunctionInferenceNode;
import androidx.compose.compiler.plugins.kotlin.k2.FirInferenceNode;
import androidx.compose.compiler.plugins.kotlin.k2.FirLambdaInferenceNode;
import androidx.compose.compiler.plugins.kotlin.k2.FirSamInferenceNode;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.caches.FirCache;
import org.jetbrains.kotlin.fir.caches.FirCachesFactoryKt;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.expressions.FirAnonymousFunctionExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirSamConversionExpression;
import org.jetbrains.kotlin.fir.extensions.FirExtensionSessionComponent;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0013\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0014\u001a\u00020\bJ\u0016\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\tJ\u0010\u0010\u0018\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0014\u001a\u00020\bJ\u0016\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\bJ\u0010\u0010\u001a\u001a\u0004\u0018\u00010\b2\u0006\u0010\u001b\u001a\u00020\fJ\u0018\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u0010H\u0002R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001e"}, d2={"Landroidx/compose/compiler/plugins/kotlin/k2/ComposableTargetSessionStorage;", "Lorg/jetbrains/kotlin/fir/extensions/FirExtensionSessionComponent;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "<init>", "(Lorg/jetbrains/kotlin/fir/FirSession;)V", "schemes", "Ljava/util/concurrent/ConcurrentHashMap;", "Lorg/jetbrains/kotlin/fir/FirElement;", "Landroidx/compose/compiler/plugins/kotlin/inference/LazyScheme;", "parent", "lambdaToExpression", "Lorg/jetbrains/kotlin/fir/declarations/FirAnonymousFunction;", "nodeCache", "Lorg/jetbrains/kotlin/fir/caches/FirCache;", "Landroidx/compose/compiler/plugins/kotlin/k2/FirInferenceNode;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "getNodeCache", "()Lorg/jetbrains/kotlin/fir/caches/FirCache;", "getLazyScheme", "element", "storeLazyScheme", "", "value", "getParent", "storeParent", "getLambdaExpression", "function", "inferenceNodeOf", "context", "kotlin-compose-compiler-plugin"})
public final class ComposableTargetSessionStorage
extends FirExtensionSessionComponent {
    @NotNull
    private final ConcurrentHashMap<FirElement, LazyScheme> schemes;
    @NotNull
    private final ConcurrentHashMap<FirElement, FirElement> parent;
    @NotNull
    private final ConcurrentHashMap<FirAnonymousFunction, FirElement> lambdaToExpression;
    @NotNull
    private final FirCache<FirElement, FirInferenceNode, CheckerContext> nodeCache;

    public ComposableTargetSessionStorage(@NotNull FirSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        super(session);
        this.schemes = new ConcurrentHashMap();
        this.parent = new ConcurrentHashMap();
        this.lambdaToExpression = new ConcurrentHashMap();
        this.nodeCache = FirCachesFactoryKt.getFirCachesFactory((FirSession)session).createCache((arg_0, arg_1) -> ComposableTargetSessionStorage.nodeCache$lambda$0(this, arg_0, arg_1));
    }

    @NotNull
    public final FirCache<FirElement, FirInferenceNode, CheckerContext> getNodeCache() {
        return this.nodeCache;
    }

    @Nullable
    public final LazyScheme getLazyScheme(@NotNull FirElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return this.schemes.get(element);
    }

    public final void storeLazyScheme(@NotNull FirElement element, @NotNull LazyScheme value) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        ((Map)this.schemes).put(element, value);
    }

    @Nullable
    public final FirElement getParent(@NotNull FirElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return this.parent.get(element);
    }

    public final void storeParent(@NotNull FirElement element, @NotNull FirElement parent) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        ((Map)this.parent).put(element, parent);
    }

    @Nullable
    public final FirElement getLambdaExpression(@NotNull FirAnonymousFunction function) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        return this.lambdaToExpression.get(function);
    }

    private final FirInferenceNode inferenceNodeOf(FirElement element, CheckerContext context) {
        FirInferenceNode firInferenceNode;
        FirElement firElement = element;
        if (firElement instanceof FirAnonymousFunctionExpression) {
            ComposableTargetSessionStorage $this$inferenceNodeOf_u24lambda_u241 = this;
            boolean bl = false;
            ((Map)$this$inferenceNodeOf_u24lambda_u241.lambdaToExpression).put(((FirAnonymousFunctionExpression)element).getAnonymousFunction(), element);
            firInferenceNode = new FirLambdaInferenceNode((FirAnonymousFunctionExpression)element);
        } else if (firElement instanceof FirSamConversionExpression) {
            ComposableTargetSessionStorage $this$inferenceNodeOf_u24lambda_u243 = this;
            boolean bl = false;
            FirExpression firExpression = ((FirSamConversionExpression)element).getExpression();
            FirAnonymousFunctionExpression firAnonymousFunctionExpression = firExpression instanceof FirAnonymousFunctionExpression ? (FirAnonymousFunctionExpression)firExpression : null;
            if (firAnonymousFunctionExpression != null) {
                FirAnonymousFunctionExpression it = firAnonymousFunctionExpression;
                boolean bl2 = false;
                ((Map)$this$inferenceNodeOf_u24lambda_u243.lambdaToExpression).put(it.getAnonymousFunction(), element);
            }
            firInferenceNode = new FirSamInferenceNode((FirSamConversionExpression)element);
        } else if (firElement instanceof FirAnonymousFunction) {
            firInferenceNode = ComposableTargetCheckerKt.access$callableInferenceNodeOf(element, (FirCallableSymbol)((FirAnonymousFunction)element).getSymbol(), context);
        } else if (firElement instanceof FirFunction) {
            firInferenceNode = new FirFunctionInferenceNode((FirFunction)element);
        } else {
            firInferenceNode = ComposableTargetCheckerKt.access$parameterInferenceNodeOrNull(element, context);
            if (firInferenceNode == null) {
                firInferenceNode = new FirElementInferenceNode(element);
            }
        }
        return firInferenceNode;
    }

    private static final FirInferenceNode nodeCache$lambda$0(ComposableTargetSessionStorage this$0, FirElement element, CheckerContext context) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this$0.inferenceNodeOf(element, context);
    }
}

