/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.javac.resolve;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.tree.JCTree;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.javac.JavacWrapper;
import org.jetbrains.kotlin.javac.resolve.CurrentClassAndInnerFieldScope;
import org.jetbrains.kotlin.javac.resolve.MockKotlinClassifier;
import org.jetbrains.kotlin.load.java.structure.JavaClass;
import org.jetbrains.kotlin.load.java.structure.JavaClassifier;
import org.jetbrains.kotlin.load.java.structure.JavaField;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/javac/resolve/IdentifierResolver;", "", "javac", "Lorg/jetbrains/kotlin/javac/JavacWrapper;", "<init>", "(Lorg/jetbrains/kotlin/javac/JavacWrapper;)V", "resolve", "Lorg/jetbrains/kotlin/load/java/structure/JavaField;", "tree", "Lcom/sun/source/tree/Tree;", "compilationUnit", "Lcom/sun/source/tree/CompilationUnitTree;", "containingClass", "Lorg/jetbrains/kotlin/load/java/structure/JavaClass;", "javac-wrapper"})
public final class IdentifierResolver {
    @NotNull
    private final JavacWrapper javac;

    public IdentifierResolver(@NotNull JavacWrapper javac2) {
        Intrinsics.checkNotNullParameter((Object)javac2, (String)"javac");
        this.javac = javac2;
    }

    @Nullable
    public final JavaField resolve(@NotNull Tree tree, @NotNull CompilationUnitTree compilationUnit, @NotNull JavaClass containingClass) {
        Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
        Intrinsics.checkNotNullParameter((Object)compilationUnit, (String)"compilationUnit");
        Intrinsics.checkNotNullParameter((Object)containingClass, (String)"containingClass");
        if (tree instanceof JCTree.JCIdent) {
            Name name2 = Name.identifier(((JCTree.JCIdent)tree).name.toString());
            Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
            Name fieldName = name2;
            return new CurrentClassAndInnerFieldScope(this.javac, compilationUnit, null, 4, null).findField(containingClass, fieldName);
        }
        if (tree instanceof JCTree.JCFieldAccess) {
            JCTree.JCExpression jCExpression = ((JCTree.JCFieldAccess)tree).selected;
            Intrinsics.checkNotNullExpressionValue((Object)jCExpression, (String)"selected");
            JavaClassifier javaClassifier = this.javac.resolve(jCExpression, compilationUnit, containingClass);
            JavaClass javaClass = javaClassifier instanceof JavaClass ? (JavaClass)javaClassifier : null;
            if (javaClass == null) {
                return null;
            }
            JavaClass javaClass2 = javaClass;
            if (javaClass2 instanceof MockKotlinClassifier) {
                MockKotlinClassifier mockKotlinClassifier = (MockKotlinClassifier)javaClass2;
                String string = ((JCTree.JCFieldAccess)tree).name.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                return mockKotlinClassifier.findField(string);
            }
            Name name3 = Name.identifier(((JCTree.JCFieldAccess)tree).name.toString());
            Intrinsics.checkNotNullExpressionValue((Object)name3, (String)"identifier(...)");
            Name fieldName = name3;
            return new CurrentClassAndInnerFieldScope(this.javac, compilationUnit, null).findField(javaClass2, fieldName);
        }
        return null;
    }
}

