/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import com.intellij.lang.LighterASTNode;
import com.intellij.util.diff.FlyweightCapableTreeStructure;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtLightSourceElement;
import org.jetbrains.kotlin.KtRealSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.KtSourceElementKind;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirFunctionTypeParameter;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.LanguageVersionUtilsKt;
import org.jetbrains.kotlin.fir.SessionHolder;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirInconsistentTypeParameterHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirTypeRefSource;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirField;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeAliasSymbol;
import org.jetbrains.kotlin.fir.types.AbbreviatedTypeAttributeKt;
import org.jetbrains.kotlin.fir.types.CompilerConeAttributesKt;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeDynamicType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirFunctionTypeRef;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.kotlin.util.LightTreeUtilsKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ-\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\u0011J;\u0010\u0012\u001a\u00020\u00072\f\u0010\u0013\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00142\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u00020\nR\u00020\bj\u0006\u0010\u000b\u001a\u00020\nj\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\u0015J5\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u00020\nR\u00020\bj\u0006\u0010\u000b\u001a\u00020\nj\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\u001aJ=\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u00020\nR\u00020\bj\u0006\u0010\u000b\u001a\u00020\nj\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\u001dJ-\u0010\u001e\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0002R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ-\u0010\u001f\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\u0011J\u000e\u0010 \u001a\u0004\u0018\u00010!*\u00020\"H\u0002J-\u0010#\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0002R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\r\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirSupertypesChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirClassChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "declaration", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirClass;)V", "checkAnnotationOnSuperclass", "superTypeRef", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/types/FirTypeRef;)V", "checkClassCannotBeExtendedDirectly", "symbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassifierSymbol;", "(Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassifierSymbol;Lorg/jetbrains/kotlin/fir/types/FirTypeRef;)V", "checkProjectionInImmediateArgumentToSupertype", "", "coneType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "(Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;Lorg/jetbrains/kotlin/fir/types/FirTypeRef;)Z", "checkSupertypeOnTypeAliasWithTypeProjection", "fullyExpandedType", "(Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;Lorg/jetbrains/kotlin/fir/types/FirTypeRef;)V", "checkDelegationNotToInterface", "checkNamedFunctionTypeParameter", "findSourceForParameterName", "Lorg/jetbrains/kotlin/KtSourceElement;", "Lorg/jetbrains/kotlin/fir/FirFunctionTypeParameter;", "checkDelegationWithoutPrimaryConstructor", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirSupertypesChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirSupertypesChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirSupertypesChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 6 KtSourceElement.kt\norg/jetbrains/kotlin/KtSourceElementKt\n+ 7 ClassKind.kt\norg/jetbrains/kotlin/descriptors/ClassKindKt\n*L\n1#1,256:1\n1#2:257\n44#3:258\n22#3:271\n13225#4,2:259\n22#5:261\n63#5:268\n35#5:270\n956#6,6:262\n34#7:269\n*S KotlinDebug\n*F\n+ 1 FirSupertypesChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirSupertypesChecker\n*L\n105#1:258\n245#1:271\n179#1:259,2\n192#1:261\n238#1:268\n239#1:270\n226#1:262,6\n238#1:269\n*E\n"})
public final class FirSupertypesChecker
extends FirDeclarationChecker<FirClass> {
    @NotNull
    public static final FirSupertypesChecker INSTANCE = new FirSupertypesChecker();

    private FirSupertypesChecker() {
        super(MppCheckerKind.Platform);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirClass declaration) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        KtSourceElement ktSourceElement = declaration.getSource();
        if ((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind) {
            return;
        }
        boolean isInterface = declaration.getClassKind() == ClassKind.INTERFACE;
        boolean extensionOrContextFunctionSupertypeReported = false;
        boolean interfaceWithSuperclassReported = !isInterface;
        boolean finalSupertypeReported = false;
        boolean singletonInSupertypeReported = false;
        boolean classAppeared = false;
        HashSet superClassSymbols = new HashSet();
        for (FirTypeRef superTypeRef : declaration.getSuperTypeRefs()) {
            boolean allowUsingClassTypeAsInterface;
            if (superTypeRef.getSource() == null) continue;
            KtSourceElement ktSourceElement2 = superTypeRef.getSource();
            if (Intrinsics.areEqual((Object)(ktSourceElement2 != null ? ktSourceElement2.getKind() : null), (Object)KtFakeSourceElementKind.EnumSuperTypeRef.INSTANCE)) continue;
            ConeKotlinType expandedSupertype = TypeExpansionUtilsKt.fullyExpandedType((SessionHolder)context2, FirTypeUtilsKt.getConeType(superTypeRef));
            ConeKotlinType originalSupertype = AbbreviatedTypeAttributeKt.getAbbreviatedTypeOrSelf(expandedSupertype);
            boolean supertypeIsDynamic = originalSupertype instanceof ConeDynamicType;
            if (ConeTypeUtilsKt.isMarkedNullable(originalSupertype)) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)superTypeRef.getSource(), FirErrors.INSTANCE.getNULLABLE_SUPERTYPE(), null, 8, null);
            } else if (ConeTypeUtilsKt.isMarkedNullable(expandedSupertype)) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)superTypeRef.getSource(), FirErrors.INSTANCE.getNULLABLE_SUPERTYPE_THROUGH_TYPEALIAS(), null, 8, null);
            }
            if (!extensionOrContextFunctionSupertypeReported) {
                ConeKotlinType it = TypeExpansionUtilsKt.fullyExpandedType((SessionHolder)context2, originalSupertype);
                boolean bl = false;
                boolean bl2 = CompilerConeAttributesKt.isExtensionFunctionType(it) || CompilerConeAttributesKt.getHasContextParameters(it);
                if (bl2 && !LanguageVersionUtilsKt.isEnabled(context2, LanguageFeature.FunctionalTypeWithExtensionAsSupertype)) {
                    KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)superTypeRef.getSource(), FirErrors.INSTANCE.getSUPERTYPE_IS_EXTENSION_OR_CONTEXT_FUNCTION_TYPE(), null, 8, null);
                    extensionOrContextFunctionSupertypeReported = true;
                }
            }
            this.checkAnnotationOnSuperclass(context2, reporter, superTypeRef);
            FirClassifierSymbol<?> symbol = ToSymbolUtilsKt.toSymbol((SessionHolder)context2, expandedSupertype);
            boolean bl = allowUsingClassTypeAsInterface = FirLanguageSettingsComponentKt.getLanguageVersionSettings(context2.getSession()).supportsFeature(LanguageFeature.AllowAnyAsAnActualTypeForExpectInterface) && ConeBuiltinTypeUtilsKt.isAny(expandedSupertype) && AbbreviatedTypeAttributeKt.getAbbreviatedType(expandedSupertype) != null;
            if (symbol instanceof FirRegularClassSymbol) {
                boolean isObject;
                if (!superClassSymbols.add(symbol)) {
                    KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)superTypeRef.getSource(), FirErrors.INSTANCE.getSUPERTYPE_APPEARS_TWICE(), null, 8, null);
                }
                if (((FirRegularClassSymbol)symbol).getClassKind() != ClassKind.INTERFACE) {
                    if (classAppeared) {
                        if (!allowUsingClassTypeAsInterface) {
                            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)superTypeRef.getSource(), FirErrors.INSTANCE.getMANY_CLASSES_IN_SUPERTYPE_LIST(), null, 8, null);
                        }
                    } else {
                        classAppeared = true;
                    }
                    if (!(interfaceWithSuperclassReported || supertypeIsDynamic || allowUsingClassTypeAsInterface)) {
                        KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)superTypeRef.getSource(), FirErrors.INSTANCE.getINTERFACE_WITH_SUPERCLASS(), null, 8, null);
                        interfaceWithSuperclassReported = true;
                    }
                }
                boolean bl3 = isObject = ((FirRegularClassSymbol)symbol).getClassKind() == ClassKind.OBJECT;
                if (!finalSupertypeReported && !isObject) {
                    FirClassLikeSymbol $this$modality$iv = (FirClassLikeSymbol)symbol;
                    boolean $i$f$getModality = false;
                    if ($this$modality$iv.getResolvedStatus().getModality() == Modality.FINAL && !supertypeIsDynamic) {
                        KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)superTypeRef.getSource(), FirErrors.INSTANCE.getFINAL_SUPERTYPE(), null, 8, null);
                        finalSupertypeReported = true;
                    }
                }
                if (!singletonInSupertypeReported && isObject) {
                    KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)superTypeRef.getSource(), FirErrors.INSTANCE.getSINGLETON_IN_SUPERTYPE(), null, 8, null);
                    singletonInSupertypeReported = true;
                }
            }
            this.checkClassCannotBeExtendedDirectly(reporter, context2, symbol, superTypeRef);
            this.checkNamedFunctionTypeParameter(context2, reporter, superTypeRef);
            if (this.checkProjectionInImmediateArgumentToSupertype(reporter, context2, originalSupertype, superTypeRef)) continue;
            this.checkSupertypeOnTypeAliasWithTypeProjection(reporter, context2, originalSupertype, expandedSupertype, superTypeRef);
        }
        this.checkDelegationNotToInterface(context2, reporter, declaration);
        this.checkDelegationWithoutPrimaryConstructor(context2, reporter, declaration);
        if (declaration.getSuperTypeRefs().size() > 1) {
            FirInconsistentTypeParameterHelpersKt.checkInconsistentTypeParameters(context2, reporter, CollectionsKt.listOf((Object)TuplesKt.to(null, declaration.getSymbol())), declaration.getSource(), true);
        }
    }

    private final void checkAnnotationOnSuperclass(CheckerContext context2, DiagnosticReporter reporter, FirTypeRef superTypeRef) {
        for (FirAnnotation annotation : superTypeRef.getAnnotations()) {
            if (annotation.getUseSiteTarget() == null) continue;
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)annotation.getSource(), FirErrors.INSTANCE.getANNOTATION_ON_SUPERCLASS_ERROR(), null, 8, null);
        }
    }

    private final void checkClassCannotBeExtendedDirectly(DiagnosticReporter reporter, CheckerContext context2, FirClassifierSymbol<?> symbol, FirTypeRef superTypeRef) {
        if (symbol instanceof FirRegularClassSymbol && Intrinsics.areEqual((Object)((FirRegularClassSymbol)symbol).getClassId(), (Object)StandardClassIds.INSTANCE.getEnum())) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)superTypeRef.getSource(), FirErrors.INSTANCE.getCLASS_CANNOT_BE_EXTENDED_DIRECTLY(), symbol, null, 16, null);
        }
    }

    private final boolean checkProjectionInImmediateArgumentToSupertype(DiagnosticReporter reporter, CheckerContext context2, ConeKotlinType coneType, FirTypeRef superTypeRef) {
        List<FirTypeRefSource> list = FirHelpersKt.extractArgumentsTypeRefAndSource(superTypeRef);
        if (list == null) {
            return false;
        }
        List<FirTypeRefSource> typeRefAndSourcesForArguments = list;
        boolean result2 = false;
        ConeTypeProjection[] coneTypeProjectionArray = coneType.getTypeArguments();
        int n2 = coneTypeProjectionArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            int index = i2;
            ConeTypeProjection typeArgument = coneTypeProjectionArray[i2];
            if (!FirHelpersKt.isConflictingOrNotInvariant(typeArgument)) continue;
            FirTypeRefSource firTypeRefSource = (FirTypeRefSource)CollectionsKt.getOrNull(typeRefAndSourcesForArguments, (int)index);
            if (firTypeRefSource == null) continue;
            KtSourceElement argSource = firTypeRefSource.component2();
            DiagnosticContext diagnosticContext2 = context2;
            KtSourceElement ktSourceElement = argSource;
            if (ktSourceElement == null) {
                ktSourceElement = superTypeRef.getSource();
            }
            KtDiagnosticReportHelpersKt.reportOn$default(diagnosticContext2, reporter, (AbstractKtSourceElement)ktSourceElement, FirErrors.INSTANCE.getPROJECTION_IN_IMMEDIATE_ARGUMENT_TO_SUPERTYPE(), null, 8, null);
            result2 = true;
        }
        return result2;
    }

    private final void checkSupertypeOnTypeAliasWithTypeProjection(DiagnosticReporter reporter, CheckerContext context2, ConeKotlinType coneType, ConeKotlinType fullyExpandedType2, FirTypeRef superTypeRef) {
        if (ToSymbolUtilsKt.toSymbol((SessionHolder)context2, coneType) instanceof FirTypeAliasSymbol) {
            boolean bl;
            block3: {
                ConeTypeProjection[] $this$any$iv = fullyExpandedType2.getTypeArguments();
                boolean $i$f$any = false;
                int n2 = $this$any$iv.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    ConeTypeProjection element$iv;
                    ConeTypeProjection it = element$iv = $this$any$iv[i2];
                    boolean bl2 = false;
                    if (!FirHelpersKt.isConflictingOrNotInvariant(it)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
            if (bl) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)superTypeRef.getSource(), FirErrors.INSTANCE.getCONSTRUCTOR_OR_SUPERTYPE_ON_TYPEALIAS_WITH_TYPE_PROJECTION(), null, 8, null);
            }
        }
    }

    private final void checkDelegationNotToInterface(CheckerContext context2, DiagnosticReporter reporter, FirClass declaration) {
        for (FirDeclaration subDeclaration : declaration.getDeclarations()) {
            FirRegularClassSymbol delegatedClassSymbol;
            if (!(subDeclaration instanceof FirField)) continue;
            FirMemberDeclaration $this$visibility$iv = (FirMemberDeclaration)subDeclaration;
            boolean $i$f$getVisibility = false;
            if (!Intrinsics.areEqual((Object)$this$visibility$iv.getStatus().getVisibility(), (Object)Visibilities.Private.INSTANCE) || !FirHelpersKt.isDelegated(((FirField)subDeclaration).getName()) || (delegatedClassSymbol = TypeUtilsKt.toRegularClassSymbol(((FirField)subDeclaration).getReturnTypeRef(), context2.getSession())) == null || delegatedClassSymbol.getClassKind() == ClassKind.INTERFACE) continue;
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)((FirField)subDeclaration).getReturnTypeRef().getSource(), FirErrors.INSTANCE.getDELEGATION_NOT_TO_INTERFACE(), null, 8, null);
        }
    }

    private final void checkNamedFunctionTypeParameter(CheckerContext context2, DiagnosticReporter reporter, FirTypeRef superTypeRef) {
        FirTypeRef firTypeRef = superTypeRef instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)superTypeRef : null;
        if (firTypeRef == null || (firTypeRef = firTypeRef.getDelegatedTypeRef()) == null) {
            return;
        }
        FirTypeRef delegatedTypeRef = firTypeRef;
        if (!(delegatedTypeRef instanceof FirFunctionTypeRef)) {
            return;
        }
        for (FirFunctionTypeParameter parameter : ((FirFunctionTypeRef)delegatedTypeRef).getParameters()) {
            KtSourceElement source;
            if (parameter.getName() == null || this.findSourceForParameterName(parameter) == null) continue;
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getUNSUPPORTED(), (Object)"Named parameter in function type as supertype is unsupported.", null, 16, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final KtSourceElement findSourceForParameterName(FirFunctionTypeParameter $this$findSourceForParameterName) {
        void tree$iv;
        void endOffset$iv;
        void startOffset$iv;
        void $this$toKtLightSourceElement_u24default$iv;
        LighterASTNode node;
        Object v1;
        FlyweightCapableTreeStructure<LighterASTNode> treeStructure;
        block3: {
            Name name2 = $this$findSourceForParameterName.getName();
            if (name2 == null) {
                return null;
            }
            Name name3 = name2;
            treeStructure = $this$findSourceForParameterName.getSource().getTreeStructure();
            List<LighterASTNode> nodes = LightTreeUtilsKt.getChildren($this$findSourceForParameterName.getSource().getLighterASTNode(), treeStructure);
            Iterable iterable = nodes;
            for (Object t2 : iterable) {
                LighterASTNode it = (LighterASTNode)t2;
                boolean bl = false;
                if (!(Intrinsics.areEqual((Object)it.getTokenType(), (Object)KtTokens.IDENTIFIER) && Intrinsics.areEqual((Object)treeStructure.toString(it), (Object)name3.getIdentifier()))) continue;
                v1 = t2;
                break block3;
            }
            v1 = null;
        }
        LighterASTNode lighterASTNode = v1;
        if (lighterASTNode == null) {
            return null;
        }
        LighterASTNode lighterASTNode2 = node = lighterASTNode;
        FlyweightCapableTreeStructure<LighterASTNode> flyweightCapableTreeStructure = treeStructure;
        int n2 = node.getStartOffset();
        int n3 = node.getEndOffset();
        KtSourceElementKind kind$iv = KtRealSourceElementKind.INSTANCE;
        boolean $i$f$toKtLightSourceElement = false;
        return new KtLightSourceElement((LighterASTNode)$this$toKtLightSourceElement_u24default$iv, (int)startOffset$iv, (int)endOffset$iv, (FlyweightCapableTreeStructure<LighterASTNode>)tree$iv, kind$iv);
    }

    private final void checkDelegationWithoutPrimaryConstructor(CheckerContext context2, DiagnosticReporter reporter, FirClass declaration) {
        FirClass $this$isInterface$iv = declaration;
        boolean $i$f$isInterface = false;
        ClassKind $this$isInterface$iv$iv = $this$isInterface$iv.getClassKind();
        boolean $i$f$isInterface2 = false;
        boolean bl = $this$isInterface$iv$iv == ClassKind.INTERFACE;
        if (bl) {
            return;
        }
        FirMemberDeclaration $this$isExpect$iv = declaration;
        boolean $i$f$isExpect = false;
        if ($this$isExpect$iv.getStatus().isExpect()) {
            return;
        }
        FirConstructorSymbol primaryConstructor = DeclarationUtilsKt.primaryConstructorIfAny(declaration, context2.getSession());
        if (primaryConstructor != null) {
            return;
        }
        for (FirDeclaration subDeclaration : declaration.getDeclarations()) {
            if (!(subDeclaration instanceof FirField)) continue;
            FirCallableSymbol $this$visibility$iv = ((FirField)subDeclaration).getSymbol();
            boolean $i$f$getVisibility = false;
            if (!Intrinsics.areEqual((Object)$this$visibility$iv.getResolvedStatus().getVisibility(), (Object)Visibilities.Private.INSTANCE) || !FirHelpersKt.isDelegated(((FirField)subDeclaration).getName())) continue;
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)((FirField)subDeclaration).getSource(), FirErrors.INSTANCE.getUNSUPPORTED(), (Object)"Delegation without primary constructor is unsupported.", null, 16, null);
        }
    }
}

