/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import com.intellij.lang.LighterASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakePsiSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtLightSourceElement;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.KtPsiSourceElement;
import org.jetbrains.kotlin.KtRealPsiSourceElement;
import org.jetbrains.kotlin.KtRealSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.diagnostics.LightTreePositioningStrategiesKt;
import org.jetbrains.kotlin.fir.LanguageVersionUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirKeywordUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirModifier;
import org.jetbrains.kotlin.fir.analysis.checkers.FirModifierList;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirFunctionParameterChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousInitializer;
import org.jetbrains.kotlin.fir.declarations.FirBackingField;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirPropertyBodyResolveStateKt;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.FirValueParameterKindKt;
import org.jetbrains.kotlin.fir.declarations.impl.FirPrimaryConstructor;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeStarProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeProjectionKt;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.psi.KtContextReceiverList;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ\f\u0010\u000e\u001a\u00020\u000f*\u00020\u0010H\u0002J\u0012\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012*\u00020\u0002H\u0002J\u0012\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u0012*\u00020\u0015H\u0002J%\u0010\u0016\u001a\u00020\u000f2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u0012R\u00020\bj\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\u0019\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirContextParametersDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "declaration", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;)V", "isDelegationOperator", "", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "getContextParameters", "", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "findContextReceiverListSources", "Lorg/jetbrains/kotlin/KtSourceElement;", "checkSubTypes", "types", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Ljava/util/List;)Z", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirContextParametersDeclarationChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirContextParametersDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirContextParametersDeclarationChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 5 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 6 KtSourceElement.kt\norg/jetbrains/kotlin/KtSourceElementKt\n+ 7 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 8 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,181:1\n1#2:182\n1586#3:183\n1661#3,3:184\n1915#3,2:187\n1586#3:191\n1661#3,2:192\n1663#3:198\n1586#3:199\n1661#3,2:200\n1663#3:208\n1391#3:209\n1480#3,2:210\n1586#3:212\n1661#3,3:213\n1482#3,3:216\n39#4:189\n261#5:190\n950#6,4:194\n956#6,6:202\n11705#7:219\n12052#7,3:220\n37#8,2:223\n*S KotlinDebug\n*F\n+ 1 FirContextParametersDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirContextParametersDeclarationChecker\n*L\n88#1:183\n88#1:184,3\n111#1:187,2\n135#1:191\n135#1:192,2\n135#1:198\n139#1:199\n139#1:200,2\n139#1:208\n161#1:209\n161#1:210,2\n163#1:212\n163#1:213,3\n161#1:216,3\n121#1:189\n135#1:190\n135#1:194,4\n139#1:202,6\n151#1:219\n151#1:220,3\n158#1:223,2\n*E\n"})
public final class FirContextParametersDeclarationChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirContextParametersDeclarationChecker INSTANCE = new FirContextParametersDeclarationChecker();

    private FirContextParametersDeclarationChecker() {
        super(MppCheckerKind.Platform);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirDeclaration declaration) {
        List<FirValueParameter> contextParameters;
        String errorMessage;
        Iterator<FirValueParameter> it;
        Iterator<FirValueParameter> iterator2;
        Iterator<FirValueParameter> iterator3;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        KtSourceElement ktSourceElement = declaration.getSource();
        if ((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind) {
            return;
        }
        Object object = declaration instanceof FirFile ? ((FirFile)declaration).getPackageDirective().getSource() : declaration.getSource();
        List list = object != null ? this.findContextReceiverListSources((KtSourceElement)object) : null;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        if ((object = (Collection)list).isEmpty()) {
            boolean bl = false;
            return;
        }
        List contextListSources = (List)object;
        KtSourceElement source = (KtSourceElement)CollectionsKt.first((List)contextListSources);
        if (contextListSources.size() > 1) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getMULTIPLE_CONTEXT_LISTS(), null, 8, null);
        }
        boolean contextReceiversEnabled = LanguageVersionUtilsKt.isEnabled(context2, LanguageFeature.ContextReceivers);
        boolean contextParametersEnabled = LanguageVersionUtilsKt.isEnabled(context2, LanguageFeature.ContextParameters);
        FirDeclaration firDeclaration = declaration;
        if (firDeclaration instanceof FirTypeAlias) {
            iterator3 = "Context parameters on type aliases are unsupported.";
        } else if (firDeclaration instanceof FirAnonymousInitializer) {
            iterator3 = "Context parameters on initializers are unsupported.";
        } else if (firDeclaration instanceof FirEnumEntry) {
            iterator3 = "Context parameters on enum entries are unsupported.";
        } else if (firDeclaration instanceof FirPropertyAccessor) {
            iterator3 = "Context parameters on property accessors are unsupported.";
        } else if (firDeclaration instanceof FirBackingField) {
            iterator3 = "Context parameters on backing fields are unsupported.";
        } else if (firDeclaration instanceof FirPrimaryConstructor) {
            iterator3 = "Context parameters on primary constructors are unsupported.";
        } else if (firDeclaration instanceof FirProperty && FirPropertyBodyResolveStateKt.isLocal((FirProperty)declaration)) {
            it = iterator2 = "Context parameters on local properties are unsupported.";
            boolean bl = false;
            iterator3 = contextParametersEnabled ? iterator2 : null;
        } else if (firDeclaration instanceof FirConstructor) {
            it = iterator2 = "Context parameters on constructors are unsupported.";
            boolean bl = false;
            iterator3 = contextParametersEnabled ? iterator2 : null;
        } else if (firDeclaration instanceof FirClass) {
            it = iterator2 = "Context parameters on classes are unsupported.";
            boolean bl = false;
            iterator3 = contextParametersEnabled ? iterator2 : null;
        } else if (firDeclaration instanceof FirCallableDeclaration && this.isDelegationOperator((FirCallableDeclaration)declaration)) {
            it = iterator2 = "Context parameters on delegation operators are unsupported.";
            boolean bl = false;
            iterator3 = contextParametersEnabled ? iterator2 : null;
        } else if (firDeclaration instanceof FirProperty && ((FirProperty)declaration).getDelegate() != null) {
            it = iterator2 = "Context parameters on delegated properties are unsupported.";
            boolean bl = false;
            iterator3 = contextParametersEnabled ? iterator2 : null;
        } else {
            iterator3 = errorMessage = firDeclaration instanceof FirSimpleFunction || firDeclaration instanceof FirProperty || firDeclaration instanceof FirAnonymousFunction ? null : "Context parameters are unsupported in this position.";
        }
        if (errorMessage != null) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getUNSUPPORTED(), (Object)errorMessage, null, 16, null);
        }
        if ((contextParameters = this.getContextParameters(declaration)).isEmpty()) {
            return;
        }
        if (!contextReceiversEnabled && !contextParametersEnabled) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getUNSUPPORTED_FEATURE(), (Object)TuplesKt.to((Object)((Object)LanguageFeature.ContextParameters), (Object)context2.getLanguageVersionSettings()), null, 16, null);
            return;
        }
        if (contextReceiversEnabled) {
            Collection<ConeKotlinType> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            iterator2 = contextParameters;
            CheckerContext checkerContext = context2;
            FirContextParametersDeclarationChecker firContextParametersDeclarationChecker = this;
            boolean $i$f$map = false;
            void bl = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                FirValueParameter firValueParameter = (FirValueParameter)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(FirTypeUtilsKt.getConeType(it2.getReturnTypeRef()));
            }
            collection = (List)destination$iv$iv;
            if (firContextParametersDeclarationChecker.checkSubTypes(checkerContext, (List<? extends ConeKotlinType>)collection)) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getSUBTYPING_BETWEEN_CONTEXT_RECEIVERS(), null, 8, null);
            }
            for (FirValueParameter parameter : contextParameters) {
                if (FirValueParameterKindKt.isLegacyContextReceiver(parameter)) continue;
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)parameter.getSource(), FirErrors.INSTANCE.getUNSUPPORTED_FEATURE(), (Object)TuplesKt.to((Object)((Object)LanguageFeature.ContextParameters), (Object)context2.getLanguageVersionSettings()), null, 16, null);
            }
        }
        if (contextParametersEnabled) {
            for (FirValueParameter parameter : contextParameters) {
                List<FirModifier<?>> list2;
                if (FirValueParameterKindKt.isLegacyContextReceiver(parameter)) {
                    KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)parameter.getSource(), FirErrors.INSTANCE.getCONTEXT_PARAMETER_WITHOUT_NAME(), null, 8, null);
                }
                if ((list2 = parameter.getSource()) != null && (list2 = FirKeywordUtilsKt.getModifierList((KtSourceElement)((Object)list2))) != null && (list2 = ((FirModifierList)((Object)list2)).getModifiers()) != null) {
                    Iterable $this$forEach$iv = list2;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        FirModifier modifier = (FirModifier)element$iv;
                        boolean bl = false;
                        KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)modifier.getSource(), FirErrors.INSTANCE.getWRONG_MODIFIER_TARGET(), (Object)modifier.getToken(), (Object)"context parameter", null, 32, null);
                    }
                }
                FirFunctionParameterChecker.INSTANCE.checkValOrVar$checkers(reporter, context2, parameter);
            }
        }
    }

    private final boolean isDelegationOperator(FirCallableDeclaration $this$isDelegationOperator) {
        FirMemberDeclaration $this$isOperator$iv = $this$isDelegationOperator;
        boolean $i$f$isOperator = false;
        return $this$isOperator$iv.getStatus().isOperator() && OperatorNameConventions.DELEGATED_PROPERTY_OPERATORS.contains(FirDeclarationUtilKt.getNameOrSpecialName($this$isDelegationOperator));
    }

    private final List<FirValueParameter> getContextParameters(FirDeclaration $this$getContextParameters) {
        FirDeclaration firDeclaration = $this$getContextParameters;
        return firDeclaration instanceof FirCallableDeclaration ? ((FirCallableDeclaration)$this$getContextParameters).getContextParameters() : (firDeclaration instanceof FirRegularClass ? ((FirRegularClass)$this$getContextParameters).getContextParameters() : CollectionsKt.emptyList());
    }

    /*
     * Unable to fully structure code
     */
    private final List<KtSourceElement> findContextReceiverListSources(KtSourceElement $this$findContextReceiverListSources) {
        block13: {
            block14: {
                block12: {
                    var2_2 = $this$findContextReceiverListSources;
                    if (!(var2_2 instanceof KtPsiSourceElement)) break block12;
                    $this$getChildOfType$iv = ((KtPsiSourceElement)$this$findContextReceiverListSources).getPsi();
                    $i$f$getChildOfType = false;
                    v0 = PsiTreeUtil.getChildOfType($this$getChildOfType$iv, KtModifierList.class);
                    if (v0 != null && (v0 = v0.getContextReceiverLists()) != null) {
                        $this$map$iv = (Iterable)v0;
                        $i$f$map = false;
                        var7_11 = $this$map$iv;
                        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            var12_22 = (KtContextReceiverList)item$iv$iv;
                            var20_34 = destination$iv$iv;
                            $i$a$-map-FirContextParametersDeclarationChecker$findContextReceiverListSources$1 = false;
                            Intrinsics.checkNotNull((Object)it);
                            $this$toKtPsiSourceElement_u24default$iv = (PsiElement)it;
                            kind$iv = KtRealSourceElementKind.INSTANCE;
                            $i$f$toKtPsiSourceElement = false;
                            var17_32 = kind$iv;
                            if (var17_32 instanceof KtRealSourceElementKind) {
                                v1 = new KtRealPsiSourceElement($this$toKtPsiSourceElement_u24default$iv);
                            } else if (var17_32 instanceof KtFakeSourceElementKind) {
                                v1 = new KtFakePsiSourceElement($this$toKtPsiSourceElement_u24default$iv, (KtFakeSourceElementKind)kind$iv);
                            } else {
                                throw new NoWhenBranchMatchedException();
                            }
                            var20_34.add(v1);
                        }
                        v2 = (List)destination$iv$iv;
                    } else {
                        v2 = v3 = null;
                    }
                    if (v2 == null) {
                        v3 = CollectionsKt.emptyList();
                    }
                    break block13;
                }
                if (!(var2_2 instanceof KtLightSourceElement)) break block14;
                v4 = ((KtLightSourceElement)$this$findContextReceiverListSources).getTreeStructure();
                v5 = ((KtLightSourceElement)$this$findContextReceiverListSources).getLighterASTNode();
                v6 = KtNodeTypes.MODIFIER_LIST;
                Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"MODIFIER_LIST");
                var3_36 = LightTreePositioningStrategiesKt.findChildByType(v4, v5, v6);
                if (var3_36 == null) ** GOTO lbl-1000
                it = var3_36;
                $i$a$-let-FirContextParametersDeclarationChecker$findContextReceiverListSources$2 = false;
                v7 = ((KtLightSourceElement)$this$findContextReceiverListSources).getTreeStructure();
                v8 = KtNodeTypes.CONTEXT_RECEIVER_LIST;
                Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"CONTEXT_RECEIVER_LIST");
                var4_4 = LightTreePositioningStrategiesKt.findChildrenByType(v7, it, v8);
                if (var4_4 != null) {
                    $this$map$iv = var4_4;
                    $i$f$map = false;
                    $i$a$-let-FirContextParametersDeclarationChecker$findContextReceiverListSources$2 = $this$map$iv;
                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        it = (LighterASTNode)item$iv$iv;
                        var20_35 = destination$iv$iv;
                        $i$a$-map-FirContextParametersDeclarationChecker$findContextReceiverListSources$3 = false;
                        $this$toKtPsiSourceElement_u24default$iv = it;
                        tree$iv = ((KtLightSourceElement)$this$findContextReceiverListSources).getTreeStructure();
                        kind$iv = KtRealSourceElementKind.INSTANCE;
                        startOffset$iv = $this$toKtLightSourceElement_u24default$iv.getStartOffset();
                        endOffset$iv = $this$toKtLightSourceElement_u24default$iv.getEndOffset();
                        $i$f$toKtLightSourceElement = false;
                        var20_35.add(new KtLightSourceElement((LighterASTNode)$this$toKtLightSourceElement_u24default$iv, startOffset$iv, endOffset$iv, tree$iv, kind$iv));
                    }
                    v9 = (List)destination$iv$iv;
                } else lbl-1000:
                // 2 sources

                {
                    v9 = v3 = null;
                }
                if (v9 == null) {
                    v3 = CollectionsKt.emptyList();
                }
                break block13;
            }
            throw new NoWhenBranchMatchedException();
        }
        return v3;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean checkSubTypes(@NotNull CheckerContext context2, @NotNull List<? extends ConeKotlinType> types2) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter(types2, (String)"types");
        Iterable $this$flatMap$iv = types2;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List list;
            ConeKotlinType r2 = (ConeKotlinType)element$iv$iv;
            boolean bl = false;
            ConeKotlinType coneKotlinType = r2;
            if (coneKotlinType instanceof ConeTypeParameterType) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = ((ConeTypeParameterType)r2).getLookupTag().getTypeParameterSymbol().getResolvedBounds();
                boolean $i$f$map = false;
                Iterable iterable2 = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    FirResolvedTypeRef firResolvedTypeRef = (FirResolvedTypeRef)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl2 = false;
                    collection.add(it.getConeType());
                }
                list = (List)destination$iv$iv2;
            } else {
                list = coneKotlinType instanceof ConeClassLikeType ? CollectionsKt.listOf((Object)FirContextParametersDeclarationChecker.checkSubTypes$replaceTypeParametersByStarProjections((ConeClassLikeType)r2)) : CollectionsKt.listOf((Object)r2);
            }
            Iterable list$iv$iv = list;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List replacedTypeParameters = (List)destination$iv$iv;
        int n2 = ((Collection)replacedTypeParameters).size();
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = replacedTypeParameters.size();
            for (int j2 = i2 + 1; j2 < n3; ++j2) {
                if (!TypeUtilsKt.isSubtypeOf$default((ConeKotlinType)replacedTypeParameters.get(i2), (ConeKotlinType)replacedTypeParameters.get(j2), context2.getSession(), false, 4, null) && !TypeUtilsKt.isSubtypeOf$default((ConeKotlinType)replacedTypeParameters.get(j2), (ConeKotlinType)replacedTypeParameters.get(i2), context2.getSession(), false, 4, null)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private static final ConeClassLikeType checkSubTypes$replaceTypeParametersByStarProjections(ConeClassLikeType type) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        ConeTypeProjection[] coneTypeProjectionArray = type.getTypeArguments();
        ConeClassLikeType coneClassLikeType = type;
        boolean $i$f$map = false;
        void var3_4 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        int n2 = ((void)$this$mapTo$iv$iv).length;
        for (int i2 = 0; i2 < n2; ++i2) {
            void it;
            void item$iv$iv;
            void var9_10 = item$iv$iv = $this$mapTo$iv$iv[i2];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            ConeKotlinType type2 = ConeTypeProjectionKt.getType((ConeTypeProjection)it);
            collection.add(type2 == null ? it : (type2 instanceof ConeTypeParameterType ? (ConeTypeProjection)ConeStarProjection.INSTANCE : (type2 instanceof ConeClassLikeType ? (ConeTypeProjection)FirContextParametersDeclarationChecker.checkSubTypes$replaceTypeParametersByStarProjections((ConeClassLikeType)type2) : it)));
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return ConeTypeUtilsKt.withArguments(coneClassLikeType, thisCollection$iv.toArray(new ConeTypeProjection[0]));
    }
}

