/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cfg;

import com.google.common.collect.ImmutableSet;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.cfg.LeakingThisDescriptor;
import org.jetbrains.kotlin.cfg.pseudocode.Pseudocode;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.Instruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.KtElementInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.MagicInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.MagicKind;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.ReadValueInstruction;
import org.jetbrains.kotlin.cfg.pseudocodeTraverser.PseudocodeTraverserKt;
import org.jetbrains.kotlin.cfg.pseudocodeTraverser.TraversalOrder;
import org.jetbrains.kotlin.cfg.variable.PseudocodeVariablesData;
import org.jetbrains.kotlin.cfg.variable.VariableControlFlowState;
import org.jetbrains.kotlin.cfg.variable.VariableInitReadOnlyControlFlowInfo;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ModalityUtilsKt;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB1\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0018H\u0002J\u0006\u0010\u0019\u001a\u00020\u001aR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/cfg/ConstructorConsistencyChecker;", "", "classOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "classDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "pseudocode", "Lorg/jetbrains/kotlin/cfg/pseudocode/Pseudocode;", "variablesData", "Lorg/jetbrains/kotlin/cfg/variable/PseudocodeVariablesData;", "<init>", "(Lorg/jetbrains/kotlin/psi/KtClassOrObject;Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;Lorg/jetbrains/kotlin/resolve/BindingTrace;Lorg/jetbrains/kotlin/cfg/pseudocode/Pseudocode;Lorg/jetbrains/kotlin/cfg/variable/PseudocodeVariablesData;)V", "finalClass", "", "insideLValue", "reference", "Lorg/jetbrains/kotlin/psi/KtReferenceExpression;", "safeReferenceUsage", "safeThisUsage", "expression", "Lorg/jetbrains/kotlin/psi/KtThisExpression;", "safeCallUsage", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "check", "", "Companion", "cfg"})
@SourceDebugExtension(value={"SMAP\nConstructorConsistencyChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConstructorConsistencyChecker.kt\norg/jetbrains/kotlin/cfg/ConstructorConsistencyChecker\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,193:1\n249#2:194\n1#3:195\n812#4,12:196\n777#4:208\n873#4,2:209\n296#4,2:211\n*S KotlinDebug\n*F\n+ 1 ConstructorConsistencyChecker.kt\norg/jetbrains/kotlin/cfg/ConstructorConsistencyChecker\n*L\n47#1:194\n102#1:196,12\n103#1:208\n103#1:209,2\n108#1:211,2\n*E\n"})
public final class ConstructorConsistencyChecker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KtClassOrObject classOrObject;
    @NotNull
    private final ClassDescriptor classDescriptor;
    @NotNull
    private final BindingTrace trace;
    @NotNull
    private final Pseudocode pseudocode;
    @NotNull
    private final PseudocodeVariablesData variablesData;
    private final boolean finalClass;

    private ConstructorConsistencyChecker(KtClassOrObject classOrObject, ClassDescriptor classDescriptor, BindingTrace trace, Pseudocode pseudocode, PseudocodeVariablesData variablesData) {
        this.classOrObject = classOrObject;
        this.classDescriptor = classDescriptor;
        this.trace = trace;
        this.pseudocode = pseudocode;
        this.variablesData = variablesData;
        this.finalClass = ModalityUtilsKt.isFinalClass(this.classDescriptor);
    }

    private final boolean insideLValue(KtReferenceExpression reference2) {
        PsiElement $this$getStrictParentOfType$iv = reference2;
        boolean $i$f$getStrictParentOfType = false;
        KtBinaryExpression ktBinaryExpression = PsiTreeUtil.getParentOfType($this$getStrictParentOfType$iv, KtBinaryExpression.class, true);
        if (ktBinaryExpression == null) {
            return false;
        }
        KtBinaryExpression binary = ktBinaryExpression;
        if (KtTokens.ALL_ASSIGNMENTS.contains(binary.getOperationToken())) {
            KtExpression binaryLeft = binary.getLeft();
            PsiElement current = reference2;
            while (current != binaryLeft && current != binary) {
                if (current.getParent() != null) continue;
                return false;
            }
            return current == binaryLeft;
        }
        return false;
    }

    private final boolean safeReferenceUsage(KtReferenceExpression reference2) {
        DeclarationDescriptor descriptor = (DeclarationDescriptor)this.trace.get(BindingContext.REFERENCE_TARGET, reference2);
        if (descriptor instanceof PropertyDescriptor) {
            boolean bl;
            if (!this.finalClass && ModalityUtilsKt.isOverridable((CallableMemberDescriptor)descriptor)) {
                this.trace.record(BindingContext.LEAKING_THIS, reference2, new LeakingThisDescriptor.NonFinalProperty((PropertyDescriptor)descriptor, this.classOrObject));
                return true;
            }
            if (!Intrinsics.areEqual((Object)((PropertyDescriptor)descriptor).getContainingDeclaration(), (Object)this.classDescriptor)) {
                return true;
            }
            if (this.insideLValue(reference2)) {
                PropertySetterDescriptor propertySetterDescriptor = ((PropertyDescriptor)descriptor).getSetter();
                boolean bl2 = propertySetterDescriptor != null ? !propertySetterDescriptor.isDefault() : false;
                bl = !bl2;
            } else {
                PropertyGetterDescriptor propertyGetterDescriptor = ((PropertyDescriptor)descriptor).getGetter();
                bl = !(propertyGetterDescriptor != null ? !propertyGetterDescriptor.isDefault() : false);
            }
            return bl;
        }
        return true;
    }

    private final boolean safeThisUsage(KtThisExpression expression2) {
        boolean bl;
        DeclarationDescriptor referenceDescriptor = (DeclarationDescriptor)this.trace.get(BindingContext.REFERENCE_TARGET, expression2.getInstanceReference());
        if (!Intrinsics.areEqual((Object)referenceDescriptor, (Object)this.classDescriptor)) {
            return true;
        }
        PsiElement parent2 = expression2.getParent();
        PsiElement psiElement = parent2;
        if (psiElement instanceof KtQualifiedExpression) {
            KtExpression ktExpression = ((KtQualifiedExpression)parent2).getSelectorExpression();
            KtSimpleNameExpression ktSimpleNameExpression = ktExpression instanceof KtSimpleNameExpression ? (KtSimpleNameExpression)ktExpression : null;
            if (ktSimpleNameExpression != null) {
                KtSimpleNameExpression it = ktSimpleNameExpression;
                boolean bl2 = false;
                bl = this.safeReferenceUsage(it);
            } else {
                bl = false;
            }
        } else if (psiElement instanceof KtBinaryExpression) {
            ImmutableSet<KtSingleValueToken> immutableSet = OperatorConventions.IDENTITY_EQUALS_OPERATIONS;
            Intrinsics.checkNotNullExpressionValue(immutableSet, (String)"IDENTITY_EQUALS_OPERATIONS");
            bl = CollectionsKt.contains((Iterable)immutableSet, (Object)((KtBinaryExpression)parent2).getOperationToken());
        } else {
            bl = false;
        }
        return bl;
    }

    private final boolean safeCallUsage(KtCallExpression expression2) {
        DeclarationDescriptor descriptor;
        KtExpression callee = expression2.getCalleeExpression();
        if (callee instanceof KtReferenceExpression && (descriptor = (DeclarationDescriptor)this.trace.get(BindingContext.REFERENCE_TARGET, callee)) instanceof FunctionDescriptor) {
            DeclarationDescriptor declarationDescriptor = ((FunctionDescriptor)descriptor).getContainingDeclaration();
            Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"getContainingDeclaration(...)");
            DeclarationDescriptor containingDescriptor = declarationDescriptor;
            if (!Intrinsics.areEqual((Object)containingDescriptor, (Object)this.classDescriptor)) {
                return true;
            }
            if (!this.finalClass && ModalityUtilsKt.isOverridable((CallableMemberDescriptor)descriptor)) {
                this.trace.record(BindingContext.LEAKING_THIS, callee, new LeakingThisDescriptor.NonFinalFunction((FunctionDescriptor)descriptor, this.classOrObject));
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public final void check() {
        void $this$filterTo$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv = this.variablesData.getDeclaredVariables(this.pseudocode, false);
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof PropertyDescriptor)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PropertyDescriptor it = (PropertyDescriptor)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual(this.trace.get(BindingContext.BACKING_FIELD_REQUIRED, it), (Object)true)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List propertyDescriptors = (List)destination$iv$iv;
        PseudocodeTraverserKt.traverse(this.pseudocode, TraversalOrder.FORWARD, this.variablesData.getVariableInitializers(), (arg_0, arg_1, arg_2) -> ConstructorConsistencyChecker.check$lambda$1(this, propertyDescriptors, arg_0, arg_1, arg_2));
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final PropertyDescriptor check$lambda$1$firstUninitializedNotNullProperty(List<? extends PropertyDescriptor> propertyDescriptors, VariableInitReadOnlyControlFlowInfo $enterData) {
        Object element$iv;
        Object v0;
        boolean bl;
        Iterable $this$firstOrNull$iv = propertyDescriptors;
        boolean $i$f$firstOrNull = false;
        Iterator iterator2 = $this$firstOrNull$iv.iterator();
        do {
            if (!iterator2.hasNext()) {
                v0 = null;
                return v0;
            }
            element$iv = iterator2.next();
            PropertyDescriptor it = (PropertyDescriptor)element$iv;
            boolean bl2 = false;
            if (!(it.getType().isMarkedNullable() || KotlinBuiltIns.isPrimitiveType(it.getType()) || it.isLateInit())) {
                VariableControlFlowState variableControlFlowState = (VariableControlFlowState)$enterData.getOrNull(it);
                if (!(variableControlFlowState != null ? variableControlFlowState.definitelyInitialized() : false)) {
                    bl = true;
                    continue;
                }
            }
            bl = false;
        } while (!bl);
        v0 = element$iv;
        return v0;
    }

    private static final void check$lambda$1$handleLeakingThis(ConstructorConsistencyChecker this$0, List<? extends PropertyDescriptor> propertyDescriptors, VariableInitReadOnlyControlFlowInfo $enterData, KtExpression expression2) {
        if (!this$0.finalClass) {
            this$0.trace.record(BindingContext.LEAKING_THIS, ConstructorConsistencyChecker.Companion.target(expression2), new LeakingThisDescriptor.NonFinalClass(this$0.classDescriptor, this$0.classOrObject));
        } else {
            PropertyDescriptor uninitializedProperty = ConstructorConsistencyChecker.check$lambda$1$firstUninitializedNotNullProperty(propertyDescriptors, $enterData);
            if (uninitializedProperty != null) {
                this$0.trace.record(BindingContext.LEAKING_THIS, ConstructorConsistencyChecker.Companion.target(expression2), new LeakingThisDescriptor.PropertyIsNull(uninitializedProperty, this$0.classOrObject));
            }
        }
    }

    private static final Unit check$lambda$1(ConstructorConsistencyChecker this$0, List $propertyDescriptors, Instruction instruction, VariableInitReadOnlyControlFlowInfo enterData, VariableInitReadOnlyControlFlowInfo variableInitReadOnlyControlFlowInfo) {
        Intrinsics.checkNotNullParameter((Object)instruction, (String)"instruction");
        Intrinsics.checkNotNullParameter((Object)enterData, (String)"enterData");
        Intrinsics.checkNotNullParameter((Object)variableInitReadOnlyControlFlowInfo, (String)"<unused var>");
        if (!Intrinsics.areEqual((Object)instruction.getOwner(), (Object)this$0.pseudocode)) {
            return Unit.INSTANCE;
        }
        if (instruction instanceof KtElementInstruction) {
            KtElement element = ((KtElementInstruction)instruction).getElement();
            KtElementInstruction ktElementInstruction = (KtElementInstruction)instruction;
            if (ktElementInstruction instanceof ReadValueInstruction) {
                if (element instanceof KtThisExpression && !this$0.safeThisUsage((KtThisExpression)element)) {
                    ConstructorConsistencyChecker.check$lambda$1$handleLeakingThis(this$0, $propertyDescriptors, enterData, (KtExpression)element);
                }
            } else if (ktElementInstruction instanceof MagicInstruction && ((MagicInstruction)instruction).getKind() == MagicKind.IMPLICIT_RECEIVER) {
                if (element instanceof KtCallExpression) {
                    if (!this$0.safeCallUsage((KtCallExpression)element)) {
                        ConstructorConsistencyChecker.check$lambda$1$handleLeakingThis(this$0, $propertyDescriptors, enterData, (KtExpression)element);
                    }
                } else if (element instanceof KtReferenceExpression && !this$0.safeReferenceUsage((KtReferenceExpression)element)) {
                    ConstructorConsistencyChecker.check$lambda$1$handleLeakingThis(this$0, $propertyDescriptors, enterData, (KtExpression)element);
                }
            }
        }
        return Unit.INSTANCE;
    }

    @JvmStatic
    public static final void check(@NotNull KtSecondaryConstructor constructor, @NotNull BindingTrace trace, @NotNull Pseudocode pseudocode, @NotNull PseudocodeVariablesData pseudocodeVariablesData) {
        Companion.check(constructor, trace, pseudocode, pseudocodeVariablesData);
    }

    @JvmStatic
    public static final void check(@NotNull KtClassOrObject classOrObject, @NotNull BindingTrace trace, @NotNull Pseudocode pseudocode, @NotNull PseudocodeVariablesData pseudocodeVariablesData) {
        Companion.check(classOrObject, trace, pseudocode, pseudocodeVariablesData);
    }

    public /* synthetic */ ConstructorConsistencyChecker(KtClassOrObject classOrObject, ClassDescriptor classDescriptor, BindingTrace trace, Pseudocode pseudocode, PseudocodeVariablesData variablesData, DefaultConstructorMarker $constructor_marker) {
        this(classOrObject, classDescriptor, trace, pseudocode, variablesData);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0002\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/cfg/ConstructorConsistencyChecker$Companion;", "", "<init>", "()V", "check", "", "constructor", "Lorg/jetbrains/kotlin/psi/KtSecondaryConstructor;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "pseudocode", "Lorg/jetbrains/kotlin/cfg/pseudocode/Pseudocode;", "pseudocodeVariablesData", "Lorg/jetbrains/kotlin/cfg/variable/PseudocodeVariablesData;", "classOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "target", "Lorg/jetbrains/kotlin/psi/KtExpression;", "expression", "cfg"})
    @SourceDebugExtension(value={"SMAP\nConstructorConsistencyChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConstructorConsistencyChecker.kt\norg/jetbrains/kotlin/cfg/ConstructorConsistencyChecker$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,193:1\n1#2:194\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void check(@NotNull KtSecondaryConstructor constructor, @NotNull BindingTrace trace, @NotNull Pseudocode pseudocode, @NotNull PseudocodeVariablesData pseudocodeVariablesData) {
            Intrinsics.checkNotNullParameter((Object)constructor, (String)"constructor");
            Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
            Intrinsics.checkNotNullParameter((Object)pseudocode, (String)"pseudocode");
            Intrinsics.checkNotNullParameter((Object)pseudocodeVariablesData, (String)"pseudocodeVariablesData");
            this.check(constructor.getContainingClassOrObject(), trace, pseudocode, pseudocodeVariablesData);
        }

        @JvmStatic
        public final void check(@NotNull KtClassOrObject classOrObject, @NotNull BindingTrace trace, @NotNull Pseudocode pseudocode, @NotNull PseudocodeVariablesData pseudocodeVariablesData) {
            Intrinsics.checkNotNullParameter((Object)classOrObject, (String)"classOrObject");
            Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
            Intrinsics.checkNotNullParameter((Object)pseudocode, (String)"pseudocode");
            Intrinsics.checkNotNullParameter((Object)pseudocodeVariablesData, (String)"pseudocodeVariablesData");
            ClassDescriptor classDescriptor = (ClassDescriptor)trace.get(BindingContext.CLASS, classOrObject);
            if (classDescriptor == null) {
                return;
            }
            ClassDescriptor classDescriptor2 = classDescriptor;
            new ConstructorConsistencyChecker(classOrObject, classDescriptor2, trace, pseudocode, pseudocodeVariablesData, null).check();
        }

        private final KtExpression target(KtExpression expression2) {
            KtExpression ktExpression;
            block10: {
                KtExpression ktExpression2;
                block7: {
                    KtExpression selectorOrThis;
                    KtExpression ktExpression3;
                    block9: {
                        block8: {
                            ktExpression2 = expression2;
                            if (!(ktExpression2 instanceof KtThisExpression)) break block7;
                            PsiElement psiElement = ((KtThisExpression)expression2).getParent();
                            ktExpression3 = psiElement instanceof KtQualifiedExpression ? (KtQualifiedExpression)psiElement : null;
                            if (ktExpression3 == null) break block8;
                            KtQualifiedExpression it = ktExpression3;
                            boolean bl = false;
                            KtExpression ktExpression4 = it.getReceiverExpression() == expression2 ? it.getSelectorExpression() : null;
                            ktExpression3 = ktExpression4;
                            if (ktExpression4 != null) break block9;
                        }
                        ktExpression3 = expression2;
                    }
                    ktExpression = (selectorOrThis = ktExpression3) == expression2 ? selectorOrThis : this.target(selectorOrThis);
                    break block10;
                }
                if (ktExpression2 instanceof KtCallExpression) {
                    KtCallExpression it = (KtCallExpression)expression2;
                    boolean bl = false;
                    ktExpression = it.getCalleeExpression();
                    if (ktExpression == null) {
                        ktExpression = it;
                    }
                } else {
                    ktExpression = expression2;
                }
            }
            return ktExpression;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

