/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.inline;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.ModuleLoweringPass;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrInlinedFunctionBlock;
import org.jetbrains.kotlin.ir.inline.FunctionInlining;
import org.jetbrains.kotlin.ir.inline.InlineFunctionBodyPreprocessor;
import org.jetbrains.kotlin.ir.inline.InlineFunctionResolverKt;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrTypeSystemContextKt;
import org.jetbrains.kotlin.ir.util.IrInlineUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrVisitorVoid;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0011\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\tH\u0016J\f\u0010\u0013\u001a\u00020\t*\u00020\tH\u0002J\f\u0010\u0014\u001a\u00020\t*\u00020\tH\u0002J\f\u0010\u0015\u001a\u00020\t*\u00020\tH\u0002J\f\u0010\u0016\u001a\u00020\u0017*\u00020\u0018H\u0002J\f\u0010\u0019\u001a\u00020\t*\u00020\tH\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/ir/inline/InlineFunctionSerializationPreProcessing;", "Lorg/jetbrains/kotlin/ir/visitors/IrVisitorVoid;", "Lorg/jetbrains/kotlin/backend/common/ModuleLoweringPass;", "crossModuleFunctionInliner", "Lorg/jetbrains/kotlin/ir/inline/FunctionInlining;", "<init>", "(Lorg/jetbrains/kotlin/ir/inline/FunctionInlining;)V", "preprocessedFunctions", "", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "lower", "", "irModule", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "visitElement", "element", "Lorg/jetbrains/kotlin/ir/IrElement;", "visitSimpleFunction", "declaration", "copyAndEraseTypeParameters", "convertToPrivateTopLevel", "erasePrivateSymbols", "isEffectivelyPrivate", "", "Lorg/jetbrains/kotlin/ir/expressions/IrInlinedFunctionBlock;", "applyCrossModuleFunctionInlining", "ir.inline"})
@SourceDebugExtension(value={"SMAP\nInlineFunctionSerializationPreProcessing.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InlineFunctionSerializationPreProcessing.kt\norg/jetbrains/kotlin/ir/inline/InlineFunctionSerializationPreProcessing\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,88:1\n777#2:89\n873#2,2:90\n1205#2,2:92\n1282#2,4:94\n*S KotlinDebug\n*F\n+ 1 InlineFunctionSerializationPreProcessing.kt\norg/jetbrains/kotlin/ir/inline/InlineFunctionSerializationPreProcessing\n*L\n51#1:89\n51#1:90,2\n51#1:92,2\n51#1:94,4\n*E\n"})
public final class InlineFunctionSerializationPreProcessing
extends IrVisitorVoid
implements ModuleLoweringPass {
    @Nullable
    private final FunctionInlining crossModuleFunctionInliner;
    @NotNull
    private final List<IrSimpleFunction> preprocessedFunctions;

    public InlineFunctionSerializationPreProcessing(@Nullable FunctionInlining crossModuleFunctionInliner) {
        this.crossModuleFunctionInliner = crossModuleFunctionInliner;
        this.preprocessedFunctions = new ArrayList();
    }

    @Override
    public void lower(@NotNull IrModuleFragment irModule) {
        Intrinsics.checkNotNullParameter((Object)irModule, (String)"irModule");
        IrVisitorsKt.acceptChildrenVoid((IrElement)irModule, this);
        IrInlineUtilsKt.setPreparedInlineFunctionCopies(irModule, this.preprocessedFunctions);
    }

    @Override
    public void visitElement(@NotNull IrElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        IrVisitorsKt.acceptChildrenVoid(element, this);
    }

    @Override
    public void visitSimpleFunction(@NotNull IrSimpleFunction declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (!declaration.isInline() || declaration.getBody() == null || InlineFunctionResolverKt.isConsideredAsPrivateForInlining(declaration.getSymbol())) {
            return;
        }
        IrSimpleFunction preprocessed = this.applyCrossModuleFunctionInlining(this.erasePrivateSymbols(this.convertToPrivateTopLevel(this.copyAndEraseTypeParameters(declaration))));
        IrInlineUtilsKt.setPreparedInlineFunctionCopy(declaration, preprocessed);
        IrInlineUtilsKt.setOriginalOfPreparedInlineFunctionCopy(preprocessed, declaration);
        ((Collection)this.preprocessedFunctions).add(preprocessed);
    }

    /*
     * WARNING - void declaration
     */
    private final IrSimpleFunction copyAndEraseTypeParameters(IrSimpleFunction $this$copyAndEraseTypeParameters) {
        void $this$associateTo$iv$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = IrTypeSystemContextKt.extractTypeParameters($this$copyAndEraseTypeParameters);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            IrTypeParameter it = (IrTypeParameter)element$iv$iv;
            boolean bl = false;
            if (!(!it.isReified())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$associate$iv = (List)destination$iv$iv;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associate$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv2;
            IrTypeParameter it = (IrTypeParameter)element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)it.getSymbol(), null);
            map.put(pair.getFirst(), pair.getSecond());
        }
        Map typeArguments = destination$iv$iv2;
        IrFunction irFunction = new InlineFunctionBodyPreprocessor(typeArguments).preprocess($this$copyAndEraseTypeParameters);
        Intrinsics.checkNotNull((Object)irFunction, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrSimpleFunction");
        return (IrSimpleFunction)irFunction;
    }

    private final IrSimpleFunction convertToPrivateTopLevel(IrSimpleFunction $this$convertToPrivateTopLevel) {
        DescriptorVisibility descriptorVisibility = DescriptorVisibilities.PRIVATE;
        Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility, (String)"PRIVATE");
        $this$convertToPrivateTopLevel.setVisibility(descriptorVisibility);
        $this$convertToPrivateTopLevel.setCorrespondingPropertySymbol(null);
        $this$convertToPrivateTopLevel.setParent(IrUtilsKt.getFile($this$convertToPrivateTopLevel));
        return $this$convertToPrivateTopLevel;
    }

    private final IrSimpleFunction erasePrivateSymbols(IrSimpleFunction $this$erasePrivateSymbols) {
        new IrVisitorVoid(this){
            final /* synthetic */ InlineFunctionSerializationPreProcessing this$0;
            {
                this.this$0 = $receiver;
            }

            public void visitElement(IrElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                IrVisitorsKt.acceptChildrenVoid(element, this);
            }

            public void visitInlinedFunctionBlock(IrInlinedFunctionBlock inlinedBlock) {
                Intrinsics.checkNotNullParameter((Object)inlinedBlock, (String)"inlinedBlock");
                IrVisitorsKt.acceptChildrenVoid((IrElement)inlinedBlock, this);
                if (InlineFunctionSerializationPreProcessing.access$isEffectivelyPrivate(this.this$0, inlinedBlock)) {
                    inlinedBlock.setInlinedFunctionSymbol(null);
                }
            }
        }.visitElement($this$erasePrivateSymbols);
        return $this$erasePrivateSymbols;
    }

    private final boolean isEffectivelyPrivate(IrInlinedFunctionBlock $this$isEffectivelyPrivate) {
        IrFunctionSymbol irFunctionSymbol = $this$isEffectivelyPrivate.getInlinedFunctionSymbol();
        return irFunctionSymbol != null ? InlineFunctionResolverKt.isConsideredAsPrivateAndNotLocalForInlining(irFunctionSymbol) : false;
    }

    private final IrSimpleFunction applyCrossModuleFunctionInlining(IrSimpleFunction $this$applyCrossModuleFunctionInlining) {
        block0: {
            FunctionInlining functionInlining = this.crossModuleFunctionInliner;
            if (functionInlining == null) break block0;
            IrBody irBody = $this$applyCrossModuleFunctionInlining.getBody();
            Intrinsics.checkNotNull((Object)irBody);
            functionInlining.lower(irBody, $this$applyCrossModuleFunctionInlining);
        }
        return $this$applyCrossModuleFunctionInlining;
    }

    public static final /* synthetic */ boolean access$isEffectivelyPrivate(InlineFunctionSerializationPreProcessing $this, IrInlinedFunctionBlock $receiver) {
        return $this.isEffectivelyPrivate($receiver);
    }
}

