/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.builders;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.declarations.impl.BuildersKt;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.symbols.impl.IrVariableSymbolImpl;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\b\u001a\u00020\tJ\b\u0010\f\u001a\u00020\u000bH\u0002J\u001c\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u000e2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u000eJ\u0012\u0010\u0011\u001a\u00020\u000e2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000eH\u0002JH\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u000e2\b\b\u0002\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u000b2\b\b\u0002\u0010\u001c\u001a\u00020\u0017JX\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u001f2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u000e2\b\b\u0002\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010\u0018\u001a\u00020\u00192\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\b\u0002\u0010\u001a\u001a\u00020\u000b2\b\b\u0002\u0010\u001b\u001a\u00020\u000b2\b\b\u0002\u0010\u001c\u001a\u00020\u0017R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/ir/builders/Scope;", "", "scopeOwnerSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "<init>", "(Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;)V", "getScopeOwnerSymbol", "()Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "getLocalDeclarationParent", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationParent;", "lastTemporaryIndex", "", "nextTemporaryIndex", "inventNameForTemporary", "", "prefix", "nameHint", "getNameForTemporary", "createTemporaryVariableDeclaration", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "irType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "isMutable", "", "origin", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationOrigin;", "startOffset", "endOffset", "inventUniqueName", "createTemporaryVariable", "irExpression", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "ir.tree"})
public final class Scope {
    @NotNull
    private final IrSymbol scopeOwnerSymbol;
    private int lastTemporaryIndex;

    public Scope(@NotNull IrSymbol scopeOwnerSymbol) {
        Intrinsics.checkNotNullParameter((Object)scopeOwnerSymbol, (String)"scopeOwnerSymbol");
        this.scopeOwnerSymbol = scopeOwnerSymbol;
    }

    @NotNull
    public final IrSymbol getScopeOwnerSymbol() {
        return this.scopeOwnerSymbol;
    }

    @NotNull
    public final IrDeclarationParent getLocalDeclarationParent() {
        IrDeclarationParent irDeclarationParent;
        if (!this.scopeOwnerSymbol.isBound()) {
            throw new AssertionError((Object)("Unbound symbol: " + this.scopeOwnerSymbol));
        }
        IrSymbolOwner scopeOwnerElement = this.scopeOwnerSymbol.getOwner();
        if (scopeOwnerElement instanceof IrDeclarationParent) {
            irDeclarationParent = (IrDeclarationParent)((Object)scopeOwnerElement);
        } else {
            if (!(scopeOwnerElement instanceof IrDeclaration)) {
                throw new AssertionError((Object)("Not a declaration: " + scopeOwnerElement));
            }
            irDeclarationParent = ((IrDeclaration)scopeOwnerElement).getParent();
        }
        return irDeclarationParent;
    }

    private final int nextTemporaryIndex() {
        int n2 = this.lastTemporaryIndex;
        this.lastTemporaryIndex = n2 + 1;
        return n2;
    }

    @NotNull
    public final String inventNameForTemporary(@NotNull String prefix, @Nullable String nameHint) {
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        int index = this.nextTemporaryIndex();
        return nameHint != null ? prefix + index + '_' + nameHint : prefix + index;
    }

    public static /* synthetic */ String inventNameForTemporary$default(Scope scope2, String string, String string2, int n2, Object object) {
        if ((n2 & 1) != 0) {
            string = "tmp";
        }
        if ((n2 & 2) != 0) {
            string2 = null;
        }
        return scope2.inventNameForTemporary(string, string2);
    }

    private final String getNameForTemporary(String nameHint) {
        return this.inventNameForTemporary("tmp", nameHint);
    }

    @NotNull
    public final IrVariable createTemporaryVariableDeclaration(@NotNull IrType irType, @Nullable String nameHint, boolean isMutable, @NotNull IrDeclarationOrigin origin, int startOffset, int endOffset, boolean inventUniqueName) {
        Name name2;
        Intrinsics.checkNotNullParameter((Object)irType, (String)"irType");
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        if (inventUniqueName) {
            name2 = Name.identifier(this.getNameForTemporary(nameHint));
        } else {
            String string = nameHint;
            if (string == null) {
                string = "tmp";
            }
            name2 = Name.identifier(string);
        }
        Object object = name2;
        Intrinsics.checkNotNull((Object)object);
        Name name3 = object;
        Object $this$createTemporaryVariableDeclaration_u24lambda_u240 = object = BuildersKt.IrVariableImpl(startOffset, endOffset, origin, new IrVariableSymbolImpl(null, 1, null), name3, irType, isMutable, false, false);
        boolean bl = false;
        ((IrDeclarationBase)$this$createTemporaryVariableDeclaration_u24lambda_u240).setParent(this.getLocalDeclarationParent());
        return (IrVariable)object;
    }

    public static /* synthetic */ IrVariable createTemporaryVariableDeclaration$default(Scope scope2, IrType irType, String string, boolean bl, IrDeclarationOrigin irDeclarationOrigin, int n2, int n3, boolean bl2, int n4, Object object) {
        if ((n4 & 2) != 0) {
            string = null;
        }
        if ((n4 & 4) != 0) {
            bl = false;
        }
        if ((n4 & 8) != 0) {
            irDeclarationOrigin = IrDeclarationOrigin.Companion.getIR_TEMPORARY_VARIABLE();
        }
        if ((n4 & 0x40) != 0) {
            bl2 = true;
        }
        return scope2.createTemporaryVariableDeclaration(irType, string, bl, irDeclarationOrigin, n2, n3, bl2);
    }

    @NotNull
    public final IrVariable createTemporaryVariable(@NotNull IrExpression irExpression, @Nullable String nameHint, boolean isMutable, @NotNull IrDeclarationOrigin origin, @Nullable IrType irType, int startOffset, int endOffset, boolean inventUniqueName) {
        IrVariable irVariable;
        Intrinsics.checkNotNullParameter((Object)irExpression, (String)"irExpression");
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        IrType irType2 = irType;
        if (irType2 == null) {
            irType2 = irExpression.getType();
        }
        IrVariable $this$createTemporaryVariable_u24lambda_u240 = irVariable = this.createTemporaryVariableDeclaration(irType2, nameHint, isMutable, origin, startOffset, endOffset, inventUniqueName);
        boolean bl = false;
        $this$createTemporaryVariable_u24lambda_u240.setInitializer(irExpression);
        return irVariable;
    }

    public static /* synthetic */ IrVariable createTemporaryVariable$default(Scope scope2, IrExpression irExpression, String string, boolean bl, IrDeclarationOrigin irDeclarationOrigin, IrType irType, int n2, int n3, boolean bl2, int n4, Object object) {
        if ((n4 & 2) != 0) {
            string = null;
        }
        if ((n4 & 4) != 0) {
            bl = false;
        }
        if ((n4 & 8) != 0) {
            irDeclarationOrigin = IrDeclarationOrigin.Companion.getIR_TEMPORARY_VARIABLE();
        }
        if ((n4 & 0x10) != 0) {
            irType = null;
        }
        if ((n4 & 0x20) != 0) {
            n2 = irExpression.getStartOffset();
        }
        if ((n4 & 0x40) != 0) {
            n3 = irExpression.getEndOffset();
        }
        if ((n4 & 0x80) != 0) {
            bl2 = true;
        }
        return scope2.createTemporaryVariable(irExpression, string, bl, irDeclarationOrigin, irType, n2, n3, bl2);
    }
}

