/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.references;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiPolyVariantReferenceBase;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.asJava.elements.KtLightMethod;
import org.jetbrains.kotlin.idea.references.KDocReference;
import org.jetbrains.kotlin.idea.references.KtDestructuringDeclarationReference;
import org.jetbrains.kotlin.idea.references.KtInvokeFunctionReference;
import org.jetbrains.kotlin.idea.references.KtReference;
import org.jetbrains.kotlin.idea.references.KtReferenceMutateService;
import org.jetbrains.kotlin.idea.references.KtSimpleNameReference;
import org.jetbrains.kotlin.idea.references.ReferenceUtilsKt;
import org.jetbrains.kotlin.psi.KtBreakExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtContainerNode;
import org.jetbrains.kotlin.psi.KtContinueExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtImportAlias;
import org.jetbrains.kotlin.psi.KtLabelReferenceExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpressionImpl;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u00032\u00020\u0004B\u000f\u0012\u0006\u0010\u0005\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001b\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u000fH\u0016J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0012H\u0016J\u0010\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0005\u001a\u00020\u0015H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0004J\u0013\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\fH\u0016\u00a2\u0006\u0002\u0010\u001cJ\b\u0010\u001d\u001a\u00020\u000fH\u0016J\n\u0010\u001e\u001a\u00020\u0012H\u0096\u0080\u0004J\u0010\u0010\u001f\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020\u0015H\u0014J\u0010\u0010!\u001a\u00020\u000f2\u0006\u0010\"\u001a\u00020#H\u0014J\u0010\u0010$\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020\u0015H\u0016J\f\u0010%\u001a\u00020\u000f*\u00020&H\u0002R\u0011\u0010\b\u001a\u00028\u00008F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlin/idea/references/AbstractKtReference;", "T", "Lorg/jetbrains/kotlin/psi/KtElement;", "Lcom/intellij/psi/PsiPolyVariantReferenceBase;", "Lorg/jetbrains/kotlin/idea/references/KtReference;", "element", "<init>", "(Lorg/jetbrains/kotlin/psi/KtElement;)V", "expression", "getExpression", "()Lorg/jetbrains/kotlin/psi/KtElement;", "multiResolve", "", "Lcom/intellij/psi/ResolveResult;", "incompleteCode", "", "(Z)[Lcom/intellij/psi/ResolveResult;", "getCanonicalText", "", "canRename", "handleElementRename", "Lcom/intellij/psi/PsiElement;", "newElementName", "bindToElement", "getKtReferenceMutateService", "Lorg/jetbrains/kotlin/idea/references/KtReferenceMutateService;", "getVariants", "", "()[Ljava/lang/Object;", "isSoft", "toString", "canBeReferenceTo", "candidateTarget", "isReferenceToImportAlias", "alias", "Lorg/jetbrains/kotlin/psi/KtImportAlias;", "isReferenceTo", "isAccessorReference", "Lorg/jetbrains/kotlin/idea/references/KtSimpleNameReference;", "kt-references"})
@SourceDebugExtension(value={"SMAP\nKtReference.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KtReference.kt\norg/jetbrains/kotlin/idea/references/AbstractKtReference\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,148:1\n1915#2,2:149\n1915#2,2:151\n253#3:153\n*S KotlinDebug\n*F\n+ 1 KtReference.kt\norg/jetbrains/kotlin/idea/references/AbstractKtReference\n*L\n96#1:149,2\n107#1:151,2\n128#1:153\n*E\n"})
public abstract class AbstractKtReference<T extends KtElement>
extends PsiPolyVariantReferenceBase<T>
implements KtReference {
    public AbstractKtReference(@NotNull T element) {
        Intrinsics.checkNotNullParameter(element, (String)"element");
        super((PsiElement)element);
    }

    @NotNull
    public final T getExpression() {
        Object t2 = this.getElement();
        Intrinsics.checkNotNullExpressionValue(t2, (String)"getElement(...)");
        return (T)((KtElement)t2);
    }

    @Override
    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        ResolveResult[] resolveResultArray = ResolveCache.getInstance(((PsiElement)this.getExpression()).getProject()).resolveWithCaching((PsiPolyVariantReference)this, this.getResolver(), false, incompleteCode);
        Intrinsics.checkNotNullExpressionValue((Object)resolveResultArray, (String)"resolveWithCaching(...)");
        return resolveResultArray;
    }

    @Override
    @NotNull
    public String getCanonicalText() {
        String string = ((PsiElement)this.getExpression()).getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }

    public boolean canRename() {
        return false;
    }

    @Override
    @Nullable
    public PsiElement handleElementRename(@NotNull String newElementName) {
        Intrinsics.checkNotNullParameter((Object)newElementName, (String)"newElementName");
        return this.canRename() ? this.getKtReferenceMutateService().handleElementRename(this, newElementName) : null;
    }

    @Override
    @NotNull
    public PsiElement bindToElement(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return this.getKtReferenceMutateService().bindToElement(this, element);
    }

    @NotNull
    protected final KtReferenceMutateService getKtReferenceMutateService() {
        KtReferenceMutateService ktReferenceMutateService = ApplicationManager.getApplication().getService(KtReferenceMutateService.class);
        if (ktReferenceMutateService == null) {
            throw new IllegalStateException("Cannot handle element rename because KtReferenceMutateService is missing");
        }
        return ktReferenceMutateService;
    }

    @Override
    @NotNull
    public Object[] getVariants() {
        return PsiReference.EMPTY_ARRAY;
    }

    @Override
    public boolean isSoft() {
        return false;
    }

    @Override
    @NotNull
    public String toString() {
        return this.getClass().getSimpleName() + ": " + ((PsiElement)this.getExpression()).getText();
    }

    protected boolean canBeReferenceTo(@NotNull PsiElement candidateTarget) {
        Intrinsics.checkNotNullParameter((Object)candidateTarget, (String)"candidateTarget");
        return true;
    }

    protected boolean isReferenceToImportAlias(@NotNull KtImportAlias alias) {
        Intrinsics.checkNotNullParameter((Object)alias, (String)"alias");
        return false;
    }

    @Override
    public boolean isReferenceTo(@NotNull PsiElement candidateTarget) {
        Intrinsics.checkNotNullParameter((Object)candidateTarget, (String)"candidateTarget");
        if (!this.canBeReferenceTo(candidateTarget)) {
            return false;
        }
        PsiElement psiElement = LightClassUtilsKt.getUnwrapped(candidateTarget);
        if (psiElement == null || (psiElement = psiElement.getOriginalElement()) == null) {
            return false;
        }
        PsiElement unwrappedCandidate = psiElement;
        AbstractKtReference abstractKtReference = this;
        if (abstractKtReference instanceof KtInvokeFunctionReference) {
            if (!(candidateTarget instanceof KtNamedFunction) && !(candidateTarget instanceof PsiMethod)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)((PsiNamedElement)candidateTarget).getName(), (Object)OperatorNameConventions.INVOKE.asString())) {
                return false;
            }
        } else if (abstractKtReference instanceof KtDestructuringDeclarationReference ? !(candidateTarget instanceof KtNamedFunction) && !(candidateTarget instanceof KtParameter) && !(candidateTarget instanceof PsiMethod) : abstractKtReference instanceof KtSimpleNameReference && unwrappedCandidate instanceof PsiMethod && this.isAccessorReference((KtSimpleNameReference)this) && !LightClassUtilsKt.getCanHaveSyntheticAccessors((PsiMethod)unwrappedCandidate)) {
            return false;
        }
        Object t2 = this.getElement();
        Intrinsics.checkNotNullExpressionValue(t2, (String)"getElement(...)");
        KtElement element = (KtElement)t2;
        if (candidateTarget instanceof KtImportAlias && (element instanceof KtSimpleNameExpression && Intrinsics.areEqual((Object)((KtSimpleNameExpression)element).getReferencedName(), (Object)((KtImportAlias)candidateTarget).getName()) || this instanceof KDocReference && Intrinsics.areEqual((Object)((KDocReference)this).getCanonicalText(), (Object)((KtImportAlias)candidateTarget).getName()))) {
            return this.isReferenceToImportAlias((KtImportAlias)candidateTarget);
        }
        if (element instanceof KtLabelReferenceExpression) {
            KtExpression labeledExpression;
            PsiElement it;
            Iterable $this$forEach$iv;
            PsiElement psiElement2;
            PsiElement psiElement3 = ((KtSimpleNameExpressionImpl)element).getParent();
            KtContainerNode ktContainerNode = psiElement3 instanceof KtContainerNode ? (KtContainerNode)psiElement3 : null;
            PsiElement psiElement4 = psiElement2 = ktContainerNode != null ? ktContainerNode.getParent() : null;
            if (psiElement2 instanceof KtReturnExpression) {
                $this$forEach$iv = ReferenceUtilsKt.getUnwrappedTargets(this);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Object calleeReference;
                    CharSequence charSequence;
                    it = (PsiElement)element$iv;
                    boolean bl = false;
                    if (!(it instanceof KtFunctionLiteral) && (!(it instanceof KtNamedFunction) || !((charSequence = (CharSequence)((KtNamedFunction)it).getName()) == null || charSequence.length() == 0))) continue;
                    KtFunction cfr_ignored_0 = (KtFunction)it;
                    labeledExpression = KtPsiUtilKt.getLabeledParent((KtExpression)it, ((KtSimpleNameExpressionImpl)element).getReferencedName());
                    if (labeledExpression != null) {
                        if (!Intrinsics.areEqual((Object)candidateTarget, (Object)labeledExpression)) continue;
                        return true;
                    }
                    Object object = ReferenceUtilsKt.getCalleeByLambdaArgument((KtFunction)it);
                    if (object == null) continue;
                    if ((object = ReferenceUtilsKt.getMainReference((KtSimpleNameExpression)object)) == null || !((KtSimpleNameReference)(calleeReference = object)).isReferenceTo(candidateTarget)) continue;
                    return true;
                }
            } else if (psiElement2 instanceof KtBreakExpression || psiElement2 instanceof KtContinueExpression) {
                $this$forEach$iv = ReferenceUtilsKt.getUnwrappedTargets(this);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (PsiElement)element$iv;
                    boolean bl = false;
                    KtExpression ktExpression = it instanceof KtExpression ? (KtExpression)it : null;
                    if (ktExpression == null) continue;
                    if ((ktExpression = KtPsiUtilKt.getLabeledParent(ktExpression, ((KtSimpleNameExpressionImpl)element).getReferencedName())) == null || !Intrinsics.areEqual((Object)candidateTarget, (Object)(labeledExpression = ktExpression))) continue;
                    return true;
                }
            }
        }
        Set<PsiElement> targets = ReferenceUtilsKt.getUnwrappedTargets(this);
        PsiManager manager = candidateTarget.getManager();
        for (PsiElement target : targets) {
            if (manager.areElementsEquivalent(unwrappedCandidate, target)) {
                if (candidateTarget instanceof KtLightMethod && unwrappedCandidate instanceof KtClass && ((KtLightMethod)candidateTarget).isConstructor() && element.getParent() instanceof KtTypeElement) continue;
                return true;
            }
            if (!ReferenceUtilsKt.isConstructorOf(target, unwrappedCandidate)) {
                if (!(target instanceof KtObjectDeclaration) || !((KtObjectDeclaration)target).isCompanion()) continue;
                PsiElement $this$getNonStrictParentOfType$iv = target;
                boolean $i$f$getNonStrictParentOfType = false;
                if (!Intrinsics.areEqual((Object)PsiTreeUtil.getParentOfType($this$getNonStrictParentOfType$iv, KtClass.class, false), (Object)unwrappedCandidate)) continue;
            }
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isAccessorReference(KtSimpleNameReference $this$isAccessorReference) {
        if ($this$isAccessorReference.getElement() instanceof KtOperationReferenceExpression) return false;
        if (((KtSimpleNameExpression)$this$isAccessorReference.getElement()).getParent() instanceof KtCallableReferenceExpression) return false;
        if (((KtSimpleNameExpression)$this$isAccessorReference.getElement()).getParent() instanceof KtCallExpression) return false;
        Object t2 = $this$isAccessorReference.getElement();
        Intrinsics.checkNotNullExpressionValue(t2, (String)"getElement(...)");
        if (KtPsiUtilKt.isInImportDirective((KtExpression)t2)) return false;
        return true;
    }
}

