/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.backend;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.fir.backend.Fir2IrDelegatedMembersGenerationStrategy;
import org.jetbrains.kotlin.fir.lazy.Fir2IrLazyPropertyForPureField;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrOverridableDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrOverridableMember;
import org.jetbrains.kotlin.ir.declarations.IrPropertyWithLateBinding;
import org.jetbrains.kotlin.ir.overrides.FakeOverrideBuilderStrategy;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001c\u0010\r\u001a\u00020\u000e2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\"\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u0003H\u0014J\u0018\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001dH\u0014J\u0006\u0010\u001f\u001a\u00020\u000eR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\tR\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\tR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/fir/backend/Fir2IrFakeOverrideStrategy;", "Lorg/jetbrains/kotlin/ir/overrides/FakeOverrideBuilderStrategy$BindToPrivateSymbols;", "isGenericClashFromSameSupertypeAllowed", "", "isOverrideOfPublishedApiFromOtherModuleDisallowed", "delegatedMemberGenerationStrategy", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrDelegatedMembersGenerationStrategy;", "<init>", "(ZZLorg/jetbrains/kotlin/fir/backend/Fir2IrDelegatedMembersGenerationStrategy;)V", "()Z", "fieldOnlyProperties", "", "Lorg/jetbrains/kotlin/ir/declarations/IrPropertyWithLateBinding;", "postProcessGeneratedFakeOverride", "", "fakeOverride", "Lorg/jetbrains/kotlin/ir/declarations/IrOverridableDeclaration;", "clazz", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "fakeOverrideMember", "Lorg/jetbrains/kotlin/ir/declarations/IrOverridableMember;", "superType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "member", "linkPropertyFakeOverride", "property", "manglerCompatibleMode", "shouldSeeInternals", "thisModule", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "memberModule", "clearFakeOverrideFields", "entrypoint"})
@SourceDebugExtension(value={"SMAP\nFir2IrFakeOverrideStrategy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Fir2IrFakeOverrideStrategy.kt\norg/jetbrains/kotlin/fir/backend/Fir2IrFakeOverrideStrategy\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,477:1\n1#2:478\n*E\n"})
public final class Fir2IrFakeOverrideStrategy
extends FakeOverrideBuilderStrategy.BindToPrivateSymbols {
    private final boolean isGenericClashFromSameSupertypeAllowed;
    private final boolean isOverrideOfPublishedApiFromOtherModuleDisallowed;
    @NotNull
    private final Fir2IrDelegatedMembersGenerationStrategy delegatedMemberGenerationStrategy;
    @NotNull
    private final List<IrPropertyWithLateBinding> fieldOnlyProperties;

    public Fir2IrFakeOverrideStrategy(boolean isGenericClashFromSameSupertypeAllowed, boolean isOverrideOfPublishedApiFromOtherModuleDisallowed, @NotNull Fir2IrDelegatedMembersGenerationStrategy delegatedMemberGenerationStrategy) {
        Intrinsics.checkNotNullParameter((Object)delegatedMemberGenerationStrategy, (String)"delegatedMemberGenerationStrategy");
        this.isGenericClashFromSameSupertypeAllowed = isGenericClashFromSameSupertypeAllowed;
        this.isOverrideOfPublishedApiFromOtherModuleDisallowed = isOverrideOfPublishedApiFromOtherModuleDisallowed;
        this.delegatedMemberGenerationStrategy = delegatedMemberGenerationStrategy;
        this.fieldOnlyProperties = new ArrayList();
    }

    @Override
    public boolean isGenericClashFromSameSupertypeAllowed() {
        return this.isGenericClashFromSameSupertypeAllowed;
    }

    @Override
    public boolean isOverrideOfPublishedApiFromOtherModuleDisallowed() {
        return this.isOverrideOfPublishedApiFromOtherModuleDisallowed;
    }

    @Override
    public void postProcessGeneratedFakeOverride(@NotNull IrOverridableDeclaration<?> fakeOverride, @NotNull IrClass clazz) {
        Intrinsics.checkNotNullParameter(fakeOverride, (String)"fakeOverride");
        Intrinsics.checkNotNullParameter((Object)clazz, (String)"clazz");
        this.delegatedMemberGenerationStrategy.convertFakeOverrideToDelegateIfNeeded(fakeOverride, clazz);
    }

    @Override
    @Nullable
    public IrOverridableMember fakeOverrideMember(@NotNull IrType superType, @NotNull IrOverridableMember member, @NotNull IrClass clazz) {
        Intrinsics.checkNotNullParameter((Object)superType, (String)"superType");
        Intrinsics.checkNotNullParameter((Object)member, (String)"member");
        Intrinsics.checkNotNullParameter((Object)clazz, (String)"clazz");
        if (member instanceof Fir2IrLazyPropertyForPureField) {
            IrField irField = ((Fir2IrLazyPropertyForPureField)member).getBackingField();
            boolean bl = irField != null ? irField.isStatic() : false;
            if (bl) {
                return null;
            }
        }
        return super.fakeOverrideMember(superType, member, clazz);
    }

    @Override
    protected void linkPropertyFakeOverride(@NotNull IrPropertyWithLateBinding property2, boolean manglerCompatibleMode) {
        Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
        super.linkPropertyFakeOverride(property2, manglerCompatibleMode);
        if (property2.getGetter() == null) {
            this.fieldOnlyProperties.add(property2);
        }
    }

    @Override
    protected boolean shouldSeeInternals(@NotNull ModuleDescriptor thisModule, @NotNull ModuleDescriptor memberModule) {
        Intrinsics.checkNotNullParameter((Object)thisModule, (String)"thisModule");
        Intrinsics.checkNotNullParameter((Object)memberModule, (String)"memberModule");
        return thisModule.shouldSeeInternalsOf(memberModule);
    }

    public final void clearFakeOverrideFields() {
        for (IrPropertyWithLateBinding property2 : this.fieldOnlyProperties) {
            if (!(property2.isFakeOverride() && property2.getGetter() == null)) {
                boolean bl = false;
                String string = "Not a field-only property: " + RenderIrElementKt.render$default(property2, null, 1, null);
                throw new IllegalStateException(string.toString());
            }
            property2.setBackingField(null);
        }
    }
}

