/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.lazy.declarations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.lazy.declarations.AbstractPsiBasedDeclarationProvider;
import org.jetbrains.kotlin.resolve.lazy.declarations.FileBasedDeclarationProviderFactory;
import org.jetbrains.kotlin.resolve.lazy.declarations.PackageMemberDeclarationProvider;
import org.jetbrains.kotlin.storage.NotNullLazyValue;
import org.jetbrains.kotlin.storage.StorageManager;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B-\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\"\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060\n2\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00180\u0016H\u0016J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J\u0010\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u000bH\u0016J\n\u0010\u001c\u001a\u00020\u001dH\u0096\u0080\u0004R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\n0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/resolve/lazy/declarations/FileBasedPackageMemberDeclarationProvider;", "Lorg/jetbrains/kotlin/resolve/lazy/declarations/AbstractPsiBasedDeclarationProvider;", "Lorg/jetbrains/kotlin/resolve/lazy/declarations/PackageMemberDeclarationProvider;", "storageManager", "Lorg/jetbrains/kotlin/storage/StorageManager;", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "factory", "Lorg/jetbrains/kotlin/resolve/lazy/declarations/FileBasedDeclarationProviderFactory;", "packageFiles", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "<init>", "(Lorg/jetbrains/kotlin/storage/StorageManager;Lorg/jetbrains/kotlin/name/FqName;Lorg/jetbrains/kotlin/resolve/lazy/declarations/FileBasedDeclarationProviderFactory;Ljava/util/Collection;)V", "allDeclaredSubPackages", "Lorg/jetbrains/kotlin/storage/NotNullLazyValue;", "doCreateIndex", "", "index", "Lorg/jetbrains/kotlin/resolve/lazy/declarations/AbstractPsiBasedDeclarationProvider$Index;", "getAllDeclaredSubPackages", "nameFilter", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/name/Name;", "", "getPackageFiles", "containsFile", "file", "toString", "", "frontend"})
@SourceDebugExtension(value={"SMAP\nFileBasedPackageMemberDeclarationProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileBasedPackageMemberDeclarationProvider.kt\norg/jetbrains/kotlin/resolve/lazy/declarations/FileBasedPackageMemberDeclarationProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,53:1\n1#2:54\n1585#3:55\n1660#3,3:56\n1390#3:59\n1479#3,5:60\n1585#3:65\n1660#3,3:66\n*S KotlinDebug\n*F\n+ 1 FileBasedPackageMemberDeclarationProvider.kt\norg/jetbrains/kotlin/resolve/lazy/declarations/FileBasedPackageMemberDeclarationProvider\n*L\n50#1:55\n50#1:56,3\n51#1:59\n51#1:60,5\n51#1:65\n51#1:66,3\n*E\n"})
public final class FileBasedPackageMemberDeclarationProvider
extends AbstractPsiBasedDeclarationProvider
implements PackageMemberDeclarationProvider {
    @NotNull
    private final FqName fqName;
    @NotNull
    private final FileBasedDeclarationProviderFactory factory;
    @NotNull
    private final Collection<KtFile> packageFiles;
    @NotNull
    private final NotNullLazyValue<Collection<FqName>> allDeclaredSubPackages;

    public FileBasedPackageMemberDeclarationProvider(@NotNull StorageManager storageManager, @NotNull FqName fqName, @NotNull FileBasedDeclarationProviderFactory factory, @NotNull Collection<? extends KtFile> packageFiles) {
        Intrinsics.checkNotNullParameter((Object)storageManager, (String)"storageManager");
        Intrinsics.checkNotNullParameter((Object)fqName, (String)"fqName");
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        Intrinsics.checkNotNullParameter(packageFiles, (String)"packageFiles");
        super(storageManager);
        this.fqName = fqName;
        this.factory = factory;
        this.packageFiles = packageFiles;
        this.allDeclaredSubPackages = storageManager.createLazyValue(() -> FileBasedPackageMemberDeclarationProvider.allDeclaredSubPackages$lambda$0(this));
    }

    @Override
    protected void doCreateIndex(@NotNull AbstractPsiBasedDeclarationProvider.Index index) {
        Intrinsics.checkNotNullParameter((Object)index, (String)"index");
        for (KtFile file : this.packageFiles) {
            for (KtDeclaration declaration : file.getDeclarations()) {
                boolean bl = Intrinsics.areEqual((Object)this.fqName, (Object)file.getPackageFqName());
                if (_Assertions.ENABLED && !bl) {
                    boolean bl2 = false;
                    String string = "Files declaration utils contains file with invalid package";
                    throw new AssertionError((Object)string);
                }
                index.putToIndex(declaration);
            }
        }
    }

    @Override
    @NotNull
    public Collection<FqName> getAllDeclaredSubPackages(@NotNull Function1<? super Name, Boolean> nameFilter) {
        Intrinsics.checkNotNullParameter(nameFilter, (String)"nameFilter");
        return (Collection)this.allDeclaredSubPackages.invoke();
    }

    @Override
    @NotNull
    public Collection<KtFile> getPackageFiles() {
        return this.packageFiles;
    }

    @Override
    public boolean containsFile(@NotNull KtFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.packageFiles.contains(file);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public String toString() {
        Object list$iv$iv;
        Iterable $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv;
        KtFile it;
        Collection collection;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Iterable iterable = this.packageFiles;
        StringBuilder stringBuilder = new StringBuilder().append("Declarations for package ").append(this.fqName).append(" with files ");
        boolean $i$f$map = false;
        void var3_4 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            KtFile ktFile = (KtFile)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getName());
        }
        $this$map$iv = this.packageFiles;
        stringBuilder = stringBuilder.append((List)destination$iv$iv).append(" with declarations inside ");
        boolean $i$f$flatMap = false;
        $this$mapTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (KtFile)element$iv$iv;
            boolean bl = false;
            list$iv$iv = it.getDeclarations();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$flatMapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            list$iv$iv = (KtDeclaration)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getName();
            if (string == null) {
                string = "???";
            }
            collection.add(string);
        }
        return stringBuilder.append((List)destination$iv$iv).toString();
    }

    private static final Collection allDeclaredSubPackages$lambda$0(FileBasedPackageMemberDeclarationProvider this$0) {
        Collection<FqName> collection = this$0.factory.getAllDeclaredSubPackagesOf(this$0.fqName);
        Intrinsics.checkNotNullExpressionValue(collection, (String)"getAllDeclaredSubPackagesOf(...)");
        return collection;
    }
}

