/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FieldDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u000e\u0010\u000f\u001a\u0004\u0018\u00010\u0010*\u00020\u0011H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/VolatileAnnotationChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "<init>", "()V", "JVM_VOLATILE_ANNOTATION_FQ_NAME", "Lorg/jetbrains/kotlin/name/FqName;", "CONCURRENT_VOLATILE_ANNOTATION_FQ_NAME", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "findVolatileAnnotation", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "Lorg/jetbrains/kotlin/descriptors/FieldDescriptor;", "frontend"})
@SourceDebugExtension(value={"SMAP\nVolatileAnnotationChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VolatileAnnotationChecker.kt\norg/jetbrains/kotlin/resolve/checkers/VolatileAnnotationChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,41:1\n295#2,2:42\n*S KotlinDebug\n*F\n+ 1 VolatileAnnotationChecker.kt\norg/jetbrains/kotlin/resolve/checkers/VolatileAnnotationChecker\n*L\n38#1:42,2\n*E\n"})
public final class VolatileAnnotationChecker
implements DeclarationChecker {
    @NotNull
    public static final VolatileAnnotationChecker INSTANCE = new VolatileAnnotationChecker();
    @NotNull
    private static final FqName JVM_VOLATILE_ANNOTATION_FQ_NAME = new FqName("kotlin.jvm.Volatile");
    @NotNull
    private static final FqName CONCURRENT_VOLATILE_ANNOTATION_FQ_NAME = new FqName("kotlin.concurrent.Volatile");

    private VolatileAnnotationChecker() {
    }

    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor, @NotNull DeclarationCheckerContext context2) {
        AnnotationDescriptor delegateAnnotation;
        AnnotationDescriptor fieldAnnotation;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (!(descriptor instanceof PropertyDescriptor)) {
            return;
        }
        FieldDescriptor fieldDescriptor = ((PropertyDescriptor)descriptor).getBackingField();
        AnnotationDescriptor annotationDescriptor = fieldAnnotation = fieldDescriptor != null ? this.findVolatileAnnotation(fieldDescriptor) : null;
        if (fieldAnnotation != null && !((PropertyDescriptor)descriptor).isVar()) {
            KtAnnotationEntry ktAnnotationEntry = DescriptorToSourceUtils.getSourceFromAnnotation(fieldAnnotation);
            if (ktAnnotationEntry == null) {
                return;
            }
            KtAnnotationEntry annotationEntry = ktAnnotationEntry;
            context2.getTrace().report(Errors.VOLATILE_ON_VALUE.on((KtAnnotationEntry)((PsiElement)annotationEntry)));
        }
        FieldDescriptor fieldDescriptor2 = ((PropertyDescriptor)descriptor).getDelegateField();
        AnnotationDescriptor annotationDescriptor2 = delegateAnnotation = fieldDescriptor2 != null ? this.findVolatileAnnotation(fieldDescriptor2) : null;
        if (delegateAnnotation != null) {
            KtAnnotationEntry ktAnnotationEntry = DescriptorToSourceUtils.getSourceFromAnnotation(delegateAnnotation);
            if (ktAnnotationEntry == null) {
                return;
            }
            KtAnnotationEntry annotationEntry = ktAnnotationEntry;
            context2.getTrace().report(Errors.VOLATILE_ON_DELEGATE.on((KtAnnotationEntry)((PsiElement)annotationEntry)));
        }
    }

    private final AnnotationDescriptor findVolatileAnnotation(FieldDescriptor $this$findVolatileAnnotation) {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = $this$findVolatileAnnotation.getAnnotations();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                AnnotationDescriptor it = (AnnotationDescriptor)element$iv;
                boolean bl = false;
                if (!(Intrinsics.areEqual((Object)it.getFqName(), (Object)JVM_VOLATILE_ANNOTATION_FQ_NAME) || Intrinsics.areEqual((Object)it.getFqName(), (Object)CONCURRENT_VOLATILE_ANNOTATION_FQ_NAME))) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }
}

